/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.plan.PlanCanonicalizationStrategy;
import com.facebook.presto.common.resourceGroups.QueryType;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.cost.HistoricalPlanStatisticsUtil;
import com.facebook.presto.cost.HistoryBasedOptimizationConfig;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.cost.HistoryBasedStatisticsCacheManager;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanNodeWithHash;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.HistoricalPlanStatistics;
import com.facebook.presto.spi.statistics.HistoricalPlanStatisticsEntryInfo;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.statistics.HistoryBasedSourceInfo;
import com.facebook.presto.spi.statistics.JoinNodeStatistics;
import com.facebook.presto.spi.statistics.PartialAggregationStatistics;
import com.facebook.presto.spi.statistics.PlanStatistics;
import com.facebook.presto.spi.statistics.PlanStatisticsWithSourceInfo;
import com.facebook.presto.spi.statistics.SourceInfo;
import com.facebook.presto.spi.statistics.TableWriterNodeStatistics;
import com.facebook.presto.sql.planner.CanonicalPlan;
import com.facebook.presto.sql.planner.PlanNodeCanonicalInfo;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.Traverser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

public class HistoryBasedPlanStatisticsTracker {
    private static final Logger LOG = Logger.get(HistoryBasedPlanStatisticsTracker.class);
    private static final Set<QueryType> ALLOWED_QUERY_TYPES = ImmutableSet.of((Object)QueryType.SELECT, (Object)QueryType.INSERT);
    private final Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider;
    private final HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager;
    private final SessionPropertyManager sessionPropertyManager;
    private final HistoryBasedOptimizationConfig config;
    private final boolean isNativeExecution;
    private final String serverVersion;

    public HistoryBasedPlanStatisticsTracker(Supplier<HistoryBasedPlanStatisticsProvider> historyBasedPlanStatisticsProvider, HistoryBasedStatisticsCacheManager historyBasedStatisticsCacheManager, SessionPropertyManager sessionPropertyManager, HistoryBasedOptimizationConfig config, boolean isNativeExecution, String serverVersion) {
        this.historyBasedPlanStatisticsProvider = Objects.requireNonNull(historyBasedPlanStatisticsProvider, "historyBasedPlanStatisticsProvider is null");
        this.historyBasedStatisticsCacheManager = Objects.requireNonNull(historyBasedStatisticsCacheManager, "historyBasedStatisticsCacheManager is null");
        this.sessionPropertyManager = Objects.requireNonNull(sessionPropertyManager, "sessionPropertyManager is null");
        this.config = Objects.requireNonNull(config, "config is null");
        this.isNativeExecution = isNativeExecution;
        this.serverVersion = serverVersion;
    }

    public void updateStatistics(QueryExecution queryExecution) {
        queryExecution.addFinalQueryInfoListener(this::updateStatistics);
    }

    public Map<PlanCanonicalizationStrategy, String> getCanonicalPlan(QueryId queryId) {
        return this.historyBasedStatisticsCacheManager.getCanonicalPlan(queryId);
    }

    public Optional<PlanNode> getStatsEquivalentPlanRootNode(QueryId queryId) {
        return this.historyBasedStatisticsCacheManager.getStatsEquivalentPlanRootNode(queryId);
    }

    @VisibleForTesting
    public HistoryBasedPlanStatisticsProvider getHistoryBasedPlanStatisticsProvider() {
        return this.historyBasedPlanStatisticsProvider.get();
    }

    public Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> getQueryStats(QueryInfo queryInfo) {
        boolean querySucceed;
        Session session = queryInfo.getSession().toSession(this.sessionPropertyManager);
        if (!SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            return ImmutableMap.of();
        }
        boolean trackStatsForFailedQueries = SystemSessionProperties.trackHistoryStatsFromFailedQuery(session);
        boolean bl = querySucceed = queryInfo.getFailureInfo() == null;
        if (!querySucceed && !trackStatsForFailedQueries || !queryInfo.getOutputStage().isPresent() || !queryInfo.getOutputStage().get().getPlan().isPresent()) {
            return ImmutableMap.of();
        }
        if (!queryInfo.getQueryType().isPresent() || !ALLOWED_QUERY_TYPES.contains(queryInfo.getQueryType().get())) {
            return ImmutableMap.of();
        }
        if (!queryInfo.isFinalQueryInfo()) {
            LOG.error("Expected final query info when updating history based statistics: %s", new Object[]{queryInfo});
            return ImmutableMap.of();
        }
        StageInfo outputStage = queryInfo.getOutputStage().get();
        Object allStages = ImmutableList.of();
        if (querySucceed) {
            allStages = outputStage.getAllStages();
        } else if (trackStatsForFailedQueries) {
            allStages = (List)outputStage.getAllStages().stream().filter(x -> x.getLatestAttemptExecutionInfo().getState().equals((Object)StageExecutionState.FINISHED)).collect(ImmutableList.toImmutableList());
        }
        if (allStages.isEmpty()) {
            return ImmutableMap.of();
        }
        HistoricalPlanStatisticsEntryInfo historicalPlanStatisticsEntryInfo = new HistoricalPlanStatisticsEntryInfo(this.isNativeExecution ? HistoricalPlanStatisticsEntryInfo.WorkerType.CPP : HistoricalPlanStatisticsEntryInfo.WorkerType.JAVA, queryInfo.getQueryId(), this.serverVersion);
        Map<PlanNodeId, PlanNodeStats> planNodeStatsMap = PlanNodeStatsSummarizer.aggregateStageStats((List<StageInfo>)allStages);
        HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatisticsMap = new HashMap<PlanNodeWithHash, PlanStatisticsWithSourceInfo>();
        HashMap canonicalInfoMap = new HashMap();
        HashMap<Integer, FinalAggregationStatsInfo> aggregationNodeMap = new HashMap<Integer, FinalAggregationStatsInfo>();
        Set<PlanNodeId> planNodeIdsDynamicFilter = HistoryBasedPlanStatisticsTracker.getPlanNodeAppliedDynamicFilter(planNodeStatsMap, (List<StageInfo>)allStages);
        queryInfo.getPlanCanonicalInfo().forEach(canonicalPlanWithInfo -> canonicalInfoMap.putIfAbsent(canonicalPlanWithInfo.getCanonicalPlan(), canonicalPlanWithInfo.getInfo()));
        Iterator iterator = allStages.iterator();
        while (iterator.hasNext()) {
            StageInfo stageInfo = (StageInfo)iterator.next();
            if (!stageInfo.getPlan().isPresent()) continue;
            boolean isScaledWriterStage = stageInfo.getPlan().isPresent() && stageInfo.getPlan().get().getPartitioning().equals((Object)SystemPartitioningHandle.SCALED_WRITER_DISTRIBUTION);
            PlanNode root = stageInfo.getPlan().get().getRoot();
            for (PlanNode planNode : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root)) {
                PlanNodeStats planNodeStats;
                if (!planNode.getStatsEquivalentPlanNode().isPresent() && !this.isAggregation(planNode, AggregationNode.Step.PARTIAL) || planNodeIdsDynamicFilter.contains(planNode.getId()) || (planNodeStats = planNodeStatsMap.get(planNode.getId())) == null) continue;
                double outputPositions = planNodeStats.getPlanNodeOutputPositions();
                double outputBytes = this.adjustedOutputBytes(planNode, planNodeStats);
                double nullJoinBuildKeyCount = planNodeStats.getPlanNodeNullJoinBuildKeyCount();
                double joinBuildKeyCount = planNodeStats.getPlanNodeJoinBuildKeyCount();
                double nullJoinProbeKeyCount = planNodeStats.getPlanNodeNullJoinProbeKeyCount();
                double joinProbeKeyCount = planNodeStats.getPlanNodeJoinProbeKeyCount();
                PartialAggregationStatistics partialAggregationStatistics = PartialAggregationStatistics.empty();
                if (this.isAggregation(planNode, AggregationNode.Step.PARTIAL) && SystemSessionProperties.trackPartialAggregationHistory(session)) {
                    partialAggregationStatistics = this.constructAggregationNodeStatistics(planNode, planNodeStatsMap, outputBytes, outputPositions);
                    HistoryBasedPlanStatisticsTracker.updatePartialAggregationStatistics((AggregationNode)planNode, aggregationNodeMap, partialAggregationStatistics, planStatisticsMap);
                }
                if (!planNode.getStatsEquivalentPlanNode().isPresent()) continue;
                JoinNodeStatistics joinNodeStatistics = JoinNodeStatistics.empty();
                if (planNode instanceof JoinNode) {
                    joinNodeStatistics = new JoinNodeStatistics(Estimate.of((double)nullJoinBuildKeyCount), Estimate.of((double)joinBuildKeyCount), Estimate.of((double)nullJoinProbeKeyCount), Estimate.of((double)joinProbeKeyCount));
                }
                TableWriterNodeStatistics tableWriterNodeStatistics = TableWriterNodeStatistics.empty();
                if (isScaledWriterStage && planNode instanceof TableWriterNode) {
                    tableWriterNodeStatistics = new TableWriterNodeStatistics(Estimate.of((double)stageInfo.getLatestAttemptExecutionInfo().getStats().getTotalTasks()));
                }
                PlanNode statsEquivalentPlanNode = (PlanNode)planNode.getStatsEquivalentPlanNode().get();
                for (PlanCanonicalizationStrategy strategy : HistoryBasedPlanStatisticsManager.historyBasedPlanCanonicalizationStrategyList(session)) {
                    Optional<PlanNodeCanonicalInfo> planNodeCanonicalInfo = Optional.ofNullable((PlanNodeCanonicalInfo)canonicalInfoMap.get(new CanonicalPlan(statsEquivalentPlanNode, strategy)));
                    if (!planNodeCanonicalInfo.isPresent()) continue;
                    String hash = planNodeCanonicalInfo.get().getHash();
                    List<PlanStatistics> inputTableStatistics = planNodeCanonicalInfo.get().getInputTableStatistics();
                    PlanNodeWithHash planNodeWithHash = new PlanNodeWithHash(statsEquivalentPlanNode, Optional.of(hash));
                    PlanStatistics newPlanNodeStats = new PlanStatistics(Estimate.of((double)outputPositions), Double.isNaN(outputBytes) ? Estimate.unknown() : Estimate.of((double)outputBytes), 1.0, joinNodeStatistics, tableWriterNodeStatistics, partialAggregationStatistics);
                    if (planStatisticsMap.containsKey(planNodeWithHash)) {
                        newPlanNodeStats = ((PlanStatisticsWithSourceInfo)planStatisticsMap.get(planNodeWithHash)).getPlanStatistics().update(newPlanNodeStats);
                    }
                    PlanStatisticsWithSourceInfo planStatsWithSourceInfo = new PlanStatisticsWithSourceInfo(planNode.getId(), newPlanNodeStats, (SourceInfo)new HistoryBasedSourceInfo(Optional.of(hash), Optional.of(inputTableStatistics), Optional.of(historicalPlanStatisticsEntryInfo)));
                    planStatisticsMap.put(planNodeWithHash, planStatsWithSourceInfo);
                    if (!this.isAggregation(planNode, AggregationNode.Step.FINAL) || !((AggregationNode)planNode).getAggregationId().isPresent() || !SystemSessionProperties.trackPartialAggregationHistory(session)) continue;
                    aggregationNodeMap.put((Integer)((AggregationNode)planNode).getAggregationId().get(), new FinalAggregationStatsInfo(planNodeWithHash, planStatsWithSourceInfo));
                }
            }
        }
        return ImmutableMap.copyOf(planStatisticsMap);
    }

    private static Set<PlanNodeId> getPlanNodeAppliedDynamicFilter(Map<PlanNodeId, PlanNodeStats> planNodeStatsMap, List<StageInfo> allStages) {
        HashMap<PlanNodeId, Set> dynamicFilterNodeMap = new HashMap<PlanNodeId, Set>();
        planNodeStatsMap.forEach((planNodeId, planNodeStats) -> {
            if (planNodeStats.getDynamicFilterStats().isPresent()) {
                if (!dynamicFilterNodeMap.containsKey(planNodeId)) {
                    dynamicFilterNodeMap.put((PlanNodeId)planNodeId, new HashSet());
                }
                ((Set)dynamicFilterNodeMap.get(planNodeId)).addAll(planNodeStats.getDynamicFilterStats().get().getProducerNodeIds());
            }
        });
        if (dynamicFilterNodeMap.isEmpty()) {
            return ImmutableSet.of();
        }
        MutableGraph reversePlanTree = GraphBuilder.directed().allowsSelfLoops(false).build();
        for (StageInfo stageInfo : allStages) {
            if (!stageInfo.getPlan().isPresent()) continue;
            PlanNode root = stageInfo.getPlan().get().getRoot();
            for (PlanNode planNode : Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)root)) {
                for (PlanNode child : planNode.getSources()) {
                    reversePlanTree.putEdge((Object)child.getId(), (Object)planNode.getId());
                }
            }
        }
        HashSet<PlanNodeId> planNodeIdsDynamicFilter = new HashSet<PlanNodeId>();
        dynamicFilterNodeMap.forEach((destNode, producerNodes) -> {
            for (PlanNodeId producerNode : producerNodes) {
                PlanNodeId rootNode = destNode;
                HashSet<PlanNodeId> visitedNodes = new HashSet<PlanNodeId>();
                while (!rootNode.equals((Object)producerNode)) {
                    visitedNodes.add(rootNode);
                    if (reversePlanTree.successors((Object)rootNode).isEmpty()) break;
                    Preconditions.checkState((reversePlanTree.successors((Object)rootNode).size() == 1 ? 1 : 0) != 0);
                    rootNode = reversePlanTree.successors((Object)rootNode).stream().findFirst().orElse(null);
                }
                if (!rootNode.equals((Object)producerNode)) continue;
                planNodeIdsDynamicFilter.addAll(visitedNodes);
            }
        });
        return planNodeIdsDynamicFilter;
    }

    private static void updatePartialAggregationStatistics(AggregationNode partialAggregationNode, Map<Integer, FinalAggregationStatsInfo> aggregationNodeStats, PartialAggregationStatistics partialAggregationStatistics, Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatisticsMap) {
        if (!partialAggregationNode.getAggregationId().isPresent() || !aggregationNodeStats.containsKey(partialAggregationNode.getAggregationId().get())) {
            return;
        }
        FinalAggregationStatsInfo finalAggregationStatsInfo = aggregationNodeStats.get(partialAggregationNode.getAggregationId().get());
        PlanStatisticsWithSourceInfo planStatisticsWithSourceInfo = finalAggregationStatsInfo.getPlanStatisticsWithSourceInfo();
        PlanStatistics planStatisticsFinalAgg = planStatisticsWithSourceInfo.getPlanStatistics();
        planStatisticsFinalAgg = planStatisticsFinalAgg.updateAggregationStatistics(partialAggregationStatistics);
        planStatisticsMap.put(finalAggregationStatsInfo.getPlanNodeWithHash(), new PlanStatisticsWithSourceInfo(planStatisticsWithSourceInfo.getId(), planStatisticsFinalAgg, planStatisticsWithSourceInfo.getSourceInfo()));
    }

    private PartialAggregationStatistics constructAggregationNodeStatistics(PlanNode planNode, Map<PlanNodeId, PlanNodeStats> planNodeStatsMap, double outputBytes, double outputPositions) {
        PlanNode childNode = (PlanNode)planNode.getSources().get(0);
        PlanNodeStats childNodeStats = planNodeStatsMap.get(childNode.getId());
        if (childNodeStats != null) {
            double partialAggregationInputBytes = this.adjustedOutputBytes(childNode, childNodeStats);
            return new PartialAggregationStatistics(Double.isNaN(partialAggregationInputBytes) ? Estimate.unknown() : Estimate.of((double)partialAggregationInputBytes), Double.isNaN(outputBytes) ? Estimate.unknown() : Estimate.of((double)outputBytes), Estimate.of((double)childNodeStats.getPlanNodeOutputPositions()), Estimate.of((double)outputPositions));
        }
        return PartialAggregationStatistics.empty();
    }

    private boolean isAggregation(PlanNode planNode, AggregationNode.Step step) {
        return planNode instanceof AggregationNode && ((AggregationNode)planNode).getStep() == step;
    }

    private double adjustedOutputBytes(PlanNode planNode, PlanNodeStats planNodeStats) {
        double outputPositions = planNodeStats.getPlanNodeOutputPositions();
        double outputBytes = planNodeStats.getPlanNodeOutputDataSize().toBytes();
        outputBytes -= planNode.getOutputVariables().stream().mapToDouble(variable -> variable.getType() instanceof FixedWidthType ? outputPositions * (double)((FixedWidthType)variable.getType()).getFixedSize() : 0.0).sum();
        List outputVariables = planNode.getOutputVariables();
        if (planNode.getStatsEquivalentPlanNode().isPresent()) {
            outputVariables = ((PlanNode)planNode.getStatsEquivalentPlanNode().get()).getOutputVariables();
        }
        if ((outputBytes += outputVariables.stream().mapToDouble(variable -> variable.getType() instanceof FixedWidthType ? outputPositions * (double)((FixedWidthType)variable.getType()).getFixedSize() : 0.0).sum()) < 0.0 || outputPositions > 0.0 && outputBytes < 1.0 && !outputVariables.isEmpty()) {
            outputBytes = Double.NaN;
        }
        return outputBytes;
    }

    public void updateStatistics(QueryInfo queryInfo) {
        Session session = queryInfo.getSession().toSession(this.sessionPropertyManager);
        if (!SystemSessionProperties.trackHistoryBasedPlanStatisticsEnabled(session)) {
            this.historyBasedStatisticsCacheManager.invalidate(queryInfo.getQueryId());
            return;
        }
        Map<PlanNodeWithHash, PlanStatisticsWithSourceInfo> planStatistics = this.getQueryStats(queryInfo);
        Map historicalPlanStatisticsMap = this.historyBasedPlanStatisticsProvider.get().getStats((List)planStatistics.keySet().stream().collect(ImmutableList.toImmutableList()), SystemSessionProperties.getHistoryBasedOptimizerTimeoutLimit(session).toMillis());
        Map newPlanStatistics = (Map)planStatistics.entrySet().stream().filter(entry -> ((PlanNodeWithHash)entry.getKey()).getHash().isPresent() && ((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo() instanceof HistoryBasedSourceInfo && ((HistoryBasedSourceInfo)((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo()).getInputTableStatistics().isPresent() && ((HistoryBasedSourceInfo)((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo()).getHistoricalPlanStatisticsEntryInfo().isPresent()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            HistoricalPlanStatistics historicalPlanStatistics = Optional.ofNullable((HistoricalPlanStatistics)historicalPlanStatisticsMap.get(entry.getKey())).orElseGet(HistoricalPlanStatistics::empty);
            HistoryBasedSourceInfo historyBasedSourceInfo = (HistoryBasedSourceInfo)((PlanStatisticsWithSourceInfo)entry.getValue()).getSourceInfo();
            return HistoricalPlanStatisticsUtil.updatePlanStatistics(historicalPlanStatistics, (List)historyBasedSourceInfo.getInputTableStatistics().get(), ((PlanStatisticsWithSourceInfo)entry.getValue()).getPlanStatistics(), this.config, (HistoricalPlanStatisticsEntryInfo)historyBasedSourceInfo.getHistoricalPlanStatisticsEntryInfo().get());
        }));
        if (!newPlanStatistics.isEmpty()) {
            this.historyBasedPlanStatisticsProvider.get().putStats((Map)ImmutableMap.copyOf((Map)newPlanStatistics));
        }
        this.historyBasedStatisticsCacheManager.invalidate(queryInfo.getQueryId());
    }

    private class FinalAggregationStatsInfo {
        private final PlanNodeWithHash planNodeWithHash;
        private final PlanStatisticsWithSourceInfo planStatisticsWithSourceInfo;

        FinalAggregationStatsInfo(PlanNodeWithHash planNodeWithHash, PlanStatisticsWithSourceInfo planStatisticsWithSourceInfo) {
            this.planNodeWithHash = Objects.requireNonNull(planNodeWithHash);
            this.planStatisticsWithSourceInfo = Objects.requireNonNull(planStatisticsWithSourceInfo);
        }

        public PlanNodeWithHash getPlanNodeWithHash() {
            return this.planNodeWithHash;
        }

        public PlanStatisticsWithSourceInfo getPlanStatisticsWithSourceInfo() {
            return this.planStatisticsWithSourceInfo;
        }
    }
}

