/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.operator.BlockedReason;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class BasicStageExecutionStats {
    public static final BasicStageExecutionStats EMPTY_STAGE_STATS = new BasicStageExecutionStats(false, 0, 0, 0, 0, 0L, 0L, 0.0, 0.0, 0L, 0L, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), 0L, OptionalDouble.empty());
    private final boolean isScheduled;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int completedDrivers;
    private final long rawInputDataSizeInBytes;
    private final long rawInputPositions;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final long userMemoryReservationInBytes;
    private final long totalMemoryReservationInBytes;
    private final Duration totalCpuTime;
    private final Duration totalScheduledTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final long totalAllocationInBytes;
    private final OptionalDouble progressPercentage;

    public BasicStageExecutionStats(boolean isScheduled, int totalDrivers, int queuedDrivers, int runningDrivers, int completedDrivers, long rawInputDataSizeInBytes, long rawInputPositions, double cumulativeUserMemory, double cumulativeTotalMemory, long userMemoryReservationInBytes, long totalMemoryReservationInBytes, Duration totalCpuTime, Duration totalScheduledTime, boolean fullyBlocked, Set<BlockedReason> blockedReasons, long totalAllocationInBytes, OptionalDouble progressPercentage) {
        this.isScheduled = isScheduled;
        this.totalDrivers = totalDrivers;
        this.queuedDrivers = queuedDrivers;
        this.runningDrivers = runningDrivers;
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((rawInputDataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"rawInputDataSizeInBytes is negative");
        this.rawInputDataSizeInBytes = rawInputDataSizeInBytes;
        this.rawInputPositions = rawInputPositions;
        this.cumulativeUserMemory = cumulativeUserMemory;
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        Preconditions.checkArgument((userMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"userMemoryReservationInBytes is negative");
        this.userMemoryReservationInBytes = userMemoryReservationInBytes;
        Preconditions.checkArgument((totalMemoryReservationInBytes >= 0L ? 1 : 0) != 0, (Object)"totalMemoryReservationInBytes is negative");
        this.totalMemoryReservationInBytes = totalMemoryReservationInBytes;
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        Preconditions.checkArgument((totalAllocationInBytes >= 0L ? 1 : 0) != 0, (Object)"totalAllocationInBytes is negative");
        this.totalAllocationInBytes = totalAllocationInBytes;
        this.progressPercentage = Objects.requireNonNull(progressPercentage, "progressPercentage is null");
    }

    public boolean isScheduled() {
        return this.isScheduled;
    }

    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    public long getRawInputDataSizeInBytes() {
        return this.rawInputDataSizeInBytes;
    }

    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    public long getUserMemoryReservationInBytes() {
        return this.userMemoryReservationInBytes;
    }

    public long getTotalMemoryReservationInBytes() {
        return this.totalMemoryReservationInBytes;
    }

    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    public long getTotalAllocationInBytes() {
        return this.totalAllocationInBytes;
    }

    public OptionalDouble getProgressPercentage() {
        return this.progressPercentage;
    }

    public static BasicStageExecutionStats aggregateBasicStageStats(Iterable<BasicStageExecutionStats> stages) {
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int completedDrivers = 0;
        double cumulativeUserMemory = 0.0;
        double cumulativeTotalMemory = 0.0;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTimeMillis = 0L;
        long totalCpuTime = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        boolean isScheduled = true;
        boolean fullyBlocked = true;
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        long totalAllocation = 0L;
        for (BasicStageExecutionStats stageStats : stages) {
            totalDrivers += stageStats.getTotalDrivers();
            queuedDrivers += stageStats.getQueuedDrivers();
            runningDrivers += stageStats.getRunningDrivers();
            completedDrivers += stageStats.getCompletedDrivers();
            cumulativeUserMemory += stageStats.getCumulativeUserMemory();
            cumulativeTotalMemory += stageStats.getCumulativeTotalMemory();
            userMemoryReservation += stageStats.getUserMemoryReservationInBytes();
            totalMemoryReservation += stageStats.getTotalMemoryReservationInBytes();
            totalScheduledTimeMillis += stageStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            isScheduled &= stageStats.isScheduled();
            fullyBlocked &= stageStats.isFullyBlocked();
            blockedReasons.addAll(stageStats.getBlockedReasons());
            totalAllocation += stageStats.getTotalAllocationInBytes();
            rawInputDataSize += stageStats.getRawInputDataSizeInBytes();
            rawInputPositions += stageStats.getRawInputPositions();
        }
        OptionalDouble progressPercentage = OptionalDouble.empty();
        if (isScheduled && totalDrivers != 0) {
            progressPercentage = OptionalDouble.of(Math.min(100.0, (double)completedDrivers * 100.0 / (double)totalDrivers));
        }
        return new BasicStageExecutionStats(isScheduled, totalDrivers, queuedDrivers, runningDrivers, completedDrivers, rawInputDataSize, rawInputPositions, cumulativeUserMemory, cumulativeTotalMemory, userMemoryReservation, totalMemoryReservation, Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)totalScheduledTimeMillis, (TimeUnit)TimeUnit.MILLISECONDS), fullyBlocked, blockedReasons, totalAllocation, progressPercentage);
    }
}

