/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class DropColumnTask
implements DDLDefinitionTask<DropColumn> {
    @Override
    public String getName() {
        return "DROP COLUMN";
    }

    @Override
    public ListenableFuture<?> execute(DropColumn statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTable());
        Optional tableHandleOptional = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandleOptional.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        Optional optionalMaterializedView = metadata.getMetadataResolver(session).getMaterializedView(tableName);
        if (optionalMaterializedView.isPresent()) {
            if (!statement.isTableExists()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "'%s' is a materialized view, and drop column is not supported", new Object[]{tableName});
            }
            return Futures.immediateFuture(null);
        }
        TableHandle tableHandle = (TableHandle)tableHandleOptional.get();
        String column = statement.getColumn().getValueLowerCase();
        accessControl.checkCanDropColumn(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
        ColumnHandle columnHandle = metadata.getColumnHandles(session, tableHandle).get(column);
        if (columnHandle == null) {
            if (!statement.isColumnExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)statement, "Column '%s' does not exist", new Object[]{column});
            }
            return Futures.immediateFuture(null);
        }
        if (metadata.getColumnMetadata(session, tableHandle, columnHandle).isHidden()) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop hidden column", new Object[0]);
        }
        if (metadata.getTableMetadata(session, tableHandle).getColumns().stream().filter(info -> !info.isHidden()).count() <= 1L) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot drop the only column in a table", new Object[0]);
        }
        metadata.dropColumn(session, tableHandle, columnHandle);
        return Futures.immediateFuture(null);
    }
}

