/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import io.airlift.units.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class QueryLimit<T extends Comparable<T>> {
    private final T limit;
    private final Source source;

    private QueryLimit(T limit, Source source) {
        this.limit = (Comparable)Objects.requireNonNull(limit, "limit is null");
        this.source = Objects.requireNonNull(source, "source is null");
    }

    public static QueryLimit<Duration> createDurationLimit(Duration limit, Source source) {
        return new QueryLimit<Duration>(limit, source);
    }

    public static QueryLimit<Long> createDataSizeLimit(long limitInBytes, Source source) {
        return new QueryLimit<Long>(limitInBytes, source);
    }

    public T getLimit() {
        return this.limit;
    }

    public Source getLimitSource() {
        return this.source;
    }

    @SafeVarargs
    public static <S extends Comparable<S>> QueryLimit<S> getMinimum(QueryLimit<S> limit, QueryLimit<S> ... limits) {
        Optional<QueryLimit> queryLimit = Stream.concat(limits != null ? Arrays.stream(limits) : Stream.empty(), limit != null ? Stream.of(limit) : Stream.empty()).filter(Objects::nonNull).min(Comparator.comparing(QueryLimit::getLimit));
        return queryLimit.orElseThrow(() -> new IllegalArgumentException("At least one nonnull argument is required."));
    }

    public static enum Source {
        QUERY,
        SYSTEM,
        RESOURCE_GROUP;

    }
}

