/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.common.RuntimeStats;
import com.facebook.presto.execution.QueryStateTimer;
import com.facebook.presto.execution.StageExecutionInfo;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.StageExecutionStats;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.ExchangeOperator;
import com.facebook.presto.operator.MergeOperator;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.TableScanOperator;
import com.facebook.presto.spi.eventlistener.StageGcStatistics;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;

public class QueryStats {
    private final long createTimeInMillis;
    private final long executionStartTimeInMillis;
    private final long lastHeartbeatInMillis;
    private final long endTimeInMillis;
    private final Duration elapsedTime;
    private final Duration waitingForPrerequisitesTime;
    private final Duration queuedTime;
    private final Duration resourceWaitingTime;
    private final Duration semanticAnalyzingTime;
    private final Duration columnAccessPermissionCheckingTime;
    private final Duration dispatchingTime;
    private final Duration executionTime;
    private final Duration analysisTime;
    private final Duration totalPlanningTime;
    private final Duration finishingTime;
    private final int totalTasks;
    private final int runningTasks;
    private final int peakRunningTasks;
    private final int completedTasks;
    private final int totalDrivers;
    private final int queuedDrivers;
    private final int runningDrivers;
    private final int blockedDrivers;
    private final int completedDrivers;
    private final double cumulativeUserMemory;
    private final double cumulativeTotalMemory;
    private final DataSize userMemoryReservation;
    private final DataSize totalMemoryReservation;
    private final DataSize peakUserMemoryReservation;
    private final DataSize peakTotalMemoryReservation;
    private final DataSize peakTaskTotalMemory;
    private final DataSize peakTaskUserMemory;
    private final DataSize peakNodeTotalMemory;
    private final boolean scheduled;
    private final Duration totalScheduledTime;
    private final Duration totalCpuTime;
    private final Duration retriedCpuTime;
    private final Duration totalBlockedTime;
    private final boolean fullyBlocked;
    private final Set<BlockedReason> blockedReasons;
    private final DataSize totalAllocation;
    private final DataSize rawInputDataSize;
    private final long rawInputPositions;
    private final DataSize processedInputDataSize;
    private final long processedInputPositions;
    private final DataSize shuffledDataSize;
    private final long shuffledPositions;
    private final DataSize outputDataSize;
    private final long outputPositions;
    private final long writtenOutputPositions;
    private final DataSize writtenOutputLogicalDataSize;
    private final DataSize writtenOutputPhysicalDataSize;
    private final DataSize writtenIntermediatePhysicalDataSize;
    private final List<StageGcStatistics> stageGcStatistics;
    private final List<OperatorStats> operatorSummaries;
    private final RuntimeStats runtimeStats;

    public QueryStats(long createTimeInMillis, long executionStartTimeInMillis, long lastHeartbeatInMillis, long endTimeInMillis, Duration elapsedTime, Duration waitingForPrerequisitesTime, Duration queuedTime, Duration resourceWaitingTime, Duration semanticAnalyzingTime, Duration columnAccessPermissionCheckingTime, Duration dispatchingTime, Duration executionTime, Duration analysisTime, Duration totalPlanningTime, Duration finishingTime, int totalTasks, int runningTasks, int peakRunningTasks, int completedTasks, int totalDrivers, int queuedDrivers, int runningDrivers, int blockedDrivers, int completedDrivers, double cumulativeUserMemory, double cumulativeTotalMemory, DataSize userMemoryReservation, DataSize totalMemoryReservation, DataSize peakUserMemoryReservation, DataSize peakTotalMemoryReservation, DataSize peakTaskUserMemory, DataSize peakTaskTotalMemory, DataSize peakNodeTotalMemory, boolean scheduled, Duration totalScheduledTime, Duration totalCpuTime, Duration retriedCpuTime, Duration totalBlockedTime, boolean fullyBlocked, Set<BlockedReason> blockedReasons, DataSize totalAllocation, DataSize rawInputDataSize, long rawInputPositions, DataSize processedInputDataSize, long processedInputPositions, DataSize shuffledDataSize, long shuffledPositions, DataSize outputDataSize, long outputPositions, long writtenOutputPositions, DataSize writtenOutputLogicalDataSize, DataSize writtenOutputPhysicalDataSize, DataSize writtenIntermediatePhysicalDataSize, List<StageGcStatistics> stageGcStatistics, List<OperatorStats> operatorSummaries, RuntimeStats runtimeStats) {
        Preconditions.checkArgument((createTimeInMillis >= 0L ? 1 : 0) != 0, (Object)"createTimeInMillis is negative");
        this.createTimeInMillis = createTimeInMillis;
        this.executionStartTimeInMillis = executionStartTimeInMillis;
        Preconditions.checkArgument((lastHeartbeatInMillis >= 0L ? 1 : 0) != 0, (Object)"lastHeartbeatInMillis is negative");
        this.lastHeartbeatInMillis = lastHeartbeatInMillis;
        this.endTimeInMillis = endTimeInMillis;
        this.elapsedTime = Objects.requireNonNull(elapsedTime, "elapsedTime is null");
        this.waitingForPrerequisitesTime = Objects.requireNonNull(waitingForPrerequisitesTime, "waitingForPrerequisitesTime is null");
        this.queuedTime = Objects.requireNonNull(queuedTime, "queuedTime is null");
        this.resourceWaitingTime = Objects.requireNonNull(resourceWaitingTime, "resourceWaitingTime is null");
        this.semanticAnalyzingTime = Objects.requireNonNull(semanticAnalyzingTime, "semanticAnalyzingTime is null");
        this.columnAccessPermissionCheckingTime = Objects.requireNonNull(columnAccessPermissionCheckingTime, "columnAccessPermissionCheckingTime is null");
        this.dispatchingTime = Objects.requireNonNull(dispatchingTime, "dispatchingTime is null");
        this.executionTime = Objects.requireNonNull(executionTime, "executionTime is null");
        this.analysisTime = Objects.requireNonNull(analysisTime, "analysisTime is null");
        this.totalPlanningTime = Objects.requireNonNull(totalPlanningTime, "totalPlanningTime is null");
        this.finishingTime = Objects.requireNonNull(finishingTime, "finishingTime is null");
        Preconditions.checkArgument((totalTasks >= 0 ? 1 : 0) != 0, (Object)"totalTasks is negative");
        this.totalTasks = totalTasks;
        Preconditions.checkArgument((runningTasks >= 0 ? 1 : 0) != 0, (Object)"runningTasks is negative");
        this.runningTasks = runningTasks;
        Preconditions.checkArgument((peakRunningTasks >= 0 ? 1 : 0) != 0, (Object)"peakRunningTasks is negative");
        this.peakRunningTasks = peakRunningTasks;
        Preconditions.checkArgument((completedTasks >= 0 ? 1 : 0) != 0, (Object)"completedTasks is negative");
        this.completedTasks = completedTasks;
        Preconditions.checkArgument((totalDrivers >= 0 ? 1 : 0) != 0, (Object)"totalDrivers is negative");
        this.totalDrivers = totalDrivers;
        Preconditions.checkArgument((queuedDrivers >= 0 ? 1 : 0) != 0, (Object)"queuedDrivers is negative");
        this.queuedDrivers = queuedDrivers;
        Preconditions.checkArgument((runningDrivers >= 0 ? 1 : 0) != 0, (Object)"runningDrivers is negative");
        this.runningDrivers = runningDrivers;
        Preconditions.checkArgument((blockedDrivers >= 0 ? 1 : 0) != 0, (Object)"blockedDrivers is negative");
        this.blockedDrivers = blockedDrivers;
        Preconditions.checkArgument((completedDrivers >= 0 ? 1 : 0) != 0, (Object)"completedDrivers is negative");
        this.completedDrivers = completedDrivers;
        Preconditions.checkArgument((cumulativeUserMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeUserMemory is negative");
        this.cumulativeUserMemory = cumulativeUserMemory;
        Preconditions.checkArgument((cumulativeTotalMemory >= 0.0 ? 1 : 0) != 0, (Object)"cumulativeTotalMemory is negative");
        this.cumulativeTotalMemory = cumulativeTotalMemory;
        this.userMemoryReservation = Objects.requireNonNull(userMemoryReservation, "userMemoryReservation is null");
        this.totalMemoryReservation = Objects.requireNonNull(totalMemoryReservation, "totalMemoryReservation is null");
        this.peakUserMemoryReservation = Objects.requireNonNull(peakUserMemoryReservation, "peakUserMemoryReservation is null");
        this.peakTotalMemoryReservation = Objects.requireNonNull(peakTotalMemoryReservation, "peakTotalMemoryReservation is null");
        this.peakTaskTotalMemory = Objects.requireNonNull(peakTaskTotalMemory, "peakTaskTotalMemory is null");
        this.peakTaskUserMemory = Objects.requireNonNull(peakTaskUserMemory, "peakTaskUserMemory is null");
        this.peakNodeTotalMemory = Objects.requireNonNull(peakNodeTotalMemory, "peakNodeTotalMemory is null");
        this.scheduled = scheduled;
        this.totalScheduledTime = Objects.requireNonNull(totalScheduledTime, "totalScheduledTime is null");
        this.totalCpuTime = Objects.requireNonNull(totalCpuTime, "totalCpuTime is null");
        this.retriedCpuTime = Objects.requireNonNull(retriedCpuTime, "totalCpuTime is null");
        this.totalBlockedTime = Objects.requireNonNull(totalBlockedTime, "totalBlockedTime is null");
        this.fullyBlocked = fullyBlocked;
        this.blockedReasons = ImmutableSet.copyOf((Collection)Objects.requireNonNull(blockedReasons, "blockedReasons is null"));
        this.totalAllocation = Objects.requireNonNull(totalAllocation, "totalAllocation is null");
        this.rawInputDataSize = Objects.requireNonNull(rawInputDataSize, "rawInputDataSize is null");
        Preconditions.checkArgument((rawInputPositions >= 0L ? 1 : 0) != 0, (Object)"rawInputPositions is negative");
        this.rawInputPositions = rawInputPositions;
        this.processedInputDataSize = Objects.requireNonNull(processedInputDataSize, "processedInputDataSize is null");
        Preconditions.checkArgument((processedInputPositions >= 0L ? 1 : 0) != 0, (Object)"processedInputPositions is negative");
        this.processedInputPositions = processedInputPositions;
        this.shuffledDataSize = Objects.requireNonNull(shuffledDataSize, "shuffledDataSize is null");
        Preconditions.checkArgument((shuffledPositions >= 0L ? 1 : 0) != 0, (Object)"shuffledPositions is negative");
        this.shuffledPositions = shuffledPositions;
        this.outputDataSize = Objects.requireNonNull(outputDataSize, "outputDataSize is null");
        Preconditions.checkArgument((outputPositions >= 0L ? 1 : 0) != 0, (Object)"outputPositions is negative");
        this.outputPositions = outputPositions;
        Preconditions.checkArgument((writtenOutputPositions >= 0L ? 1 : 0) != 0, (String)"writtenOutputPositions is negative: %s", (long)writtenOutputPositions);
        this.writtenOutputPositions = writtenOutputPositions;
        this.writtenOutputLogicalDataSize = Objects.requireNonNull(writtenOutputLogicalDataSize, "writtenOutputLogicalDataSize is null");
        this.writtenOutputPhysicalDataSize = Objects.requireNonNull(writtenOutputPhysicalDataSize, "writtenOutputPhysicalDataSize is null");
        this.writtenIntermediatePhysicalDataSize = Objects.requireNonNull(writtenIntermediatePhysicalDataSize, "writtenIntermediatePhysicalDataSize is null");
        this.stageGcStatistics = ImmutableList.copyOf((Collection)Objects.requireNonNull(stageGcStatistics, "stageGcStatistics is null"));
        this.operatorSummaries = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorSummaries, "operatorSummaries is null"));
        this.runtimeStats = runtimeStats == null ? new RuntimeStats() : runtimeStats;
    }

    @JsonCreator
    public QueryStats(@JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="executionStartTime") DateTime executionStartTime, @JsonProperty(value="lastHeartbeat") DateTime lastHeartbeat, @JsonProperty(value="endTime") DateTime endTime, @JsonProperty(value="elapsedTime") Duration elapsedTime, @JsonProperty(value="waitingForPrerequisitesTime") Duration waitingForPrerequisitesTime, @JsonProperty(value="queuedTime") Duration queuedTime, @JsonProperty(value="resourceWaitingTime") Duration resourceWaitingTime, @JsonProperty(value="semanticAnalyzingTime") Duration semanticAnalyzingTime, @JsonProperty(value="columnAccessPermissionCheckingTime") Duration columnAccessPermissionCheckingTime, @JsonProperty(value="dispatchingTime") Duration dispatchingTime, @JsonProperty(value="executionTime") Duration executionTime, @JsonProperty(value="analysisTime") Duration analysisTime, @JsonProperty(value="totalPlanningTime") Duration totalPlanningTime, @JsonProperty(value="finishingTime") Duration finishingTime, @JsonProperty(value="totalTasks") int totalTasks, @JsonProperty(value="runningTasks") int runningTasks, @JsonProperty(value="peakRunningTasks") int peakRunningTasks, @JsonProperty(value="completedTasks") int completedTasks, @JsonProperty(value="totalDrivers") int totalDrivers, @JsonProperty(value="queuedDrivers") int queuedDrivers, @JsonProperty(value="runningDrivers") int runningDrivers, @JsonProperty(value="blockedDrivers") int blockedDrivers, @JsonProperty(value="completedDrivers") int completedDrivers, @JsonProperty(value="cumulativeUserMemory") double cumulativeUserMemory, @JsonProperty(value="cumulativeTotalMemory") double cumulativeTotalMemory, @JsonProperty(value="userMemoryReservation") DataSize userMemoryReservation, @JsonProperty(value="totalMemoryReservation") DataSize totalMemoryReservation, @JsonProperty(value="peakUserMemoryReservation") DataSize peakUserMemoryReservation, @JsonProperty(value="peakTotalMemoryReservation") DataSize peakTotalMemoryReservation, @JsonProperty(value="peakTaskUserMemory") DataSize peakTaskUserMemory, @JsonProperty(value="peakTaskTotalMemory") DataSize peakTaskTotalMemory, @JsonProperty(value="peakNodeTotalMemory") DataSize peakNodeTotalMemory, @JsonProperty(value="scheduled") boolean scheduled, @JsonProperty(value="totalScheduledTime") Duration totalScheduledTime, @JsonProperty(value="totalCpuTime") Duration totalCpuTime, @JsonProperty(value="retriedCpuTime") Duration retriedCpuTime, @JsonProperty(value="totalBlockedTime") Duration totalBlockedTime, @JsonProperty(value="fullyBlocked") boolean fullyBlocked, @JsonProperty(value="blockedReasons") Set<BlockedReason> blockedReasons, @JsonProperty(value="totalAllocation") DataSize totalAllocation, @JsonProperty(value="rawInputDataSize") DataSize rawInputDataSize, @JsonProperty(value="rawInputPositions") long rawInputPositions, @JsonProperty(value="processedInputDataSize") DataSize processedInputDataSize, @JsonProperty(value="processedInputPositions") long processedInputPositions, @JsonProperty(value="shuffledDataSize") DataSize shuffledDataSize, @JsonProperty(value="shuffledPositions") long shuffledPositions, @JsonProperty(value="outputDataSize") DataSize outputDataSize, @JsonProperty(value="outputPositions") long outputPositions, @JsonProperty(value="writtenOutputPositions") long writtenOutputPositions, @JsonProperty(value="writtenOutputLogicalDataSize") DataSize writtenOutputLogicalDataSize, @JsonProperty(value="writtenOutputPhysicalDataSize") DataSize writtenOutputPhysicalDataSize, @JsonProperty(value="writtenIntermediatePhysicalDataSize") DataSize writtenIntermediatePhysicalDataSize, @JsonProperty(value="stageGcStatistics") List<StageGcStatistics> stageGcStatistics, @JsonProperty(value="operatorSummaries") List<OperatorStats> operatorSummaries, @JsonProperty(value="runtimeStats") RuntimeStats runtimeStats) {
        this(DateTimeUtils.toTimeStampInMillis(createTime), DateTimeUtils.toTimeStampInMillis(executionStartTime), DateTimeUtils.toTimeStampInMillis(lastHeartbeat), DateTimeUtils.toTimeStampInMillis(endTime), elapsedTime, waitingForPrerequisitesTime, queuedTime, resourceWaitingTime, semanticAnalyzingTime, columnAccessPermissionCheckingTime, dispatchingTime, executionTime, analysisTime, totalPlanningTime, finishingTime, totalTasks, runningTasks, peakRunningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, cumulativeTotalMemory, userMemoryReservation, totalMemoryReservation, peakUserMemoryReservation, peakTotalMemoryReservation, peakTaskUserMemory, peakTaskTotalMemory, peakNodeTotalMemory, scheduled, totalScheduledTime, totalCpuTime, retriedCpuTime, totalBlockedTime, fullyBlocked, blockedReasons, totalAllocation, rawInputDataSize, rawInputPositions, processedInputDataSize, processedInputPositions, shuffledDataSize, shuffledPositions, outputDataSize, outputPositions, writtenOutputPositions, writtenOutputLogicalDataSize, writtenOutputPhysicalDataSize, writtenIntermediatePhysicalDataSize, stageGcStatistics, operatorSummaries, runtimeStats);
    }

    public static QueryStats create(QueryStateTimer queryStateTimer, Optional<StageInfo> rootStage, List<StageInfo> allStages, int peakRunningTasks, long peakUserMemoryReservation, long peakTotalMemoryReservation, long peakTaskUserMemory, long peakTaskTotalMemory, long peakNodeTotalMemory, RuntimeStats runtimeStats) {
        int totalTasks = 0;
        int runningTasks = 0;
        int completedTasks = 0;
        int totalDrivers = 0;
        int queuedDrivers = 0;
        int runningDrivers = 0;
        int blockedDrivers = 0;
        int completedDrivers = 0;
        double cumulativeUserMemory = 0.0;
        double cumulativeTotalMemory = 0.0;
        long userMemoryReservation = 0L;
        long totalMemoryReservation = 0L;
        long totalScheduledTime = 0L;
        long totalCpuTime = 0L;
        long retriedCpuTime = 0L;
        long totalBlockedTime = 0L;
        long totalAllocation = 0L;
        long rawInputDataSize = 0L;
        long rawInputPositions = 0L;
        long processedInputDataSize = 0L;
        long processedInputPositions = 0L;
        long shuffledDataSize = 0L;
        long shuffledPositions = 0L;
        long outputDataSize = 0L;
        long outputPositions = 0L;
        long writtenOutputPositions = 0L;
        long writtenOutputLogicalDataSize = 0L;
        long writtenOutputPhysicalDataSize = 0L;
        long writtenIntermediatePhysicalDataSize = 0L;
        ImmutableList.Builder stageGcStatistics = ImmutableList.builderWithExpectedSize((int)allStages.size());
        boolean fullyBlocked = rootStage.isPresent();
        HashSet<BlockedReason> blockedReasons = new HashSet<BlockedReason>();
        ImmutableList.Builder operatorStatsSummary = ImmutableList.builder();
        RuntimeStats mergedRuntimeStats = RuntimeStats.copyOf((RuntimeStats)runtimeStats);
        for (StageInfo stageInfo : allStages) {
            StageExecutionStats stageExecutionStats = stageInfo.getLatestAttemptExecutionInfo().getStats();
            totalTasks += stageExecutionStats.getTotalTasks();
            runningTasks += stageExecutionStats.getRunningTasks();
            completedTasks += stageExecutionStats.getCompletedTasks();
            totalDrivers += stageExecutionStats.getTotalDrivers();
            queuedDrivers += stageExecutionStats.getQueuedDrivers();
            runningDrivers += stageExecutionStats.getRunningDrivers();
            blockedDrivers += stageExecutionStats.getBlockedDrivers();
            completedDrivers += stageExecutionStats.getCompletedDrivers();
            cumulativeUserMemory += stageExecutionStats.getCumulativeUserMemory();
            cumulativeTotalMemory += stageExecutionStats.getCumulativeTotalMemory();
            userMemoryReservation += stageExecutionStats.getUserMemoryReservationInBytes();
            totalMemoryReservation += stageExecutionStats.getTotalMemoryReservationInBytes();
            totalScheduledTime += stageExecutionStats.getTotalScheduledTime().roundTo(TimeUnit.MILLISECONDS);
            totalCpuTime += stageExecutionStats.getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS);
            retriedCpuTime += QueryStats.computeRetriedCpuTime(stageInfo);
            totalBlockedTime += stageExecutionStats.getTotalBlockedTime().roundTo(TimeUnit.MILLISECONDS);
            if (!stageInfo.getLatestAttemptExecutionInfo().getState().isDone()) {
                fullyBlocked &= stageExecutionStats.isFullyBlocked();
                blockedReasons.addAll(stageExecutionStats.getBlockedReasons());
            }
            totalAllocation += stageExecutionStats.getTotalAllocationInBytes();
            if (stageInfo.getPlan().isPresent()) {
                PlanFragment plan = stageInfo.getPlan().get();
                for (OperatorStats operatorStats : stageExecutionStats.getOperatorSummaries()) {
                    String operatorType = operatorStats.getOperatorType();
                    if (operatorType.equals(ExchangeOperator.class.getSimpleName()) || operatorType.equals(MergeOperator.class.getSimpleName())) {
                        shuffledPositions += operatorStats.getRawInputPositions();
                        shuffledDataSize += operatorStats.getRawInputDataSizeInBytes();
                        continue;
                    }
                    if (!operatorType.equals(TableScanOperator.class.getSimpleName()) && !operatorType.equals(ScanFilterAndProjectOperator.class.getSimpleName())) continue;
                    rawInputDataSize += operatorStats.getRawInputDataSizeInBytes();
                    rawInputPositions += operatorStats.getRawInputPositions();
                }
                processedInputDataSize += stageExecutionStats.getProcessedInputDataSizeInBytes();
                processedInputPositions += stageExecutionStats.getProcessedInputPositions();
                if (plan.isOutputTableWriterFragment()) {
                    writtenOutputPositions += stageExecutionStats.getOperatorSummaries().stream().filter(stats -> stats.getOperatorType().equals("TableWriterOperator")).mapToLong(OperatorStats::getInputPositions).sum();
                    writtenOutputLogicalDataSize += stageExecutionStats.getOperatorSummaries().stream().filter(stats -> stats.getOperatorType().equals("TableWriterOperator")).mapToLong(OperatorStats::getInputDataSizeInBytes).sum();
                    writtenOutputPhysicalDataSize += stageExecutionStats.getPhysicalWrittenDataSizeInBytes();
                } else {
                    writtenIntermediatePhysicalDataSize += stageExecutionStats.getPhysicalWrittenDataSizeInBytes();
                }
            }
            stageGcStatistics.add((Object)stageExecutionStats.getGcInfo());
            operatorStatsSummary.addAll(stageExecutionStats.getOperatorSummaries());
            int stageId = stageInfo.getStageId().getId();
            stageExecutionStats.getRuntimeStats().getMetrics().forEach((name, metric) -> {
                String metricName = String.format("S%d-%s", stageId, name);
                mergedRuntimeStats.mergeMetric(metricName, metric);
            });
        }
        if (rootStage.isPresent()) {
            StageExecutionStats outputStageStats = rootStage.get().getLatestAttemptExecutionInfo().getStats();
            outputDataSize += outputStageStats.getOutputDataSizeInBytes();
            outputPositions += outputStageStats.getOutputPositions();
        }
        boolean isScheduled = rootStage.isPresent() && allStages.stream().map(StageInfo::getLatestAttemptExecutionInfo).map(StageExecutionInfo::getState).allMatch(state -> state == StageExecutionState.RUNNING || state.isDone());
        return new QueryStats(queryStateTimer.getCreateTimeInMillis(), queryStateTimer.getExecutionStartTimeInMillis(), queryStateTimer.getLastHeartbeatInMillis(), queryStateTimer.getEndTimeInMillis(), queryStateTimer.getElapsedTime(), queryStateTimer.getWaitingForPrerequisitesTime(), queryStateTimer.getQueuedTime(), queryStateTimer.getResourceWaitingTime(), queryStateTimer.getSemanticAnalyzingTime(), queryStateTimer.getColumnAccessPermissionCheckingTime(), queryStateTimer.getDispatchingTime(), queryStateTimer.getExecutionTime(), queryStateTimer.getAnalysisTime(), queryStateTimer.getPlanningTime(), queryStateTimer.getFinishingTime(), totalTasks, runningTasks, peakRunningTasks, completedTasks, totalDrivers, queuedDrivers, runningDrivers, blockedDrivers, completedDrivers, cumulativeUserMemory, cumulativeTotalMemory, DataSize.succinctBytes((long)userMemoryReservation), DataSize.succinctBytes((long)totalMemoryReservation), DataSize.succinctBytes((long)peakUserMemoryReservation), DataSize.succinctBytes((long)peakTotalMemoryReservation), DataSize.succinctBytes((long)peakTaskUserMemory), DataSize.succinctBytes((long)peakTaskTotalMemory), DataSize.succinctBytes((long)peakNodeTotalMemory), isScheduled, Duration.succinctDuration((double)totalScheduledTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)totalCpuTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)retriedCpuTime, (TimeUnit)TimeUnit.MILLISECONDS), Duration.succinctDuration((double)totalBlockedTime, (TimeUnit)TimeUnit.MILLISECONDS), fullyBlocked, blockedReasons, DataSize.succinctBytes((long)totalAllocation), DataSize.succinctBytes((long)rawInputDataSize), rawInputPositions, DataSize.succinctBytes((long)processedInputDataSize), processedInputPositions, DataSize.succinctBytes((long)shuffledDataSize), shuffledPositions, DataSize.succinctBytes((long)outputDataSize), outputPositions, writtenOutputPositions, DataSize.succinctBytes((long)writtenOutputLogicalDataSize), DataSize.succinctBytes((long)writtenOutputPhysicalDataSize), DataSize.succinctBytes((long)writtenIntermediatePhysicalDataSize), (List<StageGcStatistics>)stageGcStatistics.build(), (List<OperatorStats>)operatorStatsSummary.build(), mergedRuntimeStats);
    }

    private static long computeRetriedCpuTime(StageInfo stageInfo) {
        long stageRetriedCpuTime = stageInfo.getPreviousAttemptsExecutionInfos().stream().mapToLong(executionInfo -> executionInfo.getStats().getTotalCpuTime().roundTo(TimeUnit.MILLISECONDS)).sum();
        long taskRetriedCpuTime = stageInfo.getLatestAttemptExecutionInfo().getStats().getRetriedCpuTime().roundTo(TimeUnit.MILLISECONDS);
        return stageRetriedCpuTime + taskRetriedCpuTime;
    }

    public static QueryStats immediateFailureQueryStats() {
        long now = System.currentTimeMillis();
        return new QueryStats(now, now, now, now, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0.0, 0.0, DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), false, new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), new Duration(0.0, TimeUnit.MILLISECONDS), false, (Set<BlockedReason>)ImmutableSet.of(), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), 0L, DataSize.succinctBytes((long)0L), 0L, DataSize.succinctBytes((long)0L), 0L, DataSize.succinctBytes((long)0L), 0L, 0L, DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), DataSize.succinctBytes((long)0L), (List<StageGcStatistics>)ImmutableList.of(), (List<OperatorStats>)ImmutableList.of(), new RuntimeStats());
    }

    @JsonProperty
    public DateTime getCreateTime() {
        return new DateTime(this.createTimeInMillis);
    }

    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    @JsonProperty
    public DateTime getExecutionStartTime() {
        return new DateTime(this.executionStartTimeInMillis);
    }

    public long getExecutionStartTimeInMillis() {
        return this.executionStartTimeInMillis;
    }

    @JsonProperty
    public DateTime getLastHeartbeat() {
        return new DateTime(this.lastHeartbeatInMillis);
    }

    public long getLastHeartbeatInMillis() {
        return this.lastHeartbeatInMillis;
    }

    @Nullable
    @JsonProperty
    public DateTime getEndTime() {
        return new DateTime(this.endTimeInMillis);
    }

    public long getEndTimeInMillis() {
        return this.endTimeInMillis;
    }

    @JsonProperty
    public Duration getElapsedTime() {
        return this.elapsedTime;
    }

    @JsonProperty
    public Duration getWaitingForPrerequisitesTime() {
        return this.waitingForPrerequisitesTime;
    }

    @JsonProperty
    public Duration getResourceWaitingTime() {
        return this.resourceWaitingTime;
    }

    @JsonProperty
    public Duration getSemanticAnalyzingTime() {
        return this.semanticAnalyzingTime;
    }

    @JsonProperty
    public Duration getColumnAccessPermissionCheckingTime() {
        return this.columnAccessPermissionCheckingTime;
    }

    @JsonProperty
    public Duration getDispatchingTime() {
        return this.dispatchingTime;
    }

    @JsonProperty
    public Duration getQueuedTime() {
        return this.queuedTime;
    }

    @JsonProperty
    public Duration getExecutionTime() {
        return this.executionTime;
    }

    @JsonProperty
    public Duration getAnalysisTime() {
        return this.analysisTime;
    }

    @JsonProperty
    public Duration getTotalPlanningTime() {
        return this.totalPlanningTime;
    }

    @JsonProperty
    public Duration getFinishingTime() {
        return this.finishingTime;
    }

    @JsonProperty
    public int getTotalTasks() {
        return this.totalTasks;
    }

    @JsonProperty
    public int getRunningTasks() {
        return this.runningTasks;
    }

    @JsonProperty
    public int getPeakRunningTasks() {
        return this.peakRunningTasks;
    }

    @JsonProperty
    public int getCompletedTasks() {
        return this.completedTasks;
    }

    @JsonProperty
    public int getTotalDrivers() {
        return this.totalDrivers;
    }

    @JsonProperty
    public int getQueuedDrivers() {
        return this.queuedDrivers;
    }

    @JsonProperty
    public int getRunningDrivers() {
        return this.runningDrivers;
    }

    @JsonProperty
    public int getBlockedDrivers() {
        return this.blockedDrivers;
    }

    @JsonProperty
    public int getCompletedDrivers() {
        return this.completedDrivers;
    }

    @JsonProperty
    public double getCumulativeUserMemory() {
        return this.cumulativeUserMemory;
    }

    @JsonProperty
    public double getCumulativeTotalMemory() {
        return this.cumulativeTotalMemory;
    }

    @JsonProperty
    public DataSize getUserMemoryReservation() {
        return this.userMemoryReservation;
    }

    @JsonProperty
    public DataSize getTotalMemoryReservation() {
        return this.totalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakUserMemoryReservation() {
        return this.peakUserMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTotalMemoryReservation() {
        return this.peakTotalMemoryReservation;
    }

    @JsonProperty
    public DataSize getPeakTaskTotalMemory() {
        return this.peakTaskTotalMemory;
    }

    @JsonProperty
    public DataSize getPeakNodeTotalMemory() {
        return this.peakNodeTotalMemory;
    }

    @JsonProperty
    public DataSize getPeakTaskUserMemory() {
        return this.peakTaskUserMemory;
    }

    @JsonProperty
    public boolean isScheduled() {
        return this.scheduled;
    }

    @JsonProperty
    public Duration getTotalScheduledTime() {
        return this.totalScheduledTime;
    }

    @JsonProperty
    public Duration getTotalCpuTime() {
        return this.totalCpuTime;
    }

    @JsonProperty
    public Duration getRetriedCpuTime() {
        return this.retriedCpuTime;
    }

    @JsonProperty
    public Duration getTotalBlockedTime() {
        return this.totalBlockedTime;
    }

    @JsonProperty
    public boolean isFullyBlocked() {
        return this.fullyBlocked;
    }

    @JsonProperty
    public Set<BlockedReason> getBlockedReasons() {
        return this.blockedReasons;
    }

    @JsonProperty
    public DataSize getTotalAllocation() {
        return this.totalAllocation;
    }

    @JsonProperty
    public DataSize getRawInputDataSize() {
        return this.rawInputDataSize;
    }

    @JsonProperty
    public long getRawInputPositions() {
        return this.rawInputPositions;
    }

    @JsonProperty
    public DataSize getProcessedInputDataSize() {
        return this.processedInputDataSize;
    }

    @JsonProperty
    public long getProcessedInputPositions() {
        return this.processedInputPositions;
    }

    @JsonProperty
    public DataSize getShuffledDataSize() {
        return this.shuffledDataSize;
    }

    @JsonProperty
    public long getShuffledPositions() {
        return this.shuffledPositions;
    }

    @JsonProperty
    public DataSize getOutputDataSize() {
        return this.outputDataSize;
    }

    @JsonProperty
    public long getOutputPositions() {
        return this.outputPositions;
    }

    @JsonProperty
    public long getWrittenOutputPositions() {
        return this.writtenOutputPositions;
    }

    @JsonProperty
    public DataSize getWrittenOutputLogicalDataSize() {
        return this.writtenOutputLogicalDataSize;
    }

    @JsonProperty
    public DataSize getWrittenOutputPhysicalDataSize() {
        return this.writtenOutputPhysicalDataSize;
    }

    @JsonProperty
    public DataSize getWrittenIntermediatePhysicalDataSize() {
        return this.writtenIntermediatePhysicalDataSize;
    }

    @JsonProperty
    public List<StageGcStatistics> getStageGcStatistics() {
        return this.stageGcStatistics;
    }

    @JsonProperty
    public List<OperatorStats> getOperatorSummaries() {
        return this.operatorSummaries;
    }

    @JsonProperty
    public OptionalDouble getProgressPercentage() {
        if (!this.scheduled || this.totalDrivers == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.min(100.0, (double)this.completedDrivers * 100.0 / (double)this.totalDrivers));
    }

    @JsonProperty
    public DataSize getSpilledDataSize() {
        return DataSize.succinctBytes((long)this.operatorSummaries.stream().mapToLong(OperatorStats::getSpilledDataSizeInBytes).sum());
    }

    @JsonProperty
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }
}

