/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.execution.SessionTransactionControlTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;

public class ResetSessionTask
implements SessionTransactionControlTask<ResetSession> {
    @Override
    public String getName() {
        return "RESET SESSION";
    }

    @Override
    public ListenableFuture<?> execute(ResetSession statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters, String query) {
        List parts = statement.getName().getParts();
        if (parts.size() > 2) {
            throw new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Invalid session property '%s'", new Object[]{statement.getName()});
        }
        if (parts.size() == 1) {
            metadata.getSessionPropertyManager().getSystemSessionPropertyMetadata((String)parts.get(0)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", new Object[]{statement.getName()}));
        } else {
            ConnectorId connectorId = MetadataUtil.getConnectorIdOrThrow(stateMachine.getSession(), metadata, (String)parts.get(0), (Statement)statement, "Catalog %s does not exist");
            metadata.getSessionPropertyManager().getConnectorSessionPropertyMetadata(connectorId, (String)parts.get(1)).orElseThrow(() -> new SemanticException(SemanticErrorCode.INVALID_SESSION_PROPERTY, (Node)statement, "Session property %s does not exist", new Object[]{statement.getName()}));
        }
        stateMachine.addResetSessionProperties(statement.getName().toString());
        return Futures.immediateFuture(null);
    }
}

