/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class RevokeTask
implements DDLDefinitionTask<Revoke> {
    @Override
    public String getName() {
        return "REVOKE";
    }

    @Override
    public ListenableFuture<?> execute(Revoke statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName());
        Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
        }
        Set<Object> privileges = statement.getPrivileges().isPresent() ? (Set)((List)statement.getPrivileges().get()).stream().map(privilege -> RevokeTask.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        for (Privilege privilege2 : privileges) {
            accessControl.checkCanRevokeTablePrivilege(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), privilege2, tableName, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isGrantOptionFor());
        }
        metadata.revokeTablePrivileges(session, tableName, privileges, MetadataUtil.createPrincipal(statement.getGrantee()), statement.isGrantOptionFor());
        return Futures.immediateFuture(null);
    }

    private static Privilege parsePrivilege(Revoke statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw new SemanticException(SemanticErrorCode.INVALID_PRIVILEGE, (Node)statement, "Unknown privilege: '%s'", new Object[]{privilegeString});
    }
}

