/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.spi.QueryId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

@ThriftStruct
public class StageExecutionId {
    private final StageId stageId;
    private final int id;

    @JsonCreator
    public static StageExecutionId valueOf(String stageExecutionAttemptId) {
        return StageExecutionId.valueOf(QueryId.parseDottedId((String)stageExecutionAttemptId, (int)3, (String)"stageExecutionAttemptId"));
    }

    public static StageExecutionId valueOf(List<String> ids) {
        Preconditions.checkArgument((ids.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 ids but got: %s", ids);
        return new StageExecutionId(new StageId(new QueryId(ids.get(0)), Integer.parseInt(ids.get(1))), Integer.parseInt(ids.get(2)));
    }

    @ThriftConstructor
    public StageExecutionId(StageId stageId, int id) {
        this.stageId = Objects.requireNonNull(stageId, "stageId is null");
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (String)"id is negative: %s", (int)id);
        this.id = id;
    }

    @ThriftField(value=1)
    public StageId getStageId() {
        return this.stageId;
    }

    @ThriftField(value=2)
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageExecutionId that = (StageExecutionId)o;
        return this.id == that.id && Objects.equals(this.stageId, that.stageId);
    }

    public int hashCode() {
        return Objects.hash(this.stageId, this.id);
    }

    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendString(builder);
        return builder.toString();
    }

    public void appendString(StringBuilder builder) {
        this.stageId.appendString(builder);
        builder.append(".").append(this.id);
    }
}

