/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.execution.DDLDefinitionTask;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.TruncateTable;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class TruncateTableTask
implements DDLDefinitionTask<TruncateTable> {
    @Override
    public String getName() {
        return "TRUNCATE TABLE";
    }

    @Override
    public ListenableFuture<?> execute(TruncateTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, Session session, List<Expression> parameters, WarningCollector warningCollector, String query) {
        QualifiedObjectName tableName;
        MetadataResolver metadataResolver = metadata.getMetadataResolver(session);
        if (metadataResolver.isMaterializedView(tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTableName()))) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot truncate a materialized view", new Object[0]);
        }
        if (metadataResolver.isView(tableName)) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Cannot truncate a view", new Object[0]);
        }
        Optional tableHandle = metadata.getMetadataResolver(session).getTableHandle(tableName);
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", new Object[]{tableName});
        }
        accessControl.checkCanTruncateTable(session.getRequiredTransactionId(), session.getIdentity(), session.getAccessControlContext(), tableName);
        metadata.truncateTable(session, (TableHandle)tableHandle.get());
        return Futures.immediateFuture(null);
    }
}

