/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import io.airlift.compress.Compressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;

public class GzipCompressor
implements Compressor {
    private static final int EXTRA_COMPRESSION_SPACE = 16;

    public int maxCompressedLength(int uncompressedSize) {
        return uncompressedSize + (uncompressedSize + 7 >> 3) + (uncompressedSize + 63 >> 6) + 5 + 16;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int compress(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset, int maxOutputLength) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int n;
            try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
                gzipOutputStream.write(input, inputOffset, inputLength);
                gzipOutputStream.finish();
                byte[] compressed = byteArrayOutputStream.toByteArray();
                if (compressed.length > maxOutputLength) {
                    throw new IllegalArgumentException("maxCompressedLength formula is incorrect, because gzip produced more data");
                }
                System.arraycopy(compressed, 0, output, outputOffset, compressed.length);
                n = compressed.length;
            }
            return n;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void compress(ByteBuffer input, ByteBuffer output) {
        if (input.isDirect() || output.isDirect() || !input.hasArray() || !output.hasArray()) {
            throw new IllegalArgumentException("Non-direct byte buffer backed by byte array required");
        }
        int inputOffset = input.arrayOffset() + input.position();
        int outputOffset = output.arrayOffset() + output.position();
        int written = this.compress(input.array(), inputOffset, input.remaining(), output.array(), outputOffset, output.remaining());
        ((Buffer)output).position(output.position() + written);
    }
}

