/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.buffer.OutputBufferMemoryManager;
import com.facebook.presto.execution.buffer.SerializedPageReference;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import javax.annotation.Nullable;

final class LifespanSerializedPageTracker
implements SerializedPageReference.PagesReleasedListener {
    private final OutputBufferMemoryManager memoryManager;
    @Nullable
    private final SerializedPageReference.PagesReleasedListener childListener;
    private final ConcurrentMap<Lifespan, AtomicLong> outstandingPageCountPerLifespan = new ConcurrentHashMap<Lifespan, AtomicLong>();
    private final Set<Lifespan> noMorePagesForLifespan = ConcurrentHashMap.newKeySet();
    private volatile Consumer<Lifespan> lifespanCompletionCallback;

    public LifespanSerializedPageTracker(OutputBufferMemoryManager memoryManager) {
        this(memoryManager, Optional.empty());
    }

    public LifespanSerializedPageTracker(OutputBufferMemoryManager memoryManager, Optional<SerializedPageReference.PagesReleasedListener> childListener) {
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.childListener = Objects.requireNonNull(childListener, "childListener is null").orElse(null);
    }

    public boolean isLifespanCompletionCallbackRegistered() {
        return this.lifespanCompletionCallback != null;
    }

    public void registerLifespanCompletionCallback(Consumer<Lifespan> callback) {
        Preconditions.checkState((this.lifespanCompletionCallback == null ? 1 : 0) != 0, (Object)"lifespanCompletionCallback is already set");
        this.lifespanCompletionCallback = Objects.requireNonNull(callback, "callback is null");
    }

    public void incrementLifespanPageCount(Lifespan lifespan, int pagesAdded) {
        AtomicLong counter = (AtomicLong)this.outstandingPageCountPerLifespan.get(lifespan);
        if (counter == null) {
            counter = this.outstandingPageCountPerLifespan.computeIfAbsent(lifespan, ignore -> new AtomicLong());
        }
        counter.addAndGet(pagesAdded);
    }

    public void setNoMorePagesForLifespan(Lifespan lifespan) {
        Objects.requireNonNull(lifespan, "lifespan is null");
        this.noMorePagesForLifespan.add(lifespan);
    }

    public boolean isNoMorePagesForLifespan(Lifespan lifespan) {
        return this.noMorePagesForLifespan.contains(lifespan);
    }

    public boolean isFinishedForLifespan(Lifespan lifespan) {
        if (!this.noMorePagesForLifespan.contains(lifespan)) {
            return false;
        }
        AtomicLong outstandingPageCount = (AtomicLong)this.outstandingPageCountPerLifespan.get(lifespan);
        return outstandingPageCount == null || outstandingPageCount.get() == 0L;
    }

    @Override
    public void onPagesReleased(Lifespan lifespan, int releasedPageCount, long releasedSizeInBytes) {
        long outstandingPageCount = ((AtomicLong)this.outstandingPageCountPerLifespan.get(lifespan)).addAndGet(-releasedPageCount);
        if (outstandingPageCount == 0L && this.noMorePagesForLifespan.contains(lifespan)) {
            Consumer<Lifespan> lifespanCompletionCallback = this.lifespanCompletionCallback;
            Preconditions.checkState((lifespanCompletionCallback != null ? 1 : 0) != 0, (Object)"lifespanCompletionCallback is not null");
            lifespanCompletionCallback.accept(lifespan);
        }
        this.memoryManager.updateMemoryUsage(-releasedSizeInBytes);
        if (this.childListener != null) {
            this.childListener.onPagesReleased(lifespan, releasedPageCount, releasedSizeInBytes);
        }
    }
}

