/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ThriftStruct
public class PageBufferInfo {
    private final int partition;
    private final long bufferedPages;
    private final long bufferedBytes;
    private final long rowsAdded;
    private final long pagesAdded;

    @JsonCreator
    @ThriftConstructor
    public PageBufferInfo(@JsonProperty(value="partition") int partition, @JsonProperty(value="bufferedPages") long bufferedPages, @JsonProperty(value="bufferedBytes") long bufferedBytes, @JsonProperty(value="rowsAdded") long rowsAdded, @JsonProperty(value="pagesAdded") long pagesAdded) {
        this.partition = partition;
        this.bufferedPages = bufferedPages;
        this.bufferedBytes = bufferedBytes;
        this.rowsAdded = rowsAdded;
        this.pagesAdded = pagesAdded;
    }

    @JsonProperty
    @ThriftField(value=1)
    public int getPartition() {
        return this.partition;
    }

    @JsonProperty
    @ThriftField(value=2)
    public long getBufferedPages() {
        return this.bufferedPages;
    }

    @JsonProperty
    @ThriftField(value=3)
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @JsonProperty
    @ThriftField(value=4)
    public long getRowsAdded() {
        return this.rowsAdded;
    }

    @JsonProperty
    @ThriftField(value=5)
    public long getPagesAdded() {
        return this.pagesAdded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PageBufferInfo that = (PageBufferInfo)o;
        return Objects.equals(this.partition, that.partition) && Objects.equals(this.bufferedPages, that.bufferedPages) && Objects.equals(this.bufferedBytes, that.bufferedBytes) && Objects.equals(this.rowsAdded, that.rowsAdded) && Objects.equals(this.pagesAdded, that.pagesAdded);
    }

    public int hashCode() {
        return Objects.hash(this.partition, this.bufferedPages, this.bufferedBytes, this.rowsAdded, this.pagesAdded);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("partition", this.partition).add("bufferedPages", this.bufferedPages).add("bufferedBytes", this.bufferedBytes).add("rowsAdded", this.rowsAdded).add("pagesAdded", this.pagesAdded).toString();
    }

    public static PageBufferInfo empty() {
        return new PageBufferInfo(0, 0L, 0L, 0L, 0L);
    }
}

