/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CTEMaterializationTracker {
    private final Map<String, SettableFuture<Void>> materializationFutures = new ConcurrentHashMap<String, SettableFuture<Void>>();

    public ListenableFuture<Void> getFutureForCTE(String cteName) {
        return Futures.nonCancellationPropagating((ListenableFuture)((ListenableFuture)this.materializationFutures.compute(cteName, (key, existingFuture) -> {
            if (existingFuture == null) {
                return SettableFuture.create();
            }
            Preconditions.checkArgument((!existingFuture.isCancelled() ? 1 : 0) != 0, (Object)String.format("Error: Existing future was found cancelled in CTEMaterializationTracker for cte", cteName));
            return existingFuture;
        })));
    }

    public void markCTEAsMaterialized(String cteName) {
        this.materializationFutures.compute(cteName, (key, existingFuture) -> {
            if (existingFuture == null) {
                SettableFuture completedFuture = SettableFuture.create();
                completedFuture.set(null);
                return completedFuture;
            }
            Preconditions.checkArgument((!existingFuture.isCancelled() ? 1 : 0) != 0, (Object)String.format("Error: Existing future was found cancelled in CTEMaterializationTracker for cte", cteName));
            existingFuture.set(null);
            return existingFuture;
        });
    }
}

