/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.scheduler;

import com.facebook.presto.execution.SqlStageExecution;
import com.facebook.presto.execution.StageExecutionState;
import com.facebook.presto.execution.scheduler.ExecutionSchedule;
import com.facebook.presto.execution.scheduler.StageExecutionAndScheduler;
import com.facebook.presto.spi.plan.JoinNode;
import com.facebook.presto.spi.plan.MergeJoinNode;
import com.facebook.presto.spi.plan.PlanFragmentId;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.SemiJoinNode;
import com.facebook.presto.spi.plan.SpatialJoinNode;
import com.facebook.presto.spi.plan.UnionNode;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.InternalPlanVisitor;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.KosarajuStrongConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;

@NotThreadSafe
public class PhasedExecutionSchedule
implements ExecutionSchedule {
    private final List<Set<StageExecutionAndScheduler>> schedulePhases;
    private final Set<StageExecutionAndScheduler> activeSources = new HashSet<StageExecutionAndScheduler>();

    public PhasedExecutionSchedule(Collection<StageExecutionAndScheduler> stages) {
        List<Set<PlanFragmentId>> phases = PhasedExecutionSchedule.extractPhases((Collection)stages.stream().map(StageExecutionAndScheduler::getStageExecution).map(SqlStageExecution::getFragment).collect(ImmutableList.toImmutableList()));
        Map stagesByFragmentId = (Map)stages.stream().collect(ImmutableMap.toImmutableMap(stage -> stage.getStageExecution().getFragment().getId(), Function.identity()));
        this.schedulePhases = new ArrayList<Set<StageExecutionAndScheduler>>();
        for (Set<PlanFragmentId> phase : phases) {
            this.schedulePhases.add(phase.stream().map(stagesByFragmentId::get).collect(Collectors.toCollection(HashSet::new)));
        }
    }

    @Override
    public Set<StageExecutionAndScheduler> getStagesToSchedule() {
        this.removeCompletedStages();
        this.addPhasesIfNecessary();
        if (this.isFinished()) {
            return ImmutableSet.of();
        }
        return this.activeSources;
    }

    private void removeCompletedStages() {
        Iterator<StageExecutionAndScheduler> stageIterator = this.activeSources.iterator();
        while (stageIterator.hasNext()) {
            StageExecutionState state = stageIterator.next().getStageExecution().getState();
            if (state != StageExecutionState.SCHEDULED && state != StageExecutionState.RUNNING && !state.isDone()) continue;
            stageIterator.remove();
        }
    }

    private void addPhasesIfNecessary() {
        if (PhasedExecutionSchedule.hasSourceDistributedStage(this.activeSources)) {
            return;
        }
        while (!this.schedulePhases.isEmpty()) {
            Set<StageExecutionAndScheduler> phase = this.schedulePhases.remove(0);
            this.activeSources.addAll(phase);
            if (!PhasedExecutionSchedule.hasSourceDistributedStage(phase)) continue;
            return;
        }
    }

    private static boolean hasSourceDistributedStage(Set<StageExecutionAndScheduler> phase) {
        return phase.stream().anyMatch(stage -> !stage.getStageExecution().getFragment().getTableScanSchedulingOrder().isEmpty());
    }

    @Override
    public boolean isFinished() {
        return this.activeSources.isEmpty() && this.schedulePhases.isEmpty();
    }

    @VisibleForTesting
    static List<Set<PlanFragmentId>> extractPhases(Collection<PlanFragment> fragments) {
        DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
        fragments.forEach(arg_0 -> PhasedExecutionSchedule.lambda$extractPhases$2((Graph)graph, arg_0));
        Visitor visitor = new Visitor(fragments, (Graph<PlanFragmentId, DefaultEdge>)graph);
        for (PlanFragment fragment : fragments) {
            visitor.processFragment(fragment.getId());
        }
        List components = new KosarajuStrongConnectivityInspector((Graph)graph).stronglyConnectedSets();
        HashMap<PlanFragmentId, Object> componentMembership = new HashMap<PlanFragmentId, Object>();
        for (Object component : components) {
            Iterator iterator = component.iterator();
            while (iterator.hasNext()) {
                PlanFragmentId planFragmentId = (PlanFragmentId)iterator.next();
                componentMembership.put(planFragmentId, component);
            }
        }
        DefaultDirectedGraph componentGraph = new DefaultDirectedGraph(DefaultEdge.class);
        components.forEach(arg_0 -> ((Graph)componentGraph).addVertex(arg_0));
        for (DefaultEdge edge : graph.edgeSet()) {
            Set to;
            PlanFragmentId source = (PlanFragmentId)graph.getEdgeSource((Object)edge);
            PlanFragmentId target = (PlanFragmentId)graph.getEdgeTarget((Object)edge);
            Set from = (Set)componentMembership.get(source);
            if (from.equals(to = (Set)componentMembership.get(target))) continue;
            componentGraph.addEdge((Object)from, (Object)to);
        }
        ImmutableList schedulePhases = ImmutableList.copyOf((Iterator)new TopologicalOrderIterator((Graph)componentGraph));
        return schedulePhases;
    }

    private static /* synthetic */ void lambda$extractPhases$2(Graph graph, PlanFragment fragment) {
        graph.addVertex((Object)fragment.getId());
    }

    private static class Visitor
    extends InternalPlanVisitor<Set<PlanFragmentId>, PlanFragmentId> {
        private final Map<PlanFragmentId, PlanFragment> fragments;
        private final Graph<PlanFragmentId, DefaultEdge> graph;
        private final Map<PlanFragmentId, Set<PlanFragmentId>> fragmentSources = new HashMap<PlanFragmentId, Set<PlanFragmentId>>();

        public Visitor(Collection<PlanFragment> fragments, Graph<PlanFragmentId, DefaultEdge> graph) {
            this.fragments = (Map)fragments.stream().collect(ImmutableMap.toImmutableMap(PlanFragment::getId, Function.identity()));
            this.graph = graph;
        }

        public Set<PlanFragmentId> processFragment(PlanFragmentId planFragmentId) {
            if (this.fragmentSources.containsKey(planFragmentId)) {
                return this.fragmentSources.get(planFragmentId);
            }
            Set<PlanFragmentId> fragment = this.processFragment(this.fragments.get(planFragmentId));
            this.fragmentSources.put(planFragmentId, fragment);
            return fragment;
        }

        private Set<PlanFragmentId> processFragment(PlanFragment fragment) {
            Set sources = (Set)fragment.getRoot().accept((PlanVisitor)this, (Object)fragment.getId());
            return ImmutableSet.builder().add((Object)fragment.getId()).addAll((Iterable)sources).build();
        }

        public Set<PlanFragmentId> visitJoin(JoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getRight(), node.getLeft(), currentFragmentId);
        }

        public Set<PlanFragmentId> visitSpatialJoin(SpatialJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getRight(), node.getLeft(), currentFragmentId);
        }

        public Set<PlanFragmentId> visitSemiJoin(SemiJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getFilteringSource(), node.getSource(), currentFragmentId);
        }

        @Override
        public Set<PlanFragmentId> visitIndexJoin(IndexJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getIndexSource(), node.getProbeSource(), currentFragmentId);
        }

        public Set<PlanFragmentId> visitMergeJoin(MergeJoinNode node, PlanFragmentId currentFragmentId) {
            return this.processJoin(node.getRight(), node.getLeft(), currentFragmentId);
        }

        private Set<PlanFragmentId> processJoin(PlanNode build, PlanNode probe, PlanFragmentId currentFragmentId) {
            Set buildSources = (Set)build.accept((PlanVisitor)this, (Object)currentFragmentId);
            Set probeSources = (Set)probe.accept((PlanVisitor)this, (Object)currentFragmentId);
            for (PlanFragmentId buildSource : buildSources) {
                for (PlanFragmentId probeSource : probeSources) {
                    this.graph.addEdge((Object)buildSource, (Object)probeSource);
                }
            }
            return ImmutableSet.builder().addAll((Iterable)buildSources).addAll((Iterable)probeSources).build();
        }

        @Override
        public Set<PlanFragmentId> visitRemoteSource(RemoteSourceNode node, PlanFragmentId currentFragmentId) {
            ImmutableSet.Builder sources = ImmutableSet.builder();
            Object previousFragmentSources = ImmutableSet.of();
            for (PlanFragmentId remoteFragment : node.getSourceFragmentIds()) {
                this.graph.addEdge((Object)currentFragmentId, (Object)remoteFragment);
                Set<PlanFragmentId> remoteFragmentSources = this.processFragment(remoteFragment);
                sources.addAll(remoteFragmentSources);
                this.addEdges((Set<PlanFragmentId>)previousFragmentSources, remoteFragmentSources);
                previousFragmentSources = remoteFragmentSources;
            }
            return sources.build();
        }

        @Override
        public Set<PlanFragmentId> visitExchange(ExchangeNode node, PlanFragmentId currentFragmentId) {
            Preconditions.checkArgument((boolean)node.getScope().isLocal(), (Object)"Only local exchanges are supported in the phased execution scheduler");
            ImmutableSet.Builder allSources = ImmutableSet.builder();
            Object previousSources = ImmutableSet.of();
            for (PlanNode subPlanNode : node.getSources()) {
                Set currentSources = (Set)subPlanNode.accept((PlanVisitor)this, (Object)currentFragmentId);
                allSources.addAll((Iterable)currentSources);
                this.addEdges((Set<PlanFragmentId>)previousSources, currentSources);
                previousSources = currentSources;
            }
            return allSources.build();
        }

        public Set<PlanFragmentId> visitUnion(UnionNode node, PlanFragmentId currentFragmentId) {
            ImmutableSet.Builder allSources = ImmutableSet.builder();
            Object previousSources = ImmutableSet.of();
            for (PlanNode subPlanNode : node.getSources()) {
                Set currentSources = (Set)subPlanNode.accept((PlanVisitor)this, (Object)currentFragmentId);
                allSources.addAll((Iterable)currentSources);
                this.addEdges((Set<PlanFragmentId>)previousSources, currentSources);
                previousSources = currentSources;
            }
            return allSources.build();
        }

        public Set<PlanFragmentId> visitPlan(PlanNode node, PlanFragmentId currentFragmentId) {
            List sources = node.getSources();
            if (sources.isEmpty()) {
                return ImmutableSet.of((Object)currentFragmentId);
            }
            if (sources.size() == 1) {
                return (Set)((PlanNode)sources.get(0)).accept((PlanVisitor)this, (Object)currentFragmentId);
            }
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private void addEdges(Set<PlanFragmentId> sourceFragments, Set<PlanFragmentId> targetFragments) {
            for (PlanFragmentId targetFragment : targetFragments) {
                for (PlanFragmentId sourceFragment : sourceFragments) {
                    this.graph.addEdge((Object)sourceFragment, (Object)targetFragment);
                }
            }
        }
    }
}

