/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ClusterMemoryLeakDetector {
    private static final Logger log = Logger.get(ClusterMemoryLeakDetector.class);
    private static final int DEFAULT_LEAK_CLAIM_DELTA_MILLIS = 60000;
    @GuardedBy(value="this")
    private Set<QueryId> leakedQueries;
    @GuardedBy(value="this")
    private long leakedBytes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForMemoryLeaks(Map<QueryId, Optional<BasicQueryInfo>> queryIdToInfo, Map<QueryId, Long> queryMemoryReservations) {
        Map leakedQueryReservations = (Map)queryMemoryReservations.entrySet().stream().filter(entry -> (Long)entry.getValue() > 0L).filter(entry -> ClusterMemoryLeakDetector.isLeaked(queryIdToInfo, (QueryId)entry.getKey())).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        long leakedBytesThisTime = leakedQueryReservations.values().stream().reduce(0L, Long::sum);
        if (!leakedQueryReservations.isEmpty()) {
            log.warn("Memory leak of %s detected. The following queries are already finished, but they have memory reservations on some worker node(s): %s", new Object[]{DataSize.succinctBytes((long)this.leakedBytes), leakedQueryReservations});
        }
        ClusterMemoryLeakDetector clusterMemoryLeakDetector = this;
        synchronized (clusterMemoryLeakDetector) {
            this.leakedQueries = ImmutableSet.copyOf(leakedQueryReservations.keySet());
            this.leakedBytes = leakedBytesThisTime;
        }
    }

    private static boolean isLeaked(Map<QueryId, Optional<BasicQueryInfo>> queryIdToInfo, QueryId queryId) {
        Optional<BasicQueryInfo> queryInfo = queryIdToInfo.get(queryId);
        if (queryInfo == null) {
            return true;
        }
        Optional<Boolean> queryEndTimeInMillis = queryInfo.flatMap(qi -> Optional.ofNullable(qi.getState() == QueryState.RUNNING ? null : Long.valueOf(qi.getQueryStats().getEndTimeInMillis())));
        return queryEndTimeInMillis.map(ts -> System.currentTimeMillis() - ts >= 60000L).orElse(false);
    }

    synchronized boolean wasQueryPossiblyLeaked(QueryId queryId) {
        return this.leakedQueries.contains(queryId);
    }

    synchronized int getNumberOfLeakedQueries() {
        return this.leakedQueries.size();
    }

    synchronized long getLeakedBytes() {
        return this.leakedBytes;
    }
}

