/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.function.FunctionImplementationType;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.FunctionMetadata;
import com.facebook.presto.spi.function.Parameter;
import com.facebook.presto.spi.function.ScalarFunctionImplementation;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlInvokedFunction;
import com.facebook.presto.spi.function.SqlInvokedScalarFunctionImplementation;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class SessionFunctionHandle
implements FunctionHandle {
    public static final CatalogSchemaName SESSION_NAMESPACE = new CatalogSchemaName("presto", "session");
    private final SqlInvokedFunction sqlFunction;

    @JsonCreator
    public SessionFunctionHandle(@JsonProperty(value="sqlFunction") SqlInvokedFunction sqlFunction) {
        this.sqlFunction = Objects.requireNonNull(sqlFunction, "sqlFunction is null");
    }

    public CatalogSchemaName getCatalogSchemaName() {
        return SESSION_NAMESPACE;
    }

    public String getName() {
        return this.sqlFunction.getSignature().getName().toString();
    }

    public FunctionKind getKind() {
        return this.sqlFunction.getSignature().getKind();
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.sqlFunction.getSignature().getArgumentTypes();
    }

    public FunctionMetadata getFunctionMetadata() {
        Signature signature = this.sqlFunction.getSignature();
        return new FunctionMetadata(signature.getName(), signature.getArgumentTypes(), (List)this.sqlFunction.getParameters().stream().map(Parameter::getName).collect(ImmutableList.toImmutableList()), signature.getReturnType(), signature.getKind(), this.sqlFunction.getRoutineCharacteristics().getLanguage(), FunctionImplementationType.SQL, this.sqlFunction.isDeterministic(), this.sqlFunction.isCalledOnNullInput(), this.sqlFunction.getVersion());
    }

    @JsonProperty
    public SqlInvokedFunction getSqlFunction() {
        return this.sqlFunction;
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation() {
        return new SqlInvokedScalarFunctionImplementation(this.sqlFunction.getBody());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionFunctionHandle that = (SessionFunctionHandle)o;
        return Objects.equals(this.sqlFunction, that.sqlFunction);
    }

    public int hashCode() {
        return Objects.hash(this.sqlFunction);
    }
}

