/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class TableLayoutResult {
    private final TableLayout layout;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;

    public TableLayoutResult(TableLayout layout, TupleDomain<ColumnHandle> unenforcedConstraint) {
        this.layout = Objects.requireNonNull(layout, "layout is null");
        this.unenforcedConstraint = Objects.requireNonNull(unenforcedConstraint, "unenforcedConstraint is null");
    }

    public TableLayout getLayout() {
        return this.layout;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public static TupleDomain<ColumnHandle> computeEnforced(TupleDomain<ColumnHandle> predicate, TupleDomain<ColumnHandle> unenforced) {
        if (predicate.isNone()) {
            if (unenforced.isNone()) {
                return TupleDomain.all();
            }
            if (unenforced.isAll()) {
                return TupleDomain.none();
            }
            throw new IllegalArgumentException();
        }
        Preconditions.checkArgument((!unenforced.isNone() ? 1 : 0) != 0);
        Map predicateDomains = (Map)predicate.getDomains().get();
        Map unenforcedDomains = (Map)unenforced.getDomains().get();
        ImmutableMap.Builder enforcedDomainsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : predicateDomains.entrySet()) {
            ColumnHandle predicateColumnHandle = (ColumnHandle)entry.getKey();
            if (unenforcedDomains.containsKey(predicateColumnHandle)) {
                Preconditions.checkArgument((boolean)((Domain)entry.getValue()).equals(unenforcedDomains.get(predicateColumnHandle)), (Object)"Enforced tuple domain cannot be determined. The connector is expected to enforce the respective domain entirely on none, some, or all of the column.");
                continue;
            }
            enforcedDomainsBuilder.put((Object)predicateColumnHandle, (Object)((Domain)entry.getValue()));
        }
        ImmutableMap enforcedDomains = enforcedDomainsBuilder.build();
        Preconditions.checkArgument((enforcedDomains.size() + unenforcedDomains.size() == predicateDomains.size() ? 1 : 0) != 0, (Object)"Enforced tuple domain cannot be determined. Connector returned an unenforced TupleDomain that contains columns not in predicate.");
        return TupleDomain.withColumnDomains((Map)enforcedDomains);
    }
}

