/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.stats.CounterStat;
import com.facebook.presto.Session;
import com.facebook.presto.execution.FragmentResultCacheContext;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.execution.TaskId;
import com.facebook.presto.memory.QueryContextVisitor;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.operator.DriverStats;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.OperationTimer;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorStats;
import com.facebook.presto.operator.PipelineContext;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class DriverContext {
    private final PipelineContext pipelineContext;
    private final Executor notificationExecutor;
    private final ScheduledExecutorService yieldExecutor;
    private final AtomicBoolean finished = new AtomicBoolean();
    private final long createdTimeInMillis = System.currentTimeMillis();
    private final long createNanos = System.nanoTime();
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final OperationTimer.OperationTiming overallTiming = new OperationTimer.OperationTiming();
    private final AtomicReference<BlockedMonitor> blockedMonitor = new AtomicReference();
    private final AtomicLong blockedWallNanos = new AtomicLong();
    private final AtomicLong executionStartTime = new AtomicLong();
    private final AtomicLong executionEndTime = new AtomicLong();
    private final MemoryTrackingContext driverMemoryContext;
    private final DriverYieldSignal yieldSignal;
    private final List<OperatorContext> operatorContexts = new CopyOnWriteArrayList<OperatorContext>();
    private final Lifespan lifespan;
    private final Optional<FragmentResultCacheContext> fragmentResultCacheContext;
    private final long splitWeight;

    public DriverContext(PipelineContext pipelineContext, Executor notificationExecutor, ScheduledExecutorService yieldExecutor, MemoryTrackingContext driverMemoryContext, Lifespan lifespan, Optional<FragmentResultCacheContext> fragmentResultCacheContext, long splitWeight) {
        this.pipelineContext = Objects.requireNonNull(pipelineContext, "pipelineContext is null");
        this.notificationExecutor = Objects.requireNonNull(notificationExecutor, "notificationExecutor is null");
        this.yieldExecutor = Objects.requireNonNull(yieldExecutor, "scheduler is null");
        this.driverMemoryContext = Objects.requireNonNull(driverMemoryContext, "driverMemoryContext is null");
        this.lifespan = Objects.requireNonNull(lifespan, "lifespan is null");
        this.fragmentResultCacheContext = Objects.requireNonNull(fragmentResultCacheContext, "fragmentResultCacheContext is null");
        this.yieldSignal = new DriverYieldSignal();
        this.splitWeight = splitWeight;
        Preconditions.checkArgument((splitWeight >= 0L ? 1 : 0) != 0, (String)"splitWeight must be >= 0, found: %s", (long)splitWeight);
    }

    public TaskId getTaskId() {
        return this.pipelineContext.getTaskId();
    }

    public long getSplitWeight() {
        return this.splitWeight;
    }

    public OperatorContext addOperatorContext(int operatorId, PlanNodeId planNodeId, String operatorType) {
        Preconditions.checkArgument((operatorId >= 0 ? 1 : 0) != 0, (Object)"operatorId is negative");
        for (OperatorContext operatorContext : this.operatorContexts) {
            Preconditions.checkArgument((operatorId != operatorContext.getOperatorId() ? 1 : 0) != 0, (String)"A context already exists for operatorId %s", (int)operatorId);
        }
        OperatorContext operatorContext = new OperatorContext(operatorId, planNodeId, operatorType, this, this.notificationExecutor, this.driverMemoryContext.newMemoryTrackingContext());
        this.operatorContexts.add(operatorContext);
        return operatorContext;
    }

    public List<OperatorContext> getOperatorContexts() {
        return ImmutableList.copyOf(this.operatorContexts);
    }

    public PipelineContext getPipelineContext() {
        return this.pipelineContext;
    }

    public Session getSession() {
        return this.pipelineContext.getSession();
    }

    public void startProcessTimer() {
        if (this.executionStartTime.get() == 0L && this.startNanos.compareAndSet(0L, System.nanoTime())) {
            this.executionStartTime.set(System.currentTimeMillis());
            this.pipelineContext.start();
        }
    }

    public void recordProcessed(OperationTimer operationTimer) {
        operationTimer.end(this.overallTiming);
    }

    public void recordBlocked(ListenableFuture<?> blocked) {
        Objects.requireNonNull(blocked, "blocked is null");
        BlockedMonitor monitor = new BlockedMonitor();
        BlockedMonitor oldMonitor = this.blockedMonitor.getAndSet(monitor);
        if (oldMonitor != null) {
            oldMonitor.run();
        }
        blocked.addListener((Runnable)monitor, this.notificationExecutor);
    }

    public void finished() {
        if (!this.finished.compareAndSet(false, true)) {
            return;
        }
        this.endNanos.set(System.nanoTime());
        this.executionEndTime.set(System.currentTimeMillis());
        this.pipelineContext.driverFinished(this);
    }

    public void failed(Throwable cause) {
        this.pipelineContext.failed(cause);
        this.finished.set(true);
    }

    public boolean isDone() {
        return this.finished.get() || this.pipelineContext.isDone();
    }

    public ListenableFuture<?> reserveSpill(long bytes) {
        return this.pipelineContext.reserveSpill(bytes);
    }

    public void freeSpill(long bytes) {
        if (bytes == 0L) {
            return;
        }
        Preconditions.checkArgument((bytes > 0L ? 1 : 0) != 0, (Object)"bytes is negative");
        this.pipelineContext.freeSpill(bytes);
    }

    public DriverYieldSignal getYieldSignal() {
        return this.yieldSignal;
    }

    public long getSystemMemoryUsage() {
        return this.driverMemoryContext.getSystemMemory();
    }

    public long getMemoryUsage() {
        return this.driverMemoryContext.getUserMemory();
    }

    public long getRevocableMemoryUsage() {
        return this.driverMemoryContext.getRevocableMemory();
    }

    public void moreMemoryAvailable() {
        this.operatorContexts.forEach(OperatorContext::moreMemoryAvailable);
    }

    public boolean isPerOperatorCpuTimerEnabled() {
        return this.pipelineContext.isPerOperatorCpuTimerEnabled();
    }

    public boolean isCpuTimerEnabled() {
        return this.pipelineContext.isCpuTimerEnabled();
    }

    public boolean isPerOperatorAllocationTrackingEnabled() {
        return this.pipelineContext.isPerOperatorAllocationTrackingEnabled();
    }

    public boolean isAllocationTrackingEnabled() {
        return this.pipelineContext.isAllocationTrackingEnabled();
    }

    public CounterStat getInputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getInputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getFirst(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getInputPositions();
        }
        return new CounterStat();
    }

    public CounterStat getOutputDataSize() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputDataSize();
        }
        return new CounterStat();
    }

    public CounterStat getOutputPositions() {
        OperatorContext inputOperator = (OperatorContext)Iterables.getLast(this.operatorContexts, null);
        if (inputOperator != null) {
            return inputOperator.getOutputPositions();
        }
        return new CounterStat();
    }

    public long getPhysicalWrittenDataSize() {
        return this.operatorContexts.stream().mapToLong(OperatorContext::getPhysicalWrittenDataSize).sum();
    }

    public boolean isExecutionStarted() {
        return this.executionStartTime.get() != 0L;
    }

    public boolean isFullyBlocked() {
        return this.blockedMonitor.get() != null;
    }

    public DriverStats getDriverStats() {
        long outputPositions;
        long outputDataSize;
        long processedInputPositions;
        long processedInputDataSize;
        Duration rawInputReadTime;
        long rawInputPositions;
        long rawInputDataSize;
        long executionStartTimeInMillis;
        long totalScheduledTime = this.overallTiming.getWallNanos();
        long totalCpuTime = this.overallTiming.getCpuNanos();
        long totalAllocation = this.overallTiming.getAllocationBytes();
        long totalBlockedTime = this.blockedWallNanos.get();
        BlockedMonitor blockedMonitor = this.blockedMonitor.get();
        if (blockedMonitor != null) {
            totalBlockedTime += blockedMonitor.getBlockedTime();
        }
        Duration queuedTime = new Duration((double)DriverContext.nanosBetween(this.createNanos, (executionStartTimeInMillis = this.executionStartTime.get()) == 0L ? System.nanoTime() : this.startNanos.get()), TimeUnit.NANOSECONDS);
        long executionEndTimeInMillis = this.executionEndTime.get();
        Duration elapsedTime = new Duration((double)DriverContext.nanosBetween(this.createNanos, executionEndTimeInMillis == 0L ? System.nanoTime() : this.endNanos.get()), TimeUnit.NANOSECONDS);
        ImmutableList operators = ImmutableList.copyOf((Iterable)Iterables.transform(this.operatorContexts, OperatorContext::getOperatorStats));
        OperatorStats inputOperator = (OperatorStats)Iterables.getFirst((Iterable)operators, null);
        if (inputOperator != null) {
            rawInputDataSize = inputOperator.getRawInputDataSizeInBytes();
            rawInputPositions = inputOperator.getRawInputPositions();
            rawInputReadTime = inputOperator.getAddInputWall();
            processedInputDataSize = inputOperator.getInputDataSizeInBytes();
            processedInputPositions = inputOperator.getInputPositions();
            OperatorStats outputOperator = Objects.requireNonNull((OperatorStats)Iterables.getLast((Iterable)operators, null));
            outputDataSize = outputOperator.getOutputDataSizeInBytes();
            outputPositions = outputOperator.getOutputPositions();
        } else {
            rawInputDataSize = 0L;
            rawInputPositions = 0L;
            rawInputReadTime = new Duration(0.0, TimeUnit.MILLISECONDS);
            processedInputDataSize = 0L;
            processedInputPositions = 0L;
            outputDataSize = 0L;
            outputPositions = 0L;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        long physicalWrittenDataSize = 0L;
        for (OperatorStats operator : operators) {
            physicalWrittenDataSize += operator.getPhysicalWrittenDataSizeInBytes();
            if (operator.getBlockedReason().isPresent()) {
                builder.add((Object)operator.getBlockedReason().get());
            }
            totalCpuTime += operator.getAdditionalCpu().roundTo(TimeUnit.NANOSECONDS);
        }
        return new DriverStats(this.lifespan, this.createdTimeInMillis, executionStartTimeInMillis, executionEndTimeInMillis, queuedTime.convertToMostSuccinctTimeUnit(), elapsedTime.convertToMostSuccinctTimeUnit(), this.driverMemoryContext.getUserMemory(), this.driverMemoryContext.getRevocableMemory(), this.driverMemoryContext.getSystemMemory(), Duration.succinctNanos((long)totalScheduledTime), Duration.succinctNanos((long)totalCpuTime), Duration.succinctNanos((long)totalBlockedTime), blockedMonitor != null, (Set<BlockedReason>)builder.build(), totalAllocation, rawInputDataSize, rawInputPositions, rawInputReadTime, processedInputDataSize, processedInputPositions, outputDataSize, outputPositions, physicalWrittenDataSize, (List<OperatorStats>)operators);
    }

    public <C, R> R accept(QueryContextVisitor<C, R> visitor, C context) {
        return visitor.visitDriverContext(this, context);
    }

    public <C, R> List<R> acceptChildren(QueryContextVisitor<C, R> visitor, C context) {
        return this.operatorContexts.stream().map(operatorContext -> operatorContext.accept(visitor, context)).collect(Collectors.toList());
    }

    public Lifespan getLifespan() {
        return this.lifespan;
    }

    public Optional<FragmentResultCacheContext> getFragmentResultCacheContext() {
        return this.fragmentResultCacheContext;
    }

    public ScheduledExecutorService getYieldExecutor() {
        return this.yieldExecutor;
    }

    private static long nanosBetween(long start, long end) {
        return Math.max(0L, end - start);
    }

    @VisibleForTesting
    public MemoryTrackingContext getDriverMemoryContext() {
        return this.driverMemoryContext;
    }

    @VisibleForTesting
    public void addOperatorContext(OperatorContext operatorContext) {
        this.operatorContexts.add(operatorContext);
    }

    private class BlockedMonitor
    implements Runnable {
        private final long start = System.nanoTime();
        private boolean finished;

        private BlockedMonitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BlockedMonitor blockedMonitor = this;
            synchronized (blockedMonitor) {
                if (this.finished) {
                    return;
                }
                this.finished = true;
                DriverContext.this.blockedMonitor.compareAndSet(this, null);
                DriverContext.this.blockedWallNanos.getAndAdd(this.getBlockedTime());
            }
        }

        public long getBlockedTime() {
            return DriverContext.nanosBetween(this.start, System.nanoTime());
        }
    }
}

