/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;

@ThriftStruct
public class DynamicFilterStats {
    private final Set<PlanNodeId> producerNodeIds;

    @JsonCreator
    @ThriftConstructor
    public DynamicFilterStats(@JsonProperty(value="producerNodeIds") Set<PlanNodeId> producerNodeIds) {
        this.producerNodeIds = Objects.requireNonNull(producerNodeIds, "producerNodeIds is null");
    }

    public static DynamicFilterStats copyOf(DynamicFilterStats dynamicFilterStats) {
        Objects.requireNonNull(dynamicFilterStats, "dynamicFilterStats is null");
        return new DynamicFilterStats(dynamicFilterStats.getProducerNodeIds());
    }

    public void mergeWith(DynamicFilterStats other) {
        if (other == null) {
            return;
        }
        this.producerNodeIds.addAll(other.getProducerNodeIds());
    }

    public boolean empty() {
        return this.producerNodeIds.isEmpty();
    }

    @JsonProperty
    @ThriftField(value=1)
    public Set<PlanNodeId> getProducerNodeIds() {
        return this.producerNodeIds;
    }
}

