/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"exchange.async-page-transport-enabled"})
public class ExchangeClientConfig {
    private DataSize maxBufferSize = new DataSize(32.0, DataSize.Unit.MEGABYTE);
    private int concurrentRequestMultiplier = 3;
    private Duration minErrorDuration = new Duration(1.0, TimeUnit.MINUTES);
    private Duration maxErrorDuration = new Duration(5.0, TimeUnit.MINUTES);
    private Duration asyncPageTransportTimeout = new Duration(60.0, TimeUnit.SECONDS);
    private DataSize maxResponseSize = DataSize.succinctDataSize((double)16.0, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int clientThreads = 25;
    private int pageBufferClientMaxCallbackThreads = 25;
    private boolean acknowledgePages = true;
    private double responseSizeExponentialMovingAverageDecayingAlpha = 0.1;

    @NotNull
    public DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Config(value="exchange.max-buffer-size")
    public ExchangeClientConfig setMaxBufferSize(DataSize maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getConcurrentRequestMultiplier() {
        return this.concurrentRequestMultiplier;
    }

    @Config(value="exchange.concurrent-request-multiplier")
    public ExchangeClientConfig setConcurrentRequestMultiplier(int concurrentRequestMultiplier) {
        this.concurrentRequestMultiplier = concurrentRequestMultiplier;
        return this;
    }

    @Deprecated
    public Duration getMinErrorDuration() {
        return this.maxErrorDuration;
    }

    @Deprecated
    @Config(value="exchange.min-error-duration")
    public ExchangeClientConfig setMinErrorDuration(Duration minErrorDuration) {
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public Duration getMaxErrorDuration() {
        return this.maxErrorDuration;
    }

    @Config(value="exchange.max-error-duration")
    public ExchangeClientConfig setMaxErrorDuration(Duration maxErrorDuration) {
        this.maxErrorDuration = maxErrorDuration;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public Duration getAsyncPageTransportTimeout() {
        return this.asyncPageTransportTimeout;
    }

    @Config(value="exchange.async-page-transport-timeout")
    public ExchangeClientConfig setAsyncPageTransportTimeout(Duration asyncPageTransportTimeout) {
        this.asyncPageTransportTimeout = asyncPageTransportTimeout;
        return this;
    }

    @NotNull
    @MinDataSize(value="1MB")
    public DataSize getMaxResponseSize() {
        return this.maxResponseSize;
    }

    @Config(value="exchange.max-response-size")
    public ExchangeClientConfig setMaxResponseSize(DataSize maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getClientThreads() {
        return this.clientThreads;
    }

    @Config(value="exchange.client-threads")
    public ExchangeClientConfig setClientThreads(int clientThreads) {
        this.clientThreads = clientThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getPageBufferClientMaxCallbackThreads() {
        return this.pageBufferClientMaxCallbackThreads;
    }

    @Config(value="exchange.page-buffer-client.max-callback-threads")
    public ExchangeClientConfig setPageBufferClientMaxCallbackThreads(int pageBufferClientMaxCallbackThreads) {
        this.pageBufferClientMaxCallbackThreads = pageBufferClientMaxCallbackThreads;
        return this;
    }

    public boolean isAcknowledgePages() {
        return this.acknowledgePages;
    }

    @Config(value="exchange.acknowledge-pages")
    public ExchangeClientConfig setAcknowledgePages(boolean acknowledgePages) {
        this.acknowledgePages = acknowledgePages;
        return this;
    }

    @Config(value="exchange.response-size-exponential-moving-average-decaying-alpha")
    public ExchangeClientConfig setResponseSizeExponentialMovingAverageDecayingAlpha(double responseSizeExponentialMovingAverageDecayingAlpha) {
        this.responseSizeExponentialMovingAverageDecayingAlpha = responseSizeExponentialMovingAverageDecayingAlpha;
        return this;
    }

    public double getResponseSizeExponentialMovingAverageDecayingAlpha() {
        return this.responseSizeExponentialMovingAverageDecayingAlpha;
    }
}

