/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.InMemoryHashAggregationBuilder;
import com.facebook.presto.operator.aggregation.builder.SpillableHashAggregationBuilder;
import com.facebook.presto.operator.aggregation.partial.PartialAggregationController;
import com.facebook.presto.operator.aggregation.partial.SkipAggregationBuilder;
import com.facebook.presto.operator.scalar.CombineHashFunction;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spiller.SpillerFactory;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.DataSize;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;

public class HashAggregationOperator
implements Operator {
    private static final double MERGE_WITH_MEMORY_RATIO = 0.9;
    public static final String OPERATOR_TYPE = "HashAggregationOperator";
    private final OperatorContext operatorContext;
    private final List<Type> groupByTypes;
    private final List<Integer> groupByChannels;
    private final int[] preGroupedChannels;
    private final List<Integer> globalAggregationGroupIds;
    private final AggregationNode.Step step;
    private final boolean produceDefaultOutput;
    private final List<AccumulatorFactory> accumulatorFactories;
    private final Optional<Integer> hashChannel;
    private final Optional<Integer> groupIdChannel;
    private final int expectedGroups;
    private final Optional<DataSize> maxPartialMemory;
    private final boolean spillEnabled;
    private final Optional<PartialAggregationController> partialAggregationController;
    private final DataSize memoryLimitForMerge;
    private final DataSize memoryLimitForMergeWithMemory;
    private final SpillerFactory spillerFactory;
    private final JoinCompiler joinCompiler;
    private final boolean useSystemMemory;
    private final Optional<PagesHashStrategy> preGroupedHashStrategy;
    private final List<Type> types;
    private final HashCollisionsCounter hashCollisionsCounter;
    private HashAggregationBuilder aggregationBuilder;
    private WorkProcessor<Page> outputPages;
    private boolean inputProcessed;
    private boolean finishing;
    private boolean finished;
    private Page firstUnfinishedSegment;
    private Page remainingPageForSegmentedAggregation;
    private Work<?> unfinishedWork;
    private long inputBytesProcessed;
    private long inputRowsProcessed;
    private long uniqueRowsProduced;

    public HashAggregationOperator(OperatorContext operatorContext, List<Type> groupByTypes, List<Integer> groupByChannels, List<Integer> preGroupedChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, Optional<PartialAggregationController> partialAggregationController, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler, boolean useSystemMemory) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        Objects.requireNonNull(step, "step is null");
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.groupByTypes = ImmutableList.copyOf(groupByTypes);
        this.groupByChannels = ImmutableList.copyOf(groupByChannels);
        this.preGroupedChannels = Ints.toArray((Collection)Objects.requireNonNull(preGroupedChannels, "preGroupedChannels is null"));
        this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
        this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
        this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
        this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
        this.step = step;
        this.produceDefaultOutput = produceDefaultOutput;
        this.expectedGroups = expectedGroups;
        this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
        this.types = InMemoryHashAggregationBuilder.toTypes(groupByTypes, step, accumulatorFactories, hashChannel);
        this.spillEnabled = spillEnabled;
        this.partialAggregationController = Objects.requireNonNull(partialAggregationController, "partialAggregationController is null");
        Preconditions.checkArgument((!partialAggregationController.isPresent() || step.isOutputPartial() ? 1 : 0) != 0, (Object)"partialAggregationController should only be present for partial aggregation");
        this.memoryLimitForMerge = Objects.requireNonNull(memoryLimitForMerge, "memoryLimitForMerge is null");
        this.memoryLimitForMergeWithMemory = Objects.requireNonNull(memoryLimitForMergeWithMemory, "memoryLimitForMergeWithMemory is null");
        this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
        this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        this.hashCollisionsCounter = new HashCollisionsCounter(operatorContext);
        operatorContext.setInfoSupplier(this.hashCollisionsCounter);
        this.useSystemMemory = useSystemMemory;
        Preconditions.checkState((boolean)ImmutableSet.copyOf(groupByChannels).containsAll(preGroupedChannels), (Object)"groupByChannels must include all channels in preGroupedChannels");
        this.preGroupedHashStrategy = preGroupedChannels.isEmpty() ? Optional.empty() : Optional.of(joinCompiler.compilePagesHashStrategyFactory((List)preGroupedChannels.stream().map(groupByTypes::get).collect(ImmutableList.toImmutableList()), preGroupedChannels, Optional.empty()).createPagesHashStrategy((List)groupByTypes.stream().map(type -> ImmutableList.of()).collect(ImmutableList.toImmutableList()), OptionalInt.empty()));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finishing && this.unfinishedWork == null && this.outputPages == null && !this.partialAggregationReachedMemoryLimit() && this.remainingPageForSegmentedAggregation == null;
    }

    @Override
    public void addInput(Page page) {
        Preconditions.checkState((this.unfinishedWork == null ? 1 : 0) != 0, (Object)"Operator has unfinished work");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is already finishing");
        Objects.requireNonNull(page, "page is null");
        this.inputProcessed = true;
        this.initializeAggregationBuilderIfNeeded();
        this.processInputPage(page);
        if (this.unfinishedWork != null && this.unfinishedWork.process()) {
            this.unfinishedWork = null;
        }
        this.aggregationBuilder.updateMemory();
        this.inputBytesProcessed += page.getSizeInBytes();
        this.inputRowsProcessed += (long)page.getPositionCount();
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        if (this.aggregationBuilder != null) {
            return this.aggregationBuilder.startMemoryRevoke();
        }
        return NOT_BLOCKED;
    }

    @Override
    public void finishMemoryRevoke() {
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.finishMemoryRevoke();
        }
    }

    @Override
    public Page getOutput() {
        if (this.finished) {
            return null;
        }
        if (this.unfinishedWork != null) {
            boolean workDone = this.unfinishedWork.process();
            this.aggregationBuilder.updateMemory();
            if (!workDone) {
                return null;
            }
            this.unfinishedWork = null;
        }
        if (this.outputPages == null) {
            if (this.finishing) {
                if (!this.inputProcessed && this.produceDefaultOutput) {
                    this.finished = true;
                    return this.getGlobalAggregationOutput();
                }
                if (this.aggregationBuilder == null) {
                    this.finished = true;
                    return null;
                }
            }
            if (!this.shouldFlush()) {
                return null;
            }
            this.outputPages = this.aggregationBuilder.buildResult();
        }
        if (!this.outputPages.process()) {
            return null;
        }
        if (this.outputPages.isFinished()) {
            this.closeAggregationBuilder();
            this.processRemainingPageForSegmentedAggregation();
            return null;
        }
        Page result = this.outputPages.getResult();
        this.uniqueRowsProduced += (long)result.getPositionCount();
        return result;
    }

    @Override
    public void close() {
        this.closeAggregationBuilder();
    }

    @VisibleForTesting
    public HashAggregationBuilder getAggregationBuilder() {
        return this.aggregationBuilder;
    }

    private void processInputPage(Page page) {
        if (!this.preGroupedHashStrategy.isPresent()) {
            this.unfinishedWork = this.aggregationBuilder.processPage(page);
            return;
        }
        if (this.firstUnfinishedSegment == null) {
            this.firstUnfinishedSegment = page.getRegion(0, 1);
        }
        Page pageOnPreGroupedChannels = page.extractChannels(this.preGroupedChannels);
        int lastRowInPage = page.getPositionCount() - 1;
        int lastSegmentStart = this.findLastSegmentStart(this.preGroupedHashStrategy.get(), pageOnPreGroupedChannels);
        if (lastSegmentStart == 0) {
            if (this.preGroupedHashStrategy.get().rowEqualsRow(0, this.firstUnfinishedSegment.extractChannels(this.preGroupedChannels), 0, pageOnPreGroupedChannels)) {
                this.unfinishedWork = this.aggregationBuilder.processPage(page);
            } else {
                this.remainingPageForSegmentedAggregation = page;
            }
        } else {
            this.unfinishedWork = this.aggregationBuilder.processPage(page.getRegion(0, lastSegmentStart));
            this.remainingPageForSegmentedAggregation = page.getRegion(lastSegmentStart, lastRowInPage - lastSegmentStart + 1);
        }
        this.firstUnfinishedSegment = page.getRegion(lastRowInPage, 1);
    }

    private int findLastSegmentStart(PagesHashStrategy pagesHashStrategy, Page page) {
        for (int i = page.getPositionCount() - 1; i > 0; --i) {
            if (pagesHashStrategy.rowEqualsRow(i - 1, page, i, page)) continue;
            return i;
        }
        return 0;
    }

    private void closeAggregationBuilder() {
        this.partialAggregationController.ifPresent(controller -> controller.onFlush(this.inputBytesProcessed, this.inputRowsProcessed, this.aggregationBuilder instanceof SkipAggregationBuilder ? OptionalLong.empty() : OptionalLong.of(this.uniqueRowsProduced)));
        this.inputBytesProcessed = 0L;
        this.inputRowsProcessed = 0L;
        this.uniqueRowsProduced = 0L;
        this.outputPages = null;
        if (this.aggregationBuilder != null) {
            this.aggregationBuilder.recordHashCollisions(this.hashCollisionsCounter);
            this.aggregationBuilder.close();
            this.aggregationBuilder = null;
        }
        this.operatorContext.localUserMemoryContext().setBytes(0L);
        this.operatorContext.localRevocableMemoryContext().setBytes(0L);
    }

    private void processRemainingPageForSegmentedAggregation() {
        if (this.remainingPageForSegmentedAggregation != null) {
            this.initializeAggregationBuilderIfNeeded();
            this.unfinishedWork = this.aggregationBuilder.processPage(this.remainingPageForSegmentedAggregation);
            this.remainingPageForSegmentedAggregation = null;
        }
    }

    private void initializeAggregationBuilderIfNeeded() {
        if (this.aggregationBuilder != null) {
            Preconditions.checkState((!this.aggregationBuilder.isFull() ? 1 : 0) != 0, (Object)"Aggregation buffer is full");
            return;
        }
        boolean partialAggregationDisabled = this.partialAggregationController.map(PartialAggregationController::isPartialAggregationDisabled).orElse(false);
        if (this.step.isOutputPartial() && partialAggregationDisabled) {
            this.aggregationBuilder = new SkipAggregationBuilder(this.groupByChannels, this.hashChannel, this.accumulatorFactories, this.operatorContext.localUserMemoryContext());
        } else if (this.step.isOutputPartial() || !this.spillEnabled) {
            this.aggregationBuilder = new InMemoryHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, this.maxPartialMemory, this.joinCompiler, true, this.useSystemMemory ? ReserveType.SYSTEM : ReserveType.USER);
        } else {
            Verify.verify((!this.useSystemMemory ? 1 : 0) != 0, (String)"using system memory in spillable aggregations is not supported", (Object[])new Object[0]);
            this.aggregationBuilder = new SpillableHashAggregationBuilder(this.accumulatorFactories, this.step, this.expectedGroups, this.groupByTypes, this.groupByChannels, this.hashChannel, this.operatorContext, this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler);
        }
    }

    private boolean shouldFlush() {
        return this.finishing || this.partialAggregationReachedMemoryLimit() || this.remainingPageForSegmentedAggregation != null;
    }

    private boolean partialAggregationReachedMemoryLimit() {
        return this.aggregationBuilder != null && this.aggregationBuilder.isFull();
    }

    private Page getGlobalAggregationOutput() {
        List accumulators = this.accumulatorFactories.stream().map(accumulatorFactory -> accumulatorFactory.createAccumulator(UpdateMemory.NOOP)).collect(Collectors.toList());
        PageBuilder output = new PageBuilder(this.globalAggregationGroupIds.size(), this.types);
        for (int groupId : this.globalAggregationGroupIds) {
            int channel;
            output.declarePosition();
            for (channel = 0; channel < this.groupByTypes.size(); ++channel) {
                if (channel == this.groupIdChannel.get()) {
                    output.getBlockBuilder(channel).writeLong((long)groupId);
                    continue;
                }
                output.getBlockBuilder(channel).appendNull();
            }
            if (this.hashChannel.isPresent()) {
                long hashValue = HashAggregationOperator.calculateDefaultOutputHash(this.groupByTypes, this.groupIdChannel.get(), groupId);
                output.getBlockBuilder(channel++).writeLong(hashValue);
            }
            for (int j = 0; j < accumulators.size(); ++j) {
                if (this.step.isOutputPartial()) {
                    ((Accumulator)accumulators.get(j)).evaluateIntermediate(output.getBlockBuilder(channel));
                } else {
                    ((Accumulator)accumulators.get(j)).evaluateFinal(output.getBlockBuilder(channel));
                }
                ++channel;
            }
        }
        if (output.isEmpty()) {
            return null;
        }
        return output.build();
    }

    private static long calculateDefaultOutputHash(List<Type> groupByChannels, int groupIdChannel, int groupId) {
        long result = 0L;
        for (int channel = 0; channel < groupByChannels.size(); ++channel) {
            result = channel != groupIdChannel ? CombineHashFunction.getHash(result, 0L) : CombineHashFunction.getHash(result, BigintType.hash((long)groupId));
        }
        return result;
    }

    public static enum ReserveType {
        USER,
        SYSTEM,
        REVOCABLE;

    }

    public static class HashAggregationOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final List<Type> groupByTypes;
        private final List<Integer> groupByChannels;
        private final List<Integer> preGroupedChannels;
        private final List<Integer> globalAggregationGroupIds;
        private final AggregationNode.Step step;
        private final boolean produceDefaultOutput;
        private final List<AccumulatorFactory> accumulatorFactories;
        private final Optional<Integer> hashChannel;
        private final Optional<Integer> groupIdChannel;
        private final int expectedGroups;
        private final Optional<DataSize> maxPartialMemory;
        private final boolean spillEnabled;
        private final DataSize memoryLimitForMerge;
        private final DataSize memoryLimitForMergeWithMemory;
        private final SpillerFactory spillerFactory;
        private final JoinCompiler joinCompiler;
        private final boolean useSystemMemory;
        private final Optional<PartialAggregationController> partialAggregationController;
        private boolean closed;

        @VisibleForTesting
        public HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> preGroupedChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, JoinCompiler joinCompiler, boolean useSystemMemory) {
            this(operatorId, planNodeId, groupByTypes, groupByChannels, preGroupedChannels, globalAggregationGroupIds, step, false, accumulatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialMemory, false, Optional.empty(), new DataSize(0.0, DataSize.Unit.MEGABYTE), new DataSize(0.0, DataSize.Unit.MEGABYTE), (types, spillContext, memoryContext) -> {
                throw new UnsupportedOperationException();
            }, joinCompiler, useSystemMemory);
        }

        public HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> preGroupedChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, Optional<PartialAggregationController> partialAggregationController, DataSize unspillMemoryLimit, SpillerFactory spillerFactory, JoinCompiler joinCompiler, boolean useSystemMemory) {
            this(operatorId, planNodeId, groupByTypes, groupByChannels, preGroupedChannels, globalAggregationGroupIds, step, produceDefaultOutput, accumulatorFactories, hashChannel, groupIdChannel, expectedGroups, maxPartialMemory, spillEnabled, partialAggregationController, unspillMemoryLimit, DataSize.succinctBytes((long)((long)((double)unspillMemoryLimit.toBytes() * 0.9))), spillerFactory, joinCompiler, useSystemMemory);
        }

        @VisibleForTesting
        HashAggregationOperatorFactory(int operatorId, PlanNodeId planNodeId, List<? extends Type> groupByTypes, List<Integer> groupByChannels, List<Integer> preGroupedChannels, List<Integer> globalAggregationGroupIds, AggregationNode.Step step, boolean produceDefaultOutput, List<AccumulatorFactory> accumulatorFactories, Optional<Integer> hashChannel, Optional<Integer> groupIdChannel, int expectedGroups, Optional<DataSize> maxPartialMemory, boolean spillEnabled, Optional<PartialAggregationController> partialAggregationController, DataSize memoryLimitForMerge, DataSize memoryLimitForMergeWithMemory, SpillerFactory spillerFactory, JoinCompiler joinCompiler, boolean useSystemMemory) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.groupIdChannel = Objects.requireNonNull(groupIdChannel, "groupIdChannel is null");
            this.groupByTypes = ImmutableList.copyOf(groupByTypes);
            this.groupByChannels = ImmutableList.copyOf(groupByChannels);
            this.preGroupedChannels = ImmutableList.copyOf(preGroupedChannels);
            this.globalAggregationGroupIds = ImmutableList.copyOf(globalAggregationGroupIds);
            this.step = step;
            this.produceDefaultOutput = produceDefaultOutput;
            this.accumulatorFactories = ImmutableList.copyOf(accumulatorFactories);
            this.expectedGroups = expectedGroups;
            this.maxPartialMemory = Objects.requireNonNull(maxPartialMemory, "maxPartialMemory is null");
            this.spillEnabled = spillEnabled;
            this.partialAggregationController = Objects.requireNonNull(partialAggregationController, "partialAggregationController is null");
            this.memoryLimitForMerge = Objects.requireNonNull(memoryLimitForMerge, "memoryLimitForMerge is null");
            this.memoryLimitForMergeWithMemory = Objects.requireNonNull(memoryLimitForMergeWithMemory, "memoryLimitForMergeWithMemory is null");
            this.spillerFactory = Objects.requireNonNull(spillerFactory, "spillerFactory is null");
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
            this.useSystemMemory = useSystemMemory;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, HashAggregationOperator.class.getSimpleName());
            HashAggregationOperator hashAggregationOperator = new HashAggregationOperator(operatorContext, this.groupByTypes, this.groupByChannels, this.preGroupedChannels, this.globalAggregationGroupIds, this.step, this.produceDefaultOutput, this.accumulatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory, this.spillEnabled, this.partialAggregationController, this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler, this.useSystemMemory);
            return hashAggregationOperator;
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new HashAggregationOperatorFactory(this.operatorId, this.planNodeId, this.groupByTypes, this.groupByChannels, this.preGroupedChannels, this.globalAggregationGroupIds, this.step, this.produceDefaultOutput, this.accumulatorFactories, this.hashChannel, this.groupIdChannel, this.expectedGroups, this.maxPartialMemory, this.spillEnabled, this.partialAggregationController.map(PartialAggregationController::duplicate), this.memoryLimitForMerge, this.memoryLimitForMergeWithMemory, this.spillerFactory, this.joinCompiler, this.useSystemMemory);
        }
    }
}

