/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.airlift.concurrent.MoreFutures;
import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.JoinBridgeManager;
import com.facebook.presto.operator.NestedLoopJoinBridge;
import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;

public class NestedLoopJoinOperator
implements Operator,
Closeable {
    private final ListenableFuture<NestedLoopJoinPages> nestedLoopJoinPagesFuture;
    private final OperatorContext operatorContext;
    private final Runnable afterClose;
    private List<Page> buildPages;
    private Page probePage;
    private Iterator<Page> buildPageIterator;
    private NestedLoopOutputIterator nestedLoopOutputIterator;
    private boolean finishing;
    private boolean closed;

    private NestedLoopJoinOperator(OperatorContext operatorContext, NestedLoopJoinBridge joinBridge, Runnable afterClose) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.nestedLoopJoinPagesFuture = joinBridge.getPagesFuture();
        this.afterClose = Objects.requireNonNull(afterClose, "afterClose is null");
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        this.finishing = true;
    }

    @Override
    public boolean isFinished() {
        boolean finished;
        boolean bl = finished = this.finishing && this.probePage == null;
        if (finished) {
            this.close();
        }
        return finished;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.nestedLoopJoinPagesFuture;
    }

    @Override
    public boolean needsInput() {
        Optional nestedLoopJoinPages;
        if (this.finishing || this.probePage != null) {
            return false;
        }
        if (this.buildPages == null && (nestedLoopJoinPages = MoreFutures.tryGetFutureValue(this.nestedLoopJoinPagesFuture)).isPresent()) {
            this.buildPages = ((NestedLoopJoinPages)nestedLoopJoinPages.get()).getPages();
        }
        return this.buildPages != null;
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.finishing ? 1 : 0) != 0, (Object)"Operator is finishing");
        Preconditions.checkState((this.buildPages != null ? 1 : 0) != 0, (Object)"Page source has not been built yet");
        Preconditions.checkState((this.probePage == null ? 1 : 0) != 0, (Object)"Current page has not been completely processed yet");
        Preconditions.checkState((this.buildPageIterator == null || !this.buildPageIterator.hasNext() ? 1 : 0) != 0, (Object)"Current buildPageIterator has not been completely processed yet");
        if (page.getPositionCount() > 0) {
            this.probePage = page;
            this.buildPageIterator = this.buildPages.iterator();
        }
    }

    @Override
    public Page getOutput() {
        if (this.probePage == null || this.buildPages == null) {
            return null;
        }
        if (this.nestedLoopOutputIterator != null && this.nestedLoopOutputIterator.hasNext()) {
            return this.nestedLoopOutputIterator.next();
        }
        if (this.buildPageIterator.hasNext()) {
            this.nestedLoopOutputIterator = NestedLoopJoinOperator.createNestedLoopOutputIterator(this.probePage, this.buildPageIterator.next());
            return this.nestedLoopOutputIterator.next();
        }
        this.probePage = null;
        this.nestedLoopOutputIterator = null;
        return null;
    }

    @Override
    public void close() {
        this.buildPages = null;
        this.probePage = null;
        this.nestedLoopOutputIterator = null;
        this.buildPageIterator = null;
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.afterClose.run();
    }

    @VisibleForTesting
    static NestedLoopOutputIterator createNestedLoopOutputIterator(Page probePage, Page buildPage) {
        if (probePage.getChannelCount() == 0 && buildPage.getChannelCount() == 0) {
            int probePositions = probePage.getPositionCount();
            int buildPositions = buildPage.getPositionCount();
            try {
                int outputPositions = Math.multiplyExact(probePositions, buildPositions);
                if (outputPositions <= 8192) {
                    return new PageRepeatingIterator(new Page(outputPositions), 1);
                }
            }
            catch (ArithmeticException outputPositions) {
                // empty catch block
            }
            Page outputPage = new Page(Math.max(probePositions, buildPositions));
            return new PageRepeatingIterator(outputPage, Math.min(probePositions, buildPositions));
        }
        if (probePage.getChannelCount() == 0 && probePage.getPositionCount() <= buildPage.getPositionCount()) {
            return new PageRepeatingIterator(buildPage, probePage.getPositionCount());
        }
        if (buildPage.getChannelCount() == 0 && buildPage.getPositionCount() <= probePage.getPositionCount()) {
            return new PageRepeatingIterator(probePage, buildPage.getPositionCount());
        }
        return new NestedLoopPageBuilder(probePage, buildPage);
    }

    @VisibleForTesting
    static abstract class NestedLoopOutputIterator {
        NestedLoopOutputIterator() {
        }

        public abstract boolean hasNext();

        public abstract Page next();
    }

    private static final class PageRepeatingIterator
    extends NestedLoopOutputIterator {
        private final Page page;
        private int remainingCount;

        private PageRepeatingIterator(Page page, int repetitions) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.remainingCount = repetitions;
        }

        @Override
        public boolean hasNext() {
            return this.remainingCount > 0;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.remainingCount;
            return this.page;
        }
    }

    private static final class NestedLoopPageBuilder
    extends NestedLoopOutputIterator {
        private final Block[] resultBlockBuffer;
        private final Page smallPage;
        private final int indexForRleBlocks;
        private final int largePagePositionCount;
        private final int maxRowIndex;
        private int rowIndex = -1;

        NestedLoopPageBuilder(Page probePage, Page buildPage) {
            int indexForPageBlocks;
            Page largePage;
            Objects.requireNonNull(probePage, "probePage is null");
            Preconditions.checkArgument((probePage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"probePage has no rows");
            Objects.requireNonNull(buildPage, "buildPage is null");
            Preconditions.checkArgument((buildPage.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"buildPage has no rows");
            if (buildPage.getPositionCount() > probePage.getPositionCount()) {
                largePage = buildPage;
                this.smallPage = probePage;
                indexForPageBlocks = probePage.getChannelCount();
                this.indexForRleBlocks = 0;
            } else {
                largePage = probePage;
                this.smallPage = buildPage;
                indexForPageBlocks = 0;
                this.indexForRleBlocks = probePage.getChannelCount();
            }
            this.largePagePositionCount = largePage.getPositionCount();
            this.maxRowIndex = this.smallPage.getPositionCount() - 1;
            this.resultBlockBuffer = new Block[largePage.getChannelCount() + this.smallPage.getChannelCount()];
            for (int i = 0; i < largePage.getChannelCount(); ++i) {
                this.resultBlockBuffer[indexForPageBlocks + i] = largePage.getBlock(i);
            }
        }

        @Override
        public boolean hasNext() {
            return this.rowIndex < this.maxRowIndex;
        }

        @Override
        public Page next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.rowIndex;
            for (int i = 0; i < this.smallPage.getChannelCount(); ++i) {
                Block block = this.smallPage.getBlock(i).getSingleValueBlock(this.rowIndex);
                this.resultBlockBuffer[this.indexForRleBlocks + i] = new RunLengthEncodedBlock(block, this.largePagePositionCount);
            }
            return new Page(this.largePagePositionCount, this.resultBlockBuffer);
        }
    }

    public static class NestedLoopJoinOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final JoinBridgeManager<NestedLoopJoinBridge> joinBridgeManager;
        private boolean closed;

        public NestedLoopJoinOperatorFactory(int operatorId, PlanNodeId planNodeId, JoinBridgeManager<NestedLoopJoinBridge> nestedLoopJoinBridgeManager) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.joinBridgeManager = nestedLoopJoinBridgeManager;
            this.joinBridgeManager.incrementProbeFactoryCount();
        }

        private NestedLoopJoinOperatorFactory(NestedLoopJoinOperatorFactory other) {
            Objects.requireNonNull(other, "other is null");
            this.operatorId = other.operatorId;
            this.planNodeId = other.planNodeId;
            this.joinBridgeManager = other.joinBridgeManager;
            this.closed = false;
            this.joinBridgeManager.incrementProbeFactoryCount();
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            NestedLoopJoinBridge nestedLoopJoinBridge = this.joinBridgeManager.getJoinBridge(driverContext.getLifespan());
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, NestedLoopJoinOperator.class.getSimpleName());
            this.joinBridgeManager.probeOperatorCreated(driverContext.getLifespan());
            return new NestedLoopJoinOperator(operatorContext, nestedLoopJoinBridge, () -> this.joinBridgeManager.probeOperatorClosed(driverContext.getLifespan()));
        }

        @Override
        public void noMoreOperators() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.joinBridgeManager.probeOperatorFactoryClosedForAllLifespans();
        }

        @Override
        public void noMoreOperators(Lifespan lifespan) {
            this.joinBridgeManager.probeOperatorFactoryClosed(lifespan);
        }

        @Override
        public OperatorFactory duplicate() {
            return new NestedLoopJoinOperatorFactory(this);
        }
    }
}

