/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.ChannelSet;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SetBuilderOperator
implements Operator {
    private final OperatorContext operatorContext;
    private final SetSupplier setSupplier;
    private final int[] sourceChannels;
    private final ChannelSet.ChannelSetBuilder channelSetBuilder;
    private boolean finished;
    @Nullable
    private Work<?> unfinishedWork;

    public SetBuilderOperator(OperatorContext operatorContext, SetSupplier setSupplier, int setChannel, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.setSupplier = Objects.requireNonNull(setSupplier, "setProvider is null");
        this.sourceChannels = Objects.requireNonNull(hashChannel, "hashChannel is null").isPresent() ? new int[]{setChannel, hashChannel.get()} : new int[]{setChannel};
        Optional<Integer> channelSetHashChannel = hashChannel.isPresent() ? Optional.of(1) : Optional.empty();
        this.channelSetBuilder = new ChannelSet.ChannelSetBuilder(setSupplier.getType(), channelSetHashChannel, expectedPositions, Objects.requireNonNull(operatorContext, "operatorContext is null"), Objects.requireNonNull(joinCompiler, "joinCompiler is null"));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        ChannelSet channelSet = this.channelSetBuilder.build();
        this.setSupplier.setChannelSet(channelSet);
        this.operatorContext.recordOutput(channelSet.getEstimatedSizeInBytes(), channelSet.size());
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean needsInput() {
        return !this.finished && (this.unfinishedWork == null || this.processUnfinishedWork());
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((!this.isFinished() ? 1 : 0) != 0, (Object)"Operator is already finished");
        this.unfinishedWork = this.channelSetBuilder.addPage(page.extractChannels(this.sourceChannels));
        this.processUnfinishedWork();
    }

    @Override
    public Page getOutput() {
        return null;
    }

    private boolean processUnfinishedWork() {
        Preconditions.checkState((this.unfinishedWork != null ? 1 : 0) != 0, (Object)"unfinishedWork is empty");
        boolean done = this.unfinishedWork.process();
        if (done) {
            this.unfinishedWork = null;
        }
        this.channelSetBuilder.updateMemoryReservation();
        return done;
    }

    @VisibleForTesting
    public int getCapacity() {
        return this.channelSetBuilder.getCapacity();
    }

    public static class SetSupplier {
        private final Type type;
        private final SettableFuture<ChannelSet> channelSetFuture = SettableFuture.create();

        public SetSupplier(Type type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public Type getType() {
            return this.type;
        }

        public ListenableFuture<ChannelSet> getChannelSet() {
            return this.channelSetFuture;
        }

        void setChannelSet(ChannelSet channelSet) {
            boolean wasSet = this.channelSetFuture.set((Object)Objects.requireNonNull(channelSet, "channelSet is null"));
            Preconditions.checkState((boolean)wasSet, (Object)"ChannelSet already set");
        }
    }

    public static class SetBuilderOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final Optional<Integer> hashChannel;
        private final SetSupplier setProvider;
        private final int setChannel;
        private final int expectedPositions;
        private boolean closed;
        private final JoinCompiler joinCompiler;

        public SetBuilderOperatorFactory(int operatorId, PlanNodeId planNodeId, Type type, int setChannel, Optional<Integer> hashChannel, int expectedPositions, JoinCompiler joinCompiler) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            Preconditions.checkArgument((setChannel >= 0 ? 1 : 0) != 0, (Object)"setChannel is negative");
            this.setProvider = new SetSupplier(Objects.requireNonNull(type, "type is null"));
            this.setChannel = setChannel;
            this.hashChannel = Objects.requireNonNull(hashChannel, "hashChannel is null");
            this.expectedPositions = expectedPositions;
            this.joinCompiler = Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        }

        public SetSupplier getSetProvider() {
            return this.setProvider;
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.planNodeId, SetBuilderOperator.class.getSimpleName());
            return new SetBuilderOperator(operatorContext, this.setProvider, this.setChannel, this.hashChannel, this.expectedPositions, this.joinCompiler);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new SetBuilderOperatorFactory(this.operatorId, this.planNodeId, this.setProvider.getType(), this.setChannel, this.hashChannel, this.expectedPositions, this.joinCompiler);
        }
    }
}

