/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.WorkProcessorUtils;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

public interface WorkProcessor<T> {
    public boolean process();

    public boolean isBlocked();

    public ListenableFuture<?> getBlockedFuture();

    public boolean isFinished();

    public T getResult();

    default public WorkProcessor<T> yielding(BooleanSupplier yieldSignal) {
        return WorkProcessorUtils.yielding(this, yieldSignal);
    }

    default public <R> WorkProcessor<R> flatMap(Function<T, WorkProcessor<R>> mapper) {
        return WorkProcessorUtils.flatMap(this, mapper);
    }

    default public <R> WorkProcessor<R> map(Function<T, R> mapper) {
        return WorkProcessorUtils.map(this, mapper);
    }

    default public <R> WorkProcessor<R> flatTransform(Transformation<T, WorkProcessor<R>> transformation) {
        return WorkProcessorUtils.flatTransform(this, transformation);
    }

    default public <R> WorkProcessor<R> transform(Transformation<T, R> transformation) {
        return WorkProcessorUtils.transform(this, transformation);
    }

    default public <R> WorkProcessor<R> transformProcessor(Function<WorkProcessor<T>, WorkProcessor<R>> transformation) {
        return transformation.apply(this);
    }

    default public Iterator<T> iterator() {
        return WorkProcessorUtils.iteratorFrom(this);
    }

    default public Iterator<Optional<T>> yieldingIterator() {
        return WorkProcessorUtils.yieldingIteratorFrom(this);
    }

    public static <T> WorkProcessor<T> flatten(WorkProcessor<WorkProcessor<T>> processor) {
        return WorkProcessorUtils.flatten(processor);
    }

    @SafeVarargs
    public static <T> WorkProcessor<T> of(T ... elements) {
        return WorkProcessor.fromIterator(Iterators.forArray((Object[])elements));
    }

    public static <T> WorkProcessor<T> fromIterable(Iterable<T> iterable) {
        return WorkProcessorUtils.fromIterator(iterable.iterator());
    }

    public static <T> WorkProcessor<T> fromIterator(Iterator<T> iterator) {
        return WorkProcessorUtils.fromIterator(iterator);
    }

    public static <T> WorkProcessor<T> create(Process<T> process) {
        return WorkProcessorUtils.create(process);
    }

    public static <T> WorkProcessor<T> mergeSorted(Iterable<WorkProcessor<T>> processorIterable, Comparator<T> comparator) {
        return WorkProcessorUtils.mergeSorted(processorIterable, comparator);
    }

    public static interface Transformation<T, R> {
        public TransformationState<R> process(Optional<T> var1);
    }

    public static interface Process<T> {
        public ProcessState<T> process();
    }

    @Immutable
    public static final class ProcessState<T> {
        private static final ProcessState<?> YIELD_STATE = new ProcessState(Type.YIELD, Optional.empty(), Optional.empty());
        private static final ProcessState<?> FINISHED_STATE = new ProcessState(Type.FINISHED, Optional.empty(), Optional.empty());
        private final Type type;
        private final Optional<T> result;
        private final Optional<ListenableFuture<?>> blocked;

        private ProcessState(Type type, Optional<T> result, Optional<ListenableFuture<?>> blocked) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.result = Objects.requireNonNull(result, "result is null");
            this.blocked = Objects.requireNonNull(blocked, "blocked is null");
        }

        public static <T> ProcessState<T> blocked(ListenableFuture<?> blocked) {
            return new ProcessState(Type.BLOCKED, Optional.empty(), Optional.of(blocked));
        }

        public static <T> ProcessState<T> yield() {
            return YIELD_STATE;
        }

        public static <T> ProcessState<T> ofResult(T result) {
            return new ProcessState<T>(Type.RESULT, Optional.of(result), Optional.empty());
        }

        public static <T> ProcessState<T> finished() {
            return FINISHED_STATE;
        }

        Type getType() {
            return this.type;
        }

        Optional<T> getResult() {
            return this.result;
        }

        Optional<ListenableFuture<?>> getBlocked() {
            return this.blocked;
        }

        static enum Type {
            BLOCKED,
            YIELD,
            RESULT,
            FINISHED;

        }
    }

    @Immutable
    public static final class TransformationState<T> {
        private static final TransformationState<?> NEEDS_MORE_DATE_STATE = new TransformationState(Type.NEEDS_MORE_DATA, true, Optional.empty(), Optional.empty());
        private static final TransformationState<?> YIELD_STATE = new TransformationState(Type.YIELD, false, Optional.empty(), Optional.empty());
        private static final TransformationState<?> FINISHED_STATE = new TransformationState(Type.FINISHED, false, Optional.empty(), Optional.empty());
        private final Type type;
        private final boolean needsMoreData;
        private final Optional<T> result;
        private final Optional<ListenableFuture<?>> blocked;

        private TransformationState(Type type, boolean needsMoreData, Optional<T> result, Optional<ListenableFuture<?>> blocked) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.needsMoreData = needsMoreData;
            this.result = Objects.requireNonNull(result, "result is null");
            this.blocked = Objects.requireNonNull(blocked, "blocked is null");
        }

        public static <T> TransformationState<T> needsMoreData() {
            return NEEDS_MORE_DATE_STATE;
        }

        public static <T> TransformationState<T> blocked(ListenableFuture<?> blocked) {
            return new TransformationState(Type.BLOCKED, false, Optional.empty(), Optional.of(blocked));
        }

        public static <T> TransformationState<T> yield() {
            return YIELD_STATE;
        }

        public static <T> TransformationState<T> ofResult(T result) {
            return TransformationState.ofResult(result, true);
        }

        public static <T> TransformationState<T> ofResult(T result, boolean needsMoreData) {
            return new TransformationState<T>(Type.RESULT, needsMoreData, Optional.of(result), Optional.empty());
        }

        public static <T> TransformationState<T> finished() {
            return FINISHED_STATE;
        }

        Type getType() {
            return this.type;
        }

        boolean isNeedsMoreData() {
            return this.needsMoreData;
        }

        Optional<T> getResult() {
            return this.result;
        }

        Optional<ListenableFuture<?>> getBlocked() {
            return this.blocked;
        }

        static enum Type {
            NEEDS_MORE_DATA,
            BLOCKED,
            YIELD,
            RESULT,
            FINISHED;

        }
    }
}

