/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.operator.aggregation.ApproximateLongPercentileAggregations;
import com.facebook.presto.operator.aggregation.FloatingPointBitsConverterUtil;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;

@AggregationFunction(value="approx_percentile")
public final class ApproximateDoublePercentileAggregations {
    private ApproximateDoublePercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.input(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), percentile);
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.input(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), percentile, accuracy);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentile);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="double") double value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.weightedInput(state, FloatingPointBitsConverterUtil.doubleToSortableLong(value), weight, percentile, accuracy);
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileState state, DigestAndPercentileState otherState) {
        ApproximateLongPercentileAggregations.combine(state, otherState);
    }

    @OutputFunction(value="double")
    public static void output(@AggregationState DigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            DoubleType.DOUBLE.writeDouble(out, FloatingPointBitsConverterUtil.sortableLongToDouble(digest.getQuantile(percentile)));
        }
    }
}

