/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.airlift.stats.QuantileDigest;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.operator.aggregation.state.DigestAndPercentileState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;

@AggregationFunction(value="approx_percentile")
public final class ApproximateLongPercentileAggregations {
    static final double DEFAULT_ACCURACY = 0.01;
    static final long DEFAULT_WEIGHT = 1L;

    private ApproximateLongPercentileAggregations() {
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.addInput(state, value, 1L, percentile, 0.01);
    }

    @InputFunction
    public static void input(@AggregationState DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.addInput(state, value, 1L, percentile, accuracy);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile) {
        ApproximateLongPercentileAggregations.checkWeight(weight);
        ApproximateLongPercentileAggregations.addInput(state, value, weight, percentile, 0.01);
    }

    @InputFunction
    public static void weightedInput(@AggregationState DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        ApproximateLongPercentileAggregations.checkWeight(weight);
        ApproximateLongPercentileAggregations.addInput(state, value, weight, percentile, accuracy);
    }

    private static void addInput(@AggregationState DigestAndPercentileState state, @SqlType(value="bigint") long value, @SqlType(value="bigint") long weight, @SqlType(value="double") double percentile, @SqlType(value="double") double accuracy) {
        QuantileDigest digest = state.getDigest();
        if (state.getDigest() == null) {
            ApproximateLongPercentileAggregations.checkAccuracy(accuracy);
            digest = new QuantileDigest(accuracy);
            state.setDigest(digest);
            state.setPercentile(percentile);
        } else {
            state.addMemoryUsage(-digest.estimatedInMemorySizeInBytes());
        }
        ApproximateLongPercentileAggregations.checkPercentile(percentile, state.getPercentile());
        digest.add(value, weight);
        state.addMemoryUsage(digest.estimatedInMemorySizeInBytes());
    }

    @CombineFunction
    public static void combine(@AggregationState DigestAndPercentileState state, DigestAndPercentileState otherState) {
        QuantileDigest input = otherState.getDigest();
        QuantileDigest previous = state.getDigest();
        if (previous == null) {
            state.setDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input);
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
        state.setPercentile(otherState.getPercentile());
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState DigestAndPercentileState state, BlockBuilder out) {
        QuantileDigest digest = state.getDigest();
        double percentile = state.getPercentile();
        if (digest == null || digest.getCount() == 0.0) {
            out.appendNull();
        } else {
            Preconditions.checkState((percentile != -1.0 ? 1 : 0) != 0, (Object)"Percentile is missing");
            Failures.checkCondition(0.0 <= percentile && percentile <= 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile must be between 0 and 1", new Object[0]);
            BigintType.BIGINT.writeLong(out, digest.getQuantile(percentile));
        }
    }

    static void checkPercentile(double percentile, double statePercentile) {
        Failures.checkCondition(percentile == statePercentile, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile argument must be constant for all input rows: %s vs. %s", percentile, statePercentile);
    }

    static void checkAccuracy(double accuracy) {
        Failures.checkCondition(0.0 < accuracy && accuracy < 1.0, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Percentile accuracy must be strictly between 0 and 1", new Object[0]);
    }

    static void checkWeight(long weight) {
        Failures.checkCondition(weight > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "percentile weight must be > 0", new Object[0]);
    }
}

