/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.bytecode.DynamicClassLoader;
import com.facebook.presto.common.CatalogSchemaName;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.TypeSignatureParameter;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.metadata.SqlAggregationFunction;
import com.facebook.presto.operator.aggregation.AccumulatorCompiler;
import com.facebook.presto.operator.aggregation.AggregationUtils;
import com.facebook.presto.operator.aggregation.BuiltInAggregationFunctionImplementation;
import com.facebook.presto.operator.aggregation.MapAggregationFunction;
import com.facebook.presto.operator.aggregation.StatisticalDigest;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestState;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateFactory;
import com.facebook.presto.operator.aggregation.state.StatisticalDigestStateSerializer;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.aggregation.Accumulator;
import com.facebook.presto.spi.function.aggregation.AggregationMetadata;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;

public abstract class MergeStatisticalDigestFunction
extends SqlAggregationFunction {
    public final String name;
    public final String type;
    public final StatisticalDigestStateFactory factory;
    private static final MethodHandle COMBINE_FUNCTION = Reflection.methodHandle(MergeStatisticalDigestFunction.class, "combine", StatisticalDigestState.class, StatisticalDigestState.class);
    private static final MethodHandle OUTPUT_FUNCTION = Reflection.methodHandle(MergeStatisticalDigestFunction.class, "output", StatisticalDigestStateSerializer.class, StatisticalDigestState.class, BlockBuilder.class);

    MergeStatisticalDigestFunction(String name, String type, StatisticalDigestStateFactory factory, SqlFunctionVisibility visibility) {
        super(new Signature(QualifiedObjectName.valueOf((CatalogSchemaName)BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE, (String)name), FunctionKind.AGGREGATE, (List)ImmutableList.of((Object)Signature.comparableTypeParameter((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)(type + "(T)")), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)(type + "(T)"))), false), visibility);
        this.name = name;
        this.type = type;
        this.factory = factory;
    }

    @Override
    public BuiltInAggregationFunctionImplementation specialize(BoundVariables boundVariables, int arity, FunctionAndTypeManager functionAndTypeManager) {
        Type valueType = boundVariables.getTypeVariable("T");
        Type outputType = functionAndTypeManager.getParameterizedType(this.type, (List<TypeSignatureParameter>)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)valueType.getTypeSignature())));
        return this.generateAggregation(outputType);
    }

    private BuiltInAggregationFunctionImplementation generateAggregation(Type type) {
        DynamicClassLoader classLoader = new DynamicClassLoader(MapAggregationFunction.class.getClassLoader());
        StatisticalDigestStateSerializer stateSerializer = new StatisticalDigestStateSerializer();
        Type intermediateType = stateSerializer.getSerializedType();
        AggregationMetadata metadata = new AggregationMetadata(AggregationUtils.generateAggregationName(this.name, type.getTypeSignature(), (List<TypeSignature>)ImmutableList.of((Object)type.getTypeSignature())), MergeStatisticalDigestFunction.createInputParameterMetadata(type), this.getInputFunction().bindTo(type), COMBINE_FUNCTION, OUTPUT_FUNCTION.bindTo(stateSerializer), (List)ImmutableList.of((Object)new AggregationMetadata.AccumulatorStateDescriptor(StatisticalDigestState.class, (AccumulatorStateSerializer)stateSerializer, (AccumulatorStateFactory)this.factory)), type);
        Class<Accumulator> accumulatorClass = AccumulatorCompiler.generateAccumulatorClass(Accumulator.class, metadata, classLoader);
        Class<GroupedAccumulator> groupedAccumulatorClass = AccumulatorCompiler.generateAccumulatorClass(GroupedAccumulator.class, metadata, classLoader);
        return new BuiltInAggregationFunctionImplementation(this.name, (List<Type>)ImmutableList.of((Object)type), (List<Type>)ImmutableList.of((Object)intermediateType), type, true, true, metadata, accumulatorClass, groupedAccumulatorClass);
    }

    private static List<AggregationMetadata.ParameterMetadata> createInputParameterMetadata(Type valueType) {
        return ImmutableList.of((Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.STATE), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INPUT_CHANNEL, valueType), (Object)new AggregationMetadata.ParameterMetadata(AggregationMetadata.ParameterMetadata.ParameterType.BLOCK_INDEX));
    }

    protected abstract MethodHandle getInputFunction();

    public static void combine(StatisticalDigestState state, StatisticalDigestState otherState) {
        MergeStatisticalDigestFunction.merge(state, otherState.getStatisticalDigest());
    }

    protected static void merge(StatisticalDigestState state, StatisticalDigest input) {
        if (input == null) {
            return;
        }
        StatisticalDigest previous = state.getStatisticalDigest();
        if (previous == null) {
            state.setStatisticalDigest(input);
            state.addMemoryUsage(input.estimatedInMemorySizeInBytes());
        } else {
            state.addMemoryUsage(-previous.estimatedInMemorySizeInBytes());
            previous.merge(input.getDigest());
            state.addMemoryUsage(previous.estimatedInMemorySizeInBytes());
        }
    }

    public static void output(StatisticalDigestStateSerializer serializer, StatisticalDigestState state, BlockBuilder out) {
        serializer.serialize(state, out);
    }
}

