/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.spi.function.AggregationFunction;
import com.facebook.presto.spi.function.AggregationState;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.CombineFunction;
import com.facebook.presto.spi.function.InputFunction;
import com.facebook.presto.spi.function.OutputFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;

@AggregationFunction(value="sum_data_size_for_stats", visibility=SqlFunctionVisibility.HIDDEN)
public final class SumDataSizeForStats {
    public static final String NAME = "sum_data_size_for_stats";

    private SumDataSizeForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState NullableLongState state, @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        SumDataSizeForStats.update(state, block.getEstimatedDataSizeForStats(index));
    }

    @CombineFunction
    public static void combine(@AggregationState NullableLongState state, @AggregationState NullableLongState otherState) {
        SumDataSizeForStats.update(state, otherState.getLong());
    }

    private static void update(NullableLongState state, long size) {
        if (state.isNull()) {
            state.setNull(false);
            state.setLong(size);
        } else {
            state.setLong(state.getLong() + size);
        }
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState NullableLongState state, BlockBuilder out) {
        NullableLongState.write((Type)BigintType.BIGINT, state, out);
    }
}

