/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.approxmostfrequent.stream;

import com.facebook.presto.common.array.IntBigArray;
import com.facebook.presto.common.array.LongBigArray;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.IndexedPriorityQueue;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.PriorityQueueDataChangeListener;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamDataEntity;
import com.facebook.presto.operator.aggregation.approxmostfrequent.stream.StreamSummaryReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.type.TypeUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class StreamSummary
implements PriorityQueueDataChangeListener {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StreamSummary.class).instanceSize();
    private static final int COMPACT_THRESHOLD_BYTES = 32768;
    private static final float FILL_RATIO = 0.75f;
    private static final int COMPACT_THRESHOLD_RATIO = 3;
    private static final int EMPTY = -1;
    private static final int DELETE_MARKER = -2;
    private final Type type;
    private final int heapCapacity;
    private final int maxBuckets;
    private int maxFill;
    private int mask;
    private int generation;
    private LongBigArray blockPositionToCount;
    private IntBigArray hashToBlockPosition;
    private int hashCapacity;
    private BlockBuilder heapBlockBuilder;
    private final IndexedPriorityQueue minHeap;
    private IntBigArray blockToHeapIndex;

    public StreamSummary(Type type, int maxBuckets, int heapCapacity) {
        this.type = type;
        this.maxBuckets = maxBuckets;
        this.heapCapacity = heapCapacity;
        this.blockPositionToCount = new LongBigArray();
        this.blockToHeapIndex = new IntBigArray();
        this.hashToBlockPosition = new IntBigArray(-1);
        this.hashCapacity = HashCommon.arraySize((int)heapCapacity, (float)0.75f);
        this.hashToBlockPosition.ensureCapacity((long)this.hashCapacity);
        this.heapBlockBuilder = type.createBlockBuilder(null, heapCapacity);
        this.minHeap = new IndexedPriorityQueue(heapCapacity, this::compare, this);
        this.mask = this.hashCapacity - 1;
        this.maxFill = StreamSummary.calculateMaxFill(this.hashCapacity);
        this.blockPositionToCount.ensureCapacity((long)this.hashCapacity);
        this.blockToHeapIndex.ensureCapacity((long)this.hashCapacity);
    }

    public void add(Block block, int blockPosition, long incrementCount) {
        int bucketPosition;
        int hashPosition = StreamSummary.getBucketId(TypeUtils.hashPosition(this.type, block, blockPosition), this.mask);
        while ((bucketPosition = this.hashToBlockPosition.get((long)hashPosition)) != -1) {
            if (bucketPosition != -2 && this.type.equalTo(block, blockPosition, (Block)this.heapBlockBuilder, bucketPosition)) {
                this.blockPositionToCount.add((long)bucketPosition, incrementCount);
                int heapIndex = this.blockToHeapIndex.get((long)bucketPosition);
                this.minHeap.get(heapIndex).setGeneration(this.generation++);
                this.minHeap.percolateDown(heapIndex);
                return;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        this.addNewGroup(block, blockPosition, hashPosition, incrementCount);
    }

    private void addNewGroup(Block block, int blockPosition, int hashPosition, long incrementCount) {
        int newElementBlockPosition = this.heapBlockBuilder.getPositionCount();
        if (this.minHeap.isFull()) {
            StreamDataEntity min = this.minHeap.getMin();
            int removedBlock = this.getBlockPosition(min);
            long minCount = this.blockPositionToCount.get((long)removedBlock);
            this.handleDelete(removedBlock, min.getHashPosition());
            this.hashToBlockPosition.set((long)hashPosition, newElementBlockPosition);
            this.blockPositionToCount.set((long)newElementBlockPosition, minCount + incrementCount);
            this.minHeap.replaceMin(new StreamDataEntity(hashPosition, this.generation++));
        } else {
            this.hashToBlockPosition.set((long)hashPosition, newElementBlockPosition);
            this.blockPositionToCount.set((long)newElementBlockPosition, incrementCount);
            this.minHeap.add(new StreamDataEntity(hashPosition, this.generation++));
        }
        this.type.appendTo(block, blockPosition, this.heapBlockBuilder);
        this.compactAndRehashIfNeeded();
    }

    private void handleDelete(int removedBlock, int removedHashPosition) {
        this.blockPositionToCount.set((long)removedBlock, 0L);
        this.blockToHeapIndex.set((long)removedBlock, -1);
        this.hashToBlockPosition.set((long)removedHashPosition, -2);
    }

    private void compactAndRehashIfNeeded() {
        if (this.shouldCompact(this.heapBlockBuilder.getSizeInBytes(), this.heapBlockBuilder.getPositionCount())) {
            this.compact();
        } else if (this.heapBlockBuilder.getPositionCount() >= this.maxFill) {
            this.rehash();
        }
    }

    protected boolean shouldCompact(long sizeInBytes, int numberOfPositionInBlock) {
        return sizeInBytes >= 32768L && numberOfPositionInBlock / this.getHeapSize() >= 3;
    }

    @VisibleForTesting
    public int getHeapSize() {
        return this.minHeap.getSize();
    }

    private synchronized void compact() {
        BlockBuilder newHeapBlockBuilder = this.type.createBlockBuilder(null, this.heapBlockBuilder.getPositionCount());
        LongBigArray newBlockPositionToCount = new LongBigArray();
        this.hashCapacity = HashCommon.arraySize((int)this.heapCapacity, (float)0.75f);
        this.maxFill = StreamSummary.calculateMaxFill(this.hashCapacity);
        newBlockPositionToCount.ensureCapacity((long)this.hashCapacity);
        IntBigArray newBlockToHeapIndex = new IntBigArray();
        newBlockToHeapIndex.ensureCapacity((long)this.hashCapacity);
        for (int heapPosition = 0; heapPosition < this.getHeapSize(); ++heapPosition) {
            int newBlockPos = newHeapBlockBuilder.getPositionCount();
            StreamDataEntity heapEntry = this.minHeap.get(heapPosition);
            int oldBlockPosition = this.getBlockPosition(heapEntry);
            this.type.appendTo((Block)this.heapBlockBuilder, oldBlockPosition, newHeapBlockBuilder);
            newBlockPositionToCount.set((long)newBlockPos, this.blockPositionToCount.get((long)oldBlockPosition));
            newBlockToHeapIndex.set((long)newBlockPos, heapPosition);
            this.hashToBlockPosition.set((long)heapEntry.getHashPosition(), newBlockPos);
        }
        this.blockPositionToCount = newBlockPositionToCount;
        this.heapBlockBuilder = newHeapBlockBuilder;
        this.blockToHeapIndex = newBlockToHeapIndex;
        this.rehash();
    }

    private void rehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = (int)newCapacityLong;
        int newMask = newCapacity - 1;
        IntBigArray newHashToBlockPosition = new IntBigArray(-1);
        newHashToBlockPosition.ensureCapacity((long)newCapacity);
        for (int heapPosition = 0; heapPosition < this.getHeapSize(); ++heapPosition) {
            StreamDataEntity heapEntry = this.minHeap.get(heapPosition);
            int blockPosition = this.getBlockPosition(heapEntry);
            int hashPosition = StreamSummary.getBucketId(TypeUtils.hashPosition(this.type, (Block)this.heapBlockBuilder, blockPosition), newMask);
            while (newHashToBlockPosition.get((long)hashPosition) != -1) {
                hashPosition = hashPosition + 1 & newMask;
            }
            newHashToBlockPosition.set((long)hashPosition, blockPosition);
            heapEntry.setHashPosition(hashPosition);
        }
        this.hashCapacity = newCapacity;
        this.mask = newMask;
        this.maxFill = StreamSummary.calculateMaxFill(newCapacity);
        this.hashToBlockPosition = newHashToBlockPosition;
        this.blockPositionToCount.ensureCapacity((long)this.maxFill);
        this.blockToHeapIndex.ensureCapacity((long)this.maxFill);
    }

    private int compare(StreamDataEntity heapValue1, StreamDataEntity heapValue2) {
        int compare = Long.compare(this.getCount(heapValue1), this.getCount(heapValue2));
        if (compare == 0) {
            compare = Long.compare(heapValue1.getGeneration(), heapValue2.getGeneration());
        }
        return compare;
    }

    private long getCount(StreamDataEntity heapEntry) {
        return this.blockPositionToCount.get((long)this.getBlockPosition(heapEntry));
    }

    private int getBlockPosition(StreamDataEntity heapEntry) {
        return this.hashToBlockPosition.get((long)heapEntry.getHashPosition());
    }

    private static int getBucketId(long rawHash, int mask) {
        return (int)HashCommon.murmurHash3((long)rawHash) & mask;
    }

    public void topK(BlockBuilder out) {
        List<StreamDataEntity> sortedHeapEntries = this.getTopHeapEntries();
        BlockBuilder valueBuilder = out.beginBlockEntry();
        for (StreamDataEntity heapEntry : sortedHeapEntries) {
            this.type.appendTo((Block)this.heapBlockBuilder, this.getBlockPosition(heapEntry), valueBuilder);
            BigintType.BIGINT.writeLong(valueBuilder, this.getCount(heapEntry));
        }
        out.closeEntry();
    }

    private List<StreamDataEntity> getTopHeapEntries() {
        return this.minHeap.topK(this.maxBuckets, (heapEntry1, heapEntry2) -> {
            int compare = Long.compare(this.getCount((StreamDataEntity)heapEntry2), this.getCount((StreamDataEntity)heapEntry1));
            if (compare == 0) {
                return Integer.compare(heapEntry1.getGeneration(), heapEntry2.getGeneration());
            }
            return compare;
        });
    }

    public void merge(StreamSummary otherStreamSummary) {
        otherStreamSummary.readAllValues(this::add);
    }

    public void readAllValues(StreamSummaryReader reader) {
        List<StreamDataEntity> heapEntries = this.getTopHeapEntries();
        for (StreamDataEntity heapEntry : heapEntries) {
            reader.read((Block)this.heapBlockBuilder, this.getBlockPosition(heapEntry), this.getCount(heapEntry));
        }
    }

    public void serialize(BlockBuilder out) {
        BlockBuilder blockBuilder = out.beginBlockEntry();
        if (this.getHeapSize() > 0) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)this.maxBuckets);
            BigintType.BIGINT.writeLong(blockBuilder, (long)this.heapCapacity);
            List<StreamDataEntity> sortedHeap = this.getTopHeapEntries();
            BlockBuilder keyItems = blockBuilder.beginBlockEntry();
            for (StreamDataEntity heapEntry : sortedHeap) {
                this.type.appendTo((Block)this.heapBlockBuilder, this.getBlockPosition(heapEntry), keyItems);
            }
            blockBuilder.closeEntry();
            BlockBuilder valueItems = blockBuilder.beginBlockEntry();
            for (StreamDataEntity heapEntry : sortedHeap) {
                BigintType.BIGINT.writeLong(valueItems, this.getCount(heapEntry));
            }
            blockBuilder.closeEntry();
        }
        out.closeEntry();
    }

    public static StreamSummary deserialize(Type type, Block block) {
        int currentPosition = 0;
        int maxBuckets = Math.toIntExact(BigintType.BIGINT.getLong(block, currentPosition++));
        int heapCapacity = Math.toIntExact(BigintType.BIGINT.getLong(block, currentPosition++));
        StreamSummary streamSummary = new StreamSummary(type, maxBuckets, heapCapacity);
        Block keysBlock = new ArrayType(type).getObject(block, currentPosition++);
        Block valuesBlock = new ArrayType((Type)BigintType.BIGINT).getObject(block, currentPosition);
        for (int position = 0; position < keysBlock.getPositionCount(); ++position) {
            streamSummary.add(keysBlock, position, valuesBlock.getLong(position));
        }
        return streamSummary;
    }

    public long estimatedInMemorySize() {
        return (long)INSTANCE_SIZE + this.heapBlockBuilder.getRetainedSizeInBytes() + this.minHeap.estimatedInMemorySize() + this.blockPositionToCount.sizeOf() + this.hashToBlockPosition.sizeOf();
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    @Override
    public void indexChanged(StreamDataEntity blockReferenceEntity, int newIndex) {
        this.blockToHeapIndex.set((long)this.getBlockPosition(blockReferenceEntity), newIndex);
    }
}

