/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.differentialentropy;

import com.facebook.presto.common.array.ObjectBigArray;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyState;
import com.facebook.presto.operator.aggregation.differentialentropy.DifferentialEntropyStateStrategy;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import java.util.Objects;

public class DifferentialEntropyStateFactory
implements AccumulatorStateFactory<DifferentialEntropyState> {
    public DifferentialEntropyState createSingleState() {
        return new SingleState();
    }

    public Class<? extends DifferentialEntropyState> getSingleStateClass() {
        return SingleState.class;
    }

    public DifferentialEntropyState createGroupedState() {
        return new GroupedState();
    }

    public Class<? extends DifferentialEntropyState> getGroupedStateClass() {
        return GroupedState.class;
    }

    public static class SingleState
    implements DifferentialEntropyState {
        private DifferentialEntropyStateStrategy strategy;

        @Override
        public void setStrategy(DifferentialEntropyStateStrategy strategy) {
            this.strategy = Objects.requireNonNull(strategy, "strategy is null");
        }

        @Override
        public DifferentialEntropyStateStrategy getStrategy() {
            return this.strategy;
        }

        public long getEstimatedSize() {
            return this.strategy == null ? 0L : this.strategy.getEstimatedSize();
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements DifferentialEntropyState {
        private ObjectBigArray<DifferentialEntropyStateStrategy> strategies = new ObjectBigArray();
        private long size;

        public void ensureCapacity(long size) {
            this.strategies.ensureCapacity(size);
        }

        @Override
        public void setStrategy(DifferentialEntropyStateStrategy strategy) {
            DifferentialEntropyStateStrategy previous = Objects.requireNonNull(strategy, "strategy is null");
            if (previous != null) {
                this.size -= previous.getEstimatedSize();
            }
            this.strategies.set(this.getGroupId(), (Object)strategy);
            this.size += strategy.getEstimatedSize();
        }

        @Override
        public DifferentialEntropyStateStrategy getStrategy() {
            return (DifferentialEntropyStateStrategy)this.strategies.get(this.getGroupId());
        }

        public long getEstimatedSize() {
            return this.size + this.strategies.sizeOf();
        }
    }
}

