/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.operator.aggregation.noisyaggregation.NoisyCountStateSerializer;
import com.facebook.presto.operator.aggregation.state.InitialBooleanValue;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateMetadata;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

@AccumulatorStateMetadata(stateSerializerClass=NoisyCountStateSerializer.class)
public interface NoisyCountState
extends AccumulatorState {
    public long getCount();

    public void setCount(long var1);

    public double getNoiseScale();

    public void setNoiseScale(double var1);

    @InitialBooleanValue(value=true)
    public boolean isNullRandomSeed();

    public void setNullRandomSeed(boolean var1);

    public long getRandomSeed();

    public void setRandomSeed(long var1);

    public static int calculateSerializationCapacity() {
        return 25;
    }

    public static void writeToSerializer(NoisyCountState state, SliceOutput output) {
        output.appendLong(state.getCount());
        output.appendDouble(state.getNoiseScale());
        output.appendByte(state.isNullRandomSeed() ? 1 : 0);
        output.appendLong(state.getRandomSeed());
    }

    public static void readFromSerializer(NoisyCountState state, SliceInput input) {
        state.setCount(input.readLong());
        state.setNoiseScale(input.readDouble());
        state.setNullRandomSeed(input.readByte() == 1);
        state.setRandomSeed(input.readLong());
    }
}

