/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.noisyaggregation;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.operator.aggregation.noisyaggregation.SfmSketchState;
import com.facebook.presto.operator.aggregation.noisyaggregation.sketch.SfmSketch;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;

public class SfmSketchStateSerializer
implements AccumulatorStateSerializer<SfmSketchState> {
    public Type getSerializedType() {
        return VarbinaryType.VARBINARY;
    }

    public void serialize(SfmSketchState state, BlockBuilder out) {
        if (state.getSketch() == null) {
            out.appendNull();
        } else {
            DynamicSliceOutput output = new DynamicSliceOutput(state.getSketch().estimatedSerializedSize() + 8);
            output.appendDouble(state.getEpsilon());
            state.getSketch().serialize(output);
            VarbinaryType.VARBINARY.writeSlice(out, output.slice());
        }
    }

    public void deserialize(Block block, int index, SfmSketchState state) {
        Slice stateSlice = VarbinaryType.VARBINARY.getSlice(block, index);
        BasicSliceInput input = stateSlice.getInput();
        state.setEpsilon(input.readDouble());
        Slice pcsaSlice = input.slice();
        state.setSketch(SfmSketch.deserialize(pcsaSlice));
    }
}

