/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.partial;

import com.facebook.presto.common.Page;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.CompletedWork;
import com.facebook.presto.operator.HashCollisionsCounter;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.WorkProcessor;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.builder.HashAggregationBuilder;
import com.facebook.presto.spi.function.aggregation.GroupByIdBlock;
import com.facebook.presto.spi.function.aggregation.GroupedAccumulator;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class SkipAggregationBuilder
implements HashAggregationBuilder {
    private final LocalMemoryContext memoryContext;
    private final List<GroupedAccumulator> groupedAccumulators;
    @Nullable
    private Page currentPage;
    private final int[] hashChannels;

    public SkipAggregationBuilder(List<Integer> groupByChannels, Optional<Integer> inputHashChannel, List<AccumulatorFactory> accumulatorFactories, LocalMemoryContext memoryContext) {
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        Objects.requireNonNull(accumulatorFactories, "accumulatorFactories is null");
        this.groupedAccumulators = (List)accumulatorFactories.stream().map(accumulatorFactory -> accumulatorFactory.createGroupedAccumulator(UpdateMemory.NOOP)).collect(ImmutableList.toImmutableList());
        this.hashChannels = new int[groupByChannels.size() + (inputHashChannel.isPresent() ? 1 : 0)];
        for (int i = 0; i < groupByChannels.size(); ++i) {
            this.hashChannels[i] = groupByChannels.get(i);
        }
        inputHashChannel.ifPresent(channelIndex -> {
            this.hashChannels[groupByChannels.size()] = channelIndex;
        });
    }

    @Override
    public Work<?> processPage(Page page) {
        Preconditions.checkState((this.currentPage == null ? 1 : 0) != 0);
        this.currentPage = page;
        return new CompletedWork();
    }

    @Override
    public WorkProcessor<Page> buildResult() {
        if (this.currentPage == null) {
            return WorkProcessor.of(new Page[0]);
        }
        Page result = this.buildOutputPage(this.currentPage);
        this.currentPage = null;
        return WorkProcessor.of(result);
    }

    @Override
    public boolean isFull() {
        return this.currentPage != null;
    }

    @Override
    public void updateMemory() {
        if (this.currentPage != null) {
            this.memoryContext.setBytes(this.currentPage.getSizeInBytes());
        }
    }

    @Override
    public void recordHashCollisions(HashCollisionsCounter hashCollisionsCounter) {
    }

    @Override
    public void close() {
    }

    @Override
    public ListenableFuture<?> startMemoryRevoke() {
        throw new UnsupportedOperationException("startMemoryRevoke not supported for SkipAggregationBuilder");
    }

    @Override
    public void finishMemoryRevoke() {
        throw new UnsupportedOperationException("finishMemoryRevoke not supported for SkipAggregationBuilder");
    }

    private Page buildOutputPage(Page page) {
        this.populateInitialAccumulatorState(page);
        BlockBuilder[] outputBuilders = this.serializeAccumulatorState(page.getPositionCount());
        return this.constructOutputPage(page, outputBuilders);
    }

    private void populateInitialAccumulatorState(Page page) {
        int positionCount = page.getPositionCount();
        GroupByIdBlock groupByIdBlock = new GroupByIdBlock((long)positionCount, (Block)new LongArrayBlock(positionCount, Optional.empty(), SkipAggregationBuilder.fillConsecutive(positionCount)));
        for (GroupedAccumulator groupedAccumulator : this.groupedAccumulators) {
            groupedAccumulator.addInput(groupByIdBlock, page);
        }
    }

    private BlockBuilder[] serializeAccumulatorState(int positionCount) {
        BlockBuilder[] outputBuilders = new BlockBuilder[this.groupedAccumulators.size()];
        for (int i = 0; i < outputBuilders.length; ++i) {
            outputBuilders[i] = this.groupedAccumulators.get(i).getIntermediateType().createBlockBuilder(null, positionCount);
        }
        for (int position = 0; position < positionCount; ++position) {
            for (int i = 0; i < this.groupedAccumulators.size(); ++i) {
                GroupedAccumulator groupedAccumulator = this.groupedAccumulators.get(i);
                BlockBuilder output = outputBuilders[i];
                groupedAccumulator.evaluateIntermediate(position, output);
            }
        }
        return outputBuilders;
    }

    private Page constructOutputPage(Page page, BlockBuilder[] outputBuilders) {
        int i;
        Block[] outputBlocks = new Block[this.hashChannels.length + outputBuilders.length];
        for (i = 0; i < this.hashChannels.length; ++i) {
            outputBlocks[i] = page.getBlock(this.hashChannels[i]);
        }
        for (i = 0; i < outputBuilders.length; ++i) {
            outputBlocks[this.hashChannels.length + i] = outputBuilders[i].build();
        }
        return new Page(page.getPositionCount(), outputBlocks);
    }

    private static long[] fillConsecutive(int positionCount) {
        long[] longs = new long[positionCount];
        for (int i = 0; i < positionCount; ++i) {
            longs[i] = i;
        }
        return longs;
    }
}

