/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.Session;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.BucketPartitionFunction;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PartitionFunction;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.exchange.BroadcastExchanger;
import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchangeSink;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.operator.exchange.PartitioningExchanger;
import com.facebook.presto.operator.exchange.PassthroughExchanger;
import com.facebook.presto.operator.exchange.RandomExchanger;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.sql.planner.PartitioningProviderManager;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class LocalExchange {
    private final Supplier<LocalExchanger> exchangerSupplier;
    private final List<LocalExchangeSource> sources;
    private final LocalExchangeMemoryManager memoryManager;
    @GuardedBy(value="this")
    private boolean allSourcesFinished;
    @GuardedBy(value="this")
    private boolean noMoreSinkFactories;
    @GuardedBy(value="this")
    private final List<LocalExchangeSinkFactory> allSinkFactories;
    @GuardedBy(value="this")
    private final Set<LocalExchangeSinkFactory> openSinkFactories = new HashSet<LocalExchangeSinkFactory>();
    @GuardedBy(value="this")
    private final Set<LocalExchangeSink> sinks = new HashSet<LocalExchangeSink>();
    @GuardedBy(value="this")
    private int nextSourceIndex;

    public LocalExchange(PartitioningProviderManager partitioningProviderManager, Session session, int sinkFactoryCount, int bufferCount, PartitioningHandle partitioning, List<Integer> partitionChannels, List<Type> partitioningChannelTypes, Optional<Integer> partitionHashChannel, DataSize maxBufferedBytes) {
        this.allSinkFactories = (List)Stream.generate(() -> new LocalExchangeSinkFactory(this)).limit(sinkFactoryCount).collect(ImmutableList.toImmutableList());
        this.openSinkFactories.addAll(this.allSinkFactories);
        this.noMoreSinkFactories();
        ImmutableList.Builder sources = ImmutableList.builder();
        for (int i = 0; i < bufferCount; ++i) {
            sources.add((Object)new LocalExchangeSource(source -> this.checkAllSourcesFinished()));
        }
        this.sources = sources.build();
        List buffers = (List)this.sources.stream().map(buffer -> buffer::addPage).collect(ImmutableList.toImmutableList());
        this.memoryManager = new LocalExchangeMemoryManager(maxBufferedBytes.toBytes());
        if (partitioning.equals((Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new BroadcastExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            this.exchangerSupplier = () -> new RandomExchanger(buffers, this.memoryManager);
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            Iterator<LocalExchangeSource> sourceIterator = this.sources.iterator();
            this.exchangerSupplier = () -> {
                Preconditions.checkState((boolean)sourceIterator.hasNext(), (Object)"no more sources");
                return new PassthroughExchanger((LocalExchangeSource)sourceIterator.next(), maxBufferedBytes.toBytes() / (long)bufferCount, this.memoryManager::updateMemoryUsage);
            };
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getConnectorId().isPresent()) {
            this.exchangerSupplier = () -> new PartitioningExchanger(buffers, this.memoryManager, LocalExchange.createPartitionFunction(partitioningProviderManager, session, partitioning, bufferCount, partitioningChannelTypes, partitionHashChannel.isPresent()), partitionChannels, partitionHashChannel);
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
    }

    static PartitionFunction createPartitionFunction(PartitioningProviderManager partitioningProviderManager, Session session, PartitioningHandle partitioning, int partitionCount, List<Type> partitioningChannelTypes, boolean isHashPrecomputed) {
        if (partitioning.getConnectorHandle() instanceof SystemPartitioningHandle) {
            HashGenerator hashGenerator = isHashPrecomputed ? new PrecomputedHashGenerator(0) : InterpretedHashGenerator.createPositionalWithTypes(partitioningChannelTypes);
            return new LocalPartitionGenerator(hashGenerator, partitionCount);
        }
        ConnectorNodePartitioningProvider partitioningProvider = partitioningProviderManager.getPartitioningProvider((ConnectorId)partitioning.getConnectorId().get());
        int bucketCount = partitioningProvider.getBucketCount((ConnectorTransactionHandle)partitioning.getTransactionHandle().orElse(null), session.toConnectorSession((ConnectorId)partitioning.getConnectorId().get()), partitioning.getConnectorHandle());
        int[] bucketToPartition = new int[bucketCount];
        for (int bucket = 0; bucket < bucketCount; ++bucket) {
            bucketToPartition[bucket] = bucket % partitionCount;
        }
        BucketFunction bucketFunction = partitioningProvider.getBucketFunction((ConnectorTransactionHandle)partitioning.getTransactionHandle().orElse(null), session.toConnectorSession((ConnectorId)partitioning.getConnectorId().get()), partitioning.getConnectorHandle(), partitioningChannelTypes, bucketCount);
        Preconditions.checkArgument((bucketFunction != null ? 1 : 0) != 0, (String)"No bucket function for partitioning: %s", (Object)partitioning);
        return new BucketPartitionFunction(bucketFunction, bucketToPartition);
    }

    public int getBufferCount() {
        return this.sources.size();
    }

    public long getBufferedBytes() {
        return this.memoryManager.getBufferedBytes();
    }

    public synchronized LocalExchangeSinkFactory createSinkFactory() {
        Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0, (Object)"No more sink factories already set");
        LocalExchangeSinkFactory newFactory = new LocalExchangeSinkFactory(this);
        this.openSinkFactories.add(newFactory);
        return newFactory;
    }

    public synchronized LocalExchangeSinkFactory getSinkFactory(LocalExchangeSinkFactoryId id) {
        return this.allSinkFactories.get(id.id);
    }

    public synchronized LocalExchangeSource getNextSource() {
        Preconditions.checkState((this.nextSourceIndex < this.sources.size() ? 1 : 0) != 0, (Object)"All operators already created");
        LocalExchangeSource result = this.sources.get(this.nextSourceIndex);
        ++this.nextSourceIndex;
        return result;
    }

    public LocalExchangeSource getSource(int partitionIndex) {
        return this.sources.get(partitionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSourcesFinished() {
        ImmutableList openSinks;
        LocalExchange.checkNotHoldsLock(this);
        if (!this.sources.stream().allMatch(LocalExchangeSource::isFinished)) {
            return;
        }
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.allSourcesFinished = true;
            openSinks = ImmutableList.copyOf(this.sinks);
            this.sinks.clear();
        }
        openSinks.forEach(LocalExchangeSink::finish);
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalExchangeSink createSink(LocalExchangeSinkFactory factory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            Preconditions.checkState((boolean)this.openSinkFactories.contains(factory), (Object)"Factory is already closed");
            if (this.allSourcesFinished) {
                return LocalExchangeSink.finishedLocalExchangeSink();
            }
            LocalExchanger exchanger = this.exchangerSupplier.get();
            LocalExchangeSink sink = new LocalExchangeSink(exchanger, this::sinkFinished);
            this.sinks.add(sink);
            return sink;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFinished(LocalExchangeSink sink) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.sinks.remove(sink);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noMoreSinkFactories() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.noMoreSinkFactories = true;
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sinkFactoryClosed(LocalExchangeSinkFactory sinkFactory) {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            this.openSinkFactories.remove(sinkFactory);
        }
        this.checkAllSinksComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllSinksComplete() {
        LocalExchange.checkNotHoldsLock(this);
        LocalExchange localExchange = this;
        synchronized (localExchange) {
            if (!(this.noMoreSinkFactories && this.openSinkFactories.isEmpty() && this.sinks.isEmpty())) {
                return;
            }
        }
        this.sources.forEach(LocalExchangeSource::finish);
    }

    private static void checkNotHoldsLock(Object lock) {
        Preconditions.checkState((!Thread.holdsLock(lock) ? 1 : 0) != 0, (Object)"Can not execute this method while holding a lock");
    }

    private static int computeBufferCount(PartitioningHandle partitioning, int defaultConcurrency, List<Integer> partitionChannels) {
        int bufferCount;
        if (partitioning.equals((Object)SystemPartitioningHandle.SINGLE_DISTRIBUTION)) {
            bufferCount = 1;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Gather exchange must not have partition channels");
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Broadcast exchange must not have partition channels");
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Arbitrary exchange must not have partition channels");
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION)) {
            bufferCount = defaultConcurrency;
            Preconditions.checkArgument((boolean)partitionChannels.isEmpty(), (Object)"Passthrough exchange must not have partition channels");
        } else if (partitioning.equals((Object)SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION) || partitioning.getConnectorId().isPresent()) {
            bufferCount = defaultConcurrency;
        } else {
            throw new IllegalArgumentException("Unsupported local exchange partitioning " + partitioning);
        }
        return bufferCount;
    }

    @ThreadSafe
    public static class LocalExchangeSinkFactory
    implements Closeable {
        private final LocalExchange exchange;

        private LocalExchangeSinkFactory(LocalExchange exchange) {
            this.exchange = Objects.requireNonNull(exchange, "exchange is null");
        }

        public LocalExchangeSink createSink() {
            return this.exchange.createSink(this);
        }

        public LocalExchangeSinkFactory duplicate() {
            return this.exchange.createSinkFactory();
        }

        @Override
        public void close() {
            this.exchange.sinkFactoryClosed(this);
        }

        public void noMoreSinkFactories() {
            this.exchange.noMoreSinkFactories();
        }
    }

    public static class LocalExchangeSinkFactoryId {
        private final int id;

        public LocalExchangeSinkFactoryId(int id) {
            this.id = id;
        }
    }

    @ThreadSafe
    public static class LocalExchangeFactory {
        private final PartitioningProviderManager partitioningProviderManager;
        private final Session session;
        private final PartitioningHandle partitioning;
        private final List<Integer> partitionChannels;
        private final List<Type> partitioningChannelTypes;
        private final Optional<Integer> partitionHashChannel;
        private final PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy;
        private final DataSize maxBufferedBytes;
        private final int bufferCount;
        @GuardedBy(value="this")
        private boolean noMoreSinkFactories;
        @GuardedBy(value="this")
        private int numSinkFactories;
        @GuardedBy(value="this")
        private final Map<Lifespan, LocalExchange> localExchangeMap = new HashMap<Lifespan, LocalExchange>();
        @GuardedBy(value="this")
        private final List<LocalExchangeSinkFactoryId> closedSinkFactories = new ArrayList<LocalExchangeSinkFactoryId>();

        public LocalExchangeFactory(PartitioningProviderManager partitioningProviderManager, Session session, PartitioningHandle partitioning, int defaultConcurrency, List<Type> types, List<Integer> partitionChannels, Optional<Integer> partitionHashChannel, PipelineExecutionStrategy exchangeSourcePipelineExecutionStrategy, DataSize maxBufferedBytes) {
            this.partitioningProviderManager = Objects.requireNonNull(partitioningProviderManager, "partitioningProviderManager is null");
            this.session = Objects.requireNonNull(session, "session is null");
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
            this.bufferCount = LocalExchange.computeBufferCount(partitioning, defaultConcurrency, partitionChannels);
            this.partitionChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionChannels, "partitionChannels is null"));
            Objects.requireNonNull(types, "types is null");
            this.partitioningChannelTypes = (List)partitionChannels.stream().map(types::get).collect(ImmutableList.toImmutableList());
            this.partitionHashChannel = Objects.requireNonNull(partitionHashChannel, "partitionHashChannel is null");
            this.exchangeSourcePipelineExecutionStrategy = Objects.requireNonNull(exchangeSourcePipelineExecutionStrategy, "exchangeSourcePipelineExecutionStrategy is null");
            this.maxBufferedBytes = Objects.requireNonNull(maxBufferedBytes, "maxBufferedBytes is null");
        }

        public synchronized LocalExchangeSinkFactoryId newSinkFactoryId() {
            Preconditions.checkState((!this.noMoreSinkFactories ? 1 : 0) != 0);
            LocalExchangeSinkFactoryId result = new LocalExchangeSinkFactoryId(this.numSinkFactories);
            ++this.numSinkFactories;
            return result;
        }

        public synchronized void noMoreSinkFactories() {
            this.noMoreSinkFactories = true;
        }

        public int getBufferCount() {
            return this.bufferCount;
        }

        public synchronized LocalExchange getLocalExchange(Lifespan lifespan) {
            if (this.exchangeSourcePipelineExecutionStrategy == PipelineExecutionStrategy.UNGROUPED_EXECUTION) {
                Preconditions.checkArgument((boolean)lifespan.isTaskWide(), (Object)"LocalExchangeFactory is declared as UNGROUPED_EXECUTION. Driver-group exchange cannot be created.");
            } else {
                Preconditions.checkArgument((!lifespan.isTaskWide() ? 1 : 0) != 0, (Object)"LocalExchangeFactory is declared as GROUPED_EXECUTION. Task-wide exchange cannot be created.");
            }
            return this.localExchangeMap.computeIfAbsent(lifespan, ignored -> {
                Preconditions.checkState((boolean)this.noMoreSinkFactories);
                LocalExchange localExchange = new LocalExchange(this.partitioningProviderManager, this.session, this.numSinkFactories, this.bufferCount, this.partitioning, this.partitionChannels, this.partitioningChannelTypes, this.partitionHashChannel, this.maxBufferedBytes);
                for (LocalExchangeSinkFactoryId closedSinkFactoryId : this.closedSinkFactories) {
                    localExchange.getSinkFactory(closedSinkFactoryId).close();
                }
                return localExchange;
            });
        }

        public synchronized void closeSinks(LocalExchangeSinkFactoryId sinkFactoryId) {
            this.closedSinkFactories.add(sinkFactoryId);
            for (LocalExchange localExchange : this.localExchangeMap.values()) {
                localExchange.getSinkFactory(sinkFactoryId).close();
            }
        }
    }
}

