/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LiteralParameters;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.util.DateTimeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.JsonCastException;
import com.facebook.presto.util.JsonUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.io.IOException;

public final class JsonOperators {
    public static final JsonFactory JSON_FACTORY = new JsonFactory().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);

    private JsonOperators() {
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @LiteralParameters(value={"x"})
    @SqlType(value="varchar(x)")
    public static Slice castToVarchar(@SqlType(value="json") Slice json) {
        Slice slice;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Slice result = JsonUtil.currentTokenAsVarchar(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to VARCHAR", new Object[0]);
                slice = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "varchar"), (Throwable)e);
                }
            }
            parser.close();
        }
        return slice;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="bigint")
    public static Long castToBigint(@SqlType(value="json") Slice json) {
        Long l;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsBigint(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BIGINT", new Object[0]);
                l = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "bigint"), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="integer")
    public static Long castToInteger(@SqlType(value="json") Slice json) {
        Long l;
        block10: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsInteger(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to INTEGER", new Object[0]);
                l = result;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrestoException e) {
                    if (e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
                    }
                    throw e;
                }
                catch (JsonCastException | IOException | ArithmeticException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="smallint")
    public static Long castToSmallint(@SqlType(value="json") Slice json) {
        Long l;
        block10: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsSmallint(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to SMALLINT", new Object[0]);
                l = result;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrestoException e) {
                    if (e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
                    }
                    throw e;
                }
                catch (JsonCastException | IOException | IllegalArgumentException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "smallint"), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="tinyint")
    public static Long castToTinyint(@SqlType(value="json") Slice json) {
        Long l;
        block10: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsTinyint(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to TINYINT", new Object[0]);
                l = result;
                if (parser == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PrestoException e) {
                    if (e.getErrorCode().equals((Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode())) {
                        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "integer"), e.getCause());
                    }
                    throw e;
                }
                catch (JsonCastException | IOException | IllegalArgumentException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "tinyint"), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="double")
    public static Double castToDouble(@SqlType(value="json") Slice json) {
        Double d;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Double result = JsonUtil.currentTokenAsDouble(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to DOUBLE", new Object[0]);
                d = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "double"), (Throwable)e);
                }
            }
            parser.close();
        }
        return d;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="real")
    public static Long castToReal(@SqlType(value="json") Slice json) {
        Long l;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Long result = JsonUtil.currentTokenAsReal(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to REAL", new Object[0]);
                l = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "real"), (Throwable)e);
                }
            }
            parser.close();
        }
        return l;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlNullable
    @SqlType(value="boolean")
    public static Boolean castToBoolean(@SqlType(value="json") Slice json) {
        Boolean bl;
        block8: {
            JsonParser parser = JsonUtil.createJsonParser(JSON_FACTORY, json);
            try {
                parser.nextToken();
                Boolean result = JsonUtil.currentTokenAsBoolean(parser);
                Failures.checkCondition(parser.nextToken() == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot cast input json to BOOLEAN", new Object[0]);
                bl = result;
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonCastException | IOException e) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", json.toStringUtf8(), "boolean"), (Throwable)e);
                }
            }
            parser.close();
        }
        return bl;
    }

    @ScalarOperator(value=OperatorType.CAST)
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice castFromVarchar(@SqlType(value="varchar(x)") Slice value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(value.length() + 2);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(value.toStringUtf8());
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value.toStringUtf8(), "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromTinyInt(@SqlType(value="tinyint") long value) {
        return JsonOperators.internalCastFromLong(value, 4);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromSmallInt(@SqlType(value="smallint") long value) {
        return JsonOperators.internalCastFromLong(value, 8);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromInteger(@SqlType(value="integer") long value) {
        return JsonOperators.internalCastFromLong(value, 12);
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBigint(@SqlType(value="bigint") long value) {
        return JsonOperators.internalCastFromLong(value, 20);
    }

    private static Slice internalCastFromLong(long value, int estimatedSize) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(estimatedSize);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDouble(@SqlType(value="double") double value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromReal(@SqlType(value="real") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(32);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeNumber(Float.intBitsToFloat((int)value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromBoolean(@SqlType(value="boolean") boolean value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(5);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeBoolean(value);
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromTimestamp(SqlFunctionProperties properties, @SqlType(value="timestamp") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(25);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printTimestampWithoutTimeZone(properties.getTimeZoneKey(), value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.CAST)
    @SqlType(value="json")
    public static Slice castFromDate(SqlFunctionProperties properties, @SqlType(value="date") long value) {
        try {
            DynamicSliceOutput output = new DynamicSliceOutput(12);
            try (JsonGenerator jsonGenerator = JsonUtil.createJsonGenerator(JSON_FACTORY, (SliceOutput)output);){
                jsonGenerator.writeString(DateTimeUtils.printDate((int)value));
            }
            return output.slice();
        }
        catch (IOException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast '%s' to %s", value, "json"));
        }
    }

    @ScalarOperator(value=OperatorType.HASH_CODE)
    @SqlType(value="bigint")
    public static long hashCode(@SqlType(value="json") Slice value) {
        return value.hashCode();
    }

    @ScalarOperator(value=OperatorType.INDETERMINATE)
    @SqlType(value="boolean")
    public static boolean indeterminate(@SqlType(value="json") Slice value, @IsNull boolean isNull) {
        return isNull;
    }

    @ScalarOperator(value=OperatorType.EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean equals(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return leftJson.equals((Object)rightJson);
    }

    @ScalarOperator(value=OperatorType.NOT_EQUAL)
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean notEqual(@SqlType(value="json") Slice leftJson, @SqlType(value="json") Slice rightJson) {
        return !leftJson.equals((Object)rightJson);
    }

    @ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
    public static class JsonDistinctFromOperator {
        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@SqlType(value="json") Slice leftJson, @IsNull boolean leftNull, @SqlType(value="json") Slice rightJson, @IsNull boolean rightNull) {
            if (leftNull != rightNull) {
                return true;
            }
            if (leftNull) {
                return false;
            }
            return JsonOperators.notEqual(leftJson, rightJson);
        }

        @SqlType(value="boolean")
        public static boolean isDistinctFrom(@BlockPosition @SqlType(value="json", nativeContainerType=Slice.class) Block left, @BlockIndex int leftPosition, @BlockPosition @SqlType(value="json", nativeContainerType=Slice.class) Block right, @BlockIndex int rightPosition) {
            int rightLength;
            if (left.isNull(leftPosition) != right.isNull(rightPosition)) {
                return true;
            }
            if (left.isNull(leftPosition)) {
                return false;
            }
            int leftLength = left.getSliceLength(leftPosition);
            if (leftLength != (rightLength = right.getSliceLength(rightPosition))) {
                return true;
            }
            return !left.equals(leftPosition, 0, right, rightPosition, 0, leftLength);
        }
    }
}

