/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;

@ScalarFunction(value="repeat", calledOnNullInput=true)
@Description(value="Repeat an element for a given number of times")
public final class RepeatFunction {
    private static final long MAX_RESULT_ENTRIES = 10000L;
    private static final long MAX_SIZE_IN_BYTES = 1000000L;

    private RepeatFunction() {
    }

    @SqlType(value="array(unknown)")
    public static Block repeat(@SqlNullable @SqlType(value="unknown") Boolean element, @SqlType(value="integer") long count) {
        RepeatFunction.checkValidCount(count);
        Failures.checkCondition(element == null, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "expect null values", new Object[0]);
        return RunLengthEncodedBlock.create((Type)UnknownType.UNKNOWN, null, (int)((int)count));
    }

    @TypeParameter(value="T")
    @SqlType(value="array(T)")
    public static Block repeat(@TypeParameter(value="T") Type type, @SqlNullable @SqlType(value="T") Object element, @SqlType(value="integer") long count) {
        RepeatFunction.checkValidCount(count);
        if (element == null) {
            return RunLengthEncodedBlock.create((Type)type, null, (int)((int)count));
        }
        Block result = RunLengthEncodedBlock.create((Type)type, (Object)element, (int)((int)count));
        Failures.checkCondition(result.getSizeInBytes() < 1000000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "result of repeat function must not take more than 1000000 bytes", new Object[0]);
        return result;
    }

    private static void checkValidCount(long count) {
        Failures.checkCondition(count <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count argument of repeat function must be less than or equal to 10000", new Object[0]);
        Failures.checkCondition(count >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count argument of repeat function must be greater than or equal to 0", new Object[0]);
    }
}

