/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlFunctionVisibility;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameterSpecialization;
import com.facebook.presto.sql.gen.lambda.LambdaFunctionInterface;
import io.airlift.slice.Slice;
import java.util.function.Supplier;

@Description(value="internal try function for desugaring TRY")
@ScalarFunction(value="$internal$try", visibility=SqlFunctionVisibility.HIDDEN, deterministic=false)
public final class TryFunction {
    private TryFunction() {
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=long.class)
    @SqlNullable
    @SqlType(value="T")
    public static Long tryLong(@SqlType(value="function(T)") TryLongLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=double.class)
    @SqlNullable
    @SqlType(value="T")
    public static Double tryDouble(@SqlType(value="function(T)") TryDoubleLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=boolean.class)
    @SqlNullable
    @SqlType(value="T")
    public static Boolean tryBoolean(@SqlType(value="function(T)") TryBooleanLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Slice.class)
    @SqlNullable
    @SqlType(value="T")
    public static Slice trySlice(@SqlType(value="function(T)") TrySliceLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    @TypeParameter(value="T")
    @TypeParameterSpecialization(name="T", nativeContainerType=Block.class)
    @SqlNullable
    @SqlType(value="T")
    public static Block tryBlock(@SqlType(value="function(T)") TryBlockLambda function) {
        try {
            return function.apply();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return null;
        }
    }

    public static <T> T evaluate(Supplier<T> supplier, T defaultValue) {
        try {
            return supplier.get();
        }
        catch (PrestoException e) {
            TryFunction.propagateIfUnhandled(e);
            return defaultValue;
        }
    }

    private static void propagateIfUnhandled(PrestoException e) throws PrestoException {
        int errorCode = e.getErrorCode().getCode();
        if (errorCode == StandardErrorCode.DIVISION_BY_ZERO.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode().getCode() || errorCode == StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode().getCode()) {
            return;
        }
        throw e;
    }

    @FunctionalInterface
    public static interface TryLongLambda
    extends LambdaFunctionInterface {
        public Long apply();
    }

    @FunctionalInterface
    public static interface TryDoubleLambda
    extends LambdaFunctionInterface {
        public Double apply();
    }

    @FunctionalInterface
    public static interface TryBooleanLambda
    extends LambdaFunctionInterface {
        public Boolean apply();
    }

    @FunctionalInterface
    public static interface TrySliceLambda
    extends LambdaFunctionInterface {
        public Slice apply();
    }

    @FunctionalInterface
    public static interface TryBlockLambda
    extends LambdaFunctionInterface {
        public Block apply();
    }
}

