/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar.annotations;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeManager;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionAndTypeManager;
import com.facebook.presto.operator.ParametricFunctionHelpers;
import com.facebook.presto.operator.ParametricImplementation;
import com.facebook.presto.operator.annotations.FunctionsParserHelper;
import com.facebook.presto.operator.annotations.ImplementationDependency;
import com.facebook.presto.operator.scalar.BuiltInScalarFunctionImplementation;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementationChoice;
import com.facebook.presto.operator.scalar.annotations.ScalarImplementationHeader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.BlockIndex;
import com.facebook.presto.spi.function.BlockPosition;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.LongVariableConstraint;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ParametricScalarImplementation
implements ParametricImplementation {
    private final Signature signature;
    private final List<Optional<Class<?>>> argumentNativeContainerTypes;
    private final Map<String, Class<?>> specializedTypeParameters;
    private final Class<?> returnNativeContainerType;
    private final List<ParametricScalarImplementationChoice> choices;

    private ParametricScalarImplementation(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, List<ParametricScalarImplementationChoice> choices, Class<?> returnContainerType) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
        this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
        this.choices = Objects.requireNonNull(choices, "choices is null");
        this.returnNativeContainerType = Objects.requireNonNull(returnContainerType, "return native container type is null");
        for (Class<?> specializedJavaType : specializedTypeParameters.values()) {
            Preconditions.checkArgument((specializedJavaType != Object.class ? 1 : 0) != 0, (Object)"specializedTypeParameter must not contain Object.class entries");
            Preconditions.checkArgument((!Primitives.isWrapperType(specializedJavaType) ? 1 : 0) != 0, (Object)"specializedTypeParameter must not contain boxed primitive types");
        }
    }

    public Optional<BuiltInScalarFunctionImplementation> specialize(Signature boundSignature, BoundVariables boundVariables, FunctionAndTypeManager functionAndTypeManager) {
        ArrayList<ScalarFunctionImplementationChoice> implementationChoices = new ArrayList<ScalarFunctionImplementationChoice>();
        for (Map.Entry<String, Class<?>> entry : this.specializedTypeParameters.entrySet()) {
            if (entry.getValue() == boundVariables.getTypeVariable(entry.getKey()).getJavaType()) continue;
            return Optional.empty();
        }
        if (this.returnNativeContainerType != Object.class && this.returnNativeContainerType != functionAndTypeManager.getType(boundSignature.getReturnType()).getJavaType()) {
            return Optional.empty();
        }
        for (int i = 0; i < boundSignature.getArgumentTypes().size(); ++i) {
            if (((TypeSignature)boundSignature.getArgumentTypes().get(i)).getBase().equals("function")) {
                if (!this.argumentNativeContainerTypes.get(i).isPresent()) continue;
                return Optional.empty();
            }
            if (!this.argumentNativeContainerTypes.get(i).isPresent()) {
                return Optional.empty();
            }
            Class argumentType = functionAndTypeManager.getType((TypeSignature)boundSignature.getArgumentTypes().get(i)).getJavaType();
            Class<?> argumentNativeContainerType = this.argumentNativeContainerTypes.get(i).get();
            if (argumentNativeContainerType == Object.class || argumentNativeContainerType == argumentType) continue;
            return Optional.empty();
        }
        for (ParametricScalarImplementationChoice choice : this.choices) {
            MethodHandle boundMethodHandle = ParametricFunctionHelpers.bindDependencies(choice.getMethodHandle(), choice.getDependencies(), boundVariables, functionAndTypeManager);
            Optional<MethodHandle> boundConstructor = choice.getConstructor().map(constructor -> {
                MethodHandle result = ParametricFunctionHelpers.bindDependencies(constructor, choice.getConstructorDependencies(), boundVariables, functionAndTypeManager);
                Failures.checkCondition(result.type().parameterList().isEmpty(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "All parameters of a constructor in a function definition class must be Dependencies. Signature: %s", boundSignature);
                return result;
            });
            implementationChoices.add(new ScalarFunctionImplementationChoice(choice.nullable, choice.argumentProperties, choice.returnPlaceConvention, boundMethodHandle.asType(ParametricScalarImplementation.javaMethodType(choice, boundSignature, functionAndTypeManager)), boundConstructor));
        }
        return Optional.of(new BuiltInScalarFunctionImplementation(implementationChoices));
    }

    @Override
    public boolean hasSpecializedTypeParameters() {
        return !this.specializedTypeParameters.isEmpty();
    }

    Map<String, Class<?>> getSpecializedTypeParameters() {
        return this.specializedTypeParameters;
    }

    @Override
    public Signature getSignature() {
        return this.signature;
    }

    List<Optional<Class<?>>> getArgumentNativeContainerTypes() {
        return this.argumentNativeContainerTypes;
    }

    @VisibleForTesting
    public List<ParametricScalarImplementationChoice> getChoices() {
        return this.choices;
    }

    Class<?> getReturnNativeContainerType() {
        return this.returnNativeContainerType;
    }

    SpecializedSignature getSpecializedSignature() {
        return new SpecializedSignature(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
    }

    private static MethodType javaMethodType(ParametricScalarImplementationChoice choice, Signature signature, TypeManager typeManager) {
        ImmutableList.Builder methodHandleParameterTypes = ImmutableList.builder();
        if (choice.getConstructor().isPresent()) {
            methodHandleParameterTypes.add(Object.class);
        }
        if (choice.hasSqlFunctionProperties()) {
            methodHandleParameterTypes.add(SqlFunctionProperties.class);
        }
        List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties = choice.getArgumentProperties();
        block10: for (int i = 0; i < argumentProperties.size(); ++i) {
            ScalarFunctionImplementationChoice.ArgumentProperty argumentProperty = argumentProperties.get(i);
            switch (argumentProperty.getArgumentType()) {
                case VALUE_TYPE: {
                    Type signatureType = typeManager.getType((TypeSignature)signature.getArgumentTypes().get(i));
                    switch (argumentProperty.getNullConvention()) {
                        case RETURN_NULL_ON_NULL: {
                            methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                            continue block10;
                        }
                        case USE_NULL_FLAG: {
                            methodHandleParameterTypes.add((Object)signatureType.getJavaType());
                            methodHandleParameterTypes.add(Boolean.TYPE);
                            continue block10;
                        }
                        case USE_BOXED_TYPE: {
                            methodHandleParameterTypes.add((Object)Primitives.wrap((Class)signatureType.getJavaType()));
                            continue block10;
                        }
                        case BLOCK_AND_POSITION: {
                            methodHandleParameterTypes.add(Block.class);
                            methodHandleParameterTypes.add(Integer.TYPE);
                            continue block10;
                        }
                    }
                    throw new UnsupportedOperationException("unknown NullConvention");
                }
                case FUNCTION_TYPE: {
                    methodHandleParameterTypes.add((Object)argumentProperty.getLambdaInterface());
                    continue block10;
                }
                default: {
                    throw new UnsupportedOperationException("unknown ArgumentType");
                }
            }
        }
        Class methodHandleReturnType = typeManager.getType(signature.getReturnType()).getJavaType();
        if (choice.isNullable()) {
            methodHandleReturnType = Primitives.wrap((Class)methodHandleReturnType);
        }
        return MethodType.methodType(methodHandleReturnType, methodHandleParameterTypes.build());
    }

    public static final class ParametricScalarImplementationChoice
    implements Comparable<ParametricScalarImplementationChoice> {
        private final boolean nullable;
        private final List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties;
        private final ScalarFunctionImplementationChoice.ReturnPlaceConvention returnPlaceConvention;
        private final MethodHandle methodHandle;
        private final Optional<MethodHandle> constructor;
        private final List<ImplementationDependency> dependencies;
        private final List<ImplementationDependency> constructorDependencies;
        private final int numberOfBlockPositionArguments;
        private final boolean hasSqlFunctionProperties;

        private ParametricScalarImplementationChoice(boolean nullable, boolean hasSqlFunctionProperties, List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties, ScalarFunctionImplementationChoice.ReturnPlaceConvention returnPlaceConvention, MethodHandle methodHandle, Optional<MethodHandle> constructor, List<ImplementationDependency> dependencies, List<ImplementationDependency> constructorDependencies) {
            this.nullable = nullable;
            this.hasSqlFunctionProperties = hasSqlFunctionProperties;
            this.argumentProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentProperties, "argumentProperties is null"));
            this.returnPlaceConvention = Objects.requireNonNull(returnPlaceConvention, "returnPlaceConvention is null");
            this.methodHandle = Objects.requireNonNull(methodHandle, "methodHandle is null");
            this.constructor = Objects.requireNonNull(constructor, "constructor is null");
            this.dependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(dependencies, "dependencies is null"));
            this.constructorDependencies = ImmutableList.copyOf((Collection)Objects.requireNonNull(constructorDependencies, "constructorDependencies is null"));
            int numberOfBlockPositionArguments = 0;
            for (ScalarFunctionImplementationChoice.ArgumentProperty argumentProperty : argumentProperties) {
                if (argumentProperty.getArgumentType() != ScalarFunctionImplementationChoice.ArgumentType.VALUE_TYPE || !argumentProperty.getNullConvention().equals((Object)ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION)) continue;
                ++numberOfBlockPositionArguments;
            }
            this.numberOfBlockPositionArguments = numberOfBlockPositionArguments;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public boolean hasSqlFunctionProperties() {
            return this.hasSqlFunctionProperties;
        }

        public MethodHandle getMethodHandle() {
            return this.methodHandle;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getDependencies() {
            return this.dependencies;
        }

        public List<ScalarFunctionImplementationChoice.ArgumentProperty> getArgumentProperties() {
            return this.argumentProperties;
        }

        public ScalarFunctionImplementationChoice.ReturnPlaceConvention getReturnPlaceConvention() {
            return this.returnPlaceConvention;
        }

        public boolean checkDependencies() {
            for (int i = 1; i < this.getDependencies().size(); ++i) {
                if (this.getDependencies().get(i).equals(this.getDependencies().get(0))) continue;
                return false;
            }
            return true;
        }

        @VisibleForTesting
        public List<ImplementationDependency> getConstructorDependencies() {
            return this.constructorDependencies;
        }

        public Optional<MethodHandle> getConstructor() {
            return this.constructor;
        }

        @Override
        public int compareTo(ParametricScalarImplementationChoice choice) {
            if (choice.numberOfBlockPositionArguments < this.numberOfBlockPositionArguments) {
                return 1;
            }
            return -1;
        }
    }

    public static final class SpecializedSignature {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecializedSignature that = (SpecializedSignature)o;
            return Objects.equals(this.signature, that.signature) && Objects.equals(this.argumentNativeContainerTypes, that.argumentNativeContainerTypes) && Objects.equals(this.specializedTypeParameters, that.specializedTypeParameters) && Objects.equals(this.returnNativeContainerType, that.returnNativeContainerType);
        }

        public int hashCode() {
            return Objects.hash(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.returnNativeContainerType);
        }

        private SpecializedSignature(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = signature;
            this.argumentNativeContainerTypes = argumentNativeContainerTypes;
            this.specializedTypeParameters = specializedTypeParameters;
            this.returnNativeContainerType = returnNativeContainerType;
        }
    }

    public static final class Parser {
        private final ScalarImplementationHeader header;
        private final boolean nullable;
        private final List<ScalarFunctionImplementationChoice.ArgumentProperty> argumentProperties = new ArrayList<ScalarFunctionImplementationChoice.ArgumentProperty>();
        private final TypeSignature returnType;
        private final List<TypeSignature> argumentTypes = new ArrayList<TypeSignature>();
        private final List<Optional<Class<?>>> argumentNativeContainerTypes = new ArrayList();
        private final MethodHandle methodHandle;
        private final List<ImplementationDependency> dependencies = new ArrayList<ImplementationDependency>();
        private final Set<TypeParameter> typeParameters = new LinkedHashSet<TypeParameter>();
        private final Set<String> literalParameters;
        private final ImmutableSet<String> typeParameterNames;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Optional<MethodHandle> constructorMethodHandle;
        private final List<ImplementationDependency> constructorDependencies = new ArrayList<ImplementationDependency>();
        private final List<LongVariableConstraint> longVariableConstraints;
        private final Class<?> returnNativeContainerType;
        private boolean hasSqlFunctionProperties;
        private final List<ParametricScalarImplementationChoice> choices = new ArrayList<ParametricScalarImplementationChoice>();

        private Parser(ScalarImplementationHeader header, Method method, Optional<Constructor<?>> constructor) {
            this.header = Objects.requireNonNull(header, "header is null");
            this.nullable = method.getAnnotation(SqlNullable.class) != null;
            Preconditions.checkArgument((this.nullable || !FunctionsParserHelper.containsLegacyNullable(method.getAnnotations()) ? 1 : 0) != 0, (String)"Method [%s] is annotated with @Nullable but not @SqlNullable", (Object)method);
            this.typeParameters.addAll(Arrays.asList((TypeParameter[])method.getAnnotationsByType(TypeParameter.class)));
            this.literalParameters = FunctionsParserHelper.parseLiteralParameters(method);
            this.typeParameterNames = (ImmutableSet)this.typeParameters.stream().map(TypeParameter::value).collect(ImmutableSet.toImmutableSet());
            SqlType returnType = method.getAnnotation(SqlType.class);
            Preconditions.checkArgument((returnType != null ? 1 : 0) != 0, (Object)String.format("Method [%s] is missing @SqlType annotation", method));
            this.returnType = TypeSignature.parseTypeSignature((String)returnType.value(), this.literalParameters);
            Class<?> actualReturnType = method.getReturnType();
            this.returnNativeContainerType = Primitives.unwrap(actualReturnType);
            if (Primitives.isWrapperType(actualReturnType)) {
                Preconditions.checkArgument((boolean)this.nullable, (String)"Method [%s] has wrapper return type %s but is missing @SqlNullable", (Object)method, (Object)actualReturnType.getSimpleName());
            } else if (actualReturnType.isPrimitive()) {
                Preconditions.checkArgument((!this.nullable ? 1 : 0) != 0, (String)"Method [%s] annotated with @SqlNullable has primitive return type %s", (Object)method, (Object)actualReturnType.getSimpleName());
            }
            this.longVariableConstraints = FunctionsParserHelper.parseLongVariableConstraints(method);
            this.specializedTypeParameters = FunctionsParserHelper.getDeclaredSpecializedTypeParameters(method, this.typeParameters);
            for (TypeParameter typeParameter : this.typeParameters) {
                Preconditions.checkArgument((boolean)typeParameter.value().matches("[A-Z][A-Z0-9]*"), (String)"Expected type parameter to only contain A-Z and 0-9 (starting with A-Z), but got %s on method [%s]", (Object)typeParameter.value(), (Object)method);
            }
            this.inferSpecialization(method, actualReturnType, returnType.value());
            this.parseArguments(method);
            this.constructorMethodHandle = this.getConstructor(method, constructor);
            this.methodHandle = this.getMethodHandle(method);
            ParametricScalarImplementationChoice choice = new ParametricScalarImplementationChoice(this.nullable, this.hasSqlFunctionProperties, this.argumentProperties, ScalarFunctionImplementationChoice.ReturnPlaceConvention.STACK, this.methodHandle, this.constructorMethodHandle, this.dependencies, this.constructorDependencies);
            this.choices.add(choice);
        }

        private void parseArguments(Method method) {
            boolean encounteredNonDependencyAnnotation = false;
            int i = 0;
            while (i < method.getParameterCount()) {
                ScalarFunctionImplementationChoice.NullConvention nullConvention2;
                Parameter parameter = method.getParameters()[i];
                Class<?> parameterType = parameter.getType();
                if (parameterType == SqlFunctionProperties.class) {
                    Failures.checkCondition(!this.hasSqlFunctionProperties, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has more than 1 SqlFunctionProperties in the parameter list", method);
                    this.hasSqlFunctionProperties = true;
                    ++i;
                    continue;
                }
                Optional<Annotation> implementationDependency = ImplementationDependency.getImplementationDependencyAnnotation(parameter);
                if (implementationDependency.isPresent()) {
                    Failures.checkCondition(!encounteredNonDependencyAnnotation, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameters annotated with Dependency annotations that appears after other parameters", method);
                    ImplementationDependency.validateImplementationDependencyAnnotation(method, implementationDependency.get(), this.typeParameterNames, this.literalParameters);
                    this.dependencies.add(ImplementationDependency.Factory.createDependency(implementationDependency.get(), this.literalParameters));
                    ++i;
                    continue;
                }
                encounteredNonDependencyAnnotation = true;
                Annotation[] annotations = parameter.getAnnotations();
                Preconditions.checkArgument((boolean)Stream.of(annotations).noneMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that does not follow a @SqlType parameter", (Object)method);
                SqlType type = Stream.of(annotations).filter(SqlType.class::isInstance).map(SqlType.class::cast).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Method [%s] is missing @SqlType annotation for parameter", method)));
                TypeSignature typeSignature = TypeSignature.parseTypeSignature((String)type.value(), this.literalParameters);
                this.argumentTypes.add(typeSignature);
                if (typeSignature.getBase().equals("function")) {
                    Failures.checkCondition(parameterType.isAnnotationPresent(FunctionalInterface.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "argument %s is marked as lambda but the function interface class is not annotated: %s", i, this.methodHandle);
                    this.argumentProperties.add(ScalarFunctionImplementationChoice.ArgumentProperty.functionTypeArgumentProperty(parameterType));
                    this.argumentNativeContainerTypes.add(Optional.empty());
                    ++i;
                    continue;
                }
                if (Stream.of(annotations).anyMatch(SqlNullable.class::isInstance)) {
                    Failures.checkCondition(!parameterType.isPrimitive(), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Method [%s] has parameter with primitive type %s annotated with @SqlNullable", method, parameterType.getSimpleName());
                    nullConvention2 = ScalarFunctionImplementationChoice.NullConvention.USE_BOXED_TYPE;
                } else if (Stream.of(annotations).anyMatch(BlockPosition.class::isInstance)) {
                    Preconditions.checkState((method.getParameterCount() > i + 1 ? 1 : 0) != 0);
                    Preconditions.checkState((parameterType == Block.class ? 1 : 0) != 0);
                    nullConvention2 = ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION;
                    Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                    Preconditions.checkState((boolean)Stream.of(parameterAnnotations).anyMatch(BlockIndex.class::isInstance));
                } else {
                    Failures.checkCondition(parameterType == Void.class || !Primitives.isWrapperType(parameterType), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "A parameter with USE_NULL_FLAG or RETURN_NULL_ON_NULL convention must not use wrapper type. Found in method [%s]", method);
                    boolean useNullFlag = false;
                    if (method.getParameterCount() > i + 1) {
                        Annotation[] parameterAnnotations = method.getParameterAnnotations()[i + 1];
                        if (Stream.of(parameterAnnotations).anyMatch(IsNull.class::isInstance)) {
                            Class<?> isNullType = method.getParameterTypes()[i + 1];
                            Preconditions.checkArgument((boolean)Stream.of(parameterAnnotations).filter(FunctionsParserHelper::isPrestoAnnotation).allMatch(IsNull.class::isInstance), (String)"Method [%s] has @IsNull parameter that has other annotations", (Object)method);
                            Preconditions.checkArgument((isNullType == Boolean.TYPE ? 1 : 0) != 0, (String)"Method [%s] has non-boolean parameter with @IsNull", (Object)method);
                            Preconditions.checkArgument((parameterType == Void.class || !Primitives.isWrapperType(parameterType) ? 1 : 0) != 0, (String)"Method [%s] uses @IsNull following a parameter with boxed primitive type: %s", (Object)method, (Object)parameterType.getSimpleName());
                            useNullFlag = true;
                        }
                    }
                    nullConvention2 = useNullFlag ? ScalarFunctionImplementationChoice.NullConvention.USE_NULL_FLAG : ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL;
                }
                if (nullConvention2 == ScalarFunctionImplementationChoice.NullConvention.BLOCK_AND_POSITION) {
                    this.argumentNativeContainerTypes.add(Optional.of(type.nativeContainerType()));
                } else {
                    this.inferSpecialization(method, parameterType, type.value());
                    Failures.checkCondition(type.nativeContainerType().equals(Object.class), (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "@SqlType can only contain an explicitly specified nativeContainerType when using @BlockPosition", new Object[0]);
                    this.argumentNativeContainerTypes.add(Optional.of(Primitives.unwrap(parameterType)));
                }
                this.argumentProperties.add(ScalarFunctionImplementationChoice.ArgumentProperty.valueTypeArgumentProperty(nullConvention2));
                i += nullConvention2.getParameterCount();
            }
            long valueArgumentsCalledOnNullCount = this.argumentProperties.stream().filter(argumentProperty -> argumentProperty.getArgumentType() == ScalarFunctionImplementationChoice.ArgumentType.VALUE_TYPE).map(ScalarFunctionImplementationChoice.ArgumentProperty::getNullConvention).filter(nullConvention -> nullConvention != ScalarFunctionImplementationChoice.NullConvention.RETURN_NULL_ON_NULL).count();
            Failures.checkCondition(this.header.getHeader().isCalledOnNullInput() && valueArgumentsCalledOnNullCount > 0L || !this.header.getHeader().isCalledOnNullInput() && valueArgumentsCalledOnNullCount == 0L, (ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, this.header.getHeader().isCalledOnNullInput() ? String.format("Method [%s] is annotated as called on null input but no argument handles null", method) : String.format("Method [%s] is annotated as not called on null input but some arguments expect null", method), new Object[0]);
        }

        private void inferSpecialization(Method method, Class<?> parameterType, String typeParameterName) {
            if (this.typeParameterNames.contains((Object)typeParameterName) && parameterType != Object.class) {
                Class<?> specialization = this.specializedTypeParameters.get(typeParameterName);
                Class nativeParameterType = Primitives.unwrap(parameterType);
                Preconditions.checkArgument((specialization == null || specialization.equals(nativeParameterType) ? 1 : 0) != 0, (String)"Method [%s] type %s has conflicting specializations %s and %s", (Object)method, (Object)typeParameterName, specialization, (Object)nativeParameterType);
                this.specializedTypeParameters.put(typeParameterName, nativeParameterType);
            }
        }

        private Optional<MethodHandle> getConstructor(Method method, Optional<Constructor<?>> optionalConstructor) {
            if (Modifier.isStatic(method.getModifiers())) {
                return Optional.empty();
            }
            Preconditions.checkArgument((boolean)optionalConstructor.isPresent(), (String)"Method [%s] is an instance method. It must be in a class annotated with @ScalarFunction, and the class is required to have a public constructor.", (Object)method);
            Constructor<?> constructor = optionalConstructor.get();
            Set constructorTypeParameters = (Set)Stream.of((TypeParameter[])constructor.getAnnotationsByType(TypeParameter.class)).collect(ImmutableSet.toImmutableSet());
            Preconditions.checkArgument((boolean)constructorTypeParameters.containsAll(this.typeParameters), (String)"Method [%s] is an instance method and requires a public constructor containing all type parameters: %s", (Object)method, this.typeParameters);
            for (int i = 0; i < constructor.getParameterCount(); ++i) {
                Annotation[] annotations = constructor.getParameterAnnotations()[i];
                Preconditions.checkArgument((boolean)FunctionsParserHelper.containsImplementationDependencyAnnotation(annotations), (String)"Constructors may only have meta parameters [%s]", constructor);
                Preconditions.checkArgument((annotations.length == 1 ? 1 : 0) != 0, (String)"Meta parameters may only have a single annotation [%s]", constructor);
                Annotation annotation = annotations[0];
                if (annotation instanceof TypeParameter) {
                    ImplementationDependency.checkTypeParameters(TypeSignature.parseTypeSignature((String)((TypeParameter)annotation).value()), this.typeParameterNames, method);
                }
                this.constructorDependencies.add(ImplementationDependency.Factory.createDependency(annotation, this.literalParameters));
            }
            MethodHandle result = Reflection.constructorMethodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, constructor);
            return Optional.of(result.asType(result.type().changeReturnType(Object.class)));
        }

        private MethodHandle getMethodHandle(Method method) {
            MethodHandle methodHandle = Reflection.methodHandle(StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, method);
            if (!Modifier.isStatic(method.getModifiers())) {
                int i;
                methodHandle = methodHandle.asType(methodHandle.type().changeParameterType(0, Object.class));
                int[] permutedIndices = new int[methodHandle.type().parameterCount()];
                permutedIndices[0] = this.dependencies.size();
                MethodType newType = methodHandle.type().changeParameterType(this.dependencies.size(), (Class<?>)methodHandle.type().parameterType(0));
                for (i = 0; i < this.dependencies.size(); ++i) {
                    permutedIndices[i + 1] = i;
                    newType = newType.changeParameterType(i, (Class<?>)methodHandle.type().parameterType(i + 1));
                }
                for (i = this.dependencies.size() + 1; i < permutedIndices.length; ++i) {
                    permutedIndices[i] = i;
                }
                methodHandle = MethodHandles.permuteArguments(methodHandle, newType, permutedIndices);
            }
            return methodHandle;
        }

        public ParametricScalarImplementation get() {
            Signature signature = new Signature(this.header.getName(), FunctionKind.SCALAR, FunctionsParserHelper.createTypeVariableConstraints(this.typeParameters, this.dependencies), this.longVariableConstraints, this.returnType, this.argumentTypes, false);
            return new ParametricScalarImplementation(signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.choices, this.returnNativeContainerType);
        }

        static ParametricScalarImplementation parseImplementation(ScalarImplementationHeader header, Method method, Optional<Constructor<?>> constructor) {
            return new Parser(header, method, constructor).get();
        }
    }

    public static final class Builder {
        private final Signature signature;
        private final List<Optional<Class<?>>> argumentNativeContainerTypes;
        private final Map<String, Class<?>> specializedTypeParameters;
        private final Class<?> returnNativeContainerType;
        private final List<ParametricScalarImplementationChoice> choices;

        public Builder(Signature signature, List<Optional<Class<?>>> argumentNativeContainerTypes, Map<String, Class<?>> specializedTypeParameters, Class<?> returnNativeContainerType) {
            this.signature = Objects.requireNonNull(signature, "signature is null");
            this.argumentNativeContainerTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(argumentNativeContainerTypes, "argumentNativeContainerTypes is null"));
            this.specializedTypeParameters = ImmutableMap.copyOf(Objects.requireNonNull(specializedTypeParameters, "specializedTypeParameters is null"));
            this.choices = new ArrayList<ParametricScalarImplementationChoice>();
            this.returnNativeContainerType = Objects.requireNonNull(returnNativeContainerType, "return native container type is null");
        }

        void addChoices(ParametricScalarImplementation implementation) {
            this.choices.addAll(implementation.choices);
        }

        public ParametricScalarImplementation build() {
            this.choices.sort(ParametricScalarImplementationChoice::compareTo);
            return new ParametricScalarImplementation(this.signature, this.argumentNativeContainerTypes, this.specializedTypeParameters, this.choices, this.returnNativeContainerType);
        }
    }
}

