/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.sql.tree.SortItem;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class FrameInfo {
    private final WindowNode.Frame.WindowType type;
    private final WindowNode.Frame.BoundType startType;
    private final int startChannel;
    private final int sortKeyChannelForStartComparison;
    private final WindowNode.Frame.BoundType endType;
    private final int endChannel;
    private final int sortKeyChannelForEndComparison;
    private final int sortKeyChannel;
    private final Optional<SortItem.Ordering> ordering;

    public FrameInfo(WindowNode.Frame.WindowType type, WindowNode.Frame.BoundType startType, Optional<Integer> startChannel, Optional<Integer> sortKeyChannelForStartComparison, WindowNode.Frame.BoundType endType, Optional<Integer> endChannel, Optional<Integer> sortKeyChannelForEndComparison, Optional<Integer> sortKeyChannel, Optional<SortItem.Ordering> ordering) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.startType = Objects.requireNonNull(startType, "startType is null");
        this.startChannel = Objects.requireNonNull(startChannel, "startChannel is null").orElse(-1);
        this.sortKeyChannelForStartComparison = Objects.requireNonNull(sortKeyChannelForStartComparison, "sortKeyChannelForStartComparison is null").orElse(-1);
        this.endType = Objects.requireNonNull(endType, "endType is null");
        this.endChannel = Objects.requireNonNull(endChannel, "endChannel is null").orElse(-1);
        this.sortKeyChannelForEndComparison = Objects.requireNonNull(sortKeyChannelForEndComparison, "sortKeyChannelForEndComparison is null").orElse(-1);
        this.sortKeyChannel = Objects.requireNonNull(sortKeyChannel, "sortKeyChannel is null").orElse(-1);
        this.ordering = Objects.requireNonNull(ordering, "ordering is null");
    }

    public WindowNode.Frame.WindowType getType() {
        return this.type;
    }

    public WindowNode.Frame.BoundType getStartType() {
        return this.startType;
    }

    public int getStartChannel() {
        return this.startChannel;
    }

    public int getSortKeyChannelForStartComparison() {
        return this.sortKeyChannelForStartComparison;
    }

    public WindowNode.Frame.BoundType getEndType() {
        return this.endType;
    }

    public int getEndChannel() {
        return this.endChannel;
    }

    public int getSortKeyChannelForEndComparison() {
        return this.sortKeyChannelForEndComparison;
    }

    public int getSortKeyChannel() {
        return this.sortKeyChannel;
    }

    public Optional<SortItem.Ordering> getOrdering() {
        return this.ordering;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.startType, this.startChannel, this.sortKeyChannelForStartComparison, this.endType, this.endChannel, this.sortKeyChannelForEndComparison, this.sortKeyChannel, this.ordering);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameInfo other = (FrameInfo)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.startType, other.startType) && Objects.equals(this.sortKeyChannelForStartComparison, other.sortKeyChannelForStartComparison) && Objects.equals(this.startChannel, other.startChannel) && Objects.equals(this.endType, other.endType) && Objects.equals(this.endChannel, other.endChannel) && Objects.equals(this.sortKeyChannelForEndComparison, other.sortKeyChannelForEndComparison) && Objects.equals(this.sortKeyChannel, other.sortKeyChannel) && Objects.equals(this.ordering, other.ordering);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("startType", (Object)this.startType).add("startChannel", this.startChannel).add("sortKeyChannelForStartComparison", this.sortKeyChannelForStartComparison).add("endType", (Object)this.endType).add("endChannel", this.endChannel).add("sortKeyChannelForEndComparison", this.sortKeyChannelForEndComparison).add("sortKeyChannel", this.sortKeyChannel).add("ordering", this.ordering).toString();
    }
}

