/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.common.PageBuilder;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.PagesIndexComparator;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.FramedWindowFunction;
import com.facebook.presto.operator.window.PagesWindowIndex;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.WindowIndex;
import com.facebook.presto.spi.plan.WindowNode;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.util.Failures;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public final class WindowPartition {
    private final PagesIndex pagesIndex;
    private final int partitionStart;
    private final int partitionEnd;
    private final int[] outputChannels;
    private final List<FramedWindowFunction> windowFunctions;
    private final Map<Integer, Range> recentRanges;
    private final PagesHashStrategy peerGroupHashStrategy;
    private final Map<WindowOperator.FrameBoundKey, PagesIndexComparator> frameBoundComparators;
    private final Map<Integer, GroupsFrame> recentGroupsFrames;
    private int peerGroupStart;
    private int peerGroupEnd;
    private int currentGroupIndex = -1;
    private int lastPeerGroup = Integer.MAX_VALUE;
    private final Function<Integer, Integer> seekGroupStart;
    private final Function<Integer, Integer> seekGroupEnd;
    private int currentPosition;

    public WindowPartition(PagesIndex pagesIndex, int partitionStart, int partitionEnd, int[] outputChannels, List<FramedWindowFunction> windowFunctions, PagesHashStrategy peerGroupHashStrategy, Map<WindowOperator.FrameBoundKey, PagesIndexComparator> frameBoundComparators) {
        this.pagesIndex = pagesIndex;
        this.partitionStart = partitionStart;
        this.partitionEnd = partitionEnd;
        this.outputChannels = outputChannels;
        this.windowFunctions = ImmutableList.copyOf(windowFunctions);
        this.peerGroupHashStrategy = peerGroupHashStrategy;
        this.frameBoundComparators = frameBoundComparators;
        PagesWindowIndex windowIndex = new PagesWindowIndex(pagesIndex, partitionStart, partitionEnd);
        for (FramedWindowFunction framedWindowFunction : windowFunctions) {
            framedWindowFunction.getFunction().reset((WindowIndex)windowIndex);
        }
        this.currentPosition = partitionStart;
        this.updatePeerGroup();
        this.recentRanges = WindowPartition.initializeRangeCache(partitionStart, partitionEnd, this.peerGroupEnd, windowFunctions);
        this.recentGroupsFrames = WindowPartition.initializeGroupsFrameCache(partitionStart, this.peerGroupEnd, windowFunctions);
        this.seekGroupStart = position -> {
            Objects.requireNonNull(position, "position is null");
            while (position > 0 && pagesIndex.positionEqualsPosition(peerGroupHashStrategy, partitionStart + position, partitionStart + position - 1)) {
                Integer n = position;
                position = position - 1;
            }
            return position;
        };
        this.seekGroupEnd = position -> {
            Objects.requireNonNull(position, "position is null");
            while (position < partitionEnd - 1 - partitionStart && pagesIndex.positionEqualsPosition(peerGroupHashStrategy, partitionStart + position, partitionStart + position + 1)) {
                Integer n = position;
                position = position + 1;
            }
            return position;
        };
    }

    private static Map<Integer, Range> initializeRangeCache(int partitionStart, int partitionEnd, int peerGroupEnd, List<FramedWindowFunction> windowFunctions) {
        HashMap<Integer, Range> ranges = new HashMap<Integer, Range>();
        Range initialPeerRange = new Range(0, peerGroupEnd - partitionStart - 1);
        Range initialUnboundedRange = new Range(0, partitionEnd - partitionStart - 1);
        for (int i = 0; i < windowFunctions.size(); ++i) {
            FrameInfo frame = windowFunctions.get(i).getFrame();
            if (frame.getType() != WindowNode.Frame.WindowType.RANGE) continue;
            if (frame.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING) {
                ranges.put(i, initialUnboundedRange);
                continue;
            }
            ranges.put(i, initialPeerRange);
        }
        return ranges;
    }

    private static Map<Integer, GroupsFrame> initializeGroupsFrameCache(int partitionStart, int peerGroupEnd, List<FramedWindowFunction> windowFunctions) {
        HashMap<Integer, GroupsFrame> frames = new HashMap<Integer, GroupsFrame>();
        GroupsFrame initialPeerFrame = new GroupsFrame(0, 0, peerGroupEnd - partitionStart - 1, 0);
        for (int i = 0; i < windowFunctions.size(); ++i) {
            FrameInfo frame = windowFunctions.get(i).getFrame();
            if (frame.getType() != WindowNode.Frame.WindowType.GROUPS) continue;
            frames.put(i, initialPeerFrame);
        }
        return frames;
    }

    public int getPartitionStart() {
        return this.partitionStart;
    }

    public int getPartitionEnd() {
        return this.partitionEnd;
    }

    public boolean hasNext() {
        return this.currentPosition < this.partitionEnd;
    }

    public void processNextRow(PageBuilder pageBuilder) {
        int channel;
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more rows in partition");
        pageBuilder.declarePosition();
        for (channel = 0; channel < this.outputChannels.length; ++channel) {
            this.pagesIndex.appendTo(this.outputChannels[channel], this.currentPosition, pageBuilder.getBlockBuilder(channel));
        }
        if (this.currentPosition == this.peerGroupEnd) {
            this.updatePeerGroup();
        }
        for (int i = 0; i < this.windowFunctions.size(); ++i) {
            FramedWindowFunction framedFunction = this.windowFunctions.get(i);
            Range range = this.getFrameRange(framedFunction.getFrame(), i);
            framedFunction.getFunction().processRow(pageBuilder.getBlockBuilder(channel), this.peerGroupStart - this.partitionStart, this.peerGroupEnd - this.partitionStart - 1, range.getStart(), range.getEnd());
            ++channel;
        }
        ++this.currentPosition;
    }

    private void updatePeerGroup() {
        ++this.currentGroupIndex;
        this.peerGroupStart = this.currentPosition;
        this.peerGroupEnd = this.peerGroupStart + 1;
        while (this.peerGroupEnd < this.partitionEnd && this.pagesIndex.positionEqualsPosition(this.peerGroupHashStrategy, this.peerGroupStart, this.peerGroupEnd)) {
            ++this.peerGroupEnd;
        }
    }

    private Range getFrameRange(FrameInfo frameInfo, int functionIndex) {
        switch (frameInfo.getType()) {
            case RANGE: {
                Range range = this.getFrameRange(frameInfo, this.recentRanges.get(functionIndex), this.frameBoundComparators.get(new WindowOperator.FrameBoundKey(functionIndex, WindowOperator.FrameBoundKey.Type.START)), this.frameBoundComparators.get(new WindowOperator.FrameBoundKey(functionIndex, WindowOperator.FrameBoundKey.Type.END)));
                if (this.emptyFrame(range)) {
                    this.recentRanges.put(functionIndex, this.nearestValidFrame(range));
                    return new Range(-1, -1);
                }
                this.recentRanges.put(functionIndex, range);
                return range;
            }
            case ROWS: {
                return this.getFrameRange(frameInfo);
            }
            case GROUPS: {
                GroupsFrame frame = this.getFrameRange(frameInfo, this.recentGroupsFrames.get(functionIndex));
                if (this.emptyFrame(frame.getRange())) {
                    this.recentGroupsFrames.put(functionIndex, this.nearestValidFrame(frame));
                    return new Range(-1, -1);
                }
                this.recentGroupsFrames.put(functionIndex, frame);
                return frame.getRange();
            }
        }
        throw new IllegalArgumentException("Unsupported frame type: " + frameInfo.getType());
    }

    private Range getFrameRange(FrameInfo frameInfo) {
        int rowPosition = this.currentPosition - this.partitionStart;
        int endPosition = this.partitionEnd - this.partitionStart - 1;
        if (this.emptyFrame(frameInfo, rowPosition, endPosition)) {
            return new Range(-1, -1);
        }
        int frameStart = frameInfo.getStartType() == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING ? 0 : (frameInfo.getStartType() == WindowNode.Frame.BoundType.PRECEDING ? WindowPartition.preceding(rowPosition, this.getStartValue(frameInfo)) : (frameInfo.getStartType() == WindowNode.Frame.BoundType.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getStartValue(frameInfo)) : rowPosition));
        int frameEnd = frameInfo.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING ? endPosition : (frameInfo.getEndType() == WindowNode.Frame.BoundType.PRECEDING ? WindowPartition.preceding(rowPosition, this.getEndValue(frameInfo)) : (frameInfo.getEndType() == WindowNode.Frame.BoundType.FOLLOWING ? WindowPartition.following(rowPosition, endPosition, this.getEndValue(frameInfo)) : rowPosition));
        return new Range(frameStart, frameEnd);
    }

    private Range getFrameRange(FrameInfo frameInfo, Range recentRange, PagesIndexComparator startComparator, PagesIndexComparator endComparator) {
        int frameEnd;
        int frameStart;
        if (frameInfo.getStartType() == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING && frameInfo.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING) {
            return new Range(0, this.partitionEnd - this.partitionStart - 1);
        }
        if (frameInfo.getStartType() == WindowNode.Frame.BoundType.CURRENT_ROW && frameInfo.getEndType() == WindowNode.Frame.BoundType.CURRENT_ROW || frameInfo.getStartType() == WindowNode.Frame.BoundType.CURRENT_ROW && frameInfo.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING || frameInfo.getStartType() == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING && frameInfo.getEndType() == WindowNode.Frame.BoundType.CURRENT_ROW) {
            if (this.currentPosition == this.partitionStart || this.pagesIndex.positionEqualsPosition(this.peerGroupHashStrategy, this.currentPosition - 1, this.currentPosition)) {
                return recentRange;
            }
            return new Range(frameInfo.getStartType() == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING ? 0 : this.peerGroupStart - this.partitionStart, frameInfo.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING ? this.partitionEnd - this.partitionStart - 1 : this.peerGroupEnd - this.partitionStart - 1);
        }
        if (this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.currentPosition)) {
            return new Range(frameInfo.getStartType() == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING ? 0 : this.peerGroupStart - this.partitionStart, frameInfo.getEndType() == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING ? this.partitionEnd - this.partitionStart - 1 : this.peerGroupEnd - this.partitionStart - 1);
        }
        switch (frameInfo.getStartType()) {
            case UNBOUNDED_PRECEDING: {
                frameStart = 0;
                break;
            }
            case CURRENT_ROW: {
                frameStart = this.peerGroupStart - this.partitionStart;
                break;
            }
            case PRECEDING: {
                frameStart = this.getFrameStartPreceding(recentRange.getStart(), frameInfo, startComparator);
                break;
            }
            case FOLLOWING: {
                frameStart = this.getFrameStartFollowing(recentRange.getStart(), frameInfo, startComparator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported frame start type: " + frameInfo.getStartType());
            }
        }
        switch (frameInfo.getEndType()) {
            case UNBOUNDED_FOLLOWING: {
                frameEnd = this.partitionEnd - this.partitionStart - 1;
                break;
            }
            case CURRENT_ROW: {
                frameEnd = this.peerGroupEnd - this.partitionStart - 1;
                break;
            }
            case PRECEDING: {
                frameEnd = this.getFrameEndPreceding(recentRange.getEnd(), frameInfo, endComparator);
                break;
            }
            case FOLLOWING: {
                frameEnd = this.getFrameEndFollowing(recentRange.getEnd(), frameInfo, endComparator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported frame end type: " + frameInfo.getStartType());
            }
        }
        return new Range(frameStart, frameEnd);
    }

    private int getFrameStartPreceding(int recent, FrameInfo frameInfo, PagesIndexComparator comparator) {
        int sortKeyChannel = frameInfo.getSortKeyChannelForStartComparison();
        SortItem.Ordering ordering = frameInfo.getOrdering().get();
        if (this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.partitionStart + recent)) {
            return this.currentPosition - this.partitionStart;
        }
        return this.seek(comparator, sortKeyChannel, recent, -1, ordering == SortItem.Ordering.DESCENDING, 0, p -> false);
    }

    private int getFrameStartFollowing(int recent, FrameInfo frameInfo, PagesIndexComparator comparator) {
        int sortKeyChannel = frameInfo.getSortKeyChannelForStartComparison();
        SortItem.Ordering ordering = frameInfo.getOrdering().get();
        int position = recent;
        if (recent == 0 && this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.partitionStart)) {
            position = this.currentPosition - this.partitionStart;
        }
        while (this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.partitionStart + position)) {
            --position;
        }
        return this.seek(comparator, sortKeyChannel, position, -1, ordering == SortItem.Ordering.DESCENDING, 0, p -> p >= this.partitionEnd - this.partitionStart || this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + p));
    }

    private int getFrameEndPreceding(int recent, FrameInfo frameInfo, PagesIndexComparator comparator) {
        int sortKeyChannel = frameInfo.getSortKeyChannelForEndComparison();
        SortItem.Ordering ordering = frameInfo.getOrdering().get();
        int position = recent;
        while (this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.partitionStart + position)) {
            ++position;
        }
        return this.seek(comparator, sortKeyChannel, position, 1, ordering == SortItem.Ordering.ASCENDING, this.partitionEnd - 1 - this.partitionStart, p -> p < 0 || this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + p));
    }

    private int getFrameEndFollowing(int recent, FrameInfo frameInfo, PagesIndexComparator comparator) {
        SortItem.Ordering ordering = frameInfo.getOrdering().get();
        int sortKeyChannel = frameInfo.getSortKeyChannelForEndComparison();
        int position = recent;
        if (this.pagesIndex.isNull(frameInfo.getSortKeyChannel(), this.partitionStart + recent)) {
            position = this.currentPosition - this.partitionStart;
        }
        return this.seek(comparator, sortKeyChannel, position, 1, ordering == SortItem.Ordering.ASCENDING, this.partitionEnd - 1 - this.partitionStart, p -> false);
    }

    private int compare(PagesIndexComparator comparator, int left, int right, boolean reverse) {
        int result = comparator.compareTo(this.pagesIndex, left, right);
        if (reverse) {
            return -result;
        }
        return result;
    }

    private int seek(PagesIndexComparator comparator, int sortKeyChannel, int position, int step, boolean reverse, int limit, Predicate<Integer> bound) {
        int newComparison;
        int comparison = this.compare(comparator, this.partitionStart + position, this.currentPosition, reverse);
        while (comparison < 0) {
            if (bound.test(position -= step)) {
                return position;
            }
            comparison = this.compare(comparator, this.partitionStart + position, this.currentPosition, reverse);
        }
        while (position != limit && !this.pagesIndex.isNull(sortKeyChannel, this.partitionStart + position + step) && (newComparison = this.compare(comparator, this.partitionStart + position + step, this.currentPosition, reverse)) >= 0) {
            position += step;
        }
        return position;
    }

    private boolean emptyFrame(Range range) {
        return range.getStart() > range.getEnd() || range.getStart() >= this.partitionEnd - this.partitionStart || range.getEnd() < 0;
    }

    private Range nearestValidFrame(Range range) {
        return new Range(Math.min(this.partitionEnd - this.partitionStart - 1, range.getStart()), Math.max(0, range.getEnd()));
    }

    private boolean emptyFrame(FrameInfo frameInfo, int rowPosition, int endPosition) {
        WindowNode.Frame.BoundType startType = frameInfo.getStartType();
        WindowNode.Frame.BoundType endType = frameInfo.getEndType();
        int positions = endPosition - rowPosition;
        if (startType == WindowNode.Frame.BoundType.UNBOUNDED_PRECEDING && endType == WindowNode.Frame.BoundType.PRECEDING) {
            return this.getEndValue(frameInfo) > (long)rowPosition;
        }
        if (startType == WindowNode.Frame.BoundType.FOLLOWING && endType == WindowNode.Frame.BoundType.UNBOUNDED_FOLLOWING) {
            return this.getStartValue(frameInfo) > (long)positions;
        }
        if (startType != endType) {
            return false;
        }
        WindowNode.Frame.BoundType type = frameInfo.getStartType();
        if (type != WindowNode.Frame.BoundType.PRECEDING && type != WindowNode.Frame.BoundType.FOLLOWING) {
            return false;
        }
        long start = this.getStartValue(frameInfo);
        long end = this.getEndValue(frameInfo);
        if (type == WindowNode.Frame.BoundType.PRECEDING) {
            return start < end || start > (long)rowPosition && end > (long)rowPosition;
        }
        return start > end || start > (long)positions && end > (long)positions;
    }

    private static int preceding(int rowPosition, long value) {
        if (value > (long)rowPosition) {
            return 0;
        }
        return Math.toIntExact((long)rowPosition - value);
    }

    private static int following(int rowPosition, int endPosition, long value) {
        if (value > (long)(endPosition - rowPosition)) {
            return endPosition;
        }
        return Math.toIntExact((long)rowPosition + value);
    }

    private long getStartValue(FrameInfo frameInfo) {
        return this.getFrameValue(frameInfo.getStartChannel(), "starting");
    }

    private long getEndValue(FrameInfo frameInfo) {
        return this.getFrameValue(frameInfo.getEndChannel(), "ending");
    }

    private long getFrameValue(int channel, String type) {
        Failures.checkCondition(!this.pagesIndex.isNull(channel, this.currentPosition), (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be null", type);
        long value = this.pagesIndex.getLong(channel, this.currentPosition);
        Failures.checkCondition(value >= 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_WINDOW_FRAME, "Window frame %s offset must not be negative", value);
        return value;
    }

    private GroupsFrame getFrameRange(FrameInfo frameInfo, GroupsFrame recentFrame) {
        int end;
        int start;
        WindowNode.Frame.BoundType startType = frameInfo.getStartType();
        WindowNode.Frame.BoundType endType = frameInfo.getEndType();
        int startGroupIndex = GroupsFrame.ignoreIndex();
        int endGroupIndex = GroupsFrame.ignoreIndex();
        switch (startType) {
            case UNBOUNDED_PRECEDING: {
                start = 0;
                break;
            }
            case CURRENT_ROW: {
                start = this.peerGroupStart - this.partitionStart;
                break;
            }
            case PRECEDING: {
                PositionAndGroup frameStart = this.seek(Math.toIntExact((long)this.currentGroupIndex - this.getStartValue(frameInfo)), recentFrame.getStart(), recentFrame.getStartGroupIndex(), this.seekGroupStart, lastGroup -> new PositionAndGroup(0, 0));
                start = frameStart.getPosition();
                startGroupIndex = frameStart.getGroup();
                break;
            }
            case FOLLOWING: {
                PositionAndGroup frameStart = this.seek(Math.toIntExact((long)this.currentGroupIndex + this.getStartValue(frameInfo)), recentFrame.getStart(), recentFrame.getStartGroupIndex(), this.seekGroupStart, lastGroup -> new PositionAndGroup(this.partitionEnd - this.partitionStart, GroupsFrame.ignoreIndex()));
                start = frameStart.getPosition();
                startGroupIndex = frameStart.getGroup();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame start type: " + startType);
            }
        }
        switch (endType) {
            case UNBOUNDED_FOLLOWING: {
                end = this.partitionEnd - this.partitionStart - 1;
                break;
            }
            case CURRENT_ROW: {
                end = this.peerGroupEnd - this.partitionStart - 1;
                break;
            }
            case PRECEDING: {
                PositionAndGroup frameEnd = this.seek(Math.toIntExact((long)this.currentGroupIndex - this.getEndValue(frameInfo)), recentFrame.getEnd(), recentFrame.getEndGroupIndex(), this.seekGroupEnd, lastGroup -> new PositionAndGroup(-1, GroupsFrame.ignoreIndex()));
                end = frameEnd.getPosition();
                endGroupIndex = frameEnd.getGroup();
                break;
            }
            case FOLLOWING: {
                PositionAndGroup frameEnd = this.seek(Math.toIntExact((long)this.currentGroupIndex + this.getEndValue(frameInfo)), recentFrame.getEnd(), recentFrame.getEndGroupIndex(), this.seekGroupEnd, lastGroup -> new PositionAndGroup(this.partitionEnd - this.partitionStart - 1, this.lastPeerGroup));
                end = frameEnd.getPosition();
                endGroupIndex = frameEnd.getGroup();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported frame end type: " + endType);
            }
        }
        return new GroupsFrame(start, startGroupIndex, end, endGroupIndex);
    }

    private PositionAndGroup seek(int groupIndex, int recentPosition, int recentGroupIndex, Function<Integer, Integer> seekPositionWithinGroup, EdgeResultProvider edgeResult) {
        if (groupIndex < 0 || groupIndex > this.lastPeerGroup) {
            return edgeResult.get(this.lastPeerGroup);
        }
        while (recentGroupIndex > groupIndex) {
            recentPosition = this.seekGroupStart.apply(recentPosition);
            --recentPosition;
            --recentGroupIndex;
        }
        while (recentGroupIndex < groupIndex) {
            if ((recentPosition = this.seekGroupEnd.apply(recentPosition).intValue()) == this.partitionEnd - this.partitionStart - 1) {
                this.lastPeerGroup = recentGroupIndex;
                return edgeResult.get(this.lastPeerGroup);
            }
            ++recentPosition;
            ++recentGroupIndex;
        }
        if ((recentPosition = seekPositionWithinGroup.apply(recentPosition).intValue()) == this.partitionEnd - this.partitionStart - 1) {
            this.lastPeerGroup = recentGroupIndex;
        }
        return new PositionAndGroup(recentPosition, recentGroupIndex);
    }

    private GroupsFrame nearestValidFrame(GroupsFrame frame) {
        if (frame.getStart() > this.partitionEnd - this.partitionStart - 1) {
            return frame.withStart(this.partitionEnd - this.partitionStart - 1, this.lastPeerGroup);
        }
        if (frame.getEnd() < 0) {
            return frame.withEnd(0, 0);
        }
        return frame;
    }

    private static class Range {
        private final int start;
        private final int end;

        Range(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    private static class GroupsFrame {
        private static final int IGNORE_GROUP_INDEX = -1;
        private final int start;
        private final int startGroupIndex;
        private final int end;
        private final int endGroupIndex;

        public GroupsFrame(int start, int startGroupIndex, int end, int endGroupIndex) {
            this.start = start;
            this.startGroupIndex = startGroupIndex;
            this.end = end;
            this.endGroupIndex = endGroupIndex;
        }

        public static int ignoreIndex() {
            return -1;
        }

        public GroupsFrame withStart(int start, int startGroupIndex) {
            return new GroupsFrame(start, startGroupIndex, this.end, this.endGroupIndex);
        }

        public GroupsFrame withEnd(int end, int endGroupIndex) {
            return new GroupsFrame(this.start, this.startGroupIndex, end, endGroupIndex);
        }

        public int getStart() {
            return this.start;
        }

        public int getStartGroupIndex() {
            Preconditions.checkState((this.startGroupIndex != -1 ? 1 : 0) != 0, (Object)"accessing ignored group index");
            return this.startGroupIndex;
        }

        public int getEnd() {
            return this.end;
        }

        public int getEndGroupIndex() {
            Preconditions.checkState((this.endGroupIndex != -1 ? 1 : 0) != 0, (Object)"accessing ignored group index");
            return this.endGroupIndex;
        }

        public Range getRange() {
            return new Range(this.start, this.end);
        }
    }

    private static interface EdgeResultProvider {
        public PositionAndGroup get(int var1);
    }

    private static class PositionAndGroup {
        private final int position;
        private final int group;

        public PositionAndGroup(int position, int group) {
            this.position = position;
            this.group = group;
        }

        public int getPosition() {
            return this.position;
        }

        public int getGroup() {
            return this.group;
        }
    }
}

