/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.airlift.node.NodeInfo;
import com.facebook.presto.ClientRequestFilterManager;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingManager;
import com.facebook.presto.common.type.ParametricType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.connector.ConnectorManager;
import com.facebook.presto.cost.HistoryBasedPlanStatisticsManager;
import com.facebook.presto.dispatcher.QueryPrerequisitesManager;
import com.facebook.presto.eventlistener.EventListenerManager;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.server.NodeStatusNotificationManager;
import com.facebook.presto.server.PluginInstaller;
import com.facebook.presto.server.PluginManagerConfig;
import com.facebook.presto.server.PluginManagerUtil;
import com.facebook.presto.server.SessionPropertyDefaults;
import com.facebook.presto.server.security.PasswordAuthenticatorManager;
import com.facebook.presto.server.security.PrestoAuthenticatorManager;
import com.facebook.presto.spi.ClientRequestFilterFactory;
import com.facebook.presto.spi.CoordinatorPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.analyzer.AnalyzerProvider;
import com.facebook.presto.spi.analyzer.QueryPreparerProvider;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.eventlistener.EventListenerFactory;
import com.facebook.presto.spi.function.FunctionNamespaceManagerFactory;
import com.facebook.presto.spi.nodestatus.NodeStatusNotificationProviderFactory;
import com.facebook.presto.spi.plan.PlanCheckerProviderFactory;
import com.facebook.presto.spi.prerequisites.QueryPrerequisitesFactory;
import com.facebook.presto.spi.resourceGroups.ResourceGroupConfigurationManagerFactory;
import com.facebook.presto.spi.security.PasswordAuthenticatorFactory;
import com.facebook.presto.spi.security.PrestoAuthenticatorFactory;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.spi.session.SessionPropertyConfigurationManagerFactory;
import com.facebook.presto.spi.session.WorkerSessionPropertyProviderFactory;
import com.facebook.presto.spi.sql.planner.ExpressionOptimizerFactory;
import com.facebook.presto.spi.statistics.HistoryBasedPlanStatisticsProvider;
import com.facebook.presto.spi.storage.TempStorageFactory;
import com.facebook.presto.spi.tracing.TracerProvider;
import com.facebook.presto.spi.ttl.ClusterTtlProviderFactory;
import com.facebook.presto.spi.ttl.NodeTtlFetcherFactory;
import com.facebook.presto.spi.type.TypeManagerFactory;
import com.facebook.presto.sql.analyzer.AnalyzerProviderManager;
import com.facebook.presto.sql.analyzer.QueryPreparerProviderManager;
import com.facebook.presto.sql.expressions.ExpressionOptimizerManager;
import com.facebook.presto.sql.planner.sanity.PlanCheckerProviderManager;
import com.facebook.presto.storage.TempStorageManager;
import com.facebook.presto.tracing.TracerProviderManager;
import com.facebook.presto.ttl.clusterttlprovidermanagers.ClusterTtlProviderManager;
import com.facebook.presto.ttl.nodettlfetchermanagers.NodeTtlFetcherManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.resolver.ArtifactResolver;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;

@ThreadSafe
public class PluginManager {
    private static final String COORDINATOR_PLUGIN_SERVICES_FILE = "META-INF/services/" + CoordinatorPlugin.class.getName();
    private static final String PLUGIN_SERVICES_FILE = "META-INF/services/" + Plugin.class.getName();
    private static final Logger log = Logger.get(PluginManager.class);
    private final ConnectorManager connectorManager;
    private final Metadata metadata;
    private final ResourceGroupManager<?> resourceGroupManager;
    private final AccessControlManager accessControlManager;
    private final PasswordAuthenticatorManager passwordAuthenticatorManager;
    private final PrestoAuthenticatorManager prestoAuthenticatorManager;
    private final EventListenerManager eventListenerManager;
    private final BlockEncodingManager blockEncodingManager;
    private final TempStorageManager tempStorageManager;
    private final SessionPropertyDefaults sessionPropertyDefaults;
    private final QueryPrerequisitesManager queryPrerequisitesManager;
    private final NodeTtlFetcherManager nodeTtlFetcherManager;
    private final ClusterTtlProviderManager clusterTtlProviderManager;
    private final ArtifactResolver resolver;
    private final File installedPluginsDir;
    private final List<String> plugins;
    private final AtomicBoolean pluginsLoading = new AtomicBoolean();
    private final AtomicBoolean pluginsLoaded = new AtomicBoolean();
    private final ImmutableSet<String> disabledConnectors;
    private final HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager;
    private final TracerProviderManager tracerProviderManager;
    private final AnalyzerProviderManager analyzerProviderManager;
    private final QueryPreparerProviderManager queryPreparerProviderManager;
    private final NodeStatusNotificationManager nodeStatusNotificationManager;
    private final ClientRequestFilterManager clientRequestFilterManager;
    private final PlanCheckerProviderManager planCheckerProviderManager;
    private final ExpressionOptimizerManager expressionOptimizerManager;
    private final PluginInstaller pluginInstaller;

    @Inject
    public PluginManager(NodeInfo nodeInfo, PluginManagerConfig config, ConnectorManager connectorManager, Metadata metadata, ResourceGroupManager<?> resourceGroupManager, AnalyzerProviderManager analyzerProviderManager, QueryPreparerProviderManager queryPreparerProviderManager, AccessControlManager accessControlManager, PasswordAuthenticatorManager passwordAuthenticatorManager, PrestoAuthenticatorManager prestoAuthenticatorManager, EventListenerManager eventListenerManager, BlockEncodingManager blockEncodingManager, TempStorageManager tempStorageManager, QueryPrerequisitesManager queryPrerequisitesManager, SessionPropertyDefaults sessionPropertyDefaults, NodeTtlFetcherManager nodeTtlFetcherManager, ClusterTtlProviderManager clusterTtlProviderManager, HistoryBasedPlanStatisticsManager historyBasedPlanStatisticsManager, TracerProviderManager tracerProviderManager, NodeStatusNotificationManager nodeStatusNotificationManager, ClientRequestFilterManager clientRequestFilterManager, PlanCheckerProviderManager planCheckerProviderManager, ExpressionOptimizerManager expressionOptimizerManager) {
        Objects.requireNonNull(nodeInfo, "nodeInfo is null");
        Objects.requireNonNull(config, "config is null");
        this.installedPluginsDir = config.getInstalledPluginsDir();
        this.plugins = config.getPlugins() == null ? ImmutableList.of() : ImmutableList.copyOf(config.getPlugins());
        this.resolver = new ArtifactResolver(config.getMavenLocalRepository(), config.getMavenRemoteRepository());
        this.connectorManager = Objects.requireNonNull(connectorManager, "connectorManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.accessControlManager = Objects.requireNonNull(accessControlManager, "accessControlManager is null");
        this.passwordAuthenticatorManager = Objects.requireNonNull(passwordAuthenticatorManager, "passwordAuthenticatorManager is null");
        this.prestoAuthenticatorManager = Objects.requireNonNull(prestoAuthenticatorManager, "prestoAuthenticatorManager is null");
        this.eventListenerManager = Objects.requireNonNull(eventListenerManager, "eventListenerManager is null");
        this.blockEncodingManager = Objects.requireNonNull(blockEncodingManager, "blockEncodingManager is null");
        this.tempStorageManager = Objects.requireNonNull(tempStorageManager, "tempStorageManager is null");
        this.queryPrerequisitesManager = Objects.requireNonNull(queryPrerequisitesManager, "queryPrerequisitesManager is null");
        this.sessionPropertyDefaults = Objects.requireNonNull(sessionPropertyDefaults, "sessionPropertyDefaults is null");
        this.nodeTtlFetcherManager = Objects.requireNonNull(nodeTtlFetcherManager, "nodeTtlFetcherManager is null");
        this.clusterTtlProviderManager = Objects.requireNonNull(clusterTtlProviderManager, "clusterTtlProviderManager is null");
        this.disabledConnectors = Objects.requireNonNull(config.getDisabledConnectors(), "disabledConnectors is null");
        this.historyBasedPlanStatisticsManager = Objects.requireNonNull(historyBasedPlanStatisticsManager, "historyBasedPlanStatisticsManager is null");
        this.tracerProviderManager = Objects.requireNonNull(tracerProviderManager, "tracerProviderManager is null");
        this.analyzerProviderManager = Objects.requireNonNull(analyzerProviderManager, "analyzerProviderManager is null");
        this.queryPreparerProviderManager = Objects.requireNonNull(queryPreparerProviderManager, "queryPreparerProviderManager is null");
        this.nodeStatusNotificationManager = Objects.requireNonNull(nodeStatusNotificationManager, "nodeStatusNotificationManager is null");
        this.clientRequestFilterManager = Objects.requireNonNull(clientRequestFilterManager, "clientRequestFilterManager is null");
        this.planCheckerProviderManager = Objects.requireNonNull(planCheckerProviderManager, "planCheckerProviderManager is null");
        this.expressionOptimizerManager = Objects.requireNonNull(expressionOptimizerManager, "expressionManager is null");
        this.pluginInstaller = new MainPluginInstaller(this);
    }

    public void loadPlugins() throws Exception {
        PluginManagerUtil.loadPlugins(this.pluginsLoading, this.pluginsLoaded, this.installedPluginsDir, this.plugins, this.metadata, this.resolver, PluginManagerUtil.SPI_PACKAGES, COORDINATOR_PLUGIN_SERVICES_FILE, PLUGIN_SERVICES_FILE, this.pluginInstaller, this.getClass().getClassLoader());
    }

    public void installPlugin(Plugin plugin) {
        for (BlockEncoding blockEncoding : plugin.getBlockEncodings()) {
            log.info("Registering block encoding %s", new Object[]{blockEncoding.getName()});
            this.blockEncodingManager.addBlockEncoding(blockEncoding);
        }
        for (Type type : plugin.getTypes()) {
            log.info("Registering type %s", new Object[]{type.getTypeSignature()});
            this.metadata.getFunctionAndTypeManager().addType(type);
        }
        for (ParametricType parametricType : plugin.getParametricTypes()) {
            log.info("Registering parametric type %s", new Object[]{parametricType.getName()});
            this.metadata.getFunctionAndTypeManager().addParametricType(parametricType);
        }
        for (ConnectorFactory connectorFactory : plugin.getConnectorFactories()) {
            if (this.disabledConnectors.contains((Object)connectorFactory.getName())) {
                log.info("Skipping disabled connector %s", new Object[]{connectorFactory.getName()});
                continue;
            }
            log.info("Registering connector %s", new Object[]{connectorFactory.getName()});
            this.connectorManager.addConnectorFactory(connectorFactory);
        }
        for (Class functionClass : plugin.getFunctions()) {
            log.info("Registering functions from %s", new Object[]{functionClass.getName()});
            this.metadata.registerBuiltInFunctions(FunctionExtractor.extractFunctions(functionClass));
        }
        for (FunctionNamespaceManagerFactory functionNamespaceManagerFactory : plugin.getFunctionNamespaceManagerFactories()) {
            log.info("Registering function namespace manager %s", new Object[]{functionNamespaceManagerFactory.getName()});
            this.metadata.getFunctionAndTypeManager().addFunctionNamespaceFactory(functionNamespaceManagerFactory);
        }
        for (SessionPropertyConfigurationManagerFactory sessionConfigFactory : plugin.getSessionPropertyConfigurationManagerFactories()) {
            log.info("Registering session property configuration manager %s", new Object[]{sessionConfigFactory.getName()});
            this.sessionPropertyDefaults.addConfigurationManagerFactory(sessionConfigFactory);
        }
        for (ResourceGroupConfigurationManagerFactory configurationManagerFactory : plugin.getResourceGroupConfigurationManagerFactories()) {
            log.info("Registering resource group configuration manager %s", new Object[]{configurationManagerFactory.getName()});
            this.resourceGroupManager.addConfigurationManagerFactory(configurationManagerFactory);
        }
        for (SystemAccessControlFactory accessControlFactory : plugin.getSystemAccessControlFactories()) {
            log.info("Registering system access control %s", new Object[]{accessControlFactory.getName()});
            this.accessControlManager.addSystemAccessControlFactory(accessControlFactory);
        }
        for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getPasswordAuthenticatorFactories()) {
            log.info("Registering password authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.passwordAuthenticatorManager.addPasswordAuthenticatorFactory(authenticatorFactory);
        }
        for (PasswordAuthenticatorFactory authenticatorFactory : plugin.getPrestoAuthenticatorFactories()) {
            log.info("Registering presto authenticator %s", new Object[]{authenticatorFactory.getName()});
            this.prestoAuthenticatorManager.addPrestoAuthenticatorFactory((PrestoAuthenticatorFactory)authenticatorFactory);
        }
        for (EventListenerFactory eventListenerFactory : plugin.getEventListenerFactories()) {
            log.info("Registering event listener %s", new Object[]{eventListenerFactory.getName()});
            this.eventListenerManager.addEventListenerFactory(eventListenerFactory);
        }
        for (TempStorageFactory tempStorageFactory : plugin.getTempStorageFactories()) {
            log.info("Registering temp storage %s", new Object[]{tempStorageFactory.getName()});
            this.tempStorageManager.addTempStorageFactory(tempStorageFactory);
        }
        for (QueryPrerequisitesFactory queryPrerequisitesFactory : plugin.getQueryPrerequisitesFactories()) {
            log.info("Registering query prerequisite factory %s", new Object[]{queryPrerequisitesFactory.getName()});
            this.queryPrerequisitesManager.addQueryPrerequisitesFactory(queryPrerequisitesFactory);
        }
        for (NodeTtlFetcherFactory nodeTtlFetcherFactory : plugin.getNodeTtlFetcherFactories()) {
            log.info("Registering Ttl fetcher factory %s", new Object[]{nodeTtlFetcherFactory.getName()});
            this.nodeTtlFetcherManager.addNodeTtlFetcherFactory(nodeTtlFetcherFactory);
        }
        for (ClusterTtlProviderFactory clusterTtlProviderFactory : plugin.getClusterTtlProviderFactories()) {
            log.info("Registering Cluster Ttl provider factory %s", new Object[]{clusterTtlProviderFactory.getName()});
            this.clusterTtlProviderManager.addClusterTtlProviderFactory(clusterTtlProviderFactory);
        }
        for (HistoryBasedPlanStatisticsProvider historyBasedPlanStatisticsProvider : plugin.getHistoryBasedPlanStatisticsProviders()) {
            log.info("Registering plan statistics provider %s", new Object[]{historyBasedPlanStatisticsProvider.getName()});
            this.historyBasedPlanStatisticsManager.addHistoryBasedPlanStatisticsProviderFactory(historyBasedPlanStatisticsProvider);
        }
        for (TracerProvider tracerProvider : plugin.getTracerProviders()) {
            log.info("Registering tracer provider %s", new Object[]{tracerProvider.getName()});
            this.tracerProviderManager.addTracerProviderFactory(tracerProvider);
        }
        for (AnalyzerProvider analyzerProvider : plugin.getAnalyzerProviders()) {
            log.info("Registering analyzer provider %s", new Object[]{analyzerProvider.getType()});
            this.analyzerProviderManager.addAnalyzerProvider(analyzerProvider);
        }
        for (QueryPreparerProvider preparerProvider : plugin.getQueryPreparerProviders()) {
            log.info("Registering query preparer provider %s", new Object[]{preparerProvider.getType()});
            this.queryPreparerProviderManager.addQueryPreparerProvider(preparerProvider);
        }
        for (NodeStatusNotificationProviderFactory nodeStatusNotificationProviderFactory : plugin.getNodeStatusNotificationProviderFactory()) {
            log.info("Registering node status notification provider %s", new Object[]{nodeStatusNotificationProviderFactory.getName()});
            this.nodeStatusNotificationManager.addNodeStatusNotificationProviderFactory(nodeStatusNotificationProviderFactory);
        }
        for (ClientRequestFilterFactory clientRequestFilterFactory : plugin.getClientRequestFilterFactories()) {
            log.info("Registering client request filter factory");
            this.clientRequestFilterManager.registerClientRequestFilterFactory(clientRequestFilterFactory);
        }
    }

    public void installCoordinatorPlugin(CoordinatorPlugin plugin) {
        for (FunctionNamespaceManagerFactory functionNamespaceManagerFactory : plugin.getFunctionNamespaceManagerFactories()) {
            log.info("Registering function namespace manager %s", new Object[]{functionNamespaceManagerFactory.getName()});
            this.metadata.getFunctionAndTypeManager().addFunctionNamespaceFactory(functionNamespaceManagerFactory);
        }
        for (WorkerSessionPropertyProviderFactory providerFactory : plugin.getWorkerSessionPropertyProviderFactories()) {
            log.info("Registering system session property provider factory %s", new Object[]{providerFactory.getName()});
            this.metadata.getSessionPropertyManager().addSessionPropertyProviderFactory(providerFactory);
        }
        for (PlanCheckerProviderFactory planCheckerProviderFactory : plugin.getPlanCheckerProviderFactories()) {
            log.info("Registering plan checker provider factory %s", new Object[]{planCheckerProviderFactory.getName()});
            this.planCheckerProviderManager.addPlanCheckerProviderFactory(planCheckerProviderFactory);
        }
        for (ExpressionOptimizerFactory expressionOptimizerFactory : plugin.getExpressionOptimizerFactories()) {
            log.info("Registering expression optimizer factory %s", new Object[]{expressionOptimizerFactory.getName()});
            this.expressionOptimizerManager.addExpressionOptimizerFactory(expressionOptimizerFactory);
        }
        for (TypeManagerFactory typeManagerFactory : plugin.getTypeManagerFactories()) {
            log.info("Registering type manager factory %s", new Object[]{typeManagerFactory.getName()});
            this.metadata.getFunctionAndTypeManager().addTypeManagerFactory(typeManagerFactory);
        }
    }

    private class MainPluginInstaller
    implements PluginInstaller {
        private final PluginManager pluginManager;

        public MainPluginInstaller(PluginManager pluginManager2) {
            this.pluginManager = pluginManager2;
        }

        @Override
        public void installPlugin(Plugin plugin) {
            this.pluginManager.installPlugin(plugin);
        }

        @Override
        public void installCoordinatorPlugin(CoordinatorPlugin plugin) {
            this.pluginManager.installCoordinatorPlugin(plugin);
        }
    }
}

