/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.server.PluginClassLoader;
import com.facebook.presto.server.PluginDiscovery;
import com.facebook.presto.server.PluginInstaller;
import com.facebook.presto.spi.CoordinatorPlugin;
import com.facebook.presto.spi.Plugin;
import com.facebook.presto.spi.RouterPlugin;
import com.facebook.presto.spi.classloader.ThreadContextClassLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sonatype.aether.artifact.Artifact;

public class PluginManagerUtil {
    private static final Logger log = Logger.get(PluginManagerUtil.class);
    public static final ImmutableList<String> SPI_PACKAGES = ImmutableList.builder().add((Object)"com.facebook.presto.spi.").add((Object)"com.fasterxml.jackson.annotation.").add((Object)"com.fasterxml.jackson.module.afterburner.").add((Object)"io.airlift.slice.").add((Object)"io.airlift.units.").add((Object)"org.openjdk.jol.").add((Object)"com.facebook.presto.common").add((Object)"com.facebook.drift.annotations.").add((Object)"com.facebook.drift.TException").add((Object)"com.facebook.drift.TApplicationException").build();

    private PluginManagerUtil() {
    }

    public static void loadPlugins(AtomicBoolean pluginsLoading, AtomicBoolean pluginsLoaded, File installedPluginsDir, List<String> plugins, Metadata metadata, ArtifactResolver resolver, List<String> spiPackages, String coordinatorPluginServicesFile, String pluginServicesFile, PluginInstaller pluginInstaller, ClassLoader parent) throws Exception {
        if (!pluginsLoading.compareAndSet(false, true)) {
            return;
        }
        for (File file : PluginManagerUtil.listFiles(installedPluginsDir)) {
            if (!file.isDirectory()) continue;
            PluginManagerUtil.loadPlugin(file.getAbsolutePath(), resolver, spiPackages, coordinatorPluginServicesFile, pluginServicesFile, pluginInstaller, parent);
        }
        for (String plugin : plugins) {
            PluginManagerUtil.loadPlugin(plugin, resolver, spiPackages, coordinatorPluginServicesFile, pluginServicesFile, pluginInstaller, parent);
        }
        if (metadata != null) {
            metadata.verifyComparableOrderableContract();
        }
        pluginsLoaded.set(true);
    }

    public static void loadPlugin(String plugin, ArtifactResolver resolver, List<String> spiPackages, String coordinatorPluginServicesFile, String pluginServicesFile, PluginInstaller pluginInstaller, ClassLoader parent) throws Exception {
        log.info("-- Loading plugin %s --", new Object[]{plugin});
        URLClassLoader pluginClassLoader = PluginManagerUtil.buildClassLoader(plugin, resolver, spiPackages, coordinatorPluginServicesFile, pluginServicesFile, parent);
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader((ClassLoader)pluginClassLoader);){
            PluginManagerUtil.loadPlugin(pluginClassLoader, RouterPlugin.class, pluginInstaller);
            PluginManagerUtil.loadPlugin(pluginClassLoader, CoordinatorPlugin.class, pluginInstaller);
            PluginManagerUtil.loadPlugin(pluginClassLoader, Plugin.class, pluginInstaller);
        }
        log.info("-- Finished loading plugin %s --", new Object[]{plugin});
    }

    public static void loadPlugin(URLClassLoader pluginClassLoader, Class<?> clazz, PluginInstaller pluginInstaller) {
        ServiceLoader<?> serviceLoader = ServiceLoader.load(clazz, pluginClassLoader);
        ImmutableList plugins = ImmutableList.copyOf(serviceLoader);
        if (plugins.isEmpty()) {
            log.warn("No service providers of type %s", new Object[]{clazz.getName()});
        }
        for (Object plugin : plugins) {
            log.info("Installing %s", new Object[]{plugin.getClass().getName()});
            if (plugin instanceof Plugin) {
                pluginInstaller.installPlugin((Plugin)plugin);
                continue;
            }
            if (plugin instanceof CoordinatorPlugin) {
                pluginInstaller.installCoordinatorPlugin((CoordinatorPlugin)plugin);
                continue;
            }
            if (plugin instanceof RouterPlugin) {
                pluginInstaller.installRouterPlugin((RouterPlugin)plugin);
                continue;
            }
            log.warn("Unknown plugin type: %s", new Object[]{plugin.getClass().getName()});
        }
    }

    private static URLClassLoader buildClassLoader(String plugin, ArtifactResolver resolver, List<String> spiPackages, String coordinatorPluginServicesFile, String pluginServicesFile, ClassLoader parent) throws Exception {
        File file = new File(plugin);
        if (file.isFile() && (file.getName().equals("pom.xml") || file.getName().endsWith(".pom"))) {
            return PluginManagerUtil.buildClassLoaderFromPom(file, resolver, spiPackages, coordinatorPluginServicesFile, pluginServicesFile, parent);
        }
        if (file.isDirectory()) {
            return PluginManagerUtil.buildClassLoaderFromDirectory(file, spiPackages, parent);
        }
        return PluginManagerUtil.buildClassLoaderFromCoordinates(plugin, resolver, spiPackages, parent);
    }

    private static URLClassLoader buildClassLoaderFromPom(File pomFile, ArtifactResolver resolver, List<String> spiPackages, String coordinatorPluginServicesFile, String pluginServicesFile, ClassLoader parent) throws Exception {
        List artifacts = resolver.resolvePom(pomFile);
        URLClassLoader classLoader = PluginManagerUtil.createClassLoader(artifacts, pomFile.getPath(), spiPackages, parent);
        Artifact artifact = (Artifact)artifacts.get(0);
        PluginManagerUtil.processPlugins(artifact, classLoader, pluginServicesFile, Plugin.class.getName());
        if (coordinatorPluginServicesFile != null) {
            PluginManagerUtil.processPlugins(artifact, classLoader, coordinatorPluginServicesFile, CoordinatorPlugin.class.getName());
        }
        return classLoader;
    }

    private static URLClassLoader buildClassLoaderFromDirectory(File dir, List<String> spiPackages, ClassLoader parent) throws Exception {
        log.debug("Classpath for %s:", new Object[]{dir.getName()});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : PluginManagerUtil.listFiles(dir)) {
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return PluginManagerUtil.createClassLoader(urls, spiPackages, parent);
    }

    private static URLClassLoader buildClassLoaderFromCoordinates(String coordinates, ArtifactResolver resolver, List<String> spiPackages, ClassLoader parent) throws Exception {
        DefaultArtifact rootArtifact = new DefaultArtifact(coordinates);
        List artifacts = resolver.resolveArtifacts(new Artifact[]{rootArtifact});
        return PluginManagerUtil.createClassLoader(artifacts, rootArtifact.toString(), spiPackages, parent);
    }

    private static URLClassLoader createClassLoader(List<Artifact> artifacts, String name, List<String> spiPackages, ClassLoader parent) throws IOException {
        log.debug("Classpath for %s:", new Object[]{name});
        ArrayList<URL> urls = new ArrayList<URL>();
        for (Artifact artifact : PluginManagerUtil.sortedArtifacts(artifacts)) {
            if (artifact.getFile() == null) {
                throw new RuntimeException("Could not resolve artifact: " + artifact);
            }
            File file = artifact.getFile().getCanonicalFile();
            log.debug("    %s", new Object[]{file});
            urls.add(file.toURI().toURL());
        }
        return PluginManagerUtil.createClassLoader(urls, spiPackages, parent);
    }

    private static URLClassLoader createClassLoader(List<URL> urls, List<String> spiPackages, ClassLoader parent) {
        return new PluginClassLoader(urls, parent, spiPackages);
    }

    private static List<File> listFiles(File installedPluginsDir) {
        Object[] files;
        if (installedPluginsDir != null && installedPluginsDir.isDirectory() && (files = installedPluginsDir.listFiles()) != null) {
            Arrays.sort(files);
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static List<Artifact> sortedArtifacts(List<Artifact> artifacts) {
        ArrayList<Artifact> list = new ArrayList<Artifact>(artifacts);
        Collections.sort(list, Ordering.natural().nullsLast().onResultOf(Artifact::getFile));
        return list;
    }

    private static void processPlugins(Artifact artifact, ClassLoader classLoader, String servicesFile, String className) throws IOException {
        Set<String> plugins = PluginDiscovery.discoverPlugins(artifact, classLoader, servicesFile, className);
        if (!plugins.isEmpty()) {
            PluginDiscovery.writePluginServices(plugins, artifact.getFile(), servicesFile);
        }
    }
}

