/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.ErrorCode;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryProgressStats;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.WarningCode;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.util.DateTimeUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.joda.time.DateTime;

@ThriftStruct
public class QueryStateInfo {
    private final QueryState queryState;
    private final QueryId queryId;
    private final Optional<ResourceGroupId> resourceGroupId;
    private final String query;
    private final boolean queryTruncated;
    private final long createTimeInMillis;
    private final String user;
    private final boolean authenticated;
    private final Optional<String> source;
    private final Optional<String> clientInfo;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final Optional<List<ResourceGroupInfo>> pathToRoot;
    private final Optional<QueryProgressStats> progress;
    private final List<String> warningCodes;
    private final Optional<ErrorCode> errorCode;

    public QueryStateInfo(QueryId queryId, QueryState queryState, Optional<ResourceGroupId> resourceGroupId, String query, boolean queryTruncated, long createTimeInMillis, String user, boolean authenticated, Optional<String> source, Optional<String> clientInfo, Optional<String> catalog, Optional<String> schema, Optional<List<ResourceGroupInfo>> pathToRoot, Optional<QueryProgressStats> progress, List<String> warningCodes, Optional<ErrorCode> errorCode) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.queryState = Objects.requireNonNull(queryState, "queryState is null");
        this.resourceGroupId = Objects.requireNonNull(resourceGroupId, "resourceGroupId is null");
        this.query = Objects.requireNonNull(query, "query text is null");
        this.queryTruncated = queryTruncated;
        this.createTimeInMillis = Objects.requireNonNull(Long.valueOf(createTimeInMillis), "createTime is null");
        this.user = Objects.requireNonNull(user, "user is null");
        this.authenticated = authenticated;
        this.source = Objects.requireNonNull(source, "source is null");
        this.clientInfo = Objects.requireNonNull(clientInfo, "clientInfo is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(pathToRoot, "pathToRoot is null");
        this.pathToRoot = pathToRoot.map(ImmutableList::copyOf);
        this.progress = Objects.requireNonNull(progress, "progress is null");
        this.warningCodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(warningCodes, "warningCodes is null"));
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
    }

    @JsonCreator
    @ThriftConstructor
    public QueryStateInfo(@JsonProperty(value="queryId") QueryId queryId, @JsonProperty(value="queryState") QueryState queryState, @JsonProperty(value="resourceGroupId") Optional<ResourceGroupId> resourceGroupId, @JsonProperty(value="query") String query, @JsonProperty(value="queryTruncated") boolean queryTruncated, @JsonProperty(value="createTime") DateTime createTime, @JsonProperty(value="user") String user, @JsonProperty(value="authenticated") boolean authenticated, @JsonProperty(value="source") Optional<String> source, @JsonProperty(value="clientInfo") Optional<String> clientInfo, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="pathToRoot") Optional<List<ResourceGroupInfo>> pathToRoot, @JsonProperty(value="progress") Optional<QueryProgressStats> progress, @JsonProperty(value="warningCodes") List<String> warningCodes, @JsonProperty(value="errorCode") Optional<ErrorCode> errorCode) {
        this(queryId, queryState, resourceGroupId, query, queryTruncated, DateTimeUtils.toTimeStampInMillis(createTime), user, authenticated, source, clientInfo, catalog, schema, pathToRoot, progress, warningCodes, errorCode);
    }

    public static QueryStateInfo createQueryStateInfo(BasicQueryInfo queryInfo) {
        return QueryStateInfo.createQueryStateInfo(queryInfo, Optional.empty(), false, OptionalInt.empty());
    }

    public static QueryStateInfo createQueryStateInfo(BasicQueryInfo queryInfo, Optional<List<ResourceGroupInfo>> pathToRoot, boolean includeAllQueryProgressStats, OptionalInt queryTextSizeLimit) {
        Optional<QueryProgressStats> progress = Optional.empty();
        if (includeAllQueryProgressStats || !queryInfo.getState().isDone() && queryInfo.getState() != QueryState.QUEUED) {
            progress = Optional.of(QueryProgressStats.createQueryProgressStats(queryInfo.getQueryStats()));
        }
        return QueryStateInfo.createQueryStateInfo(queryInfo, pathToRoot, progress, queryTextSizeLimit);
    }

    private static QueryStateInfo createQueryStateInfo(BasicQueryInfo queryInfo, Optional<List<ResourceGroupInfo>> pathToRoot, Optional<QueryProgressStats> progress, OptionalInt queryTextSizeLimit) {
        String query = queryInfo.getQuery();
        boolean queryTruncated = false;
        if (queryTextSizeLimit.isPresent() && queryInfo.getQuery().length() > queryTextSizeLimit.getAsInt()) {
            query = query.substring(0, queryTextSizeLimit.getAsInt());
            queryTruncated = true;
        }
        return new QueryStateInfo(queryInfo.getQueryId(), queryInfo.getState(), queryInfo.getResourceGroupId(), query, queryTruncated, queryInfo.getQueryStats().getCreateTimeInMillis(), queryInfo.getSession().getUser(), queryInfo.getSession().getPrincipal().isPresent(), queryInfo.getSession().getSource(), queryInfo.getSession().getClientInfo(), queryInfo.getSession().getCatalog(), queryInfo.getSession().getSchema(), pathToRoot, progress, (List<String>)((List)queryInfo.getWarnings().stream().map(PrestoWarning::getWarningCode).map(WarningCode::getName).collect(ImmutableList.toImmutableList())), Optional.ofNullable(queryInfo.getErrorCode()));
    }

    @JsonProperty
    @ThriftField(value=1)
    public QueryId getQueryId() {
        return this.queryId;
    }

    @JsonProperty
    @ThriftField(value=2)
    public QueryState getQueryState() {
        return this.queryState;
    }

    @JsonProperty
    @ThriftField(value=3)
    public Optional<ResourceGroupId> getResourceGroupId() {
        return this.resourceGroupId;
    }

    @JsonProperty
    @ThriftField(value=4)
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    @ThriftField(value=5)
    public boolean isQueryTruncated() {
        return this.queryTruncated;
    }

    @JsonProperty
    @ThriftField(value=6)
    public String getUser() {
        return this.user;
    }

    @JsonProperty
    @ThriftField(value=7)
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @JsonProperty
    @ThriftField(value=8)
    public Optional<String> getSource() {
        return this.source;
    }

    @JsonProperty
    @ThriftField(value=9)
    public Optional<String> getClientInfo() {
        return this.clientInfo;
    }

    @JsonProperty
    @ThriftField(value=10)
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    @ThriftField(value=11)
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    @ThriftField(value=12)
    public Optional<List<ResourceGroupInfo>> getPathToRoot() {
        return this.pathToRoot;
    }

    @JsonProperty
    @ThriftField(value=13)
    public DateTime getCreateTime() {
        return new DateTime(this.createTimeInMillis);
    }

    public long getCreateTimeInMillis() {
        return this.createTimeInMillis;
    }

    @JsonProperty
    @ThriftField(value=14)
    public Optional<QueryProgressStats> getProgress() {
        return this.progress;
    }

    @JsonProperty
    @ThriftField(value=15)
    public List<String> getWarningCodes() {
        return this.warningCodes;
    }

    @JsonProperty
    @ThriftField(value=16)
    public Optional<ErrorCode> getErrorCode() {
        return this.errorCode;
    }
}

