/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sessionpropertyproviders;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.session.PropertyMetadata;
import com.facebook.presto.spi.session.WorkerSessionPropertyProvider;
import com.facebook.presto.spiller.NodeSpillConfig;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.JavaFeaturesConfig;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Objects;

public class JavaWorkerSessionPropertyProvider
implements WorkerSessionPropertyProvider {
    public static final String AGGREGATION_SPILL_ENABLED = "aggregation_spill_enabled";
    public static final String TOPN_SPILL_ENABLED = "topn_spill_enabled";
    public static final String DISTINCT_AGGREGATION_SPILL_ENABLED = "distinct_aggregation_spill_enabled";
    public static final String DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED = "dedup_based_distinct_aggregation_spill_enabled";
    public static final String DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED = "distinct_aggregation_large_block_spill_enabled";
    public static final String DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD = "distinct_aggregation_large_block_size_threshold";
    public static final String ORDER_BY_AGGREGATION_SPILL_ENABLED = "order_by_aggregation_spill_enabled";
    public static final String WINDOW_SPILL_ENABLED = "window_spill_enabled";
    public static final String ORDER_BY_SPILL_ENABLED = "order_by_spill_enabled";
    public static final String AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT = "aggregation_operator_unspill_memory_limit";
    public static final String TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT = "topn_operator_unspill_memory_limit";
    public static final String TEMP_STORAGE_SPILLER_BUFFER_SIZE = "temp_storage_spiller_buffer_size";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public JavaWorkerSessionPropertyProvider(FeaturesConfig featuresConfig, JavaFeaturesConfig javaFeaturesConfig, NodeSpillConfig nodeSpillConfig) {
        boolean nativeExecution = Objects.requireNonNull(featuresConfig, "featuresConfig is null").isNativeExecutionEnabled();
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)TOPN_SPILL_ENABLED, (String)"Enable topN spilling if spill_enabled", (Boolean)javaFeaturesConfig.isTopNSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)AGGREGATION_SPILL_ENABLED, (String)"Enable aggregate spilling if spill_enabled", (Boolean)javaFeaturesConfig.isAggregationSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)DISTINCT_AGGREGATION_SPILL_ENABLED, (String)"Enable spill for distinct aggregations if spill_enabled and aggregation_spill_enabled", (Boolean)javaFeaturesConfig.isDistinctAggregationSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED, (String)"Perform deduplication of input data for distinct aggregates before spilling", (Boolean)javaFeaturesConfig.isDedupBasedDistinctAggregationSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED, (String)"Spill large block to a separate spill file", (Boolean)javaFeaturesConfig.isDistinctAggregationLargeBlockSpillEnabled(), (boolean)nativeExecution), (Object)new PropertyMetadata(DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD, "Block size threshold beyond which it will be spilled into a separate spill file", (Type)VarcharType.VARCHAR, DataSize.class, (Object)javaFeaturesConfig.getDistinctAggregationLargeBlockSizeThreshold(), nativeExecution, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)PropertyMetadata.booleanProperty((String)ORDER_BY_AGGREGATION_SPILL_ENABLED, (String)"Enable spill for order-by aggregations if spill_enabled and aggregation_spill_enabled", (Boolean)javaFeaturesConfig.isOrderByAggregationSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)WINDOW_SPILL_ENABLED, (String)"Enable window spilling if spill_enabled", (Boolean)javaFeaturesConfig.isWindowSpillEnabled(), (boolean)nativeExecution), (Object)PropertyMetadata.booleanProperty((String)ORDER_BY_SPILL_ENABLED, (String)"Enable order by spilling if spill_enabled", (Boolean)javaFeaturesConfig.isOrderBySpillEnabled(), (boolean)nativeExecution), (Object)new PropertyMetadata(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, "Experimental: How much memory can should be allocated per aggregation operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)javaFeaturesConfig.getAggregationOperatorUnspillMemoryLimit(), nativeExecution, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)new PropertyMetadata(TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT, "How much memory can should be allocated per topN operator in unspilling process", (Type)VarcharType.VARCHAR, DataSize.class, (Object)javaFeaturesConfig.getTopNOperatorUnspillMemoryLimit(), nativeExecution, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object)new PropertyMetadata(TEMP_STORAGE_SPILLER_BUFFER_SIZE, "Experimental: Buffer size used by TempStorageSingleStreamSpiller", (Type)VarcharType.VARCHAR, DataSize.class, (Object)nodeSpillConfig.getTempStorageBufferSize(), nativeExecution, value -> DataSize.valueOf((String)((String)value)), DataSize::toString), (Object[])new PropertyMetadata[0]);
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isTopNSpillEnabled(Session session) {
        return session.getSystemProperty(TOPN_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(AGGREGATION_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isDistinctAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_SPILL_ENABLED, Boolean.class) != false && JavaWorkerSessionPropertyProvider.isAggregationSpillEnabled(session);
    }

    public static boolean isDedupBasedDistinctAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(DEDUP_BASED_DISTINCT_AGGREGATION_SPILL_ENABLED, Boolean.class);
    }

    public static boolean isDistinctAggregationLargeBlockSpillEnabled(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_LARGE_BLOCK_SPILL_ENABLED, Boolean.class);
    }

    public static DataSize getDistinctAggregationLargeBlockSizeThreshold(Session session) {
        return session.getSystemProperty(DISTINCT_AGGREGATION_LARGE_BLOCK_SIZE_THRESHOLD, DataSize.class);
    }

    public static boolean isOrderByAggregationSpillEnabled(Session session) {
        return session.getSystemProperty(ORDER_BY_AGGREGATION_SPILL_ENABLED, Boolean.class) != false && JavaWorkerSessionPropertyProvider.isAggregationSpillEnabled(session);
    }

    public static boolean isWindowSpillEnabled(Session session) {
        return session.getSystemProperty(WINDOW_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static boolean isOrderBySpillEnabled(Session session) {
        return session.getSystemProperty(ORDER_BY_SPILL_ENABLED, Boolean.class) != false && SystemSessionProperties.isSpillEnabled(session);
    }

    public static DataSize getAggregationOperatorUnspillMemoryLimit(Session session) {
        DataSize memoryLimitForMerge = session.getSystemProperty(AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((memoryLimitForMerge.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)AGGREGATION_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return memoryLimitForMerge;
    }

    public static DataSize getTopNOperatorUnspillMemoryLimit(Session session) {
        DataSize unspillMemoryLimit = session.getSystemProperty(TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT, DataSize.class);
        Preconditions.checkArgument((unspillMemoryLimit.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)TOPN_OPERATOR_UNSPILL_MEMORY_LIMIT);
        return unspillMemoryLimit;
    }

    public static DataSize getTempStorageSpillerBufferSize(Session session) {
        DataSize tempStorageSpillerBufferSize = session.getSystemProperty(TEMP_STORAGE_SPILLER_BUFFER_SIZE, DataSize.class);
        Preconditions.checkArgument((tempStorageSpillerBufferSize.toBytes() >= 0L ? 1 : 0) != 0, (String)"%s must be positive", (Object)TEMP_STORAGE_SPILLER_BUFFER_SIZE);
        return tempStorageSpillerBufferSize;
    }
}

