/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.configuration.Config;
import com.facebook.airlift.configuration.ConfigDescription;
import com.facebook.presto.metadata.BuiltInTypeAndFunctionNamespaceManager;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.operator.aggregation.multimapagg.MultimapAggGroupImplementation;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import javax.validation.constraints.Min;

public class FunctionsConfig {
    private boolean legacyArrayAgg;
    private boolean useAlternativeFunctionSignatures;
    private boolean legacyMapSubscript;
    private boolean reduceAggForComplexTypesEnabled = true;
    private boolean legacyLogFunction;
    private int re2JDfaStatesLimit = Integer.MAX_VALUE;
    private int re2JDfaRetries = 5;
    private RegexLibrary regexLibrary = RegexLibrary.JONI;
    private long kHyperLogLogAggregationGroupNumberLimit;
    private boolean limitNumberOfGroupsForKHyperLogLogAggregations = true;
    private boolean useNewNanDefinition = true;
    private HistogramGroupImplementation histogramGroupImplementation = HistogramGroupImplementation.NEW;
    private ArrayAggGroupImplementation arrayAggGroupImplementation = ArrayAggGroupImplementation.NEW;
    private MultimapAggGroupImplementation multimapAggGroupImplementation = MultimapAggGroupImplementation.NEW;
    private boolean legacyRowFieldOrdinalAccess;
    private boolean legacyTimestamp = true;
    private boolean parseDecimalLiteralsAsDouble;
    private boolean fieldNamesInJsonCastEnabled;
    private boolean warnOnPossibleNans;
    private boolean legacyCharToVarcharCoercion;
    private boolean legacyJsonCast = true;
    private boolean canonicalizedJsonExtract;
    private String defaultNamespacePrefix = BuiltInTypeAndFunctionNamespaceManager.JAVA_BUILTIN_NAMESPACE.toString();

    @Config(value="deprecated.legacy-array-agg")
    public FunctionsConfig setLegacyArrayAgg(boolean legacyArrayAgg) {
        this.legacyArrayAgg = legacyArrayAgg;
        return this;
    }

    public boolean isLegacyArrayAgg() {
        return this.legacyArrayAgg;
    }

    @Config(value="deprecated.legacy-log-function")
    public FunctionsConfig setLegacyLogFunction(boolean value) {
        this.legacyLogFunction = value;
        return this;
    }

    public boolean isLegacyLogFunction() {
        return this.legacyLogFunction;
    }

    @Config(value="use-alternative-function-signatures")
    @ConfigDescription(value="Override intermediate aggregation type of some aggregation functions to be compatible with Velox")
    public FunctionsConfig setUseAlternativeFunctionSignatures(boolean value) {
        this.useAlternativeFunctionSignatures = value;
        return this;
    }

    public boolean isUseAlternativeFunctionSignatures() {
        return this.useAlternativeFunctionSignatures;
    }

    @Config(value="deprecated.legacy-map-subscript")
    public FunctionsConfig setLegacyMapSubscript(boolean value) {
        this.legacyMapSubscript = value;
        return this;
    }

    public boolean isLegacyMapSubscript() {
        return this.legacyMapSubscript;
    }

    @Config(value="reduce-agg-for-complex-types-enabled")
    public FunctionsConfig setReduceAggForComplexTypesEnabled(boolean reduceAggForComplexTypesEnabled) {
        this.reduceAggForComplexTypesEnabled = reduceAggForComplexTypesEnabled;
        return this;
    }

    public boolean isReduceAggForComplexTypesEnabled() {
        return this.reduceAggForComplexTypesEnabled;
    }

    @Config(value="re2j.dfa-states-limit")
    public FunctionsConfig setRe2JDfaStatesLimit(int re2JDfaStatesLimit) {
        this.re2JDfaStatesLimit = re2JDfaStatesLimit;
        return this;
    }

    @Min(value=2L)
    public @Min(value=2L) int getRe2JDfaStatesLimit() {
        return this.re2JDfaStatesLimit;
    }

    @Config(value="re2j.dfa-retries")
    public FunctionsConfig setRe2JDfaRetries(int re2JDfaRetries) {
        this.re2JDfaRetries = re2JDfaRetries;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getRe2JDfaRetries() {
        return this.re2JDfaRetries;
    }

    @Config(value="regex-library")
    public FunctionsConfig setRegexLibrary(RegexLibrary regexLibrary) {
        this.regexLibrary = regexLibrary;
        return this;
    }

    public RegexLibrary getRegexLibrary() {
        return this.regexLibrary;
    }

    @Config(value="khyperloglog-agg-group-limit")
    @ConfigDescription(value="Maximum number of groups for khyperloglog_agg per task")
    public FunctionsConfig setKHyperLogLogAggregationGroupNumberLimit(long kHyperLogLogAggregationGroupNumberLimit) {
        this.kHyperLogLogAggregationGroupNumberLimit = kHyperLogLogAggregationGroupNumberLimit;
        return this;
    }

    public long getKHyperLogLogAggregationGroupNumberLimit() {
        return this.kHyperLogLogAggregationGroupNumberLimit;
    }

    @Config(value="limit-khyperloglog-agg-group-number-enabled")
    @ConfigDescription(value="Enable limiting number of groups for khyperloglog_agg and merge of KHyperLogLog states")
    public FunctionsConfig setLimitNumberOfGroupsForKHyperLogLogAggregations(boolean limitNumberOfGroupsForKHyperLogLogAggregations) {
        this.limitNumberOfGroupsForKHyperLogLogAggregations = limitNumberOfGroupsForKHyperLogLogAggregations;
        return this;
    }

    public boolean getLimitNumberOfGroupsForKHyperLogLogAggregations() {
        return this.limitNumberOfGroupsForKHyperLogLogAggregations;
    }

    @Config(value="use-new-nan-definition")
    @ConfigDescription(value="Enable functions to use the new consistent NaN definition where NaN=NaN and is sorted largest")
    public FunctionsConfig setUseNewNanDefinition(boolean useNewNanDefinition) {
        this.useNewNanDefinition = useNewNanDefinition;
        return this;
    }

    public boolean getUseNewNanDefinition() {
        return this.useNewNanDefinition;
    }

    @Config(value="histogram.implementation")
    public FunctionsConfig setHistogramGroupImplementation(HistogramGroupImplementation groupByMode) {
        this.histogramGroupImplementation = groupByMode;
        return this;
    }

    public HistogramGroupImplementation getHistogramGroupImplementation() {
        return this.histogramGroupImplementation;
    }

    @Config(value="arrayagg.implementation")
    public FunctionsConfig setArrayAggGroupImplementation(ArrayAggGroupImplementation groupByMode) {
        this.arrayAggGroupImplementation = groupByMode;
        return this;
    }

    public ArrayAggGroupImplementation getArrayAggGroupImplementation() {
        return this.arrayAggGroupImplementation;
    }

    @Config(value="multimapagg.implementation")
    public FunctionsConfig setMultimapAggGroupImplementation(MultimapAggGroupImplementation groupByMode) {
        this.multimapAggGroupImplementation = groupByMode;
        return this;
    }

    public MultimapAggGroupImplementation getMultimapAggGroupImplementation() {
        return this.multimapAggGroupImplementation;
    }

    @Config(value="deprecated.legacy-row-field-ordinal-access")
    public FunctionsConfig setLegacyRowFieldOrdinalAccess(boolean value) {
        this.legacyRowFieldOrdinalAccess = value;
        return this;
    }

    public boolean isLegacyRowFieldOrdinalAccess() {
        return this.legacyRowFieldOrdinalAccess;
    }

    @Config(value="deprecated.legacy-timestamp")
    public FunctionsConfig setLegacyTimestamp(boolean value) {
        this.legacyTimestamp = value;
        return this;
    }

    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    @Config(value="parse-decimal-literals-as-double")
    public FunctionsConfig setParseDecimalLiteralsAsDouble(boolean parseDecimalLiteralsAsDouble) {
        this.parseDecimalLiteralsAsDouble = parseDecimalLiteralsAsDouble;
        return this;
    }

    public boolean isParseDecimalLiteralsAsDouble() {
        return this.parseDecimalLiteralsAsDouble;
    }

    @Config(value="field-names-in-json-cast-enabled")
    public FunctionsConfig setFieldNamesInJsonCastEnabled(boolean fieldNamesInJsonCastEnabled) {
        this.fieldNamesInJsonCastEnabled = fieldNamesInJsonCastEnabled;
        return this;
    }

    public boolean isFieldNamesInJsonCastEnabled() {
        return this.fieldNamesInJsonCastEnabled;
    }

    @Config(value="warn-on-common-nan-patterns")
    @ConfigDescription(value="Give warnings for operations on DOUBLE/REAL types where NaN issues are common")
    public FunctionsConfig setWarnOnCommonNanPatterns(boolean warnOnPossibleNans) {
        this.warnOnPossibleNans = warnOnPossibleNans;
        return this;
    }

    public boolean getWarnOnCommonNanPatterns() {
        return this.warnOnPossibleNans;
    }

    @Config(value="deprecated.legacy-char-to-varchar-coercion")
    public FunctionsConfig setLegacyCharToVarcharCoercion(boolean value) {
        this.legacyCharToVarcharCoercion = value;
        return this;
    }

    public boolean isLegacyCharToVarcharCoercion() {
        return this.legacyCharToVarcharCoercion;
    }

    @Config(value="legacy-json-cast")
    public FunctionsConfig setLegacyJsonCast(boolean legacyJsonCast) {
        this.legacyJsonCast = legacyJsonCast;
        return this;
    }

    public boolean isLegacyJsonCast() {
        return this.legacyJsonCast;
    }

    @Config(value="canonicalized-json-extract")
    @Description(value="Extracts json data in a canonicalized manner, and raises a PrestoException when encountering invalid json structures within the input json path")
    public FunctionsConfig setCanonicalizedJsonExtract(boolean canonicalizedJsonExtract) {
        this.canonicalizedJsonExtract = canonicalizedJsonExtract;
        return this;
    }

    public boolean isCanonicalizedJsonExtract() {
        return this.canonicalizedJsonExtract;
    }

    @Config(value="presto.default-namespace")
    @ConfigDescription(value="Specifies the default function namespace prefix")
    public FunctionsConfig setDefaultNamespacePrefix(String defaultNamespacePrefix) {
        this.defaultNamespacePrefix = defaultNamespacePrefix;
        return this;
    }

    public String getDefaultNamespacePrefix() {
        return this.defaultNamespacePrefix;
    }
}

