/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.RuntimeUnit;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.function.OperatorType;
import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TimestampWithTimeZoneType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.UnknownType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.MaterializedViewDefinition;
import com.facebook.presto.spi.MaterializedViewStatus;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.analyzer.AccessControlInfo;
import com.facebook.presto.spi.analyzer.AccessControlInfoForTable;
import com.facebook.presto.spi.analyzer.AccessControlRole;
import com.facebook.presto.spi.analyzer.MetadataResolver;
import com.facebook.presto.spi.analyzer.ViewDefinition;
import com.facebook.presto.spi.connector.ConnectorTableVersion;
import com.facebook.presto.spi.function.FunctionKind;
import com.facebook.presto.spi.function.Signature;
import com.facebook.presto.spi.function.SqlFunction;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.security.AccessControl;
import com.facebook.presto.spi.security.AllowAllAccessControl;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.ViewAccessControl;
import com.facebook.presto.spi.security.ViewExpression;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.MaterializedViewUtils;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.SqlFormatterUtil;
import com.facebook.presto.sql.analyzer.AggregationAnalyzer;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.FieldId;
import com.facebook.presto.sql.analyzer.FunctionAndTypeResolver;
import com.facebook.presto.sql.analyzer.MaterializedViewPlanValidator;
import com.facebook.presto.sql.analyzer.MetadataHandle;
import com.facebook.presto.sql.analyzer.PredicateStitcher;
import com.facebook.presto.sql.analyzer.RefreshMaterializedViewPredicateAnalyzer;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.ResolvedField;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.analyzer.ScopeReferenceExtractor;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TableColumnMetadata;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.analyzer.WindowFunctionValidator;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.ExpressionDeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.VariablesExtractor;
import com.facebook.presto.sql.relational.RowExpressionDomainTranslator;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.AddConstraint;
import com.facebook.presto.sql.tree.AliasedRelation;
import com.facebook.presto.sql.tree.AllColumns;
import com.facebook.presto.sql.tree.AlterColumnNotNull;
import com.facebook.presto.sql.tree.AlterFunction;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Call;
import com.facebook.presto.sql.tree.Commit;
import com.facebook.presto.sql.tree.CreateFunction;
import com.facebook.presto.sql.tree.CreateMaterializedView;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Cube;
import com.facebook.presto.sql.tree.Deallocate;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.DropColumn;
import com.facebook.presto.sql.tree.DropConstraint;
import com.facebook.presto.sql.tree.DropFunction;
import com.facebook.presto.sql.tree.DropMaterializedView;
import com.facebook.presto.sql.tree.DropSchema;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Except;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.ExplainType;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Grant;
import com.facebook.presto.sql.tree.GroupBy;
import com.facebook.presto.sql.tree.GroupingElement;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.GroupingSets;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.Intersect;
import com.facebook.presto.sql.tree.Join;
import com.facebook.presto.sql.tree.JoinCriteria;
import com.facebook.presto.sql.tree.JoinOn;
import com.facebook.presto.sql.tree.JoinUsing;
import com.facebook.presto.sql.tree.Lateral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LogicalBinaryExpression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.NaturalJoin;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.Offset;
import com.facebook.presto.sql.tree.OrderBy;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Prepare;
import com.facebook.presto.sql.tree.Property;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameSchema;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.RenameView;
import com.facebook.presto.sql.tree.ResetSession;
import com.facebook.presto.sql.tree.Return;
import com.facebook.presto.sql.tree.Revoke;
import com.facebook.presto.sql.tree.Rollback;
import com.facebook.presto.sql.tree.Rollup;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.SampledRelation;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SelectItem;
import com.facebook.presto.sql.tree.SetOperation;
import com.facebook.presto.sql.tree.SetProperties;
import com.facebook.presto.sql.tree.SetSession;
import com.facebook.presto.sql.tree.SimpleGroupBy;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.SqlParameterDeclaration;
import com.facebook.presto.sql.tree.StartTransaction;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.sql.tree.TableSubquery;
import com.facebook.presto.sql.tree.TableVersionExpression;
import com.facebook.presto.sql.tree.TruncateTable;
import com.facebook.presto.sql.tree.Union;
import com.facebook.presto.sql.tree.Unnest;
import com.facebook.presto.sql.tree.Update;
import com.facebook.presto.sql.tree.UpdateAssignment;
import com.facebook.presto.sql.tree.Use;
import com.facebook.presto.sql.tree.Values;
import com.facebook.presto.sql.tree.Window;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.sql.tree.With;
import com.facebook.presto.sql.tree.WithQuery;
import com.facebook.presto.sql.util.AstUtils;
import com.facebook.presto.util.AnalyzerUtil;
import com.facebook.presto.util.MetadataUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

class StatementAnalyzer {
    private static final Logger log = Logger.get(StatementAnalyzer.class);
    private static final int UNION_DISTINCT_FIELDS_WARNING_THRESHOLD = 3;
    private final Analysis analysis;
    private final Metadata metadata;
    private final FunctionAndTypeResolver functionAndTypeResolver;
    private final Session session;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final WarningCollector warningCollector;
    private final MetadataResolver metadataResolver;

    public StatementAnalyzer(Analysis analysis, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Session session, WarningCollector warningCollector) {
        this.analysis = Objects.requireNonNull(analysis, "analysis is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.session = Objects.requireNonNull(session, "session is null");
        this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        this.metadataResolver = Objects.requireNonNull(metadata.getMetadataResolver(session), "metadataResolver is null");
        Objects.requireNonNull(metadata.getFunctionAndTypeManager(), "functionAndTypeManager is null");
        this.functionAndTypeResolver = Objects.requireNonNull(metadata.getFunctionAndTypeManager().getFunctionAndTypeResolver(), "functionAndTypeResolver is null");
        analysis.addQueryAccessControlInfo(new AccessControlInfo(accessControl, session.getIdentity(), session.getTransactionId(), session.getAccessControlContext()));
    }

    public Scope analyze(Node node, Scope outerQueryScope) {
        return this.analyze(node, Optional.of(outerQueryScope));
    }

    public Scope analyze(Node node, Optional<Scope> outerQueryScope) {
        return new Visitor(outerQueryScope, this.warningCollector).process(node, Optional.empty());
    }

    private static boolean hasScopeAsLocalParent(Scope root, Scope parent) {
        Scope scope = root;
        while (scope.getLocalParent().isPresent()) {
            if (!(scope = (Scope)scope.getLocalParent().get()).equals(parent)) continue;
            return true;
        }
        return false;
    }

    private class Visitor
    extends DefaultTraversalVisitor<Scope, Optional<Scope>> {
        private final Optional<Scope> outerQueryScope;
        private final WarningCollector warningCollector;

        private Visitor(Optional<Scope> outerQueryScope, WarningCollector warningCollector) {
            this.outerQueryScope = Objects.requireNonNull(outerQueryScope, "outerQueryScope is null");
            this.warningCollector = Objects.requireNonNull(warningCollector, "warningCollector is null");
        }

        public Scope process(Node node, Optional<Scope> scope) {
            Scope returnScope = (Scope)super.process(node, scope);
            Preconditions.checkState((boolean)returnScope.getOuterQueryParent().equals(this.outerQueryScope), (Object)"result scope should have outer query scope equal with parameter outer query scope");
            scope.ifPresent(value -> Preconditions.checkState((boolean)StatementAnalyzer.hasScopeAsLocalParent(returnScope, value), (Object)"return scope should have context scope as one of ancestors"));
            return returnScope;
        }

        private Scope process(Node node, Scope scope) {
            return this.process(node, Optional.of(scope));
        }

        protected Scope visitUse(Use node, Optional<Scope> scope) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "USE statement is not supported", new Object[0]);
        }

        protected Scope visitInsert(Insert insert, Optional<Scope> scope) {
            List insertColumns;
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)insert, insert.getTarget());
            MetadataHandle metadataHandle = StatementAnalyzer.this.analysis.getMetadataHandle();
            if (MetadataUtils.getViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, targetTable).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into views is not supported", new Object[0]);
            }
            if (MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, targetTable).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Inserting into materialized views is not supported", new Object[0]);
            }
            Scope queryScope = this.process((Node)insert.getQuery(), scope);
            StatementAnalyzer.this.analysis.setUpdateType("INSERT");
            TableColumnMetadata tableColumnsMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, targetTable);
            StatementAnalyzer.this.analysis.addAccessControlCheckForTable(AccessControlRole.TABLE_INSERT, new AccessControlInfoForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable));
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Insert into table with row filter is not supported", new Object[0]);
            }
            List columnsMetadata = tableColumnsMetadata.getColumnsMetadata();
            if (!StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable, columnsMetadata).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)insert, "Insert into table with column masks is not supported", new Object[0]);
            }
            List tableColumns = (List)columnsMetadata.stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
            if (insert.getColumns().isPresent()) {
                insertColumns = (List)((List)insert.getColumns().get()).stream().map(Identifier::getValue).map(column -> column.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList());
                HashSet<String> columnNames = new HashSet<String>();
                for (String insertColumn2 : insertColumns) {
                    if (!tableColumns.contains(insertColumn2)) {
                        throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)insert, "Insert column name does not exist in target table: %s", new Object[]{insertColumn2});
                    }
                    if (columnNames.add(insertColumn2)) continue;
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)insert, "Insert column name is specified more than once: %s", new Object[]{insertColumn2});
                }
            } else {
                insertColumns = tableColumns;
            }
            List expectedColumns = (List)insertColumns.stream().map(insertColumn -> this.getColumnMetadata(columnsMetadata, (String)insertColumn)).collect(ImmutableList.toImmutableList());
            this.checkTypesMatchForInsert(insert, queryScope, expectedColumns);
            Map columnHandles = tableColumnsMetadata.getColumnHandles();
            StatementAnalyzer.this.analysis.setInsert(new Analysis.Insert((TableHandle)tableColumnsMetadata.getTableHandle().get(), (List)insertColumns.stream().map(columnHandles::get).collect(ImmutableList.toImmutableList())));
            return this.createAndAssignScope((Node)insert, scope, Field.newUnqualified((Optional)insert.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        private ColumnMetadata getColumnMetadata(List<ColumnMetadata> columnsMetadata, String columnName) {
            return columnsMetadata.stream().filter(columnMetadata -> columnMetadata.getName().equals(columnName)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid column name: %s", columnName)));
        }

        private void checkTypesMatchForInsert(Insert insert, Scope queryScope, List<ColumnMetadata> expectedColumns) {
            List queryColumnTypes = (List)queryScope.getRelationType().getVisibleFields().stream().map(Field::getType).collect(ImmutableList.toImmutableList());
            String errorMessage = "";
            if (expectedColumns.size() != queryColumnTypes.size()) {
                errorMessage = String.format("Insert query has %d expression(s) but expected %d target column(s). ", queryColumnTypes.size(), expectedColumns.size());
            }
            for (int i = 0; i < Math.max(expectedColumns.size(), queryColumnTypes.size()); ++i) {
                Insert node = insert;
                QueryBody queryBody = insert.getQuery().getQueryBody();
                if (queryBody instanceof Values) {
                    List rows = ((Values)queryBody).getRows();
                    Preconditions.checkState((!rows.isEmpty() ? 1 : 0) != 0, (Object)"Missing column values");
                    node = (Node)rows.get(0);
                    if (node instanceof Row) {
                        int columnIndex = Math.min(i, queryColumnTypes.size() - 1);
                        node = (Node)((Row)rows.get(0)).getItems().get(columnIndex);
                    }
                }
                if (i == expectedColumns.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d", new Object[]{i + 1});
                }
                if (i == queryColumnTypes.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d: '%s'", new Object[]{i + 1, expectedColumns.get(i).getName()});
                }
                if (StatementAnalyzer.this.functionAndTypeResolver.canCoerce((Type)queryColumnTypes.get(i), expectedColumns.get(i).getType())) continue;
                if (queryColumnTypes.get(i) instanceof RowType && expectedColumns.get(i).getType() instanceof RowType) {
                    String fieldName = expectedColumns.get(i).getName();
                    List columnRowTypes = ((Type)queryColumnTypes.get(i)).getTypeParameters();
                    List expectedRowFields = ((RowType)expectedColumns.get(i).getType()).getFields();
                    this.checkTypesMatchForNestedStructs((Node)node, errorMessage, i + 1, fieldName, expectedRowFields, columnRowTypes);
                }
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, errorMessage + "Mismatch at column %d: '%s' is of type %s but expression is of type %s", new Object[]{i + 1, expectedColumns.get(i).getName(), expectedColumns.get(i).getType(), queryColumnTypes.get(i)});
            }
        }

        private void checkTypesMatchForNestedStructs(Node node, String errorMessage, int columnIndex, String fieldName, List<RowType.Field> expectedRowFields, List<Type> columnRowTypes) {
            if (expectedRowFields.size() != columnRowTypes.size()) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, node, errorMessage + "Mismatch at column %d: '%s' has %d field(s) but expression has %d field(s)", new Object[]{columnIndex, fieldName, expectedRowFields.size(), columnRowTypes.size()});
            }
            for (int rowFieldIndex = 0; rowFieldIndex < expectedRowFields.size(); ++rowFieldIndex) {
                if (StatementAnalyzer.this.functionAndTypeResolver.canCoerce(columnRowTypes.get(rowFieldIndex), expectedRowFields.get(rowFieldIndex).getType())) continue;
                fieldName = fieldName + "." + (String)expectedRowFields.get(rowFieldIndex).getName().get();
                if (columnRowTypes.get(rowFieldIndex) instanceof RowType && expectedRowFields.get(rowFieldIndex).getType() instanceof RowType) {
                    this.checkTypesMatchForNestedStructs(node, errorMessage, columnIndex, fieldName, ((RowType)expectedRowFields.get(rowFieldIndex).getType()).getFields(), columnRowTypes.get(rowFieldIndex).getTypeParameters());
                    continue;
                }
                throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, node, errorMessage + "Mismatch at column %d: '%s' is of type %s but expression is of type %s", new Object[]{columnIndex, fieldName, expectedRowFields.get(rowFieldIndex).getType(), columnRowTypes.get(rowFieldIndex)});
            }
        }

        protected Scope visitDelete(Delete node, Optional<Scope> scope) {
            Table table = node.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            MetadataHandle metadataHandle = StatementAnalyzer.this.analysis.getMetadataHandle();
            if (MetadataUtils.getViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from views is not supported", new Object[0]);
            }
            if (MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Deleting from materialized views is not supported", new Object[0]);
            }
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, (AccessControl)new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector);
            Scope tableScope = analyzer.analyze((Node)table, scope);
            node.getWhere().ifPresent(where -> this.analyzeWhere((Node)node, tableScope, (Expression)where));
            StatementAnalyzer.this.analysis.setUpdateType("DELETE");
            StatementAnalyzer.this.analysis.addAccessControlCheckForTable(AccessControlRole.TABLE_DELETE, new AccessControlInfoForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), tableName));
            if (!StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), tableName).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Delete from table with row filter is not supported", new Object[0]);
            }
            TableColumnMetadata tableColumnsMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), tableName);
            List columnsMetadata = tableColumnsMetadata.getColumnsMetadata();
            if (!StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), tableName, columnsMetadata).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Delete from table with column mask is not supported", new Object[0]);
            }
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitAnalyze(Analyze node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("ANALYZE");
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getTableName());
            MetadataHandle metadataHandle = StatementAnalyzer.this.analysis.getMetadataHandle();
            if (MetadataUtils.getViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Analyzing views is not supported", new Object[0]);
            }
            this.validateProperties(node.getProperties(), scope);
            Map<String, Object> analyzeProperties = StatementAnalyzer.this.metadata.getAnalyzePropertyManager().getProperties(MetadataUtil.getConnectorIdOrThrow(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, tableName.getCatalogName()), tableName.getCatalogName(), NodeUtils.mapFromProperties(node.getProperties()), StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.analysis.getParameters());
            TableHandle tableHandle = StatementAnalyzer.this.metadata.getTableHandleForStatisticsCollection(StatementAnalyzer.this.session, tableName, analyzeProperties).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)node, "Table '%s' does not exist", new Object[]{tableName}));
            ImmutableMultimap tableColumnMap = ImmutableMultimap.builder().putAll((Object)tableName, (Iterable)StatementAnalyzer.this.metadataResolver.getColumnHandles(tableHandle).keySet().stream().map(column -> new Subfield(column, (List)ImmutableList.of())).collect(ImmutableSet.toImmutableSet())).build();
            StatementAnalyzer.this.analysis.addTableColumnAndSubfieldReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), (Multimap)tableColumnMap, (Multimap)tableColumnMap);
            StatementAnalyzer.this.analysis.addAccessControlCheckForTable(AccessControlRole.TABLE_INSERT, new AccessControlInfoForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), tableName));
            StatementAnalyzer.this.analysis.setAnalyzeTarget(tableHandle);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateTableAsSelect(CreateTableAsSelect node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE TABLE");
            QualifiedObjectName targetTable = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer.this.analysis.setCreateTableDestination(targetTable);
            if (StatementAnalyzer.this.metadataResolver.tableExists(targetTable)) {
                if (node.isNotExists()) {
                    StatementAnalyzer.this.analysis.setCreateTableAsSelectNoOp(true);
                    return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
                }
                throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)node, "Destination table '%s' already exists", new Object[]{targetTable});
            }
            this.validateProperties(node.getProperties(), scope);
            StatementAnalyzer.this.analysis.setCreateTableProperties(NodeUtils.mapFromProperties(node.getProperties()));
            node.getColumnAliases().ifPresent(arg_0 -> ((Analysis)StatementAnalyzer.this.analysis).setCreateTableColumnAliases(arg_0));
            StatementAnalyzer.this.analysis.setCreateTableComment(node.getComment());
            StatementAnalyzer.this.analysis.addAccessControlCheckForTable(AccessControlRole.TABLE_CREATE, new AccessControlInfoForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), targetTable));
            StatementAnalyzer.this.analysis.setCreateTableAsSelectWithData(node.isWithData());
            Scope queryScope = this.process((Node)node.getQuery(), scope);
            if (node.getColumnAliases().isPresent()) {
                this.validateColumnAliases((List)node.getColumnAliases().get(), queryScope.getRelationType().getVisibleFieldCount());
                for (Field field : queryScope.getRelationType().getVisibleFields()) {
                    if (!field.getType().equals(UnknownType.UNKNOWN)) continue;
                    throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown at position %s", new Object[]{queryScope.getRelationType().indexOf(field) + 1});
                }
            } else {
                this.validateColumns((Statement)node, queryScope.getRelationType());
            }
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        protected Scope visitCreateView(CreateView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE VIEW");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateMaterializedView(CreateMaterializedView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE MATERIALIZED VIEW");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node, node.getName());
            StatementAnalyzer.this.analysis.setCreateTableDestination(viewName);
            if (StatementAnalyzer.this.metadataResolver.tableExists(viewName)) {
                if (node.isNotExists()) {
                    return this.createAndAssignScope((Node)node, scope);
                }
                throw new SemanticException(SemanticErrorCode.MATERIALIZED_VIEW_ALREADY_EXISTS, (Node)node, "Destination materialized view '%s' already exists", new Object[]{viewName});
            }
            this.validateProperties(node.getProperties(), scope);
            StatementAnalyzer.this.analysis.setCreateTableProperties(NodeUtils.mapFromProperties(node.getProperties()));
            StatementAnalyzer.this.analysis.setCreateTableComment(node.getComment());
            StatementAnalyzer.this.accessControl.checkCanCreateTable(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            StatementAnalyzer.this.accessControl.checkCanCreateView(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), viewName);
            Scope queryScope = this.process((Node)node.getQuery(), scope);
            this.validateColumns((Statement)node, queryScope.getRelationType());
            this.validateBaseTables(StatementAnalyzer.this.analysis.getTableNodes(), (Node)node);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRefreshMaterializedView(RefreshMaterializedView node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("INSERT");
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)node.getTarget(), node.getTarget().getName());
            MaterializedViewDefinition view = MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), viewName).orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_MATERIALIZED_VIEW, (Node)node, "Materialized view '%s' does not exist", new Object[]{viewName}));
            StatementAnalyzer.this.analysis.setExpandedQuery(String.format("-- Expanded Query: %s%nINSERT INTO %s %s", SqlFormatterUtil.getFormattedSql((Statement)node, StatementAnalyzer.this.sqlParser, Optional.empty()), viewName.getObjectName(), view.getOriginalSql()));
            StatementAnalyzer.this.analysis.addAccessControlCheckForTable(AccessControlRole.TABLE_INSERT, new AccessControlInfoForTable(StatementAnalyzer.this.accessControl, MaterializedViewUtils.getOwnerIdentity(view.getOwner(), StatementAnalyzer.this.session), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), viewName));
            StatementAnalyzer viewAnalyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, (AccessControl)new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector);
            Scope viewScope = viewAnalyzer.analyze((Node)node.getTarget(), scope);
            Map<SchemaTableName, Expression> tablePredicates = RefreshMaterializedViewPredicateAnalyzer.extractTablePredicates(viewName, node.getWhere(), viewScope, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session);
            Query viewQuery = this.parseView(view.getOriginalSql(), viewName, (Node)node);
            Query refreshQuery = tablePredicates.containsKey(MetadataUtil.toSchemaTableName(viewName)) ? this.buildQueryWithPredicate(viewQuery, tablePredicates.get(MetadataUtil.toSchemaTableName(viewName))) : viewQuery;
            StatementAnalyzer queryAnalyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, MaterializedViewUtils.buildOwnerSession(StatementAnalyzer.this.session, view.getOwner(), StatementAnalyzer.this.metadata.getSessionPropertyManager(), viewName.getCatalogName(), view.getSchema()), this.warningCollector);
            queryAnalyzer.analyze((Node)refreshQuery, Scope.create());
            TableColumnMetadata tableColumnsMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), viewName);
            TableHandle tableHandle = (TableHandle)tableColumnsMetadata.getTableHandle().orElseThrow(() -> new SemanticException(SemanticErrorCode.MISSING_MATERIALIZED_VIEW, (Node)node, "Materialized view '%s' does not exist", new Object[]{viewName}));
            Map columnHandles = tableColumnsMetadata.getColumnHandles();
            List targetColumnHandles = (List)tableColumnsMetadata.getColumnsMetadata().stream().filter(column -> !column.isHidden()).map(column -> (ColumnHandle)columnHandles.get(column.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setRefreshMaterializedViewAnalysis(new Analysis.RefreshMaterializedViewAnalysis(tableHandle, targetColumnHandles, refreshQuery));
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        private Optional<RelationType> analyzeBaseTableForRefreshMaterializedView(Table baseTable, Optional<Scope> scope) {
            Preconditions.checkState((boolean)(StatementAnalyzer.this.analysis.getStatement() instanceof RefreshMaterializedView), (Object)"Not analyzing RefreshMaterializedView statement");
            RefreshMaterializedView refreshMaterializedView = (RefreshMaterializedView)StatementAnalyzer.this.analysis.getStatement();
            QualifiedObjectName viewName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)refreshMaterializedView.getTarget(), refreshMaterializedView.getTarget().getName());
            StatementAnalyzer viewAnalyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, (AccessControl)new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector);
            Scope viewScope = viewAnalyzer.analyze((Node)refreshMaterializedView.getTarget(), scope);
            Map<SchemaTableName, Expression> tablePredicates = RefreshMaterializedViewPredicateAnalyzer.extractTablePredicates(viewName, refreshMaterializedView.getWhere(), viewScope, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session);
            SchemaTableName baseTableName = MetadataUtil.toSchemaTableName(MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)baseTable, baseTable.getName()));
            if (tablePredicates.containsKey(baseTableName)) {
                Query tableSubquery = this.buildQueryWithPredicate(baseTable, tablePredicates.get(baseTableName));
                StatementAnalyzer.this.analysis.registerNamedQuery(baseTable, tableSubquery, true);
                Scope subqueryScope = this.process((Node)tableSubquery, scope);
                return Optional.of(subqueryScope.getRelationType().withAlias(baseTableName.getTableName(), null));
            }
            return Optional.empty();
        }

        private Query buildQueryWithPredicate(Table table, Expression predicate) {
            Query query = QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)table, (Expression)predicate);
            return (Query)StatementAnalyzer.this.sqlParser.createStatement(SqlFormatterUtil.getFormattedSql((Statement)query, StatementAnalyzer.this.sqlParser, Optional.empty()), AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
        }

        private Query buildQueryWithPredicate(Query originalQuery, Expression predicate) {
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), (Relation)new TableSubquery(originalQuery), (Expression)predicate);
        }

        protected Scope visitCreateFunction(CreateFunction node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setUpdateType("CREATE FUNCTION");
            this.checkFunctionName((Statement)node, node.getFunctionName(), node.isTemporary());
            if (node.isTemporary() && node.isReplace()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "REPLACE is not supported for temporary functions", new Object[0]);
            }
            List duplicateParameters = (List)node.getParameters().stream().map(SqlParameterDeclaration::getName).map(Identifier::getValue).collect(Collectors.groupingBy(Function.identity(), Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
            if (!duplicateParameters.isEmpty()) {
                throw new SemanticException(SemanticErrorCode.DUPLICATE_PARAMETER_NAME, (Node)node, "Duplicate function parameter name: %s", new Object[]{Joiner.on((String)", ").join((Iterable)duplicateParameters)});
            }
            Type returnType = StatementAnalyzer.this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)node.getReturnType()));
            List fields = (List)node.getParameters().stream().map(parameter -> Field.newUnqualified((Optional)parameter.getName().getLocation(), (String)parameter.getName().getValue(), (Type)StatementAnalyzer.this.functionAndTypeResolver.getType(TypeSignature.parseTypeSignature((String)parameter.getType())))).collect(ImmutableList.toImmutableList());
            Scope functionScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
            if (node.getBody() instanceof Return) {
                Expression returnExpression = ((Return)node.getBody()).getExpression();
                Type bodyType = (Type)this.analyzeExpression(returnExpression, functionScope).getExpressionTypes().get(NodeRef.of((Node)returnExpression));
                if (!StatementAnalyzer.this.functionAndTypeResolver.canCoerce(bodyType, returnType)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Function implementation type '%s' does not match declared return type '%s'", new Object[]{bodyType, returnType});
                }
                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, returnExpression, "CREATE FUNCTION body");
                Analyzer.verifyNoExternalFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, returnExpression, "CREATE FUNCTION body");
            }
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAlterFunction(AlterFunction node, Optional<Scope> scope) {
            this.checkFunctionName((Statement)node, node.getFunctionName(), false);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropFunction(DropFunction node, Optional<Scope> scope) {
            this.checkFunctionName((Statement)node, node.getFunctionName(), node.isTemporary());
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetSession(SetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitResetSession(ResetSession node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAddColumn(AddColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateSchema(CreateSchema node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropSchema(DropSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameSchema(RenameSchema node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCreateTable(CreateTable node, Optional<Scope> scope) {
            this.validateProperties(node.getProperties(), scope);
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitProperty(Property node, Optional<Scope> scope) {
            ExpressionAnalyzer.createConstantAnalyzer(StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters(), this.warningCollector, StatementAnalyzer.this.analysis.isDescribe()).analyze(node.getValue(), this.createScope(scope));
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitTruncateTable(TruncateTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropTable(DropTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameTable(RenameTable node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitSetProperties(SetProperties node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameColumn(RenameColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropColumn(DropColumn node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropConstraint(DropConstraint node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAddConstraint(AddConstraint node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitAlterColumnNotNull(AlterColumnNotNull node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRenameView(RenameView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropView(DropView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDropMaterializedView(DropMaterializedView node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitStartTransaction(StartTransaction node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCommit(Commit node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRollback(Rollback node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitPrepare(Prepare node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitDeallocate(Deallocate node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitExecute(Execute node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitGrant(Grant node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitRevoke(Revoke node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        protected Scope visitCall(Call node, Optional<Scope> scope) {
            return this.createAndAssignScope((Node)node, scope);
        }

        private void validateProperties(List<Property> properties, Optional<Scope> scope) {
            HashSet<String> propertyNames = new HashSet<String>();
            for (Property property : properties) {
                if (propertyNames.add(property.getName().getValue())) continue;
                throw new SemanticException(SemanticErrorCode.DUPLICATE_PROPERTY, (Node)property, "Duplicate property: %s", new Object[]{property.getName().getValue()});
            }
            for (Property property : properties) {
                this.process((Node)property, scope);
            }
        }

        private void validateColumns(Statement node, RelationType descriptor) {
            HashSet<String> names = new HashSet<String>();
            for (Field field : descriptor.getVisibleFields()) {
                Optional fieldName = field.getName();
                if (!fieldName.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)node, "Column name not specified at position %s", new Object[]{descriptor.indexOf(field) + 1});
                }
                if (!names.add((String)fieldName.get())) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)node, "Column name '%s' specified more than once", new Object[]{fieldName.get()});
                }
                if (!field.getType().equals(UnknownType.UNKNOWN)) continue;
                throw new SemanticException(SemanticErrorCode.COLUMN_TYPE_UNKNOWN, (Node)node, "Column type is unknown: %s", new Object[]{fieldName.get()});
            }
        }

        private void validateColumnAliases(List<Identifier> columnAliases, int sourceColumnSize) {
            if (columnAliases.size() != sourceColumnSize) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)columnAliases.get(0), "Column alias list has %s entries but subquery has %s columns", new Object[]{columnAliases.size(), sourceColumnSize});
            }
            HashSet<String> names = new HashSet<String>();
            for (Identifier identifier : columnAliases) {
                if (names.contains(identifier.getValueLowerCase())) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)identifier, "Column name '%s' specified more than once", new Object[]{identifier.getValue()});
                }
                names.add(identifier.getValueLowerCase());
            }
        }

        private void validateBaseTables(List<Table> baseTables, Node node) {
            for (Table baseTable : baseTables) {
                QualifiedObjectName baseName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)baseTable, baseTable.getName());
                Optional<MaterializedViewDefinition> optionalMaterializedView = MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), baseName);
                if (!optionalMaterializedView.isPresent()) continue;
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)baseTable, "%s on a materialized view %s is not supported.", new Object[]{node.getClass().getSimpleName(), baseName});
            }
        }

        protected Scope visitExplain(Explain node, Optional<Scope> scope) throws SemanticException {
            Preconditions.checkState((boolean)node.isAnalyze(), (Object)"Non analyze explain should be rewritten to Query");
            List formats = node.getOptions().stream().filter(option -> option instanceof ExplainFormat).map(ExplainFormat.class::cast).map(ExplainFormat::getType).collect(Collectors.toList());
            Preconditions.checkState((formats.size() <= 1 ? 1 : 0) != 0, (Object)"only a single format option is supported in EXPLAIN ANALYZE");
            formats.stream().findFirst().ifPresent(format -> Preconditions.checkState((format.equals((Object)ExplainFormat.Type.TEXT) || format.equals((Object)ExplainFormat.Type.JSON) ? 1 : 0) != 0, (Object)"only TEXT and JSON formats are supported in EXPLAIN ANALYZE"));
            Preconditions.checkState((boolean)node.getOptions().stream().filter(option -> option instanceof ExplainType).findFirst().map(ExplainType.class::cast).map(ExplainType::getType).orElse(ExplainType.Type.DISTRIBUTED).equals((Object)ExplainType.Type.DISTRIBUTED), (Object)"only DISTRIBUTED type is supported in EXPLAIN ANALYZE");
            this.process((Node)node.getStatement(), scope);
            StatementAnalyzer.this.analysis.setUpdateType(null);
            return this.createAndAssignScope((Node)node, scope, Field.newUnqualified((Optional)node.getLocation(), (String)"Query Plan", (Type)VarcharType.VARCHAR));
        }

        protected Scope visitQuery(Query node, Optional<Scope> scope) {
            Scope withScope = this.analyzeWith(node, scope);
            Scope queryBodyScope = this.process((Node)node.getQueryBody(), withScope);
            List<Object> orderByExpressions = Collections.emptyList();
            if (node.getOrderBy().isPresent()) {
                orderByExpressions = this.analyzeOrderBy((Node)node, NodeUtils.getSortItemsFromOrderBy(node.getOrderBy()), queryBodyScope);
                if (queryBodyScope.getOuterQueryParent().isPresent() && !node.getLimit().isPresent()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy((OrderBy)node.getOrderBy().get());
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get());
            }
            StatementAnalyzer.this.analysis.setOutputExpressions((Node)node, this.descriptorToFields(queryBodyScope));
            Scope queryScope = Scope.builder().withParent(withScope).withRelationType(RelationId.of((Node)node), queryBodyScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, queryScope);
            return queryScope;
        }

        protected Scope visitUnnest(Unnest node, Optional<Scope> scope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (Expression expression : node.getExpressions()) {
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, this.createScope(scope));
                if (!expressionAnalysis.getScalarSubqueries().isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Scalar subqueries in UNNEST are not supported", new Object[0]);
                }
                Type expressionType = expressionAnalysis.getType(expression);
                if (expressionType instanceof ArrayType) {
                    Type elementType = ((ArrayType)expressionType).getElementType();
                    if (!SystemSessionProperties.isLegacyUnnest(StatementAnalyzer.this.session) && elementType instanceof RowType) {
                        ((RowType)elementType).getFields().stream().map(field -> Field.newUnqualified((Optional)expression.getLocation(), (Optional)field.getName(), (Type)field.getType())).forEach(arg_0 -> ((ImmutableList.Builder)outputFields).add(arg_0));
                        continue;
                    }
                    outputFields.add((Object)Field.newUnqualified((Optional)expression.getLocation(), Optional.empty(), (Type)elementType));
                    continue;
                }
                if (expressionType instanceof MapType) {
                    outputFields.add((Object)Field.newUnqualified((Optional)expression.getLocation(), Optional.empty(), (Type)((MapType)expressionType).getKeyType()));
                    outputFields.add((Object)Field.newUnqualified((Optional)expression.getLocation(), Optional.empty(), (Type)((MapType)expressionType).getValueType()));
                    continue;
                }
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Cannot unnest type: " + expressionType);
            }
            if (node.isWithOrdinality()) {
                outputFields.add((Object)Field.newUnqualified((Optional)node.getLocation(), Optional.empty(), (Type)BigintType.BIGINT));
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        protected Scope visitLateral(Lateral node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitTable(Table table, Optional<Scope> scope) {
            Table view;
            String name;
            if (!table.getName().getPrefix().isPresent()) {
                name = table.getName().getSuffix();
                Optional withQuery = this.createScope(scope).getNamedQuery(name);
                if (withQuery.isPresent()) {
                    List fields;
                    Query query = ((WithQuery)withQuery.get()).getQuery();
                    StatementAnalyzer.this.analysis.registerNamedQuery(table, query, false);
                    RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
                    Optional columnNames = ((WithQuery)withQuery.get()).getColumnNames();
                    if (columnNames.isPresent()) {
                        ImmutableList.Builder fieldBuilder = ImmutableList.builder();
                        Iterator visibleFieldsIterator = queryDescriptor.getVisibleFields().iterator();
                        for (Identifier columnName : (List)columnNames.get()) {
                            Field inputField = (Field)visibleFieldsIterator.next();
                            fieldBuilder.add((Object)Field.newQualified((Optional)columnName.getLocation(), (QualifiedName)QualifiedName.of((String)name), Optional.of(columnName.getValue()), (Type)inputField.getType(), (boolean)false, (Optional)inputField.getOriginTable(), (Optional)inputField.getOriginColumnName(), (boolean)inputField.isAliased()));
                        }
                        fields = fieldBuilder.build();
                    } else {
                        fields = (List)queryDescriptor.getAllFields().stream().map(field -> Field.newQualified((Optional)field.getNodeLocation(), (QualifiedName)QualifiedName.of((String)name), (Optional)field.getName(), (Type)field.getType(), (boolean)field.isHidden(), (Optional)field.getOriginTable(), (Optional)field.getOriginColumnName(), (boolean)field.isAliased())).collect(ImmutableList.toImmutableList());
                    }
                    return this.createAndAssignScope((Node)table, scope, fields);
                }
            }
            if ((name = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName())).getObjectName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)table, "Table name is empty", new Object[0]);
            }
            if (name.getSchemaName().isEmpty()) {
                throw new SemanticException(SemanticErrorCode.MISSING_SCHEMA, (Node)table, "Schema name is empty", new Object[0]);
            }
            StatementAnalyzer.this.analysis.addEmptyColumnReferencesForTable(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), (QualifiedObjectName)name);
            Optional<ViewDefinition> optionalView = MetadataUtils.getViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), (QualifiedObjectName)name);
            if (optionalView.isPresent()) {
                return this.processView(table, scope, (QualifiedObjectName)name, optionalView);
            }
            Optional<MaterializedViewDefinition> optionalMaterializedView = MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), (QualifiedObjectName)name);
            if (optionalMaterializedView.isPresent() && (StatementAnalyzer.this.analysis.getStatement() instanceof Insert || StatementAnalyzer.this.analysis.getStatement() instanceof CreateTableAsSelect)) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)table, "%s by selecting from a materialized view %s is not supported", new Object[]{StatementAnalyzer.this.analysis.getStatement().getClass().getSimpleName(), optionalMaterializedView.get().getTable()});
            }
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (SystemSessionProperties.isMaterializedViewDataConsistencyEnabled(StatementAnalyzer.this.session) && optionalMaterializedView.isPresent() && statement instanceof Query) {
                Analysis.MaterializedViewAnalysisState materializedViewAnalysisState = StatementAnalyzer.this.analysis.getMaterializedViewAnalysisState(table);
                if (materializedViewAnalysisState.isNotVisited()) {
                    return this.processMaterializedView(table, (QualifiedObjectName)name, scope, optionalMaterializedView.get());
                }
                if (materializedViewAnalysisState.isVisited()) {
                    throw new SemanticException(SemanticErrorCode.MATERIALIZED_VIEW_IS_RECURSIVE, (Node)table, "Materialized view is recursive", new Object[0]);
                }
            }
            TableColumnMetadata tableColumnsMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), (QualifiedObjectName)name);
            List columnsMetadata = tableColumnsMetadata.getColumnsMetadata();
            Optional<TableHandle> tableHandle = this.getTableHandle(tableColumnsMetadata, table, (QualifiedObjectName)name, scope);
            Map columnHandles = tableColumnsMetadata.getColumnHandles();
            ImmutableList.Builder fields = ImmutableList.builder();
            for (ColumnMetadata column : columnsMetadata) {
                Field field2 = Field.newQualified(Optional.empty(), (QualifiedName)table.getName(), Optional.of(column.getName()), (Type)column.getType(), (boolean)column.isHidden(), Optional.of(name), Optional.of(column.getName()), (boolean)false);
                fields.add((Object)field2);
                ColumnHandle columnHandle = (ColumnHandle)columnHandles.get(column.getName());
                Preconditions.checkArgument((columnHandle != null ? 1 : 0) != 0, (String)"Unknown field %s", (Object)field2);
                StatementAnalyzer.this.analysis.setColumn(field2, columnHandle);
            }
            StatementAnalyzer.this.analysis.registerTable(table, tableHandle.get());
            ImmutableList outputFields = fields.build();
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType((List)outputFields)).build();
            this.analyzeFiltersAndMasks(table, (QualifiedObjectName)name, accessControlScope, columnsMetadata);
            StatementAnalyzer.this.analysis.registerTable(table, tableHandle.get());
            if (statement instanceof RefreshMaterializedView && !table.equals((Object)(view = ((RefreshMaterializedView)statement).getTarget())) && !StatementAnalyzer.this.analysis.hasTableRegisteredForMaterializedView(view, table)) {
                StatementAnalyzer.this.analysis.registerTableForMaterializedView(view, table);
                Optional<RelationType> descriptor = this.analyzeBaseTableForRefreshMaterializedView(table, scope);
                StatementAnalyzer.this.analysis.unregisterTableForMaterializedView(view, table);
                if (descriptor.isPresent()) {
                    return this.createAndAssignScope((Node)table, scope, descriptor.get());
                }
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)outputFields);
        }

        private Optional<TableHandle> getTableHandle(TableColumnMetadata tableColumnsMetadata, Table table, QualifiedObjectName name, Optional<Scope> scope) {
            if (table.getTableVersionExpression().isPresent()) {
                return this.processTableVersion(table, name, scope);
            }
            return tableColumnsMetadata.getTableHandle();
        }

        private ConnectorTableVersion.VersionOperator toVersionOperator(TableVersionExpression.TableVersionOperator operator) {
            switch (operator) {
                case EQUAL: {
                    return ConnectorTableVersion.VersionOperator.EQUAL;
                }
                case LESS_THAN: {
                    return ConnectorTableVersion.VersionOperator.LESS_THAN;
                }
            }
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, "Table version operator %s not supported." + operator, new Object[0]);
        }

        private ConnectorTableVersion.VersionType toVersionType(TableVersionExpression.TableVersionType type) {
            switch (type) {
                case TIMESTAMP: {
                    return ConnectorTableVersion.VersionType.TIMESTAMP;
                }
                case VERSION: {
                    return ConnectorTableVersion.VersionType.VERSION;
                }
            }
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, "Table version type %s not supported." + type, new Object[0]);
        }

        private Optional<TableHandle> processTableVersion(Table table, QualifiedObjectName name, Optional<Scope> scope) {
            Expression stateExpr = ((TableVersionExpression)table.getTableVersionExpression().get()).getStateExpression();
            TableVersionExpression.TableVersionType tableVersionType = ((TableVersionExpression)table.getTableVersionExpression().get()).getTableVersionType();
            TableVersionExpression.TableVersionOperator tableVersionOperator = ((TableVersionExpression)table.getTableVersionExpression().get()).getTableVersionOperator();
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(stateExpr, scope.get());
            StatementAnalyzer.this.analysis.recordSubqueries((Node)table, expressionAnalysis);
            Type stateExprType = expressionAnalysis.getType(stateExpr);
            if (stateExprType == UnknownType.UNKNOWN) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ARGUMENTS, String.format("Table version AS OF/BEFORE expression cannot be NULL for %s", name.toString()));
            }
            Object evalStateExpr = ExpressionInterpreter.evaluateConstantExpression(stateExpr, stateExprType, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters());
            if (tableVersionType == TableVersionExpression.TableVersionType.TIMESTAMP && !(stateExprType instanceof TimestampWithTimeZoneType) && !(stateExprType instanceof TimestampType)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)stateExpr, "Type %s is invalid. Supported table version AS OF/BEFORE expression type is Timestamp or Timestamp with Time Zone.", new Object[]{stateExprType.getDisplayName()});
            }
            if (tableVersionType == TableVersionExpression.TableVersionType.VERSION && !(stateExprType instanceof BigintType) && !(stateExprType instanceof VarcharType)) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)stateExpr, "Type %s is invalid. Supported table version AS OF/BEFORE expression type is BIGINT or VARCHAR", new Object[]{stateExprType.getDisplayName()});
            }
            ConnectorTableVersion tableVersion = new ConnectorTableVersion(this.toVersionType(tableVersionType), this.toVersionOperator(tableVersionOperator), stateExprType, evalStateExpr);
            return StatementAnalyzer.this.metadata.getHandleVersion(StatementAnalyzer.this.session, name, Optional.of(tableVersion));
        }

        private Scope getScopeFromTable(Table table, Optional<Scope> scope) {
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            TableColumnMetadata tableColumnsMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), tableName);
            ImmutableList.Builder fields = ImmutableList.builder();
            List columnsMetadata = tableColumnsMetadata.getColumnsMetadata();
            for (ColumnMetadata columnMetadata : columnsMetadata) {
                Field field = Field.newQualified(Optional.empty(), (QualifiedName)table.getName(), Optional.of(columnMetadata.getName()), (Type)columnMetadata.getType(), (boolean)columnMetadata.isHidden(), Optional.of(tableName), Optional.of(columnMetadata.getName()), (boolean)false);
                fields.add((Object)field);
            }
            return this.createAndAssignScope((Node)table, scope, (List<Field>)fields.build());
        }

        private Scope processView(Table table, Optional<Scope> scope, QualifiedObjectName name, Optional<ViewDefinition> optionalView) {
            Statement statement = StatementAnalyzer.this.analysis.getStatement();
            if (statement instanceof CreateView) {
                CreateView viewStatement = (CreateView)statement;
                QualifiedObjectName viewNameFromStatement = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)viewStatement, viewStatement.getName());
                if (viewStatement.isReplace() && viewNameFromStatement.equals((Object)name)) {
                    throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "Statement would create a recursive view", new Object[0]);
                }
            }
            if (StatementAnalyzer.this.analysis.hasTableInView(table)) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_RECURSIVE, (Node)table, "View is recursive", new Object[0]);
            }
            ViewDefinition view = optionalView.get();
            StatementAnalyzer.this.analysis.getAccessControlReferences().addViewDefinitionReference(name, view);
            Query query = this.parseView(view.getOriginalSql(), name, (Node)table);
            StatementAnalyzer.this.analysis.registerNamedQuery(table, query, true);
            StatementAnalyzer.this.analysis.registerTableForView(table);
            RelationType descriptor = this.analyzeView(query, name, view.getCatalog(), view.getSchema(), view.getOwner(), table);
            StatementAnalyzer.this.analysis.unregisterTableForView();
            if (this.isViewStale(view.getColumns(), descriptor.getVisibleFields())) {
                throw new SemanticException(SemanticErrorCode.VIEW_IS_STALE, (Node)table, "View '%s' is stale; it must be re-created", new Object[]{name});
            }
            List outputFields = (List)view.getColumns().stream().map(column -> Field.newQualified((Optional)table.getLocation(), (QualifiedName)table.getName(), Optional.of(column.getName()), (Type)column.getType(), (boolean)false, Optional.of(name), Optional.of(column.getName()), (boolean)false)).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.addRelationCoercion((Relation)table, (Type[])outputFields.stream().map(Field::getType).toArray(Type[]::new));
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(outputFields)).build();
            this.analyzeFiltersAndMasks(table, name, accessControlScope, outputFields);
            return this.createAndAssignScope((Node)table, scope, outputFields);
        }

        private Scope processMaterializedView(Table materializedView, QualifiedObjectName materializedViewName, Optional<Scope> scope, MaterializedViewDefinition materializedViewDefinition) {
            MaterializedViewPlanValidator.validate((Query)StatementAnalyzer.this.sqlParser.createStatement(materializedViewDefinition.getOriginalSql(), AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector)));
            StatementAnalyzer.this.analysis.getAccessControlReferences().addMaterializedViewDefinitionReference(materializedViewName, materializedViewDefinition);
            StatementAnalyzer.this.analysis.registerMaterializedViewForAnalysis(materializedViewName, materializedView, materializedViewDefinition.getOriginalSql());
            String newSql = this.getMaterializedViewSQL(materializedView, materializedViewName, materializedViewDefinition, scope);
            Query query = (Query)StatementAnalyzer.this.sqlParser.createStatement(newSql, AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            StatementAnalyzer.this.analysis.registerNamedQuery(materializedView, query, true);
            Scope queryScope = this.process((Node)query, scope);
            RelationType relationType = queryScope.getRelationType().withAlias(materializedViewName.getObjectName(), null);
            StatementAnalyzer.this.analysis.unregisterMaterializedViewForAnalysis(materializedView);
            Scope accessControlScope = Scope.builder().withRelationType(RelationId.anonymous(), relationType).build();
            this.analyzeFiltersAndMasks(materializedView, materializedViewName, accessControlScope, relationType.getAllFields());
            return this.createAndAssignScope((Node)materializedView, scope, relationType);
        }

        private String getMaterializedViewSQL(Table materializedView, QualifiedObjectName materializedViewName, MaterializedViewDefinition materializedViewDefinition, Optional<Scope> scope) {
            MaterializedViewStatus materializedViewStatus = this.getMaterializedViewStatus(materializedViewName, scope, materializedView);
            String materializedViewCreateSql = materializedViewDefinition.getOriginalSql();
            if (materializedViewStatus.isNotMaterialized() || materializedViewStatus.isTooManyPartitionsMissing()) {
                StatementAnalyzer.this.session.getRuntimeStats().addMetricValue("skipReadingFromMaterializedViewCount", RuntimeUnit.NONE, 1L);
                return materializedViewCreateSql;
            }
            Statement createSqlStatement = StatementAnalyzer.this.sqlParser.createStatement(materializedViewCreateSql, AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            Map<Object, Object> baseTablePredicates = Collections.emptyMap();
            if (materializedViewStatus.isFullyMaterialized()) {
                baseTablePredicates = MaterializedViewUtils.generateFalsePredicates(materializedViewDefinition.getBaseTables());
            } else if (materializedViewStatus.isPartiallyMaterialized()) {
                baseTablePredicates = MaterializedViewUtils.generateBaseTablePredicates(materializedViewStatus.getPartitionsFromBaseTables(), StatementAnalyzer.this.metadata);
            }
            Query predicateStitchedQuery = (Query)new PredicateStitcher(StatementAnalyzer.this.session, baseTablePredicates).process((Node)createSqlStatement, new PredicateStitcher.PredicateStitcherContext());
            QuerySpecification materializedViewQuerySpecification = new QuerySpecification(QueryUtil.selectList((SelectItem[])new SelectItem[]{new AllColumns()}), Optional.of(materializedView), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
            Union union = new Union((List)ImmutableList.of((Object)predicateStitchedQuery.getQueryBody(), (Object)materializedViewQuerySpecification), Optional.of(Boolean.FALSE));
            Query unionQuery = new Query(predicateStitchedQuery.getWith(), (QueryBody)union, predicateStitchedQuery.getOrderBy(), predicateStitchedQuery.getOffset(), predicateStitchedQuery.getLimit());
            return SqlFormatterUtil.getFormattedSql((Statement)unionQuery, StatementAnalyzer.this.sqlParser, Optional.empty());
        }

        private MaterializedViewStatus getMaterializedViewStatus(QualifiedObjectName materializedViewName, Optional<Scope> scope, Table table) {
            TupleDomain baseQueryDomain = TupleDomain.all();
            Preconditions.checkArgument((boolean)StatementAnalyzer.this.analysis.getCurrentQuerySpecification().isPresent(), (Object)"Current subquery should be set when processing materialized view");
            QuerySpecification currentSubquery = (QuerySpecification)StatementAnalyzer.this.analysis.getCurrentQuerySpecification().get();
            if (currentSubquery.getWhere().isPresent() && SystemSessionProperties.isMaterializedViewPartitionFilteringEnabled(StatementAnalyzer.this.session)) {
                Optional<MaterializedViewDefinition> materializedViewDefinition = MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, StatementAnalyzer.this.analysis.getMetadataHandle(), materializedViewName);
                if (!materializedViewDefinition.isPresent()) {
                    log.warn("Materialized view definition not present as expected when fetching materialized view status");
                    return StatementAnalyzer.this.metadataResolver.getMaterializedViewStatus(materializedViewName, baseQueryDomain);
                }
                Scope sourceScope = this.getScopeFromTable(table, scope);
                Expression viewQueryWhereClause = (Expression)currentSubquery.getWhere().get();
                this.analyzeWhere((Node)currentSubquery, sourceScope, viewQueryWhereClause);
                RowExpressionDomainTranslator domainTranslator = new RowExpressionDomainTranslator(StatementAnalyzer.this.metadata);
                RowExpression rowExpression = SqlToRowExpressionTranslator.translate(viewQueryWhereClause, StatementAnalyzer.this.analysis.getTypes(), (Map<VariableReferenceExpression, Integer>)ImmutableMap.of(), StatementAnalyzer.this.metadata.getFunctionAndTypeManager(), StatementAnalyzer.this.session);
                TupleDomain<String> viewQueryDomain = MaterializedViewUtils.getDomainFromFilter(StatementAnalyzer.this.session, domainTranslator, rowExpression);
                Map directColumnMappings = materializedViewDefinition.get().getDirectColumnMappingsAsMap();
                boolean mappedToOneTable = true;
                HashMap<String, Domain> rewrittenDomain = new HashMap<String, Domain>();
                for (Map.Entry entry : ((Map)viewQueryDomain.getDomains().orElse(ImmutableMap.of())).entrySet()) {
                    Map baseTableMapping = (Map)directColumnMappings.get(entry.getKey());
                    if (baseTableMapping == null || baseTableMapping.size() != 1) {
                        mappedToOneTable = false;
                        break;
                    }
                    String baseColumnName = (String)((Map.Entry)baseTableMapping.entrySet().stream().findAny().get()).getValue();
                    rewrittenDomain.put(baseColumnName, (Domain)entry.getValue());
                }
                if (mappedToOneTable) {
                    baseQueryDomain = TupleDomain.withColumnDomains(rewrittenDomain);
                }
            }
            return StatementAnalyzer.this.metadataResolver.getMaterializedViewStatus(materializedViewName, baseQueryDomain);
        }

        protected Scope visitAliasedRelation(AliasedRelation relation, Optional<Scope> scope) {
            int totalColumns;
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            RelationType relationType = relationScope.getRelationType();
            if (relation.getColumnNames() != null && (totalColumns = relationType.getVisibleFieldCount()) != relation.getColumnNames().size()) {
                throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)relation, "Column alias list has %s entries but '%s' has %s columns available", new Object[]{relation.getColumnNames().size(), relation.getAlias(), totalColumns});
            }
            List aliases = null;
            if (relation.getColumnNames() != null) {
                aliases = relation.getColumnNames().stream().map(Identifier::getValue).collect(Collectors.toList());
            }
            RelationType descriptor = relationType.withAlias(relation.getAlias().getValue(), aliases);
            return this.createAndAssignScope((Node)relation, scope, descriptor);
        }

        protected Scope visitSampledRelation(SampledRelation relation, Optional<Scope> scope) {
            if (!VariablesExtractor.extractNames(relation.getSamplePercentage(), StatementAnalyzer.this.analysis.getColumnReferences()).isEmpty()) {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            }
            Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypes(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, TypeProvider.empty(), relation.getSamplePercentage(), (Map<NodeRef<Parameter>, Expression>)StatementAnalyzer.this.analysis.getParameters(), this.warningCollector, StatementAnalyzer.this.analysis.isDescribe());
            ExpressionInterpreter samplePercentageEval = ExpressionInterpreter.expressionOptimizer(relation.getSamplePercentage(), StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, expressionTypes);
            Object samplePercentageObject = samplePercentageEval.optimize(symbol -> {
                throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage cannot contain column references", new Object[0]);
            });
            try {
                samplePercentageObject = ExpressionInterpreter.evaluateConstantExpression(relation.getSamplePercentage(), (Type)DoubleType.DOUBLE, StatementAnalyzer.this.metadata, StatementAnalyzer.this.session, StatementAnalyzer.this.analysis.getParameters());
            }
            catch (SemanticException e) {
                if (e.getCode() == SemanticErrorCode.TYPE_MISMATCH) {
                    throw new SemanticException(SemanticErrorCode.NON_NUMERIC_SAMPLE_PERCENTAGE, (Node)relation.getSamplePercentage(), "Sample percentage should evaluate to a double", new Object[0]);
                }
                throw e;
            }
            double samplePercentageValue = (Double)samplePercentageObject;
            if (samplePercentageValue < 0.0) {
                throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be greater than or equal to 0", new Object[0]);
            }
            if (samplePercentageValue > 100.0) {
                throw new SemanticException(SemanticErrorCode.SAMPLE_PERCENTAGE_OUT_OF_RANGE, (Node)relation.getSamplePercentage(), "Sample percentage must be less than or equal to 100", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setSampleRatio(relation, samplePercentageValue / 100.0);
            Scope relationScope = this.process((Node)relation.getRelation(), scope);
            return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType());
        }

        protected Scope visitTableSubquery(TableSubquery node, Optional<Scope> scope) {
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session, this.warningCollector);
            Scope queryScope = analyzer.analyze((Node)node.getQuery(), scope);
            return this.createAndAssignScope((Node)node, scope, queryScope.getRelationType());
        }

        protected Scope visitQuerySpecification(QuerySpecification node, Optional<Scope> scope) {
            StatementAnalyzer.this.analysis.setCurrentSubquery(node);
            Scope sourceScope = this.analyzeFrom(node, scope);
            if (node.getWhere().isPresent()) {
                Expression predicate = (Expression)node.getWhere().get();
                if (StatementAnalyzer.this.analysis.getWhere(node) == null) {
                    this.analyzeWhere((Node)node, sourceScope, predicate);
                }
            }
            List<Expression> outputExpressions = this.analyzeSelect(node, sourceScope);
            List<Expression> groupByExpressions = this.analyzeGroupBy(node, sourceScope, outputExpressions);
            this.analyzeHaving(node, sourceScope);
            Scope outputScope = this.computeAndAssignOutputScope(node, scope, sourceScope);
            List<Expression> orderByExpressions = Collections.emptyList();
            Optional<Object> orderByScope = Optional.empty();
            if (node.getOrderBy().isPresent()) {
                if (node.getSelect().isDistinct()) {
                    this.verifySelectDistinct(node, outputExpressions);
                }
                OrderBy orderBy = (OrderBy)node.getOrderBy().get();
                orderByScope = Optional.of(this.computeAndAssignOrderByScope(orderBy, sourceScope, outputScope));
                orderByExpressions = this.analyzeOrderBy((Node)node, orderBy.getSortItems(), (Scope)orderByScope.get());
                if (sourceScope.getOuterQueryParent().isPresent() && !node.getLimit().isPresent()) {
                    StatementAnalyzer.this.analysis.markRedundantOrderBy(orderBy);
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.REDUNDANT_ORDER_BY, "ORDER BY in subquery may have no effect"));
                }
            }
            if (node.getOffset().isPresent()) {
                this.analyzeOffset((Offset)node.getOffset().get());
            }
            StatementAnalyzer.this.analysis.setOrderByExpressions((Node)node, orderByExpressions);
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>(outputExpressions);
            node.getHaving().ifPresent(sourceExpressions::add);
            this.analyzeGroupingOperations(node, sourceExpressions, orderByExpressions);
            List<FunctionCall> aggregates = this.analyzeAggregations(node, sourceExpressions, orderByExpressions);
            if (!aggregates.isEmpty() && groupByExpressions.isEmpty()) {
                StatementAnalyzer.this.analysis.setGroupByExpressions(node, (List)ImmutableList.of());
            }
            this.verifyAggregations(node, sourceScope, orderByScope, groupByExpressions, sourceExpressions, orderByExpressions);
            this.analyzeWindowFunctions(node, outputExpressions, orderByExpressions);
            if (StatementAnalyzer.this.analysis.isAggregation(node) && node.getOrderBy().isPresent()) {
                List<GroupingOperation> orderByGroupingOperations = ExpressionTreeUtils.extractExpressions(orderByExpressions, GroupingOperation.class);
                List<FunctionCall> orderByAggregations = ExpressionTreeUtils.extractAggregateFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), orderByExpressions, StatementAnalyzer.this.functionAndTypeResolver);
                this.computeAndAssignOrderByScopeWithAggregation((OrderBy)node.getOrderBy().get(), sourceScope, outputScope, orderByAggregations, groupByExpressions, orderByGroupingOperations);
            }
            return outputScope;
        }

        protected Scope visitSetOperation(SetOperation node, Optional<Scope> scope) {
            int i;
            Preconditions.checkState((node.getRelations().size() >= 2 ? 1 : 0) != 0);
            List relationScopes = (List)node.getRelations().stream().map(relation -> {
                Scope relationScope = this.process((Node)relation, scope);
                return this.createAndAssignScope((Node)relation, scope, relationScope.getRelationType().withOnlyVisibleFields());
            }).collect(ImmutableList.toImmutableList());
            Type[] outputFieldTypes = (Type[])((Scope)relationScopes.get(0)).getRelationType().getVisibleFields().stream().map(Field::getType).toArray(Type[]::new);
            int outputFieldSize = outputFieldTypes.length;
            if (this.isExpensiveUnionDistinct(node, outputFieldTypes)) {
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, String.format("UNION DISTINCT query should consider avoiding double/real/complex types and reducing the number of visible fields (%d) to %d", outputFieldSize, 3)));
            }
            for (Scope relationScope : relationScopes) {
                RelationType relationType = relationScope.getRelationType();
                int descFieldSize = relationType.getVisibleFields().size();
                String setOperationName = node.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
                if (outputFieldSize != descFieldSize) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "%s query has different number of fields: %d, %d", new Object[]{setOperationName, outputFieldSize, descFieldSize});
                }
                for (int i2 = 0; i2 < descFieldSize; ++i2) {
                    Type descFieldType = relationType.getFieldByIndex(i2).getType();
                    Optional commonSuperType = StatementAnalyzer.this.functionAndTypeResolver.getCommonSuperType(outputFieldTypes[i2], descFieldType);
                    if (!commonSuperType.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "column %d in %s query has incompatible types: %s, %s", new Object[]{i2 + 1, setOperationName, outputFieldTypes[i2].getDisplayName(), descFieldType.getDisplayName()});
                    }
                    outputFieldTypes[i2] = (Type)commonSuperType.get();
                }
            }
            Field[] outputDescriptorFields = new Field[outputFieldTypes.length];
            RelationType firstDescriptor = ((Scope)relationScopes.get(0)).getRelationType().withOnlyVisibleFields();
            for (i = 0; i < outputFieldTypes.length; ++i) {
                Field oldField = firstDescriptor.getFieldByIndex(i);
                outputDescriptorFields[i] = new Field(oldField.getNodeLocation(), oldField.getRelationAlias(), oldField.getName(), outputFieldTypes[i], oldField.isHidden(), oldField.getOriginTable(), oldField.getOriginColumnName(), oldField.isAliased());
            }
            block3: for (i = 0; i < node.getRelations().size(); ++i) {
                Relation relation2 = (Relation)node.getRelations().get(i);
                Scope relationScope = (Scope)relationScopes.get(i);
                RelationType relationType = relationScope.getRelationType();
                for (int j = 0; j < relationType.getVisibleFields().size(); ++j) {
                    Type outputFieldType = outputFieldTypes[j];
                    Type descFieldType = relationType.getFieldByIndex(j).getType();
                    if (outputFieldType.equals(descFieldType)) continue;
                    StatementAnalyzer.this.analysis.addRelationCoercion(relation2, outputFieldTypes);
                    continue block3;
                }
            }
            return this.createAndAssignScope((Node)node, scope, outputDescriptorFields);
        }

        private boolean isExpensiveUnionDistinct(SetOperation setOperation, Type[] outputTypes) {
            return setOperation instanceof Union && setOperation.isDistinct().orElse(false) != false && outputTypes.length > 3 && Arrays.stream(outputTypes).anyMatch(type -> type instanceof RealType || type instanceof DoubleType || type instanceof MapType || type instanceof ArrayType || type instanceof RowType);
        }

        protected Scope visitUnion(Union node, Optional<Scope> scope) {
            if (!node.isDistinct().isPresent()) {
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, "UNION specified without ALL or DISTINCT keyword is equivalent to UNION DISTINCT, which is computationally expensive. Consider using UNION ALL when possible, or specifically add the keyword DISTINCT if absolutely necessary"));
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        protected Scope visitIntersect(Intersect node, Optional<Scope> scope) {
            if (!node.isDistinct().orElse(true).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "INTERSECT ALL not yet implemented", new Object[0]);
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        protected Scope visitExcept(Except node, Optional<Scope> scope) {
            if (!node.isDistinct().orElse(true).booleanValue()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "EXCEPT ALL not yet implemented", new Object[0]);
            }
            return this.visitSetOperation((SetOperation)node, scope);
        }

        private boolean isJoinOnConditionReferencesRelatedFields(Expression expression, Scope leftScope, Scope rightScope) {
            return ExpressionUtils.extractDisjuncts(expression).stream().allMatch(disjunct -> {
                List<DereferenceExpression> dereferenceExpressions = ExpressionTreeUtils.extractExpressions(Arrays.asList(disjunct), DereferenceExpression.class);
                List<Identifier> identifiers = ExpressionTreeUtils.extractExpressions(Arrays.asList(disjunct), Identifier.class);
                boolean isJoinOnConditionReferencedVariableInLeftScope = dereferenceExpressions.stream().anyMatch(expr -> rightScope.tryResolveField((Expression)expr).isPresent()) || identifiers.stream().anyMatch(expr -> rightScope.tryResolveField((Expression)expr).isPresent());
                boolean isJoinOnConditionReferencedVariableInRightScope = dereferenceExpressions.stream().anyMatch(expr -> leftScope.tryResolveField((Expression)expr).isPresent()) || identifiers.stream().anyMatch(expr -> leftScope.tryResolveField((Expression)expr).isPresent());
                return isJoinOnConditionReferencedVariableInLeftScope && isJoinOnConditionReferencedVariableInRightScope;
            });
        }

        protected Scope visitJoin(Join node, Optional<Scope> scope) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            JoinCriteria criteria = node.getCriteria().orElse(null);
            if (criteria instanceof NaturalJoin) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "Natural join not supported", new Object[0]);
            }
            Scope left = this.process((Node)node.getLeft(), scope);
            Scope right = this.process((Node)node.getRight(), this.isLateralRelation(node.getRight()) ? Optional.of(left) : scope);
            if (criteria instanceof JoinUsing) {
                return this.analyzeJoinUsing(node, ((JoinUsing)criteria).getColumns(), scope, left, right);
            }
            Scope output = this.createAndAssignScope((Node)node, scope, left.getRelationType().joinWith(right.getRelationType()));
            if (node.getType() == Join.Type.CROSS || node.getType() == Join.Type.IMPLICIT) {
                return output;
            }
            if (criteria instanceof JoinOn) {
                expression = ((JoinOn)criteria).getExpression();
                expressionAnalysis = this.analyzeExpression(expression, output);
                Type clauseType = expressionAnalysis.getType(expression);
                if (!clauseType.equals(BooleanType.BOOLEAN)) {
                    if (!clauseType.equals(UnknownType.UNKNOWN)) {
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)expression, "JOIN ON clause must evaluate to a boolean: actual type %s", new Object[]{clauseType});
                    }
                    StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, false);
                }
                if (expression instanceof LogicalBinaryExpression && ((LogicalBinaryExpression)expression).getOperator() == LogicalBinaryExpression.Operator.OR) {
                    String warningMessage = this.createWarningMessage((Node)expression, "JOIN conditions with an OR can cause performance issues as it may lead to a cross join with filter");
                    this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, warningMessage));
                }
            } else {
                throw new UnsupportedOperationException("unsupported join criteria: " + criteria.getClass().getName());
            }
            this.verifyJoinOnConditionReferencesRelatedFields(left, right, expression, node.getRight());
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, expression, "JOIN clause");
            StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
            StatementAnalyzer.this.analysis.setJoinCriteria(node, expression);
            return output;
        }

        private void verifyJoinOnConditionReferencesRelatedFields(Scope leftScope, Scope rightScope, Expression expression, Relation rightRelation) {
            if (!this.isJoinOnConditionReferencesRelatedFields(expression, leftScope, rightScope)) {
                Optional<String> tableName = this.tryGetTableName(rightRelation);
                String warningMessage = tableName.isPresent() ? this.createWarningMessage((Node)expression, String.format("JOIN ON condition(s) do not reference the joined table '%s' and other tables in the same expression that can cause performance issues as it may lead to a cross join with filter", tableName.get())) : this.createWarningMessage((Node)expression, "JOIN ON condition(s) do not reference the joined relation and other relation in the same expression that can cause performance issues as it may lead to a cross join with filter");
                this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, warningMessage));
            }
        }

        private Optional<String> tryGetTableName(Relation relation) {
            AliasedRelation aliasedRelation;
            if (relation instanceof Table) {
                return Optional.of(((Table)relation).getName().toString());
            }
            if (relation instanceof AliasedRelation && (aliasedRelation = (AliasedRelation)relation).getRelation() instanceof Table) {
                return Optional.of(((Table)aliasedRelation.getRelation()).getName().toString());
            }
            return Optional.empty();
        }

        private String createWarningMessage(Node node, String description) {
            NodeLocation nodeLocation = (NodeLocation)node.getLocation().get();
            return String.format("line %s:%s: %s", nodeLocation.getLineNumber(), nodeLocation.getColumnNumber(), description);
        }

        protected Scope visitUpdate(Update update, Optional<Scope> scope) {
            Table table = update.getTable();
            QualifiedObjectName tableName = MetadataUtil.createQualifiedObjectName(StatementAnalyzer.this.session, (Node)table, table.getName());
            MetadataHandle metadataHandle = StatementAnalyzer.this.analysis.getMetadataHandle();
            if (MetadataUtils.getViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)update, "Updating into views is not supported", new Object[0]);
            }
            if (MetadataUtils.getMaterializedViewDefinition(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName).isPresent()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)update, "Updating into materialized views is not supported", new Object[0]);
            }
            TableColumnMetadata tableMetadata = MetadataUtils.getTableColumnsMetadata(StatementAnalyzer.this.session, StatementAnalyzer.this.metadataResolver, metadataHandle, tableName);
            List allColumns = tableMetadata.getColumnsMetadata();
            Map columns = (Map)allColumns.stream().collect(ImmutableMap.toImmutableMap(ColumnMetadata::getName, Function.identity()));
            for (UpdateAssignment assignment2 : update.getAssignments()) {
                String columnName = assignment2.getName().getValue();
                if (columns.containsKey(columnName)) continue;
                throw new SemanticException(SemanticErrorCode.MISSING_COLUMN, (Node)assignment2.getName(), "The UPDATE SET target column %s doesn't exist", new Object[]{columnName});
            }
            Set assignmentTargets = (Set)update.getAssignments().stream().map(assignment -> assignment.getName().getValue()).collect(ImmutableSet.toImmutableSet());
            StatementAnalyzer.this.accessControl.checkCanUpdateTableColumns(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), tableName, assignmentTargets);
            List updatedColumns = (List)allColumns.stream().filter(column -> assignmentTargets.contains(column.getName())).collect(ImmutableList.toImmutableList());
            StatementAnalyzer.this.analysis.setUpdateType("UPDATE");
            StatementAnalyzer.this.analysis.setUpdatedColumns(updatedColumns);
            StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, (AccessControl)new AllowAllAccessControl(), StatementAnalyzer.this.session, this.warningCollector);
            Scope tableScope = analyzer.analyze((Node)table, scope);
            update.getWhere().ifPresent(where -> this.analyzeWhere((Node)update, tableScope, (Expression)where));
            ImmutableList.Builder analysesBuilder = ImmutableList.builder();
            ImmutableList.Builder expressionTypesBuilder = ImmutableList.builder();
            for (UpdateAssignment assignment3 : update.getAssignments()) {
                Expression expression = assignment3.getValue();
                ExpressionAnalysis analysis = this.analyzeExpression(expression, tableScope);
                analysesBuilder.add((Object)analysis);
                expressionTypesBuilder.add((Object)analysis.getType(expression));
            }
            ImmutableList analyses = analysesBuilder.build();
            ImmutableList expressionTypes = expressionTypesBuilder.build();
            List tableTypes = (List)update.getAssignments().stream().map(assignment -> Objects.requireNonNull((ColumnMetadata)columns.get(assignment.getName().getValue()))).map(ColumnMetadata::getType).collect(ImmutableList.toImmutableList());
            for (int index = 0; index < expressionTypes.size(); ++index) {
                Expression expression = ((UpdateAssignment)update.getAssignments().get(index)).getValue();
                Type expressionType = (Type)expressionTypes.get(index);
                Type targetType = (Type)tableTypes.get(index);
                if (!targetType.equals(expressionType)) {
                    StatementAnalyzer.this.analysis.addCoercion(expression, targetType, StatementAnalyzer.this.functionAndTypeResolver.isTypeOnlyCoercion(expressionType, targetType));
                }
                StatementAnalyzer.this.analysis.recordSubqueries((Node)update, (ExpressionAnalysis)analyses.get(index));
            }
            return this.createAndAssignScope((Node)update, scope, Field.newUnqualified((Optional)update.getLocation(), (String)"rows", (Type)BigintType.BIGINT));
        }

        private Scope analyzeJoinUsing(Join node, List<Identifier> columns, Optional<Scope> scope, Scope left, Scope right) {
            ArrayList<Field> joinFields = new ArrayList<Field>();
            ArrayList<Integer> leftJoinFields = new ArrayList<Integer>();
            ArrayList<Integer> rightJoinFields = new ArrayList<Integer>();
            HashSet<Identifier> seen = new HashSet<Identifier>();
            for (Identifier column : columns) {
                ImmutableMultimap tableColumnMap;
                if (!seen.add(column)) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_COLUMN_NAME, (Node)column, "Column '%s' appears multiple times in USING clause", new Object[]{column.getValue()});
                }
                Optional leftField = left.tryResolveField((Expression)column);
                Optional rightField = right.tryResolveField((Expression)column);
                if (!leftField.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)column, "Column '%s' is missing from left side of join", new Object[]{column.getValue()});
                }
                if (!rightField.isPresent()) {
                    throw new SemanticException(SemanticErrorCode.MISSING_ATTRIBUTE, (Node)column, "Column '%s' is missing from right side of join", new Object[]{column.getValue()});
                }
                try {
                    StatementAnalyzer.this.functionAndTypeResolver.resolveOperator(OperatorType.EQUAL, TypeSignatureProvider.fromTypes((Type[])new Type[]{((ResolvedField)leftField.get()).getType(), ((ResolvedField)rightField.get()).getType()}));
                }
                catch (OperatorNotFoundException e) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)column, "%s", new Object[]{e.getMessage()});
                }
                Optional type = StatementAnalyzer.this.functionAndTypeResolver.getCommonSuperType(((ResolvedField)leftField.get()).getType(), ((ResolvedField)rightField.get()).getType());
                StatementAnalyzer.this.analysis.addTypes((Map)ImmutableMap.of((Object)NodeRef.of((Node)column), (Object)((Type)type.get())));
                joinFields.add(Field.newUnqualified((Optional)column.getLocation(), (String)column.getValue(), (Type)((Type)type.get())));
                leftJoinFields.add(((ResolvedField)leftField.get()).getRelationFieldIndex());
                rightJoinFields.add(((ResolvedField)rightField.get()).getRelationFieldIndex());
                StatementAnalyzer.this.analysis.addColumnReference(NodeRef.of((Node)column), FieldId.from((ResolvedField)((ResolvedField)leftField.get())));
                StatementAnalyzer.this.analysis.addColumnReference(NodeRef.of((Node)column), FieldId.from((ResolvedField)((ResolvedField)rightField.get())));
                if (((ResolvedField)leftField.get()).getField().getOriginTable().isPresent() && ((ResolvedField)leftField.get()).getField().getOriginColumnName().isPresent()) {
                    tableColumnMap = ImmutableMultimap.of((Object)((QualifiedObjectName)((ResolvedField)leftField.get()).getField().getOriginTable().get()), (Object)new Subfield((String)((ResolvedField)leftField.get()).getField().getOriginColumnName().get(), (List)ImmutableList.of()));
                    StatementAnalyzer.this.analysis.addTableColumnAndSubfieldReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), (Multimap)tableColumnMap, (Multimap)tableColumnMap);
                }
                if (!((ResolvedField)rightField.get()).getField().getOriginTable().isPresent() || !((ResolvedField)rightField.get()).getField().getOriginColumnName().isPresent()) continue;
                tableColumnMap = ImmutableMultimap.of((Object)((QualifiedObjectName)((ResolvedField)rightField.get()).getField().getOriginTable().get()), (Object)new Subfield((String)((ResolvedField)rightField.get()).getField().getOriginColumnName().get(), (List)ImmutableList.of()));
                StatementAnalyzer.this.analysis.addTableColumnAndSubfieldReferences(StatementAnalyzer.this.accessControl, StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getTransactionId(), StatementAnalyzer.this.session.getAccessControlContext(), (Multimap)tableColumnMap, (Multimap)tableColumnMap);
            }
            ImmutableList.Builder outputs = ImmutableList.builder();
            outputs.addAll(joinFields);
            ImmutableList.Builder leftFields = ImmutableList.builder();
            for (int i = 0; i < left.getRelationType().getAllFieldCount(); ++i) {
                if (leftJoinFields.contains(i)) continue;
                outputs.add((Object)left.getRelationType().getFieldByIndex(i));
                leftFields.add((Object)i);
            }
            ImmutableList.Builder rightFields = ImmutableList.builder();
            for (int i = 0; i < right.getRelationType().getAllFieldCount(); ++i) {
                if (rightJoinFields.contains(i)) continue;
                outputs.add((Object)right.getRelationType().getFieldByIndex(i));
                rightFields.add((Object)i);
            }
            StatementAnalyzer.this.analysis.setJoinUsing(node, new Analysis.JoinUsingAnalysis(leftJoinFields, rightJoinFields, (List)leftFields.build(), (List)rightFields.build()));
            return this.createAndAssignScope((Node)node, scope, new RelationType((List)outputs.build()));
        }

        private boolean isLateralRelation(Relation node) {
            if (node instanceof AliasedRelation) {
                return this.isLateralRelation(((AliasedRelation)node).getRelation());
            }
            return node instanceof Unnest || node instanceof Lateral;
        }

        protected Scope visitValues(Values node, Optional<Scope> scope) {
            Preconditions.checkState((node.getRows().size() >= 1 ? 1 : 0) != 0);
            List rowTypes = (List)node.getRows().stream().map(row -> this.analyzeExpression((Expression)row, this.createScope(scope)).getType(row)).map(type -> {
                if (type instanceof RowType) {
                    return type.getTypeParameters();
                }
                return ImmutableList.of((Object)type);
            }).collect(ImmutableList.toImmutableList());
            ArrayList<Type> fieldTypes = new ArrayList<Type>((Collection)rowTypes.iterator().next());
            for (List rowType : rowTypes) {
                if (rowType.size() != fieldTypes.size()) {
                    throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", new Object[]{rowTypes.get(0), rowType});
                }
                for (int i = 0; i < rowType.size(); ++i) {
                    Type fieldType = (Type)rowType.get(i);
                    Type superType = (Type)fieldTypes.get(i);
                    Optional commonSuperType = StatementAnalyzer.this.functionAndTypeResolver.getCommonSuperType(fieldType, superType);
                    if (!commonSuperType.isPresent()) {
                        throw new SemanticException(SemanticErrorCode.MISMATCHED_SET_COLUMN_TYPES, (Node)node, "Values rows have mismatched types: %s vs %s", new Object[]{rowTypes.get(0), rowType});
                    }
                    fieldTypes.set(i, (Type)commonSuperType.get());
                }
            }
            for (Expression row2 : node.getRows()) {
                Type expectedType;
                if (row2 instanceof Row) {
                    List items = ((Row)row2).getItems();
                    for (int i = 0; i < items.size(); ++i) {
                        Type expectedType2 = (Type)fieldTypes.get(i);
                        Expression item = (Expression)items.get(i);
                        Type actualType = StatementAnalyzer.this.analysis.getType(item);
                        if (actualType.equals(expectedType2)) continue;
                        StatementAnalyzer.this.analysis.addCoercion(item, expectedType2, StatementAnalyzer.this.functionAndTypeResolver.isTypeOnlyCoercion(actualType, expectedType2));
                    }
                    continue;
                }
                Type actualType = StatementAnalyzer.this.analysis.getType(row2);
                if (actualType.equals(expectedType = (Type)fieldTypes.get(0))) continue;
                StatementAnalyzer.this.analysis.addCoercion(row2, expectedType, StatementAnalyzer.this.functionAndTypeResolver.isTypeOnlyCoercion(actualType, expectedType));
            }
            List fields = (List)fieldTypes.stream().map(valueType -> Field.newUnqualified((Optional)node.getLocation(), Optional.empty(), (Type)valueType)).collect(ImmutableList.toImmutableList());
            return this.createAndAssignScope((Node)node, scope, fields);
        }

        private void analyzeWindowFunctions(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            StatementAnalyzer.this.analysis.setWindowFunctions(node, this.analyzeWindowFunctions(node, outputExpressions));
            if (node.getOrderBy().isPresent()) {
                StatementAnalyzer.this.analysis.setOrderByWindowFunctions((OrderBy)node.getOrderBy().get(), this.analyzeWindowFunctions(node, orderByExpressions));
            }
        }

        private List<FunctionCall> analyzeWindowFunctions(QuerySpecification node, List<Expression> expressions) {
            for (Expression expression : expressions) {
                new WindowFunctionValidator(StatementAnalyzer.this.functionAndTypeResolver).process((Node)expression, StatementAnalyzer.this.analysis);
            }
            List<FunctionCall> windowFunctions = ExpressionTreeUtils.extractWindowFunctions(expressions);
            for (FunctionCall windowFunction : windowFunctions) {
                FunctionKind kind;
                if (windowFunction.getFilter().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "FILTER is not yet supported for window functions", new Object[0]);
                }
                if (windowFunction.getOrderBy().isPresent()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)windowFunction, "Window function with ORDER BY is not supported", new Object[0]);
                }
                Window window = (Window)windowFunction.getWindow().get();
                if (window.getOrderBy().filter(orderBy -> orderBy.getSortItems().stream().anyMatch(item -> item.getSortKey() instanceof Literal)).isPresent()) {
                    if (SystemSessionProperties.isAllowWindowOrderByLiterals(StatementAnalyzer.this.session)) {
                        this.warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.PERFORMANCE_WARNING, String.format("ORDER BY literals/constants with window function: '%s' is unnecessary and expensive. If you intend to ORDER BY using ordinals, please use the actual expression instead of the ordinal", windowFunction)));
                    } else {
                        throw new SemanticException(SemanticErrorCode.WINDOW_FUNCTION_ORDERBY_LITERAL, (Node)node, "ORDER BY literals/constants with window function: '%s' is unnecessary and expensive. If you intend to ORDER BY using ordinals, please use the actual expression instead of the ordinal", new Object[]{windowFunction});
                    }
                }
                ImmutableList.Builder toExtract = ImmutableList.builder();
                toExtract.addAll((Iterable)windowFunction.getArguments());
                toExtract.addAll((Iterable)window.getPartitionBy());
                window.getOrderBy().ifPresent(orderBy -> toExtract.addAll((Iterable)orderBy.getSortItems()));
                window.getFrame().ifPresent(arg_0 -> ((ImmutableList.Builder)toExtract).add(arg_0));
                List<FunctionCall> nestedWindowFunctions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)toExtract.build());
                if (!nestedWindowFunctions.isEmpty()) {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, (Node)node, "Cannot nest window functions inside window function '%s': %s", new Object[]{windowFunction, windowFunctions});
                }
                if (windowFunction.isDistinct()) {
                    throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)node, "DISTINCT in window function parameters not yet supported: %s", new Object[]{windowFunction});
                }
                if (window.getFrame().isPresent()) {
                    this.analyzeWindowFrame((WindowFrame)window.getFrame().get());
                }
                if ((kind = StatementAnalyzer.this.functionAndTypeResolver.getFunctionMetadata(StatementAnalyzer.this.analysis.getFunctionHandle(windowFunction)).getFunctionKind()) == FunctionKind.AGGREGATE || kind == FunctionKind.WINDOW) continue;
                throw new SemanticException(SemanticErrorCode.MUST_BE_WINDOW_FUNCTION, (Node)node, "Not a window function: %s", new Object[]{windowFunction.getName()});
            }
            return windowFunctions;
        }

        private void analyzeWindowFrame(WindowFrame frame) {
            FrameBound.Type startType = frame.getStart().getType();
            FrameBound.Type endType = frame.getEnd().orElseGet(() -> new FrameBound(FrameBound.Type.CURRENT_ROW)).getType();
            if (startType == FrameBound.Type.UNBOUNDED_FOLLOWING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame start cannot be UNBOUNDED FOLLOWING", new Object[0]);
            }
            if (endType == FrameBound.Type.UNBOUNDED_PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame end cannot be UNBOUNDED PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.CURRENT_ROW && endType == FrameBound.Type.PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from CURRENT ROW cannot end with PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.PRECEDING) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with PRECEDING", new Object[0]);
            }
            if (startType == FrameBound.Type.FOLLOWING && endType == FrameBound.Type.CURRENT_ROW) {
                throw new SemanticException(SemanticErrorCode.INVALID_WINDOW_FRAME, (Node)frame, "Window frame starting from FOLLOWING cannot end with CURRENT ROW", new Object[0]);
            }
        }

        private void analyzeHaving(QuerySpecification node, Scope scope) {
            if (node.getHaving().isPresent()) {
                Expression predicate = (Expression)node.getHaving().get();
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
                expressionAnalysis.getWindowFunctions().stream().findFirst().ifPresent(function -> {
                    throw new SemanticException(SemanticErrorCode.NESTED_WINDOW, function.getNode(), "HAVING clause cannot contain window functions", new Object[0]);
                });
                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                Type predicateType = expressionAnalysis.getType(predicate);
                if (!predicateType.equals(BooleanType.BOOLEAN) && !predicateType.equals(UnknownType.UNKNOWN)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "HAVING clause must evaluate to a boolean: actual type %s", new Object[]{predicateType});
                }
                StatementAnalyzer.this.analysis.setHaving(node, predicate);
            }
        }

        private Multimap<QualifiedName, Expression> extractNamedOutputExpressions(Select node) {
            ImmutableMultimap.Builder assignments = ImmutableMultimap.builder();
            for (SelectItem item : node.getSelectItems()) {
                if (!(item instanceof SingleColumn)) continue;
                SingleColumn column = (SingleColumn)item;
                Optional alias = column.getAlias();
                if (alias.isPresent()) {
                    assignments.put((Object)QualifiedName.of((String)((Identifier)alias.get()).getValue()), (Object)column.getExpression());
                    continue;
                }
                if (!(column.getExpression() instanceof Identifier)) continue;
                assignments.put((Object)QualifiedName.of((String)((Identifier)column.getExpression()).getValue()), (Object)column.getExpression());
            }
            return assignments.build();
        }

        private void checkFunctionName(Statement node, QualifiedName functionName, boolean isTemporary) {
            if (isTemporary) {
                if (functionName.getParts().size() != 1) {
                    throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, "Temporary functions cannot be qualified.", new Object[0]);
                }
                List builtInFunctionNames = StatementAnalyzer.this.functionAndTypeResolver.listBuiltInFunctions().stream().map(SqlFunction::getSignature).map(Signature::getName).map(QualifiedObjectName::getObjectName).collect(Collectors.toList());
                if (builtInFunctionNames.contains(functionName.toString())) {
                    throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, String.format("Function %s is already registered as a built-in function.", functionName), new Object[0]);
                }
            } else if (functionName.getParts().size() != 3) {
                throw new SemanticException(SemanticErrorCode.INVALID_FUNCTION_NAME, (Node)node, String.format("Function name should be in the form of catalog.schema.function_name, found: %s", functionName), new Object[0]);
            }
        }

        private void checkGroupingSetsCount(GroupBy node) {
            int crossProduct = 1;
            for (GroupingElement element : node.getGroupingElements()) {
                try {
                    int product;
                    if (element instanceof SimpleGroupBy) {
                        product = 1;
                    } else if (element instanceof Cube) {
                        int exponent = element.getExpressions().size();
                        if (exponent > 30) {
                            throw new ArithmeticException();
                        }
                        product = 1 << exponent;
                    } else if (element instanceof Rollup) {
                        product = element.getExpressions().size() + 1;
                    } else if (element instanceof GroupingSets) {
                        product = ((GroupingSets)element).getSets().size();
                    } else {
                        throw new UnsupportedOperationException("Unsupported grouping element type: " + element.getClass().getName());
                    }
                    crossProduct = Math.multiplyExact(crossProduct, product);
                }
                catch (ArithmeticException e) {
                    throw new SemanticException(SemanticErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has more than %s grouping sets but can contain at most %s", new Object[]{Integer.MAX_VALUE, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)});
                }
                if (crossProduct <= SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)) continue;
                throw new SemanticException(SemanticErrorCode.TOO_MANY_GROUPING_SETS, (Node)node, "GROUP BY has %s grouping sets but can contain at most %s", new Object[]{crossProduct, SystemSessionProperties.getMaxGroupingSets(StatementAnalyzer.this.session)});
            }
        }

        private List<Expression> analyzeGroupBy(QuerySpecification node, Scope scope, List<Expression> outputExpressions) {
            if (node.getGroupBy().isPresent()) {
                ImmutableList.Builder cubes = ImmutableList.builder();
                ImmutableList.Builder rollups = ImmutableList.builder();
                ImmutableList.Builder sets = ImmutableList.builder();
                ImmutableList.Builder complexExpressions = ImmutableList.builder();
                ImmutableList.Builder groupingExpressions = ImmutableList.builder();
                this.checkGroupingSetsCount((GroupBy)node.getGroupBy().get());
                for (GroupingElement groupingElement : ((GroupBy)node.getGroupBy().get()).getGroupingElements()) {
                    if (groupingElement instanceof SimpleGroupBy) {
                        for (Expression column : groupingElement.getExpressions()) {
                            if (column instanceof LongLiteral) {
                                long ordinal = ((LongLiteral)column).getValue();
                                if (ordinal < 1L || ordinal > (long)outputExpressions.size()) {
                                    throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)column, "GROUP BY position %s is not in select list", new Object[]{ordinal});
                                }
                                column = outputExpressions.get(Math.toIntExact(ordinal - 1L));
                            } else {
                                this.analyzeExpression(column, scope);
                            }
                            if (StatementAnalyzer.this.analysis.getColumnReferenceFields().containsKey((Object)NodeRef.of((Node)column))) {
                                sets.add((Object)ImmutableList.of((Object)ImmutableSet.copyOf((Collection)StatementAnalyzer.this.analysis.getColumnReferenceFields().get((Object)NodeRef.of((Node)column)))));
                            } else {
                                Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, column, "GROUP BY clause");
                                StatementAnalyzer.this.analysis.recordSubqueries((Node)node, this.analyzeExpression(column, scope));
                                complexExpressions.add((Object)column);
                            }
                            groupingExpressions.add((Object)column);
                        }
                        continue;
                    }
                    for (Expression column : groupingElement.getExpressions()) {
                        this.analyzeExpression(column, scope);
                        if (!StatementAnalyzer.this.analysis.getColumnReferences().contains(NodeRef.of((Node)column))) {
                            throw new SemanticException(SemanticErrorCode.MUST_BE_COLUMN_REFERENCE, (Node)column, "GROUP BY expression must be a column reference: %s", new Object[]{column});
                        }
                        groupingExpressions.add((Object)column);
                    }
                    if (groupingElement instanceof Cube) {
                        Set cube = (Set)groupingElement.getExpressions().stream().map(NodeRef::of).map(arg_0 -> ((Multimap)StatementAnalyzer.this.analysis.getColumnReferenceFields()).get(arg_0)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
                        cubes.add((Object)cube);
                        continue;
                    }
                    if (groupingElement instanceof Rollup) {
                        List rollup = (List)groupingElement.getExpressions().stream().map(NodeRef::of).map(arg_0 -> ((Multimap)StatementAnalyzer.this.analysis.getColumnReferenceFields()).get(arg_0)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
                        rollups.add((Object)rollup);
                        continue;
                    }
                    if (!(groupingElement instanceof GroupingSets)) continue;
                    List groupingSets = (List)((GroupingSets)groupingElement).getSets().stream().map(set -> (ImmutableSet)set.stream().map(NodeRef::of).map(arg_0 -> ((Multimap)StatementAnalyzer.this.analysis.getColumnReferenceFields()).get(arg_0)).flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet())).collect(ImmutableList.toImmutableList());
                    sets.add((Object)groupingSets);
                }
                ImmutableList expressions = groupingExpressions.build();
                for (Expression expression : expressions) {
                    Type type = StatementAnalyzer.this.analysis.getType(expression);
                    if (type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "%s is not comparable, and therefore cannot be used in GROUP BY", new Object[]{type});
                }
                StatementAnalyzer.this.analysis.setGroupByExpressions(node, (List)expressions);
                StatementAnalyzer.this.analysis.setGroupingSets(node, new Analysis.GroupingSetAnalysis((List)cubes.build(), (List)rollups.build(), (List)sets.build(), (List)complexExpressions.build()));
                return expressions;
            }
            return ImmutableList.of();
        }

        private Scope computeAndAssignOutputScope(QuerySpecification node, Optional<Scope> scope, Scope sourceScope) {
            ImmutableList.Builder outputFields = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    Optional starPrefix = ((AllColumns)item).getPrefix();
                    for (Optional<Identifier> field : sourceScope.getRelationType().resolveFieldsWithPrefix(starPrefix)) {
                        outputFields.add((Object)Field.newUnqualified((Optional)node.getSelect().getLocation(), (Optional)field.getName(), (Type)field.getType(), (Optional)field.getOriginTable(), (Optional)field.getOriginColumnName(), (boolean)false));
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    List matchingFields;
                    Optional<Identifier> field;
                    SingleColumn column = (SingleColumn)item;
                    Expression expression = column.getExpression();
                    field = column.getAlias();
                    Optional originTable = Optional.empty();
                    Optional originColumn = Optional.empty();
                    QualifiedName name = null;
                    if (expression instanceof Identifier) {
                        name = QualifiedName.of((String)((Identifier)expression).getValue());
                    } else if (expression instanceof DereferenceExpression) {
                        name = DereferenceExpression.getQualifiedName((DereferenceExpression)((DereferenceExpression)expression));
                    }
                    if (name != null && !(matchingFields = sourceScope.getRelationType().resolveFields(name)).isEmpty()) {
                        originTable = ((Field)matchingFields.get(0)).getOriginTable();
                        originColumn = ((Field)matchingFields.get(0)).getOriginColumnName();
                    }
                    if (!field.isPresent() && name != null) {
                        field = Optional.of(new Identifier((String)Iterables.getLast((Iterable)name.getOriginalParts())));
                    }
                    outputFields.add((Object)Field.newUnqualified((Optional)expression.getLocation(), field.map(Identifier::getValue), (Type)StatementAnalyzer.this.analysis.getType(expression), (Optional)originTable, (Optional)originColumn, (boolean)column.getAlias().isPresent()));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            return this.createAndAssignScope((Node)node, scope, (List<Field>)outputFields.build());
        }

        private Scope computeAndAssignOrderByScope(OrderBy node, Scope sourceScope, Scope outputScope) {
            Scope orderByScope = Scope.builder().withParent(sourceScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            return orderByScope;
        }

        private Scope computeAndAssignOrderByScopeWithAggregation(OrderBy node, Scope sourceScope, Scope outputScope, List<FunctionCall> aggregations, List<Expression> groupByExpressions, List<GroupingOperation> groupingOperations) {
            ImmutableList.Builder orderByAggregationExpressionsBuilder = ImmutableList.builder().addAll(groupByExpressions).addAll(aggregations).addAll(groupingOperations);
            List orderByExpressionsReferencingOutputScope = (List)AstUtils.preOrder((Node)node).filter(Expression.class::isInstance).map(Expression.class::cast).filter(expression -> ScopeReferenceExtractor.hasReferencesToScope((Node)expression, StatementAnalyzer.this.analysis, outputScope)).collect(ImmutableList.toImmutableList());
            List orderByAggregationExpressions = (List)orderByAggregationExpressionsBuilder.build().stream().filter(expression -> !orderByExpressionsReferencingOutputScope.contains(expression) || StatementAnalyzer.this.analysis.isColumnReference(expression)).collect(ImmutableList.toImmutableList());
            HashSet seen = new HashSet();
            List orderByAggregationSourceFields = (List)orderByAggregationExpressions.stream().map(expression -> {
                Optional<Field> sourceField = sourceScope.tryResolveField(expression).filter(resolvedField -> seen.add(resolvedField.getField())).map(ResolvedField::getField);
                return sourceField.orElse(Field.newUnqualified((Optional)expression.getLocation(), Optional.empty(), (Type)StatementAnalyzer.this.analysis.getType(expression)));
            }).collect(ImmutableList.toImmutableList());
            Scope orderByAggregationScope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(orderByAggregationSourceFields)).build();
            Scope orderByScope = Scope.builder().withParent(orderByAggregationScope).withRelationType(outputScope.getRelationId(), outputScope.getRelationType()).build();
            StatementAnalyzer.this.analysis.setScope((Node)node, orderByScope);
            StatementAnalyzer.this.analysis.setOrderByAggregates(node, orderByAggregationExpressions);
            return orderByScope;
        }

        private List<Expression> analyzeSelect(QuerySpecification node, Scope scope) {
            ImmutableList.Builder outputExpressionBuilder = ImmutableList.builder();
            for (SelectItem item : node.getSelect().getSelectItems()) {
                if (item instanceof AllColumns) {
                    Optional starPrefix = ((AllColumns)item).getPrefix();
                    RelationType relationType = scope.getRelationType();
                    List fields = relationType.resolveFieldsWithPrefix(starPrefix);
                    if (fields.isEmpty()) {
                        if (starPrefix.isPresent()) {
                            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)item, "Table '%s' not found", new Object[]{starPrefix.get()});
                        }
                        if (!node.getFrom().isPresent()) {
                            throw new SemanticException(SemanticErrorCode.WILDCARD_WITHOUT_FROM, (Node)item, "SELECT * not allowed in queries without FROM clause", new Object[0]);
                        }
                        throw new SemanticException(SemanticErrorCode.COLUMN_NAME_NOT_SPECIFIED, (Node)item, "SELECT * not allowed from relation that has no columns", new Object[0]);
                    }
                    for (Field field : fields) {
                        int fieldIndex = relationType.indexOf(field);
                        FieldReference expression = new FieldReference(field.getNodeLocation(), fieldIndex);
                        outputExpressionBuilder.add((Object)expression);
                        ExpressionAnalysis expressionAnalysis = this.analyzeExpression((Expression)expression, scope);
                        Type type = expressionAnalysis.getType((Expression)expression);
                        if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                        throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s)", new Object[]{type});
                    }
                    continue;
                }
                if (item instanceof SingleColumn) {
                    SingleColumn column = (SingleColumn)item;
                    ExpressionAnalysis expressionAnalysis = this.analyzeExpression(column.getExpression(), scope);
                    StatementAnalyzer.this.analysis.recordSubqueries((Node)node, expressionAnalysis);
                    outputExpressionBuilder.add((Object)column.getExpression());
                    Type type = expressionAnalysis.getType(column.getExpression());
                    if (!node.getSelect().isDistinct() || type.isComparable()) continue;
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node.getSelect(), "DISTINCT can only be applied to comparable types (actual: %s): %s", new Object[]{type, column.getExpression()});
                }
                throw new IllegalArgumentException("Unsupported SelectItem type: " + item.getClass().getName());
            }
            ImmutableList result = outputExpressionBuilder.build();
            StatementAnalyzer.this.analysis.setOutputExpressions((Node)node, (List)result);
            return result;
        }

        public void analyzeWhere(Node node, Scope scope, Expression predicate) {
            ExpressionAnalysis expressionAnalysis = this.analyzeExpression(predicate, scope);
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, predicate, "WHERE clause");
            StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
            Type predicateType = expressionAnalysis.getType(predicate);
            if (!predicateType.equals(BooleanType.BOOLEAN)) {
                if (!predicateType.equals(UnknownType.UNKNOWN)) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)predicate, "WHERE clause must evaluate to a boolean: actual type %s", new Object[]{predicateType});
                }
                StatementAnalyzer.this.analysis.addCoercion(predicate, (Type)BooleanType.BOOLEAN, false);
            }
            StatementAnalyzer.this.analysis.setWhere(node, predicate);
        }

        private Scope analyzeFrom(QuerySpecification node, Optional<Scope> scope) {
            if (node.getFrom().isPresent()) {
                return this.process((Node)node.getFrom().get(), scope);
            }
            return this.createScope(scope);
        }

        private void analyzeGroupingOperations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            boolean isGroupingOperationPresent;
            List<GroupingOperation> groupingOperations = ExpressionTreeUtils.extractExpressions(Iterables.concat(outputExpressions, orderByExpressions), GroupingOperation.class);
            boolean bl = isGroupingOperationPresent = !groupingOperations.isEmpty();
            if (isGroupingOperationPresent && !node.getGroupBy().isPresent()) {
                throw new SemanticException(SemanticErrorCode.INVALID_PROCEDURE_ARGUMENTS, (Node)node, "A GROUPING() operation can only be used with a corresponding GROUPING SET/CUBE/ROLLUP/GROUP BY clause", new Object[0]);
            }
            StatementAnalyzer.this.analysis.setGroupingOperations(node, groupingOperations);
        }

        private List<FunctionCall> analyzeAggregations(QuerySpecification node, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), Iterables.concat(outputExpressions, orderByExpressions), StatementAnalyzer.this.functionAndTypeResolver);
            StatementAnalyzer.this.analysis.setAggregates(node, aggregates);
            return aggregates;
        }

        private void verifyAggregations(QuerySpecification node, Scope sourceScope, Optional<Scope> orderByScope, List<Expression> groupByExpressions, List<Expression> outputExpressions, List<Expression> orderByExpressions) {
            Preconditions.checkState((orderByExpressions.isEmpty() || orderByScope.isPresent() ? 1 : 0) != 0, (Object)"non-empty orderByExpressions list without orderByScope provided");
            if (StatementAnalyzer.this.analysis.isAggregation(node)) {
                List distinctGroupingColumns = (List)groupByExpressions.stream().distinct().collect(ImmutableList.toImmutableList());
                for (Expression expression : outputExpressions) {
                    AggregationAnalyzer.verifySourceAggregations(distinctGroupingColumns, sourceScope, expression, StatementAnalyzer.this.functionAndTypeResolver, StatementAnalyzer.this.analysis, this.warningCollector, StatementAnalyzer.this.session);
                }
                for (Expression expression : orderByExpressions) {
                    AggregationAnalyzer.verifyOrderByAggregations(distinctGroupingColumns, sourceScope, orderByScope.get(), expression, StatementAnalyzer.this.functionAndTypeResolver, StatementAnalyzer.this.analysis, this.warningCollector, StatementAnalyzer.this.session);
                }
            }
        }

        private RelationType analyzeView(Query query, QualifiedObjectName name, Optional<String> catalog, Optional<String> schema, Optional<String> owner, Table node) {
            try {
                AccessControl viewAccessControl;
                Identity identity;
                if (owner.isPresent() && !owner.get().equals(StatementAnalyzer.this.session.getIdentity().getUser())) {
                    identity = new Identity(owner.get(), Optional.empty(), StatementAnalyzer.this.session.getIdentity().getExtraCredentials());
                    viewAccessControl = new ViewAccessControl(StatementAnalyzer.this.accessControl);
                } else {
                    identity = StatementAnalyzer.this.session.getIdentity();
                    viewAccessControl = StatementAnalyzer.this.accessControl;
                }
                Session viewSession = this.createViewSession(catalog, schema, identity);
                StatementAnalyzer analyzer = new StatementAnalyzer(StatementAnalyzer.this.analysis, StatementAnalyzer.this.metadata, StatementAnalyzer.this.sqlParser, viewAccessControl, viewSession, this.warningCollector);
                Scope queryScope = analyzer.analyze((Node)query, Scope.create());
                return queryScope.getRelationType().withAlias(name.getObjectName(), null);
            }
            catch (RuntimeException e) {
                Throwables.throwIfInstanceOf((Throwable)e, PrestoException.class);
                throw new SemanticException(SemanticErrorCode.VIEW_ANALYSIS_ERROR, (Throwable)e, node.getLocation(), "Failed analyzing stored view '%s': %s", new Object[]{name, e.getMessage()});
            }
        }

        private Session createViewSession(Optional<String> catalog, Optional<String> schema, Identity identity) {
            Session.SessionBuilder viewSessionBuilder = Session.builder(StatementAnalyzer.this.metadata.getSessionPropertyManager()).setQueryId(StatementAnalyzer.this.session.getQueryId()).setTransactionId(StatementAnalyzer.this.session.getTransactionId().orElse(null)).setIdentity(identity).setSource(StatementAnalyzer.this.session.getSource().orElse(null)).setCatalog(catalog.orElse(null)).setSchema(schema.orElse(null)).setTimeZoneKey(StatementAnalyzer.this.session.getTimeZoneKey()).setLocale(StatementAnalyzer.this.session.getLocale()).setRemoteUserAddress(StatementAnalyzer.this.session.getRemoteUserAddress().orElse(null)).setUserAgent(StatementAnalyzer.this.session.getUserAgent().orElse(null)).setClientInfo(StatementAnalyzer.this.session.getClientInfo().orElse(null)).setStartTime(StatementAnalyzer.this.session.getStartTime());
            StatementAnalyzer.this.session.getConnectorProperties().forEach((connectorId, properties) -> properties.forEach((k, v) -> viewSessionBuilder.setConnectionProperty((ConnectorId)connectorId, (String)k, (String)v)));
            return viewSessionBuilder.build();
        }

        private Query parseView(String view, QualifiedObjectName name, Node node) {
            try {
                return (Query)StatementAnalyzer.this.sqlParser.createStatement(view, AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session, this.warningCollector));
            }
            catch (ParsingException e) {
                throw new SemanticException(SemanticErrorCode.VIEW_PARSE_ERROR, node, "Failed parsing stored view '%s': %s", new Object[]{name, e.getMessage()});
            }
        }

        private boolean isViewStale(List<ViewDefinition.ViewColumn> columns, Collection<Field> fields) {
            if (columns.size() != fields.size()) {
                return true;
            }
            ImmutableList fieldList = ImmutableList.copyOf(fields);
            for (int i = 0; i < columns.size(); ++i) {
                ViewDefinition.ViewColumn column = columns.get(i);
                Field field = (Field)fieldList.get(i);
                if (column.getName().equalsIgnoreCase(field.getName().orElse(null)) && StatementAnalyzer.this.functionAndTypeResolver.canCoerce(field.getType(), column.getType())) continue;
                return true;
            }
            return false;
        }

        private ExpressionAnalysis analyzeExpression(Expression expression, Scope scope) {
            return ExpressionAnalyzer.analyzeExpression(StatementAnalyzer.this.session, StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector);
        }

        private void analyzeFiltersAndMasks(Table table, QualifiedObjectName name, Scope accessControlScope, Collection<Field> fields) {
            ArrayList<ColumnMetadata> columnsMetadata = new ArrayList<ColumnMetadata>();
            for (Field field : fields) {
                if (!field.getName().isPresent()) continue;
                columnsMetadata.add(ColumnMetadata.builder().setName((String)field.getName().get()).setType(field.getType()).build());
            }
            this.analyzeFiltersAndMasks(table, name, accessControlScope, (List<ColumnMetadata>)columnsMetadata);
        }

        private void analyzeFiltersAndMasks(Table table, QualifiedObjectName name, Scope accessControlScope, List<ColumnMetadata> columnsMetadata) {
            Map masks = StatementAnalyzer.this.accessControl.getColumnMasks(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), name, columnsMetadata);
            for (Map.Entry maskEntry : masks.entrySet()) {
                this.analyzeColumnMask(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, (ColumnMetadata)maskEntry.getKey(), accessControlScope, (ViewExpression)maskEntry.getValue());
            }
            StatementAnalyzer.this.accessControl.getRowFilters(StatementAnalyzer.this.session.getRequiredTransactionId(), StatementAnalyzer.this.session.getIdentity(), StatementAnalyzer.this.session.getAccessControlContext(), name).forEach(filter -> this.analyzeRowFilter(StatementAnalyzer.this.session.getIdentity().getUser(), table, name, accessControlScope, (ViewExpression)filter));
        }

        private void analyzeRowFilter(String currentIdentity, Table table, QualifiedObjectName name, Scope scope, ViewExpression filter) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            if (StatementAnalyzer.this.analysis.hasRowFilter(name, currentIdentity)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, String.format("Row filter for '%s' is recursive", name), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(filter.getExpression(), AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session));
            }
            catch (ParsingException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_ROW_FILTER, String.format("Invalid row filter for '%s': %s", name, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForRowFiltering(name, currentIdentity);
            try {
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.createViewSession(filter.getCatalog(), filter.getSchema(), new Identity(filter.getIdentity(), Optional.empty())), StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector);
            }
            catch (PrestoException e) {
                throw new PrestoException(() -> ((PrestoException)e).getErrorCode(), String.format("Invalid row filter for '%s: %s'", name, e.getMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForRowFiltering(name, currentIdentity);
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, expression, String.format("Row filter for '%s'", name));
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals(BooleanType.BOOLEAN)) {
                if (!StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce(actualType, (Type)BooleanType.BOOLEAN)) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DATATYPE_MISMATCH, String.format("Expected row filter for '%s' to be of type BOOLEAN, but was %s", name, actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, (Type)BooleanType.BOOLEAN, false);
            }
            StatementAnalyzer.this.analysis.addRowFilter(table, expression);
        }

        private void analyzeColumnMask(String currentIdentity, Table table, QualifiedObjectName tableName, ColumnMetadata columnMetadata, Scope scope, ViewExpression mask) {
            ExpressionAnalysis expressionAnalysis;
            Expression expression;
            String column = columnMetadata.getName();
            if (StatementAnalyzer.this.analysis.hasColumnMask(tableName, column, currentIdentity)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_MASK, String.format("Column mask for '%s.%s' is recursive", tableName, column), null);
            }
            try {
                expression = StatementAnalyzer.this.sqlParser.createExpression(mask.getExpression(), AnalyzerUtil.createParsingOptions(StatementAnalyzer.this.session));
            }
            catch (ParsingException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_COLUMN_MASK, String.format("Invalid column mask for '%s.%s': %s", tableName, column, e.getErrorMessage()), (Throwable)e);
            }
            StatementAnalyzer.this.analysis.registerTableForColumnMasking(tableName, column, currentIdentity);
            try {
                expressionAnalysis = ExpressionAnalyzer.analyzeExpression(this.createViewSession(mask.getCatalog(), mask.getSchema(), new Identity(mask.getIdentity(), Optional.empty())), StatementAnalyzer.this.metadata, StatementAnalyzer.this.accessControl, StatementAnalyzer.this.sqlParser, scope, StatementAnalyzer.this.analysis, expression, this.warningCollector);
            }
            catch (PrestoException e) {
                throw new PrestoException(() -> ((PrestoException)e).getErrorCode(), String.format("Invalid column mask for '%s.%s: %s'", tableName, column, e.getMessage()), (Throwable)e);
            }
            finally {
                StatementAnalyzer.this.analysis.unregisterTableForColumnMasking(tableName, column, currentIdentity);
            }
            Analyzer.verifyNoAggregateWindowOrGroupingFunctions(StatementAnalyzer.this.analysis.getFunctionHandles(), StatementAnalyzer.this.functionAndTypeResolver, expression, String.format("Column mask for '%s.%s'", table.getName(), column));
            StatementAnalyzer.this.analysis.recordSubqueries((Node)expression, expressionAnalysis);
            Type expectedType = columnMetadata.getType();
            Type actualType = expressionAnalysis.getType(expression);
            if (!actualType.equals(expectedType)) {
                if (!StatementAnalyzer.this.metadata.getFunctionAndTypeManager().canCoerce(actualType, columnMetadata.getType())) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.DATATYPE_MISMATCH, String.format("Expected column mask for '%s.%s' to be of type %s, but was %s", tableName, column, columnMetadata.getType(), actualType), null);
                }
                StatementAnalyzer.this.analysis.addCoercion(expression, expectedType, false);
            }
            StatementAnalyzer.this.analysis.addColumnMask(table, column, expression);
        }

        private List<Expression> descriptorToFields(Scope scope) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int fieldIndex = 0; fieldIndex < scope.getRelationType().getAllFieldCount(); ++fieldIndex) {
                FieldReference expression = new FieldReference(scope.getRelationType().getFieldByIndex(fieldIndex).getNodeLocation(), fieldIndex);
                builder.add((Object)expression);
                this.analyzeExpression((Expression)expression, scope);
            }
            return builder.build();
        }

        private Scope analyzeWith(Query node, Optional<Scope> scope) {
            if (!node.getWith().isPresent()) {
                return this.createScope(scope);
            }
            With with = (With)node.getWith().get();
            if (with.isRecursive()) {
                throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)with, "Recursive WITH queries are not supported", new Object[0]);
            }
            Scope.Builder withScopeBuilder = this.scopeBuilder(scope);
            for (WithQuery withQuery : with.getQueries()) {
                Query query = withQuery.getQuery();
                this.process((Node)query, withScopeBuilder.build());
                String name = withQuery.getName().getValueLowerCase();
                if (withScopeBuilder.containsNamedQuery(name)) {
                    throw new SemanticException(SemanticErrorCode.DUPLICATE_RELATION, (Node)withQuery, "WITH query name '%s' specified more than once", new Object[]{name});
                }
                if (withQuery.getColumnNames().isPresent()) {
                    List columnNames = (List)withQuery.getColumnNames().get();
                    RelationType queryDescriptor = StatementAnalyzer.this.analysis.getOutputDescriptor((Node)query);
                    if (columnNames.size() != queryDescriptor.getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.MISMATCHED_COLUMN_ALIASES, (Node)withQuery, "WITH column alias list has %s entries but WITH query(%s) has %s columns", new Object[]{columnNames.size(), name, queryDescriptor.getVisibleFieldCount()});
                    }
                }
                withScopeBuilder.withNamedQuery(name, withQuery);
            }
            Scope withScope = withScopeBuilder.build();
            StatementAnalyzer.this.analysis.setScope((Node)with, withScope);
            return withScope;
        }

        private void analyzeOffset(Offset node) {
            long rowCount;
            try {
                rowCount = Long.parseLong(node.getRowCount());
            }
            catch (NumberFormatException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_OFFSET_ROW_COUNT, (Node)node, "Invalid OFFSET row count: %s", new Object[]{node.getRowCount()});
            }
            if (rowCount < 0L) {
                throw new SemanticException(SemanticErrorCode.INVALID_OFFSET_ROW_COUNT, (Node)node, "OFFSET row count must be greater or equal to 0 (actual value: %s)", new Object[]{rowCount});
            }
            StatementAnalyzer.this.analysis.setOffset(node, rowCount);
        }

        private void verifySelectDistinct(QuerySpecification node, List<Expression> outputExpressions) {
            for (SortItem item : ((OrderBy)node.getOrderBy().get()).getSortItems()) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) continue;
                Expression rewrittenOrderByExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new OrderByExpressionRewriter(this.extractNamedOutputExpressions(node.getSelect())), (Expression)expression);
                int index = outputExpressions.indexOf(rewrittenOrderByExpression);
                if (index == -1) {
                    throw new SemanticException(SemanticErrorCode.ORDER_BY_MUST_BE_IN_SELECT, (Node)node.getSelect(), "For SELECT DISTINCT, ORDER BY expressions must appear in select list", new Object[0]);
                }
                if (ExpressionDeterminismEvaluator.isDeterministic(expression)) continue;
                throw new SemanticException(SemanticErrorCode.NONDETERMINISTIC_ORDER_BY_EXPRESSION_WITH_SELECT_DISTINCT, (Node)expression, "Non deterministic ORDER BY expression is not supported with SELECT DISTINCT", new Object[0]);
            }
        }

        private List<Expression> analyzeOrderBy(Node node, List<SortItem> sortItems, Scope orderByScope) {
            ImmutableList.Builder orderByFieldsBuilder = ImmutableList.builder();
            for (SortItem item : sortItems) {
                Expression expression = item.getSortKey();
                if (expression instanceof LongLiteral) {
                    long ordinal = ((LongLiteral)expression).getValue();
                    if (ordinal < 1L || ordinal > (long)orderByScope.getRelationType().getVisibleFieldCount()) {
                        throw new SemanticException(SemanticErrorCode.INVALID_ORDINAL, (Node)expression, "ORDER BY position %s is not in select list", new Object[]{ordinal});
                    }
                    expression = new FieldReference(expression.getLocation(), Math.toIntExact(ordinal - 1L));
                }
                ExpressionAnalysis expressionAnalysis = this.analyzeExpression(expression, orderByScope);
                StatementAnalyzer.this.analysis.recordSubqueries(node, expressionAnalysis);
                Type type = StatementAnalyzer.this.analysis.getType(expression);
                if (!type.isOrderable()) {
                    throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, node, "Type %s is not orderable, and therefore cannot be used in ORDER BY: %s", new Object[]{type, expression});
                }
                orderByFieldsBuilder.add((Object)expression);
            }
            ImmutableList orderByFields = orderByFieldsBuilder.build();
            return orderByFields;
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope) {
            return this.createAndAssignScope(node, parentScope, Collections.emptyList());
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, Field ... fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, List<Field> fields) {
            return this.createAndAssignScope(node, parentScope, new RelationType(fields));
        }

        private Scope createAndAssignScope(Node node, Optional<Scope> parentScope, RelationType relationType) {
            Scope scope = this.scopeBuilder(parentScope).withRelationType(RelationId.of((Node)node), relationType).build();
            StatementAnalyzer.this.analysis.setScope(node, scope);
            return scope;
        }

        private Scope createScope(Optional<Scope> parentScope) {
            return this.scopeBuilder(parentScope).build();
        }

        private Scope.Builder scopeBuilder(Optional<Scope> parentScope) {
            Scope.Builder scopeBuilder = Scope.builder();
            if (parentScope.isPresent()) {
                scopeBuilder.withParent(parentScope.get());
            } else if (this.outerQueryScope.isPresent()) {
                scopeBuilder.withOuterQueryParent(this.outerQueryScope.get());
            }
            return scopeBuilder;
        }

        private class OrderByExpressionRewriter
        extends ExpressionRewriter<Void> {
            private final Multimap<QualifiedName, Expression> assignments;

            public OrderByExpressionRewriter(Multimap<QualifiedName, Expression> assignments) {
                this.assignments = assignments;
            }

            public Expression rewriteIdentifier(Identifier reference, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                QualifiedName name = QualifiedName.of((String)reference.getValue());
                Set expressions = this.assignments.get((Object)name).stream().collect(Collectors.toSet());
                if (expressions.size() > 1) {
                    throw new SemanticException(SemanticErrorCode.AMBIGUOUS_ATTRIBUTE, (Node)reference, "'%s' in ORDER BY is ambiguous", new Object[]{name});
                }
                if (expressions.size() == 1) {
                    return (Expression)Iterables.getOnlyElement(expressions);
                }
                return reference;
            }
        }
    }
}

