/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.BytecodeVisitor;
import com.facebook.presto.bytecode.CallSiteBinder;
import com.facebook.presto.bytecode.MethodGenerationContext;
import com.facebook.presto.bytecode.Scope;
import com.facebook.presto.bytecode.Variable;
import com.facebook.presto.bytecode.control.IfStatement;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.relation.CallExpression;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.InputReferenceExpression;
import com.facebook.presto.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.sql.gen.SqlTypeBytecodeExpression;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.objectweb.asm.MethodVisitor;

class InputReferenceCompiler
implements RowExpressionVisitor<BytecodeNode, Scope> {
    private final BiFunction<Scope, Integer, BytecodeExpression> blockResolver;
    private final BiFunction<Scope, Integer, BytecodeExpression> positionResolver;
    private final CallSiteBinder callSiteBinder;

    public InputReferenceCompiler(BiFunction<Scope, Integer, BytecodeExpression> blockResolver, BiFunction<Scope, Integer, BytecodeExpression> positionResolver, CallSiteBinder callSiteBinder) {
        this.blockResolver = Objects.requireNonNull(blockResolver, "blockResolver is null");
        this.positionResolver = Objects.requireNonNull(positionResolver, "positionResolver is null");
        this.callSiteBinder = Objects.requireNonNull(callSiteBinder, "callSiteBinder is null");
    }

    public static BytecodeNode generateInputReference(CallSiteBinder callSiteBinder, Scope scope, Type type, BytecodeExpression block, BytecodeExpression position) {
        return new InputReferenceNode(callSiteBinder, scope, type, block, position);
    }

    public BytecodeNode visitInputReference(InputReferenceExpression node, Scope scope) {
        int field = node.getField();
        Type type = node.getType();
        BytecodeExpression block = this.blockResolver.apply(scope, field);
        BytecodeExpression position = this.positionResolver.apply(scope, field);
        return InputReferenceCompiler.generateInputReference(this.callSiteBinder, scope, type, block, position);
    }

    public BytecodeNode visitCall(CallExpression call, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public BytecodeNode visitConstant(ConstantExpression literal, Scope scope) {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public BytecodeNode visitLambda(LambdaDefinitionExpression lambda, Scope context) {
        throw new UnsupportedOperationException();
    }

    public BytecodeNode visitVariableReference(VariableReferenceExpression reference, Scope context) {
        throw new UnsupportedOperationException();
    }

    public BytecodeNode visitSpecialForm(SpecialFormExpression specialForm, Scope context) {
        throw new UnsupportedOperationException();
    }

    static class InputReferenceNode
    implements BytecodeNode {
        private final BytecodeNode body;
        private final BytecodeExpression block;
        private final BytecodeExpression position;

        private InputReferenceNode(CallSiteBinder callSiteBinder, Scope scope, Type type, BytecodeExpression block, BytecodeExpression position) {
            Variable wasNullVariable = scope.getVariable("wasNull");
            Class<Object> javaType = type.getJavaType();
            if (!javaType.isPrimitive() && javaType != Slice.class) {
                javaType = Object.class;
            }
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition((BytecodeNode)block.invoke("isNull", Boolean.TYPE, new BytecodeExpression[]{position}));
            ifStatement.ifTrue().putVariable(wasNullVariable, true).pushJavaDefault(javaType);
            String methodName = "get" + Primitives.wrap(javaType).getSimpleName();
            ifStatement.ifFalse((BytecodeNode)SqlTypeBytecodeExpression.constantType(callSiteBinder, type).invoke(methodName, javaType, new BytecodeExpression[]{block, position}));
            this.body = ifStatement;
            this.block = block;
            this.position = position;
        }

        public List<BytecodeNode> getChildNodes() {
            return ImmutableList.of();
        }

        public void accept(MethodVisitor visitor, MethodGenerationContext generationContext) {
            this.body.accept(visitor, generationContext);
        }

        public <T> T accept(BytecodeNode parent, BytecodeVisitor<T> visitor) {
            return (T)visitor.visitIf(parent, (IfStatement)this.body);
        }

        public BytecodeNode produceBlockAndPosition() {
            BytecodeBlock blockAndPosition = new BytecodeBlock();
            blockAndPosition.append((BytecodeNode)this.block);
            blockAndPosition.append((BytecodeNode)this.position);
            return blockAndPosition;
        }
    }
}

