/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.common.function.SqlFunctionProperties;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.Decimals;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.JsonType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDate;
import com.facebook.presto.common.type.SqlTime;
import com.facebook.presto.common.type.SqlTimestamp;
import com.facebook.presto.common.type.SqlVarbinary;
import com.facebook.presto.common.type.TimeType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.TypeSignature;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.metadata.CastType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.scalar.VarbinaryFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.FunctionHandle;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.TypeSignatureProvider;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.BinaryLiteral;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.CharLiteral;
import com.facebook.presto.sql.tree.DecimalLiteral;
import com.facebook.presto.sql.tree.DoubleLiteral;
import com.facebook.presto.sql.tree.EnumLiteral;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.GenericLiteral;
import com.facebook.presto.sql.tree.IntervalLiteral;
import com.facebook.presto.sql.tree.Literal;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.sql.tree.TimeLiteral;
import com.facebook.presto.sql.tree.TimestampLiteral;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.IntervalYearMonthType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.facebook.presto.type.SqlIntervalYearMonth;
import com.facebook.presto.util.DateTimeUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class LiteralInterpreter {
    private LiteralInterpreter() {
    }

    public static Object evaluate(Metadata metadata, ConnectorSession session, Expression node) {
        if (!(node instanceof Literal)) {
            throw new IllegalArgumentException("node must be a Literal");
        }
        return new LiteralVisitor(metadata).process((Node)node, session);
    }

    public static Object evaluate(ConnectorSession session, ConstantExpression node) {
        Type type = node.getType();
        SqlFunctionProperties properties = session.getSqlFunctionProperties();
        if (node.getValue() == null) {
            return null;
        }
        if (type instanceof BooleanType) {
            return node.getValue();
        }
        if (type instanceof BigintType || type instanceof TinyintType || type instanceof SmallintType || type instanceof IntegerType) {
            return node.getValue();
        }
        if (type instanceof DoubleType) {
            return node.getValue();
        }
        if (type instanceof RealType) {
            Long number = (Long)node.getValue();
            return Float.valueOf(Float.intBitsToFloat(number.intValue()));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (decimalType.isShort()) {
                Preconditions.checkState((boolean)(node.getValue() instanceof Long));
                return LiteralInterpreter.decodeDecimal(BigInteger.valueOf((Long)node.getValue()), decimalType);
            }
            Preconditions.checkState((boolean)(node.getValue() instanceof Slice));
            Slice value = (Slice)node.getValue();
            return LiteralInterpreter.decodeDecimal(Decimals.decodeUnscaledValue((Slice)value), decimalType);
        }
        if (type instanceof VarcharType || type instanceof CharType) {
            return ((Slice)node.getValue()).toStringUtf8();
        }
        if (type instanceof VarbinaryType) {
            return new SqlVarbinary(((Slice)node.getValue()).getBytes());
        }
        if (type instanceof DateType) {
            return new SqlDate(((Long)node.getValue()).intValue());
        }
        if (type instanceof TimeType) {
            if (properties.isLegacyTimestamp()) {
                return new SqlTime(((Long)node.getValue()).longValue(), properties.getTimeZoneKey());
            }
            return new SqlTime(((Long)node.getValue()).longValue());
        }
        if (type instanceof TimestampType) {
            try {
                if (properties.isLegacyTimestamp()) {
                    return new SqlTimestamp(((Long)node.getValue()).longValue(), properties.getTimeZoneKey(), TimeUnit.MILLISECONDS);
                }
                return new SqlTimestamp(((Long)node.getValue()).longValue(), TimeUnit.MILLISECONDS);
            }
            catch (RuntimeException e) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("'%s' is not a valid timestamp literal", (String)node.getValue()));
            }
        }
        if (type instanceof IntervalDayTimeType) {
            return new SqlIntervalDayTime((Long)node.getValue());
        }
        if (type instanceof IntervalYearMonthType) {
            return new SqlIntervalYearMonth(((Long)node.getValue()).intValue());
        }
        if (type.getJavaType().equals(Slice.class)) {
            return "'" + VarbinaryFunctions.toBase64((Slice)node.getValue()).toStringUtf8() + "'";
        }
        return node.getValue();
    }

    private static Number decodeDecimal(BigInteger unscaledValue, DecimalType type) {
        return new BigDecimal(unscaledValue, type.getScale(), new MathContext(type.getPrecision()));
    }

    private static class LiteralVisitor
    extends AstVisitor<Object, ConnectorSession> {
        private final Metadata metadata;
        private final InterpretedFunctionInvoker functionInvoker;

        private LiteralVisitor(Metadata metadata) {
            this.metadata = metadata;
            this.functionInvoker = new InterpretedFunctionInvoker(metadata.getFunctionAndTypeManager());
        }

        protected Object visitLiteral(Literal node, ConnectorSession session) {
            throw new UnsupportedOperationException("Unhandled literal type: " + node);
        }

        protected Object visitBooleanLiteral(BooleanLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Long visitLongLiteral(LongLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Double visitDoubleLiteral(DoubleLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitDecimalLiteral(DecimalLiteral node, ConnectorSession context) {
            return Decimals.parse((String)node.getValue()).getObject();
        }

        protected Slice visitStringLiteral(StringLiteral node, ConnectorSession session) {
            return node.getSlice();
        }

        protected Object visitCharLiteral(CharLiteral node, ConnectorSession context) {
            return node.getSlice();
        }

        protected Slice visitBinaryLiteral(BinaryLiteral node, ConnectorSession session) {
            return node.getValue();
        }

        protected Object visitEnumLiteral(EnumLiteral node, ConnectorSession context) {
            return node.getValue();
        }

        protected Object visitGenericLiteral(GenericLiteral node, ConnectorSession session) {
            Type type = this.metadata.getType(TypeSignature.parseTypeSignature((String)node.getType()));
            if (type == null) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "Unknown type: " + node.getType(), new Object[0]);
            }
            if (JsonType.JSON.equals((Object)type)) {
                FunctionHandle functionHandle = this.metadata.getFunctionAndTypeManager().lookupFunction("json_parse", (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR}));
                return this.functionInvoker.invoke(functionHandle, session.getSqlFunctionProperties(), (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            try {
                FunctionHandle functionHandle = this.metadata.getFunctionAndTypeManager().lookupCast(CastType.CAST, (Type)VarcharType.VARCHAR, type);
                return this.functionInvoker.invoke(functionHandle, session.getSqlFunctionProperties(), (List<Object>)ImmutableList.of((Object)Slices.utf8Slice((String)node.getValue())));
            }
            catch (IllegalArgumentException e) {
                throw new SemanticException(SemanticErrorCode.TYPE_MISMATCH, (Node)node, "No literal form for type %s", new Object[]{type});
            }
        }

        protected Long visitTimeLiteral(TimeLiteral node, ConnectorSession session) {
            SqlFunctionProperties properties = session.getSqlFunctionProperties();
            if (properties.isLegacyTimestamp()) {
                return DateTimeUtils.parseTimeLiteral(properties.getTimeZoneKey(), node.getValue());
            }
            return DateTimeUtils.parseTimeLiteral(node.getValue());
        }

        protected Long visitTimestampLiteral(TimestampLiteral node, ConnectorSession session) {
            SqlFunctionProperties properties = session.getSqlFunctionProperties();
            try {
                if (properties.isLegacyTimestamp()) {
                    return DateTimeUtils.parseTimestampLiteral(properties.getTimeZoneKey(), node.getValue());
                }
                return DateTimeUtils.parseTimestampLiteral(node.getValue());
            }
            catch (RuntimeException e) {
                throw new SemanticException(SemanticErrorCode.INVALID_LITERAL, (Node)node, "'%s' is not a valid timestamp literal", new Object[]{node.getValue()});
            }
        }

        protected Long visitIntervalLiteral(IntervalLiteral node, ConnectorSession session) {
            if (node.isYearToMonth()) {
                return (long)node.getSign().multiplier() * DateTimeUtils.parseYearMonthInterval(node.getValue(), node.getStartField(), node.getEndField());
            }
            return (long)node.getSign().multiplier() * DateTimeUtils.parseDayTimeInterval(node.getValue(), node.getStartField(), node.getEndField());
        }

        protected Object visitNullLiteral(NullLiteral node, ConnectorSession session) {
            return null;
        }
    }
}

