/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.common.QualifiedObjectName;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorId;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NewTableLayout;
import com.facebook.presto.spi.PartitionedTableWritePolicy;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.TableMetadata;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.AggregationNode;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.DeleteNode;
import com.facebook.presto.spi.plan.LimitNode;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.StatisticAggregations;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.spi.plan.ValuesNode;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.statistics.TableStatisticsMetadata;
import com.facebook.presto.sql.TemporaryTableUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.Field;
import com.facebook.presto.sql.analyzer.RelationId;
import com.facebook.presto.sql.analyzer.RelationType;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.PlannerUtils;
import com.facebook.presto.sql.planner.QueryPlanner;
import com.facebook.presto.sql.planner.RelationPlan;
import com.facebook.presto.sql.planner.RelationPlanner;
import com.facebook.presto.sql.planner.SqlPlannerContext;
import com.facebook.presto.sql.planner.StatisticsAggregationPlanner;
import com.facebook.presto.sql.planner.TranslateExpressionsUtil;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.UpdateNode;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.tree.Analyze;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.ExplainFormat;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LambdaArgumentDeclaration;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.RefreshMaterializedView;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.Update;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class LogicalPlanner {
    private final PlanNodeIdAllocator idAllocator;
    private final Session session;
    private final VariableAllocator variableAllocator;
    private final Metadata metadata;
    private final StatisticsAggregationPlanner statisticsAggregationPlanner;
    private final SqlParser sqlParser;

    public LogicalPlanner(Session session, PlanNodeIdAllocator idAllocator, Metadata metadata, VariableAllocator variableAllocator, SqlParser sqlParser) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
        this.statisticsAggregationPlanner = new StatisticsAggregationPlanner(this.variableAllocator, metadata.getFunctionAndTypeManager(), session);
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
    }

    public PlanNode plan(Analysis analysis) {
        return this.planStatement(analysis, analysis.getStatement());
    }

    public PlanNode planStatement(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect && analysis.isCreateTableAsSelectNoOp()) {
            Preconditions.checkState((boolean)analysis.getCreateTableDestination().isPresent(), (Object)"Table destination is missing");
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)statement), "rows", (Type)BigintType.BIGINT);
            ValuesNode source = new ValuesNode(ExpressionTreeUtils.getSourceLocation((Node)statement), this.idAllocator.getNextId(), (List)ImmutableList.of((Object)variable), (List)ImmutableList.of((Object)ImmutableList.of((Object)Expressions.constant(0L, (Type)BigintType.BIGINT))), Optional.empty());
            return new OutputNode(source.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)source, (List)ImmutableList.of((Object)"rows"), (List)ImmutableList.of((Object)variable));
        }
        return this.createOutputPlan(this.planStatementWithoutOutput(analysis, statement), analysis);
    }

    private RelationPlan planStatementWithoutOutput(Analysis analysis, Statement statement) {
        if (statement instanceof CreateTableAsSelect) {
            if (analysis.isCreateTableAsSelectNoOp()) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "CREATE TABLE IF NOT EXISTS is not supported in this context " + statement.getClass().getSimpleName());
            }
            return this.createTableCreationPlan(analysis, ((CreateTableAsSelect)statement).getQuery());
        }
        if (statement instanceof Analyze) {
            return this.createAnalyzePlan(analysis, (Analyze)statement);
        }
        if (statement instanceof Insert) {
            Preconditions.checkState((boolean)analysis.getInsert().isPresent(), (Object)"Insert handle is missing");
            return this.createInsertPlan(analysis, (Insert)statement);
        }
        if (statement instanceof Delete) {
            return this.createDeletePlan(analysis, (Delete)statement);
        }
        if (statement instanceof Update) {
            return this.createUpdatePlan(analysis, (Update)statement);
        }
        if (statement instanceof Query) {
            return this.createRelationPlan(analysis, (Query)statement, new SqlPlannerContext(0));
        }
        if (statement instanceof Explain && ((Explain)statement).isAnalyze()) {
            return this.createExplainAnalyzePlan(analysis, (Explain)statement);
        }
        if (statement instanceof RefreshMaterializedView) {
            Preconditions.checkState((boolean)analysis.getRefreshMaterializedViewAnalysis().isPresent(), (Object)"RefreshMaterializedView analysis is missing");
            return this.createRefreshMaterializedViewPlan(analysis, (RefreshMaterializedView)statement);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type " + statement.getClass().getSimpleName());
    }

    private RelationPlan createExplainAnalyzePlan(Analysis analysis, Explain statement) {
        RelationPlan underlyingPlan = this.planStatementWithoutOutput(analysis, statement.getStatement());
        PlanNode root = underlyingPlan.getRoot();
        Scope scope = analysis.getScope((Node)statement);
        VariableReferenceExpression outputVariable = PlannerUtils.newVariable(this.variableAllocator, scope.getRelationType().getFieldByIndex(0));
        ExplainFormat.Type type = statement.getOptions().stream().filter(option -> option instanceof ExplainFormat).findFirst().map(ExplainFormat.class::cast).map(ExplainFormat::getType).orElse(ExplainFormat.Type.TEXT);
        root = new ExplainAnalyzeNode(ExpressionTreeUtils.getSourceLocation((Node)statement), this.idAllocator.getNextId(), root, outputVariable, statement.isVerbose(), type);
        return new RelationPlan(root, scope, (List<VariableReferenceExpression>)ImmutableList.of((Object)outputVariable));
    }

    private RelationPlan createAnalyzePlan(Analysis analysis, Analyze analyzeStatement) {
        TableHandle targetTable = (TableHandle)analysis.getAnalyzeTarget().get();
        Map<String, ColumnHandle> columnHandles = this.metadata.getColumnHandles(this.session, targetTable);
        ImmutableList.Builder tableScanOutputsBuilder = ImmutableList.builder();
        ImmutableMap.Builder variableToColumnHandle = ImmutableMap.builder();
        ImmutableMap.Builder columnNameToVariable = ImmutableMap.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, targetTable);
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            VariableReferenceExpression variable = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), column.getName(), column.getType());
            tableScanOutputsBuilder.add((Object)variable);
            variableToColumnHandle.put((Object)variable, (Object)columnHandles.get(column.getName()));
            columnNameToVariable.put((Object)column.getName(), (Object)variable);
        }
        TableStatisticsMetadata tableStatisticsMetadata = this.metadata.getStatisticsCollectionMetadata(this.session, targetTable.getConnectorId().getCatalogName(), tableMetadata.getMetadata());
        StatisticsAggregationPlanner.TableStatisticAggregation tableStatisticAggregation = this.statisticsAggregationPlanner.createStatisticsAggregation(tableStatisticsMetadata, (Map<String, VariableReferenceExpression>)columnNameToVariable.build());
        StatisticAggregations statisticAggregations = tableStatisticAggregation.getAggregations();
        ImmutableList tableScanOutputs = tableScanOutputsBuilder.build();
        ImmutableMap assignments = ImmutableMap.builder().putAll((Map)tableScanOutputs.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), Function.identity()))).putAll(tableStatisticAggregation.getAdditionalVariables()).build();
        TableScanNode scanNode = new TableScanNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), targetTable, (List)tableScanOutputs, (Map)variableToColumnHandle.build(), TupleDomain.all(), TupleDomain.all(), Optional.empty());
        PlanNode project = PlannerUtils.addProjections((PlanNode)scanNode, this.idAllocator, (Map<VariableReferenceExpression, RowExpression>)assignments);
        StatisticsWriterNode planNode = new StatisticsWriterNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), (PlanNode)new AggregationNode(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), this.idAllocator.getNextId(), project, statisticAggregations.getAggregations(), AggregationNode.singleGroupingSet((List)statisticAggregations.getGroupingVariables()), (List)ImmutableList.of(), AggregationNode.Step.SINGLE, Optional.empty(), Optional.empty(), Optional.empty()), targetTable, this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)analyzeStatement), "rows", (Type)BigintType.BIGINT), tableStatisticsMetadata.getTableStatistics().contains(TableStatisticType.ROW_COUNT), tableStatisticAggregation.getDescriptor());
        return new RelationPlan(planNode, analysis.getScope((Node)analyzeStatement), planNode.getOutputVariables());
    }

    private RelationPlan createTableCreationPlan(Analysis analysis, Query query) {
        QualifiedObjectName destination = (QualifiedObjectName)analysis.getCreateTableDestination().get();
        RelationPlan plan = this.createRelationPlan(analysis, query, new SqlPlannerContext(0));
        ConnectorTableMetadata tableMetadata = this.createTableMetadata(destination, LogicalPlanner.getOutputTableColumns(plan, analysis.getColumnAliases()), analysis.getCreateTableProperties(), analysis.getParameters(), analysis.getCreateTableComment());
        Optional<NewTableLayout> newTableLayout = this.metadata.getNewTableLayout(this.session, destination.getCatalogName(), tableMetadata);
        List columnNames = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, destination.getCatalogName(), tableMetadata);
        return this.createTableWriterPlan(analysis, plan, (TableWriterNode.WriterTarget)new TableWriterNode.CreateName(new ConnectorId(destination.getCatalogName()), tableMetadata, newTableLayout), columnNames, tableMetadata.getColumns(), newTableLayout, statisticsMetadata);
    }

    private RelationPlan createRefreshMaterializedViewPlan(Analysis analysis, RefreshMaterializedView refreshMaterializedViewStatement) {
        Analysis.RefreshMaterializedViewAnalysis viewAnalysis = (Analysis.RefreshMaterializedViewAnalysis)analysis.getRefreshMaterializedViewAnalysis().get();
        TableHandle tableHandle = viewAnalysis.getTarget();
        List columnHandles = viewAnalysis.getColumns();
        TableWriterNode.RefreshMaterializedViewReference target = new TableWriterNode.RefreshMaterializedViewReference(tableHandle, this.metadata.getTableMetadata(this.session, tableHandle).getTable());
        return this.buildInternalInsertPlan(tableHandle, columnHandles, viewAnalysis.getQuery(), analysis, (TableWriterNode.WriterTarget)target);
    }

    private RelationPlan createInsertPlan(Analysis analysis, Insert insertStatement) {
        Analysis.Insert insertAnalysis = (Analysis.Insert)analysis.getInsert().get();
        TableHandle tableHandle = insertAnalysis.getTarget();
        List columnHandles = insertAnalysis.getColumns();
        TableWriterNode.InsertReference target = new TableWriterNode.InsertReference(tableHandle, this.metadata.getTableMetadata(this.session, tableHandle).getTable());
        return this.buildInternalInsertPlan(tableHandle, columnHandles, insertStatement.getQuery(), analysis, (TableWriterNode.WriterTarget)target);
    }

    private RelationPlan buildInternalInsertPlan(TableHandle tableHandle, List<ColumnHandle> columnHandles, Query query, Analysis analysis, TableWriterNode.WriterTarget target) {
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, tableHandle);
        List visibleTableColumns = (List)tableMetadata.getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        List visibleTableColumnNames = (List)visibleTableColumns.stream().map(ColumnMetadata::getName).collect(ImmutableList.toImmutableList());
        SqlPlannerContext context = new SqlPlannerContext(0);
        RelationPlan plan = this.createRelationPlan(analysis, query, context);
        Map<String, ColumnHandle> columns = this.metadata.getColumnHandles(this.session, tableHandle);
        Assignments.Builder assignments = Assignments.builder();
        for (ColumnMetadata column2 : tableMetadata.getColumns()) {
            if (column2.isHidden()) continue;
            VariableReferenceExpression output = this.variableAllocator.newVariable(ExpressionTreeUtils.getSourceLocation((Node)query), column2.getName(), column2.getType());
            int index = columnHandles.indexOf(columns.get(column2.getName()));
            if (index < 0) {
                Cast cast = new Cast((Expression)new NullLiteral(), column2.getType().getTypeSignature().toString());
                assignments.put(output, this.rowExpression((Expression)cast, context, analysis));
                continue;
            }
            VariableReferenceExpression input = plan.getVariable(index);
            Type tableType = column2.getType();
            Type queryType = input.getType();
            if (queryType.equals(tableType) || this.metadata.getFunctionAndTypeManager().isTypeOnlyCoercion(queryType, tableType)) {
                assignments.put(output, (RowExpression)input);
                continue;
            }
            Cast cast = new Cast((Expression)ExpressionTreeUtils.createSymbolReference(input), tableType.getTypeSignature().toString());
            assignments.put(output, this.rowExpression((Expression)cast, context, analysis));
        }
        ProjectNode projectNode = new ProjectNode(this.idAllocator.getNextId(), plan.getRoot(), assignments.build());
        List fields = (List)visibleTableColumns.stream().map(column -> Field.newUnqualified((Optional)query.getLocation(), (String)column.getName(), (Type)column.getType())).collect(ImmutableList.toImmutableList());
        Scope scope = Scope.builder().withRelationType(RelationId.anonymous(), new RelationType(fields)).build();
        plan = new RelationPlan((PlanNode)projectNode, scope, projectNode.getOutputVariables());
        Optional<NewTableLayout> newTableLayout = this.metadata.getInsertLayout(this.session, tableHandle);
        String catalogName = tableHandle.getConnectorId().getCatalogName();
        TableStatisticsMetadata statisticsMetadata = this.metadata.getStatisticsCollectionMetadataForWrite(this.session, catalogName, tableMetadata.getMetadata());
        return this.createTableWriterPlan(analysis, plan, target, visibleTableColumnNames, visibleTableColumns, newTableLayout, statisticsMetadata);
    }

    private RelationPlan createTableWriterPlan(Analysis analysis, RelationPlan plan, TableWriterNode.WriterTarget target, List<String> columnNames, List<ColumnMetadata> columnMetadataList, Optional<NewTableLayout> writeTableLayout, TableStatisticsMetadata statisticsMetadata) {
        PlanNode source = plan.getRoot();
        if (!analysis.isCreateTableAsSelectWithData()) {
            source = new LimitNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, 0L, LimitNode.Step.FINAL);
        }
        List<VariableReferenceExpression> variables = plan.getFieldMappings();
        Optional<PartitioningScheme> tablePartitioningScheme = LogicalPlanner.getPartitioningSchemeForTableWrite(writeTableLayout, columnNames, variables);
        Verify.verify((columnNames.size() == variables.size() ? 1 : 0) != 0, (String)"columnNames.size() != variables.size(): %s and %s", columnNames, variables);
        Map columnToVariableMap = (Map)Streams.zip(columnNames.stream(), plan.getFieldMappings().stream(), AbstractMap.SimpleImmutableEntry::new).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        Set notNullColumnVariables = (Set)columnMetadataList.stream().filter(column -> !column.isNullable()).map(ColumnMetadata::getName).map(columnToVariableMap::get).collect(ImmutableSet.toImmutableSet());
        if (!statisticsMetadata.isEmpty()) {
            StatisticsAggregationPlanner.TableStatisticAggregation result = this.statisticsAggregationPlanner.createStatisticsAggregation(statisticsMetadata, columnToVariableMap);
            StatisticAggregations.Parts aggregations = TemporaryTableUtil.splitIntoPartialAndFinal(result.getAggregations(), this.variableAllocator, this.metadata.getFunctionAndTypeManager());
            TableFinishNode commitNode = new TableFinishNode(source.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)new TableWriterNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("fragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("commitcontext", (Type)VarbinaryType.VARBINARY), plan.getFieldMappings(), columnNames, notNullColumnVariables, tablePartitioningScheme, Optional.of(aggregations.getPartialAggregation()), Optional.empty(), Optional.of(Boolean.FALSE)), Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.of(aggregations.getFinalAggregation()), Optional.of(result.getDescriptor()), Optional.empty());
            return new RelationPlan((PlanNode)commitNode, analysis.getRootScope(), commitNode.getOutputVariables());
        }
        TableFinishNode commitNode = new TableFinishNode(source.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)new TableWriterNode(source.getSourceLocation(), this.idAllocator.getNextId(), source, Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), this.variableAllocator.newVariable("fragments", (Type)VarbinaryType.VARBINARY), this.variableAllocator.newVariable("commitcontext", (Type)VarbinaryType.VARBINARY), plan.getFieldMappings(), columnNames, notNullColumnVariables, tablePartitioningScheme, Optional.empty(), Optional.empty(), Optional.of(Boolean.FALSE)), Optional.of(target), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty(), Optional.empty());
        return new RelationPlan((PlanNode)commitNode, analysis.getRootScope(), commitNode.getOutputVariables());
    }

    private RelationPlan createDeletePlan(Analysis analysis, Delete node) {
        SqlPlannerContext context = new SqlPlannerContext(0);
        DeleteNode deleteNode = new QueryPlanner(analysis, this.variableAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToVariableMap(analysis, this.variableAllocator), this.metadata, this.session, context, this.sqlParser).plan(node);
        TableHandle handle = analysis.getTableHandle(node.getTable());
        TableWriterNode.DeleteHandle deleteHandle = new TableWriterNode.DeleteHandle(handle, this.metadata.getTableMetadata(this.session, handle).getTable());
        TableFinishNode commitNode = new TableFinishNode(deleteNode.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)deleteNode, Optional.of(deleteHandle), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty(), Optional.empty());
        return new RelationPlan((PlanNode)commitNode, analysis.getScope((Node)node), commitNode.getOutputVariables());
    }

    private RelationPlan createUpdatePlan(Analysis analysis, Update node) {
        SqlPlannerContext context = new SqlPlannerContext(0);
        UpdateNode updateNode = new QueryPlanner(analysis, this.variableAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToVariableMap(analysis, this.variableAllocator), this.metadata, this.session, context, this.sqlParser).plan(node);
        TableHandle handle = analysis.getTableHandle(node.getTable());
        ImmutableList.Builder updatedColumnNamesBuilder = ImmutableList.builder();
        ImmutableList.Builder updatedColumnHandlesBuilder = ImmutableList.builder();
        TableMetadata tableMetadata = this.metadata.getTableMetadata(this.session, handle);
        Map<String, ColumnHandle> columnMap = this.metadata.getColumnHandles(this.session, handle);
        List dataColumns = (List)tableMetadata.getMetadata().getColumns().stream().filter(column -> !column.isHidden()).collect(ImmutableList.toImmutableList());
        List targetColumnNames = (List)node.getAssignments().stream().map(assignment -> assignment.getName().getValue()).collect(ImmutableList.toImmutableList());
        for (ColumnMetadata columnMetadata : dataColumns) {
            String name = columnMetadata.getName();
            int index = targetColumnNames.indexOf(name);
            if (index < 0) continue;
            updatedColumnNamesBuilder.add((Object)name);
            updatedColumnHandlesBuilder.add((Object)Objects.requireNonNull(columnMap.get(name), "columnMap didn't contain name"));
        }
        TableWriterNode.UpdateTarget updateTarget = new TableWriterNode.UpdateTarget(handle, this.metadata.getTableMetadata(this.session, handle).getTable(), (List)updatedColumnNamesBuilder.build(), (List)updatedColumnHandlesBuilder.build());
        TableFinishNode commitNode = new TableFinishNode(updateNode.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)updateNode, Optional.of(updateTarget), this.variableAllocator.newVariable("rows", (Type)BigintType.BIGINT), Optional.empty(), Optional.empty(), Optional.empty());
        return new RelationPlan((PlanNode)commitNode, analysis.getScope((Node)node), commitNode.getOutputVariables());
    }

    private PlanNode createOutputPlan(RelationPlan plan, Analysis analysis) {
        ImmutableList.Builder outputs = ImmutableList.builder();
        ImmutableList.Builder names = ImmutableList.builder();
        int columnNumber = 0;
        RelationType outputDescriptor = analysis.getOutputDescriptor();
        for (Field field : outputDescriptor.getVisibleFields()) {
            String name = field.getName().orElse("_col" + columnNumber);
            names.add((Object)name);
            int fieldIndex = outputDescriptor.indexOf(field);
            VariableReferenceExpression variable = plan.getVariable(fieldIndex);
            outputs.add((Object)variable);
            ++columnNumber;
        }
        return new OutputNode(plan.getRoot().getSourceLocation(), this.idAllocator.getNextId(), plan.getRoot(), (List)names.build(), (List)outputs.build());
    }

    private RelationPlan createRelationPlan(Analysis analysis, Query query, SqlPlannerContext context) {
        return new RelationPlanner(analysis, this.variableAllocator, this.idAllocator, LogicalPlanner.buildLambdaDeclarationToVariableMap(analysis, this.variableAllocator), this.metadata, this.session, this.sqlParser).process((Node)query, context);
    }

    private ConnectorTableMetadata createTableMetadata(QualifiedObjectName table, List<ColumnMetadata> columns, Map<String, Expression> propertyExpressions, Map<NodeRef<Parameter>, Expression> parameters, Optional<String> comment) {
        Map<String, Object> properties = this.metadata.getTablePropertyManager().getProperties(MetadataUtil.getConnectorIdOrThrow(this.session, this.metadata, table.getCatalogName()), table.getCatalogName(), propertyExpressions, this.session, this.metadata, parameters);
        return new ConnectorTableMetadata(MetadataUtil.toSchemaTableName(table), columns, properties, comment);
    }

    private RowExpression rowExpression(Expression expression, SqlPlannerContext context, Analysis analysis) {
        return TranslateExpressionsUtil.toRowExpression(expression, this.metadata, this.session, this.sqlParser, this.variableAllocator, analysis, context.getTranslatorContext());
    }

    private static List<ColumnMetadata> getOutputTableColumns(RelationPlan plan, Optional<List<Identifier>> columnAliases) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int aliasPosition = 0;
        for (Field field : plan.getDescriptor().getVisibleFields()) {
            String columnName = columnAliases.isPresent() ? columnAliases.get().get(aliasPosition).getValue() : (String)field.getName().get();
            columns.add((Object)ColumnMetadata.builder().setName(columnName).setType(field.getType()).build());
            ++aliasPosition;
        }
        return columns.build();
    }

    private static Map<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> buildLambdaDeclarationToVariableMap(Analysis analysis, VariableAllocator variableAllocator) {
        LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression> resultMap = new LinkedHashMap<NodeRef<LambdaArgumentDeclaration>, VariableReferenceExpression>();
        for (Map.Entry entry : analysis.getTypes().entrySet()) {
            NodeRef lambdaArgumentDeclaration;
            if (!(((NodeRef)entry.getKey()).getNode() instanceof LambdaArgumentDeclaration) || resultMap.containsKey(lambdaArgumentDeclaration = NodeRef.of((Node)((LambdaArgumentDeclaration)((NodeRef)entry.getKey()).getNode())))) continue;
            resultMap.put((NodeRef<LambdaArgumentDeclaration>)lambdaArgumentDeclaration, PlannerUtils.newVariable(variableAllocator, (Expression)lambdaArgumentDeclaration.getNode(), (Type)entry.getValue()));
        }
        return resultMap;
    }

    private static Optional<PartitioningScheme> getPartitioningSchemeForTableWrite(Optional<NewTableLayout> tableLayout, List<String> columnNames, List<VariableReferenceExpression> variables) {
        tableLayout.ifPresent(layout -> {
            if (!ImmutableSet.copyOf((Collection)columnNames).containsAll((Collection)layout.getPartitionColumns())) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "INSERT must write all distribution columns: " + layout.getPartitionColumns());
            }
        });
        Optional<PartitioningScheme> partitioningScheme = Optional.empty();
        if (tableLayout.isPresent()) {
            ArrayList partitionFunctionArguments = new ArrayList();
            tableLayout.get().getPartitionColumns().stream().mapToInt(columnNames::indexOf).mapToObj(variables::get).forEach(partitionFunctionArguments::add);
            ArrayList<VariableReferenceExpression> outputLayout = new ArrayList<VariableReferenceExpression>(variables);
            partitioningScheme = Optional.of(new PartitioningScheme(Partitioning.create((PartitioningHandle)tableLayout.get().getPartitioning(), partitionFunctionArguments), outputLayout, tableLayout.get().getWriterPolicy() == PartitionedTableWritePolicy.MULTIPLE_WRITERS_PER_PARTITION_ALLOWED));
        }
        return partitioningScheme;
    }
}

