/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.scheduler.BucketNodeMap;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.StandardWarningCode;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.facebook.presto.spi.plan.OutputNode;
import com.facebook.presto.spi.plan.Partitioning;
import com.facebook.presto.spi.plan.PartitioningHandle;
import com.facebook.presto.spi.plan.PartitioningScheme;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeId;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.TableFinishNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.plan.TableWriterNode;
import com.facebook.presto.sql.planner.GroupedExecutionTagger;
import com.facebook.presto.sql.planner.NodePartitioningManager;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.StatisticsWriterNode;
import com.facebook.presto.sql.planner.plan.TableWriterMergeNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PlanFragmenterUtils {
    public static final int ROOT_FRAGMENT_ID = 0;
    public static final String TOO_MANY_STAGES_MESSAGE = "If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.";
    private static final Set<Class> PLAN_NODES_WITH_COORDINATOR_ONLY_DISTRIBUTION = ImmutableSet.of(ExplainAnalyzeNode.class, StatisticsWriterNode.class, TableFinishNode.class, MetadataDeleteNode.class);

    private PlanFragmenterUtils() {
    }

    public static SubPlan finalizeSubPlan(SubPlan subPlan, QueryManagerConfig config, Metadata metadata, NodePartitioningManager nodePartitioningManager, Session session, boolean noExchange, WarningCollector warningCollector, PartitioningHandle partitioningHandle) {
        subPlan = PlanFragmenterUtils.reassignPartitioningHandleIfNecessary(metadata, session, subPlan, partitioningHandle);
        if (!noExchange && !SystemSessionProperties.isSingleNodeExecutionEnabled(session)) {
            subPlan = PlanFragmenterUtils.analyzeGroupedExecution(session, subPlan, false, metadata, nodePartitioningManager);
        }
        Preconditions.checkState((subPlan.getFragment().getId().getId() != 0 || !SystemSessionProperties.isForceSingleNodeOutput(session) || subPlan.getFragment().getPartitioning().isSingleNode() ? 1 : 0) != 0, (Object)"Root of PlanFragment is not single node");
        PlanFragmenterUtils.sanityCheckFragmentedPlan(subPlan, warningCollector, SystemSessionProperties.getExchangeMaterializationStrategy(session), SystemSessionProperties.getQueryMaxStageCount(session), config.getStageCountWarningThreshold());
        return subPlan;
    }

    private static void sanityCheckFragmentedPlan(SubPlan subPlan, WarningCollector warningCollector, QueryManagerConfig.ExchangeMaterializationStrategy exchangeMaterializationStrategy, int maxStageCount, int stageCountSoftLimit) {
        subPlan.sanityCheck();
        int fragmentCount = subPlan.getAllFragments().size();
        if (fragmentCount > maxStageCount) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_HAS_TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the allowed maximum (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, maxStageCount));
        }
        if (exchangeMaterializationStrategy != QueryManagerConfig.ExchangeMaterializationStrategy.ALL && fragmentCount > stageCountSoftLimit) {
            warningCollector.add(new PrestoWarning((WarningCodeSupplier)StandardWarningCode.TOO_MANY_STAGES, String.format("Number of stages in the query (%s) exceeds the soft limit (%s). If the query contains multiple DISTINCTs, please set the 'use_mark_distinct' session property to false. If the query contains multiple CTEs that are referenced more than once, please create temporary table(s) for one or more of the CTEs.", fragmentCount, stageCountSoftLimit)));
        }
    }

    private static SubPlan analyzeGroupedExecution(Session session, SubPlan subPlan, boolean parentContainsTableFinish, Metadata metadata, NodePartitioningManager nodePartitioningManager) {
        PlanFragment fragment = subPlan.getFragment();
        GroupedExecutionTagger.GroupedExecutionProperties properties = (GroupedExecutionTagger.GroupedExecutionProperties)fragment.getRoot().accept((PlanVisitor)new GroupedExecutionTagger(session, metadata, nodePartitioningManager), null);
        if (properties.isSubTreeUseful()) {
            boolean preferDynamic = fragment.getRemoteSourceNodes().stream().allMatch(node -> node.getExchangeType() == ExchangeNode.Type.REPLICATE) && new HashSet<PlanNodeId>(properties.getCapableTableScanNodes()).containsAll(fragment.getTableScanSchedulingOrder());
            BucketNodeMap bucketNodeMap = nodePartitioningManager.getBucketNodeMap(session, fragment.getPartitioning(), preferDynamic);
            if (bucketNodeMap.isDynamic()) {
                boolean recoverable;
                boolean bl = recoverable = SystemSessionProperties.isRecoverableGroupedExecutionEnabled(session) && parentContainsTableFinish && (fragment.getRoot() instanceof TableWriterMergeNode || fragment.getRoot() instanceof TableWriterNode) && properties.isRecoveryEligible();
                fragment = recoverable ? fragment.withRecoverableGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans()) : fragment.withDynamicLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans());
            } else {
                fragment = fragment.withFixedLifespanScheduleGroupedExecution(properties.getCapableTableScanNodes(), properties.getTotalLifespans());
            }
        }
        ImmutableList.Builder result = ImmutableList.builder();
        boolean containsTableFinishNode = PlanFragmenterUtils.containsTableFinishNode(fragment);
        for (SubPlan child : subPlan.getChildren()) {
            result.add((Object)PlanFragmenterUtils.analyzeGroupedExecution(session, child, containsTableFinishNode, metadata, nodePartitioningManager));
        }
        return new SubPlan(fragment, (List<SubPlan>)result.build());
    }

    private static boolean containsTableFinishNode(PlanFragment planFragment) {
        PlanNode root = planFragment.getRoot();
        return root instanceof OutputNode && Iterables.getOnlyElement((Iterable)root.getSources()) instanceof TableFinishNode;
    }

    private static SubPlan reassignPartitioningHandleIfNecessary(Metadata metadata, Session session, SubPlan subPlan, PartitioningHandle partitioningHandle) {
        return PlanFragmenterUtils.reassignPartitioningHandleIfNecessaryHelper(metadata, session, subPlan, partitioningHandle);
    }

    private static SubPlan reassignPartitioningHandleIfNecessaryHelper(Metadata metadata, Session session, SubPlan subPlan, PartitioningHandle newOutputPartitioningHandle) {
        PlanFragment fragment = subPlan.getFragment();
        PlanNode newRoot = fragment.getRoot();
        if (!fragment.getPartitioning().isSingleNode()) {
            PartitioningHandleReassigner partitioningHandleReassigner = new PartitioningHandleReassigner(fragment.getPartitioning(), metadata, session);
            newRoot = SimplePlanRewriter.rewriteWith(partitioningHandleReassigner, newRoot);
        }
        PartitioningScheme outputPartitioningScheme = fragment.getPartitioningScheme();
        Partitioning newOutputPartitioning = outputPartitioningScheme.getPartitioning();
        if (outputPartitioningScheme.getPartitioning().getHandle().getConnectorId().isPresent()) {
            newOutputPartitioning = newOutputPartitioning.withAlternativePartitioningHandle(newOutputPartitioningHandle);
        }
        PlanFragment newFragment = new PlanFragment(fragment.getId(), newRoot, fragment.getVariables(), fragment.getPartitioning(), fragment.getTableScanSchedulingOrder(), new PartitioningScheme(newOutputPartitioning, outputPartitioningScheme.getOutputLayout(), outputPartitioningScheme.getHashColumn(), outputPartitioningScheme.isReplicateNullsAndAny(), outputPartitioningScheme.isScaleWriters(), outputPartitioningScheme.getEncoding(), outputPartitioningScheme.getBucketToPartition()), fragment.getStageExecutionDescriptor(), fragment.isOutputTableWriterFragment(), fragment.getStatsAndCosts(), fragment.getJsonRepresentation());
        ImmutableList.Builder childrenBuilder = ImmutableList.builder();
        for (SubPlan child : subPlan.getChildren()) {
            childrenBuilder.add((Object)PlanFragmenterUtils.reassignPartitioningHandleIfNecessaryHelper(metadata, session, child, fragment.getPartitioning()));
        }
        return new SubPlan(newFragment, (List<SubPlan>)childrenBuilder.build());
    }

    public static Set<PlanNodeId> getTableWriterNodeIds(PlanNode plan) {
        return (Set)Streams.stream((Iterable)Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)plan)).filter(node -> node instanceof TableWriterNode).map(PlanNode::getId).collect(ImmutableSet.toImmutableSet());
    }

    public static Set<PlanNodeId> getOutputTableWriterNodeIds(PlanNode plan) {
        return (Set)Streams.stream((Iterable)Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)plan)).filter(node -> node instanceof TableWriterNode).map(node -> (TableWriterNode)node).filter(tableWriterNode -> tableWriterNode.getIsTemporaryTableWriter().orElse(false) == false).map(node -> node).map(PlanNode::getId).collect(ImmutableSet.toImmutableSet());
    }

    public static Optional<Integer> getTableWriterTasks(PlanNode plan) {
        return Streams.stream((Iterable)Traverser.forTree(PlanNode::getSources).depthFirstPreOrder((Object)plan)).filter(node -> node instanceof TableWriterNode).map(x -> ((TableWriterNode)x).getTaskCountIfScaledWriter()).filter(Optional::isPresent).map(Optional::get).max(Integer::compareTo);
    }

    public static boolean isRootFragment(PlanFragment fragment) {
        return fragment.getId().getId() == 0;
    }

    public static boolean isCoordinatorOnlyDistribution(PlanNode planNode) {
        return PLAN_NODES_WITH_COORDINATOR_ONLY_DISTRIBUTION.contains(planNode.getClass());
    }

    private static final class PartitioningHandleReassigner
    extends SimplePlanRewriter<Void> {
        private final PartitioningHandle fragmentPartitioningHandle;
        private final Metadata metadata;
        private final Session session;

        public PartitioningHandleReassigner(PartitioningHandle fragmentPartitioningHandle, Metadata metadata, Session session) {
            this.fragmentPartitioningHandle = fragmentPartitioningHandle;
            this.metadata = metadata;
            this.session = session;
        }

        public PlanNode visitTableScan(TableScanNode node, SimplePlanRewriter.RewriteContext<Void> context) {
            PartitioningHandle partitioning = this.metadata.getLayout(this.session, node.getTable()).getTablePartitioning().map(TableLayout.TablePartitioning::getPartitioningHandle).orElse(SystemPartitioningHandle.SOURCE_DISTRIBUTION);
            if (partitioning.equals((Object)this.fragmentPartitioningHandle)) {
                return node;
            }
            TableHandle newTableHandle = this.metadata.getAlternativeTableHandle(this.session, node.getTable(), this.fragmentPartitioningHandle);
            return new TableScanNode(node.getSourceLocation(), node.getId(), newTableHandle, node.getOutputVariables(), node.getAssignments(), node.getCurrentConstraint(), node.getEnforcedConstraint(), node.getCteMaterializationInfo());
        }
    }
}

